/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.junit.Assert;

public class MarkerAttributeChangeListener
extends Assert
implements IResourceChangeListener {
    private Map<Long, Map<String, Object>> attributeMap = new HashMap<Long, Map<String, Object>>();
    private AssertionFailedError error;

    public void expectChanges(IMarker marker) throws CoreException {
        this.expectChanges(new IMarker[]{marker});
    }

    public void expectChanges(IMarker[] markers) throws CoreException {
        this.error = null;
        this.attributeMap.clear();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.attributeMap.put(marker.getId(), marker.getAttributes());
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
        try {
            this.checkDelta(deltas);
        }
        catch (AssertionFailedError e) {
            this.error = e;
        }
    }

    private void checkDelta(IMarkerDelta[] deltas) throws AssertionFailedError {
        MarkerAttributeChangeListener.assertEquals((String)"wrong number of changes", (long)this.attributeMap.size(), (long)deltas.length);
        IMarkerDelta[] iMarkerDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            Map<String, Object> values = this.attributeMap.get(delta.getId());
            MarkerAttributeChangeListener.assertEquals((String)"Changes different from expecations", (Object)delta.getAttributes(), values);
            ++n2;
        }
    }

    public void verifyChanges() {
        if (this.error != null) {
            throw this.error;
        }
    }
}

