/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MarkerReader;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.MarkerAttributeChangeListener;
import org.eclipse.core.tests.resources.MarkersChangeListener;
import org.eclipse.core.tests.resources.ResourceTest;

public class MarkerTest
extends ResourceTest {
    public static final String TRANSIENT_MARKER = "org.eclipse.core.tests.resources.transientmarker";
    public static final String TEST_PROBLEM_MARKER = "org.eclipse.core.tests.resources.testproblem";
    IResource[] resources;

    public MarkerTest() {
    }

    public MarkerTest(String name) {
        super(name);
    }

    public void testMarkerChangesInDelta3() {
        MarkerTest.debug((String)"TestMarkerChangesInDelta3");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            IPath destination;
            IResource resource = MarkerTest.getWorkspace().getRoot().findMember("1");
            IResource destinationResource = null;
            IMarker[] markers = new IMarker[4];
            try {
                destination = resource.getFullPath().removeLastSegments(1).append(String.valueOf(resource.getFullPath().lastSegment()) + "new");
                markers[0] = resource.createMarker("org.eclipse.core.resources.bookmark");
                IResource child = ((IProject)resource).members()[0];
                markers[1] = child.createMarker("org.eclipse.core.resources.taskmarker");
                listener.reset();
                resource.move(destination, false, this.getMonitor());
                destinationResource = MarkerTest.getWorkspace().getRoot().findMember(destination);
                markers[2] = destinationResource.getMarker(markers[0].getId());
                IResource destinationChild = ((IProject)destinationResource).findMember(child.getName());
                markers[3] = destinationChild.getMarker(markers[1].getId());
                MarkerTest.assertEquals((String)("1.1." + resource.getFullPath()), (int)4, (int)listener.numAffectedResources());
                MarkerTest.assertTrue((String)("1.2." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, new IMarker[]{markers[0]}, null));
                MarkerTest.assertTrue((String)("1.3." + resource.getFullPath()), (boolean)listener.checkChanges(child, null, new IMarker[]{markers[1]}, null));
                MarkerTest.assertTrue((String)("1.4." + destinationResource.getFullPath()), (boolean)listener.checkChanges(destinationResource, new IMarker[]{markers[2]}, null, null));
                MarkerTest.assertTrue((String)("1.5." + destinationResource.getFullPath()), (boolean)listener.checkChanges(destinationChild, new IMarker[]{markers[3]}, null, null));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.99", (Throwable)e);
            }
            try {
                resource = MarkerTest.getWorkspace().getRoot().findMember("2");
                destination = resource.getFullPath().removeLastSegments(1).append(String.valueOf(resource.getFullPath().lastSegment()) + "copy");
                resource.createMarker("org.eclipse.core.resources.bookmark");
                listener.reset();
                resource.copy(destination, false, this.getMonitor());
                MarkerTest.assertEquals((String)("2.1." + resource.getFullPath()), (int)0, (int)listener.numAffectedResources());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.99", (Throwable)e);
            }
            try {
                MarkerTest.getWorkspace().getRoot().deleteMarkers(null, true, 2);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"99.99", (Throwable)e);
            }
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void _testPerformanceManyResources() {
        long stop;
        long start;
        MarkerTest.debug((String)"testPerformanceManyResources");
        IResource[] testResources = null;
        try {
            MarkerTest.getWorkspace().getRoot().delete(false, this.getMonitor());
            testResources = this.createLargeHierarchy();
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.0", (Throwable)e);
        }
        int numMarkers = testResources.length * 20;
        this.display("\nNumber of resources: " + testResources.length);
        this.display("Markers per resource: 20");
        this.display("Total Number of Markers: " + numMarkers);
        IWorkspaceRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                int i = 0;
                while (i < 20) {
                    resource.createMarker("org.eclipse.core.resources.problemmarker");
                    ++i;
                }
                return true;
            };
            MarkerTest.getWorkspace().getRoot().accept(visitor);
        };
        try {
            start = System.currentTimeMillis();
            MarkerTest.getWorkspace().run(body, this.getMonitor());
            stop = System.currentTimeMillis();
            this.display("Task: creating markers");
            this.display(start, stop);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.0", (Throwable)e);
        }
        IMarker[] markers = new IMarker[numMarkers];
        try {
            IMarker[] temp = MarkerTest.getWorkspace().getRoot().findMarkers(null, true, 2);
            MarkerTest.assertEquals((String)"0.1", (int)numMarkers, (int)temp.length);
            int i = 0;
            while (i < temp.length) {
                markers[i] = temp[i];
                ++i;
            }
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.2", (Throwable)e);
        }
        body = monitor -> {
            IMarker[] iMarkerArray2 = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray2[n2];
                marker.setAttribute("message", (Object)this.getRandomString());
                ++n2;
            }
        };
        try {
            start = System.currentTimeMillis();
            MarkerTest.getWorkspace().run(body, this.getMonitor());
            stop = System.currentTimeMillis();
            this.display("Task: setting an attribute on each marker");
            this.display(start, stop);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.0", (Throwable)e);
        }
        body = monitor -> {
            IMarker[] iMarkerArray2 = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray2[n2];
                marker.getAttribute("message");
                ++n2;
            }
        };
        try {
            start = System.currentTimeMillis();
            MarkerTest.getWorkspace().run(body, this.getMonitor());
            stop = System.currentTimeMillis();
            this.display("Task: getting an attribute on each marker");
            this.display(start, stop);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"2.0", (Throwable)e);
        }
    }

    public void _testPerformanceOneResource() {
        long stop;
        long start;
        MarkerTest.debug((String)"testPerformanceOneResource");
        this.display("Number of resources: 1");
        this.display("Number of Markers: 4000");
        IMarker[] markers = new IMarker[4000];
        IWorkspaceRunnable body = monitor -> {
            IWorkspaceRoot resource = MarkerTest.getWorkspace().getRoot();
            int i = 0;
            while (i < markers.length) {
                iMarkerArray[i] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                ++i;
            }
        };
        try {
            start = System.currentTimeMillis();
            MarkerTest.getWorkspace().run(body, this.getMonitor());
            stop = System.currentTimeMillis();
            this.display("Task: creating markers");
            this.display(start, stop);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.0", (Throwable)e);
        }
        body = monitor -> {
            IMarker[] iMarkerArray2 = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray2[n2];
                marker.setAttribute("message", (Object)this.getRandomString());
                ++n2;
            }
        };
        try {
            start = System.currentTimeMillis();
            MarkerTest.getWorkspace().run(body, this.getMonitor());
            stop = System.currentTimeMillis();
            this.display("Task: setting an attribute on each marker");
            this.display(start, stop);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.0", (Throwable)e);
        }
        Comparator c = (o1, o2) -> {
            try {
                String name1 = (String)o1.getAttribute("message");
                String name2 = (String)o2.getAttribute("message");
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                int result = name1.compareToIgnoreCase(name2);
                return result;
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.0", (Throwable)e);
                return -1;
            }
        };
        start = System.currentTimeMillis();
        Arrays.sort(markers, c);
        stop = System.currentTimeMillis();
        this.display("Task: sort arrays based on MESSAGE attribute");
        this.display(start, stop);
    }

    protected void addChildren(ArrayList<String> result, IPath root, int breadth, int depth) {
        int i = 1;
        while (i < breadth + 1) {
            IPath child = root.append(String.valueOf(i));
            if (depth == 0) {
                result.add(child.toString());
                return;
            }
            child = child.addTrailingSeparator();
            result.add(child.toString());
            this.addChildren(result, child, breadth, depth - 1);
            ++i;
        }
    }

    protected void assertDoesNotExist(String message, IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.assertDoesNotExist(message, marker);
            ++n2;
        }
    }

    protected void assertDoesNotExist(String message, IMarker marker) {
        MarkerTest.assertTrue((String)message, (!marker.exists() ? 1 : 0) != 0);
    }

    protected void assertEquals(String message, IMarker[] expectedMarkers, IMarker[] actualMarkers) {
        int n = expectedMarkers.length;
        if (n != actualMarkers.length) {
            MarkerTest.fail((String)message);
        }
        boolean[] seen = new boolean[n];
        int i = 0;
        while (i < n) {
            boolean found = false;
            int j = 0;
            while (j < n) {
                if (!seen[j] && MarkerTest.equals(expectedMarkers[i], actualMarkers[j])) {
                    found = true;
                    seen[j] = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                MarkerTest.fail((String)message);
            }
            ++i;
        }
    }

    protected void assertEquals(String message, Map<String, ? extends Object> map, Object[] keys, Object[] values) {
        MarkerTest.assertEquals((String)message, (int)keys.length, (int)values.length);
        MarkerTest.assertEquals((String)message, (int)keys.length, (int)map.size());
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            boolean found = false;
            int j = 0;
            while (!found && j < keys.length) {
                if (keys[j].equals(key)) {
                    found = true;
                    if (!values[j].equals(value)) {
                        MarkerTest.fail((String)message);
                    }
                }
                ++j;
            }
            if (found) continue;
            MarkerTest.assertTrue((String)message, (boolean)false);
        }
    }

    protected void assertExists(String message, IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.assertExists(message, marker);
            ++n2;
        }
    }

    protected void assertExists(String message, IMarker marker) {
        MarkerTest.assertTrue((String)message, (boolean)marker.exists());
    }

    public IResource[] createLargeHierarchy() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("/");
        new MarkerTest().addChildren(result, (IPath)Path.ROOT, 3, 4);
        String[] names = result.toArray(new String[result.size()]);
        IResource[] created = this.buildResources((IContainer)MarkerTest.getWorkspace().getRoot(), names);
        this.ensureExistsInWorkspace(created, true);
        return created;
    }

    protected IMarker[] createMarkers(IResource[] hosts, String type) throws CoreException {
        IMarker[] result = new IMarker[hosts.length];
        MarkerTest.getWorkspace().run(monitor -> {
            int i = 0;
            while (i < hosts.length) {
                iMarkerArray[i] = hosts[i].createMarker(type);
                ++i;
            }
        }, this.getMonitor());
        return result;
    }

    public void createProblem(IResource host, int severity) {
        try {
            IMarker marker = host.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", severity);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)("Failed to create problem on resource: " + host), (Throwable)e);
        }
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/", "1/", "1/1", "1/2/", "1/2/1", "1/2/2/", "2/", "2/1", "2/2/", "2/2/1", "2/2/2/"};
    }

    public void display(long start, long stop) {
        this.display("Start: " + start);
        this.display("Stop: " + stop);
        this.display("Duration: " + (stop - start));
    }

    public void display(String message) {
        System.out.println(message);
    }

    public static boolean equals(IMarker a, IMarker b) {
        block3: {
            try {
                if (a.getType() == b.getType()) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return a.getId() == b.getId();
    }

    protected static boolean equalsOrNull(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resources = this.createHierarchy();
    }

    public static Test suite() {
        return new TestSuite(MarkerTest.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            MarkerTest.getWorkspace().getRoot().delete(true, null);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"#tearDown", (Throwable)e);
        }
    }

    public void testCopyResource() {
        MarkerTest.debug((String)"TestCopyResource");
    }

    public void testCreateMarker() {
        MarkerTest.debug((String)"TestCreateMarker");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            listener.reset();
            IMarker[] markers = new IMarker[3];
            try {
                markers[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                markers[1] = resource.createMarker("org.eclipse.core.resources.bookmark");
                markers[2] = resource.createMarker("org.eclipse.core.resources.taskmarker");
                this.assertExists("1.0." + resource.getFullPath(), markers);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("1.1." + resource.getFullPath()), (Throwable)e);
            }
            MarkerTest.assertEquals((String)("1.2." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
            MarkerTest.assertTrue((String)("1.3." + resource.getFullPath()), (boolean)listener.checkChanges(resource, markers, null, null));
            try {
                resource.createMarker(null);
                MarkerTest.fail((String)("2.0." + resource.getFullPath()));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("2.1." + resource.getFullPath()), (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            ++n2;
        }
        IFile testResource = MarkerTest.getWorkspace().getRoot().getFile((IPath)new Path("non/existant/resource"));
        MarkerTest.assertTrue((String)"3.0", (!testResource.exists() ? 1 : 0) != 0);
        try {
            testResource.createMarker("org.eclipse.core.resources.problemmarker");
            MarkerTest.fail((String)"3.1");
        }
        catch (CoreException coreException) {}
        MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
    }

    public void testCreationTime() {
        int i = 0;
        while (i < this.resources.length) {
            IMarker marker = null;
            try {
                marker = this.resources[i].createMarker("org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"0.0", (Throwable)e);
            }
            try {
                MarkerTest.assertTrue((String)("1.0." + i), (0L != marker.getCreationTime() ? 1 : 0) != 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.1", (Throwable)e);
            }
            ++i;
        }
    }

    public void testDeleteMarker() {
        MarkerTest.debug((String)"TestDeleteMarker");
        IMarker marker = null;
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                listener.reset();
                marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                MarkerTest.assertEquals((String)("2.0." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                MarkerTest.assertTrue((String)("2.1." + resource.getFullPath()), (boolean)listener.checkChanges(resource, new IMarker[]{marker}, null, null));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("2.2." + resource.getFullPath()), (Throwable)e);
            }
            this.assertExists("2.3." + resource.getFullPath(), marker);
            try {
                listener.reset();
                marker.delete();
                this.assertDoesNotExist("2.4." + resource.getFullPath(), marker);
                MarkerTest.assertEquals((String)("2.5." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                MarkerTest.assertTrue((String)("2.6." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, new IMarker[]{marker}, null));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("2.7." + resource.getFullPath()), (Throwable)e);
            }
            try {
                marker.delete();
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("3.0." + resource.getFullPath()), (Throwable)e);
            }
            IMarker[] markers = new IMarker[3];
            try {
                markers[0] = resource.createMarker("org.eclipse.core.resources.bookmark");
                this.assertExists("4.0." + resource.getFullPath(), markers[0]);
                markers[1] = resource.createMarker("org.eclipse.core.resources.taskmarker");
                this.assertExists("4.1." + resource.getFullPath(), markers[1]);
                markers[2] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                this.assertExists("4.2." + resource.getFullPath(), markers[2]);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.3." + resource.getFullPath()), (Throwable)e);
            }
            try {
                listener.reset();
                MarkerTest.getWorkspace().deleteMarkers(markers);
                MarkerTest.assertEquals((String)("4.4." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                MarkerTest.assertTrue((String)("4.5." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, markers, null));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.6." + resource.getFullPath()), (Throwable)e);
            }
            this.assertDoesNotExist("4.7." + resource.getFullPath(), markers);
            ++n2;
        }
        MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
    }

    public void testDeleteMarkers() {
        MarkerTest.debug((String)"TestDeleteMarkers");
        IMarker[] markers = null;
        try {
            markers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.0", (Throwable)e);
        }
        try {
            MarkerTest.getWorkspace().deleteMarkers(markers);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.0", (Throwable)e);
        }
        int i = 0;
        while (i < markers.length) {
            MarkerTest.assertTrue((String)"1.1", (!markers[i].exists() ? 1 : 0) != 0);
            ++i;
        }
        try {
            MarkerTest.getWorkspace().deleteMarkers(new IMarker[0]);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.2", (Throwable)e);
        }
    }

    public void testFindMarkers() {
        IMarker[] found;
        IMarker marker;
        IMarker[] found2;
        MarkerTest.debug((String)"TestFindMarkers");
        IMarker[] markers = null;
        try {
            markers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.0", (Throwable)e);
        }
        try {
            found2 = MarkerTest.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            this.assertEquals("1.0", markers, found2);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            found2 = MarkerTest.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            this.assertEquals("1.2", markers, found2);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            found2 = MarkerTest.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.bookmark", false, 2);
            MarkerTest.assertTrue((String)"2.0", (found2.length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"2.1", (Throwable)e);
        }
        Vector<IMarker> allMarkers = new Vector<IMarker>(markers.length * 3);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            allMarkers.add(marker);
            ++n2;
        }
        try {
            markers = this.createMarkers(this.resources, "org.eclipse.core.resources.bookmark");
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.0", (Throwable)e);
        }
        iMarkerArray = markers;
        n = markers.length;
        n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            allMarkers.add(marker);
            ++n2;
        }
        try {
            markers = this.createMarkers(this.resources, "org.eclipse.core.resources.taskmarker");
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.1", (Throwable)e);
        }
        iMarkerArray = markers;
        n = markers.length;
        n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            allMarkers.add(marker);
            ++n2;
        }
        try {
            found = MarkerTest.getWorkspace().getRoot().findMarkers(null, false, 2);
            this.assertEquals("3.2", allMarkers.toArray(new IMarker[allMarkers.size()]), found);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.3", (Throwable)e);
        }
        try {
            found = MarkerTest.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.marker", true, 2);
            this.assertEquals("3.4", allMarkers.toArray(new IMarker[allMarkers.size()]), found);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.5", (Throwable)e);
        }
    }

    public void test_35300() {
        IProject project = MarkerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String MARKER_ID = "foomarker.example.com";
        IMarker marker = null;
        int expected = 4;
        try {
            marker = project.createMarker(MARKER_ID);
            marker.setAttribute("transient", expected);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.0", (Throwable)e);
        }
        catch (Exception e) {
            MarkerTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            int actual = marker.getAttribute("transient", -1);
            MarkerTest.assertEquals((String)"2.1", (int)expected, (int)actual);
            try {
                marker.setAttribute("message", (Object)this.getRandomString());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.2", (Throwable)e);
            }
        }
        catch (Exception e) {
            MarkerTest.fail((String)"2.3", (Throwable)e);
        }
    }

    public void test_10989() {
        MarkerTest.debug((String)"test_10989");
        try {
            IProject project = MarkerTest.getWorkspace().getRoot().getProject("MyProject");
            project.create(null);
            project.open(null);
            IFile file = project.getFile("foo.txt");
            file.create(this.getRandomContents(), true, null);
            file.createMarker("org.eclipse.core.resources.problemmarker");
            IMarker[] found = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            MarkerTest.assertEquals((String)"1.0", (int)1, (int)found.length);
            found = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            MarkerTest.assertEquals((String)"1.1", (int)1, (int)found.length);
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test_289811() {
        MarkerTest.debug((String)"test_289811");
        IFile file = null;
        String testValue = this.getRandomString();
        try {
            IProject project = MarkerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
            project.create(null);
            project.open(null);
            file = project.getFile("foo.txt");
            file.create(this.getRandomContents(), true, null);
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttributes(new HashMap());
            marker.setAttribute("severity", (Object)testValue);
            Object value = marker.getAttribute("severity");
            MarkerTest.assertEquals((String)("1.0." + file.getFullPath()), (Object)value, (Object)testValue);
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)("1.1." + file.getFullPath()), (Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MarkerTest.fail((String)("1.2." + file.getFullPath()), (Throwable)e);
        }
        catch (RuntimeException e) {
            MarkerTest.fail((String)("1.3." + file.getFullPath()), (Throwable)e);
        }
    }

    public void testFindMaxProblemSeverity() throws CoreException {
        IWorkspaceRoot root = MarkerTest.getWorkspace().getRoot();
        IProject project = root.getProject("testFindMaxProblemSeverity");
        IFolder folder = project.getFolder("top");
        IFolder sub = folder.getFolder("sub");
        IFile topFile = folder.getFile("a.txt");
        IFile subFile = sub.getFile("b.txt");
        IResource[] allResources = new IResource[]{project, folder, sub, topFile, subFile};
        this.ensureExistsInWorkspace(allResources, true);
        MarkerTest.assertEquals((String)"1.0", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"1.1", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2));
        MarkerTest.assertEquals((String)"1.2", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
        this.createProblem((IResource)subFile, 0);
        MarkerTest.assertEquals((String)"2.0", (int)0, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"2.1", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"2.2", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
        MarkerTest.assertEquals((String)"2.3", (int)-1, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2));
        MarkerTest.assertEquals((String)"3.0", (int)0, (int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"3.1", (int)-1, (int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"3.2", (int)-1, (int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
        MarkerTest.assertEquals((String)"3.3", (int)-1, (int)folder.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2));
        MarkerTest.assertEquals((String)"4.1", (int)0, (int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"4.2", (int)0, (int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"4.3", (int)-1, (int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
        MarkerTest.assertEquals((String)"4.4", (int)-1, (int)sub.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2));
        MarkerTest.assertEquals((String)"5.1", (int)0, (int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"5.2", (int)0, (int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", false, 1));
        MarkerTest.assertEquals((String)"5.3", (int)0, (int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
        MarkerTest.assertEquals((String)"5.4", (int)-1, (int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2));
        this.createProblem((IResource)topFile, 2);
        MarkerTest.assertEquals((String)"6.1", (int)2, (int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2));
        MarkerTest.assertEquals((String)"6.2", (int)2, (int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"6.3", (int)2, (int)topFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"6.4", (int)0, (int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1));
        MarkerTest.assertEquals((String)"6.5", (int)0, (int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0));
    }

    public void testIsSubTypeOf() {
        IProject project = MarkerTest.getWorkspace().getRoot().getProject("testisSubType");
        try {
            this.ensureExistsInWorkspace((IResource)project, true);
            IMarker marker = project.createMarker("org.eclipse.core.resources.marker");
            IMarker task = project.createMarker("org.eclipse.core.resources.taskmarker");
            IMarker problem = project.createMarker("org.eclipse.core.resources.problemmarker");
            IMarker testProblem = project.createMarker(TEST_PROBLEM_MARKER);
            IMarker invalid = project.createMarker("does.not.exist.at.AllMarker");
            MarkerTest.assertTrue((String)"1.0", (boolean)marker.isSubtypeOf("org.eclipse.core.resources.marker"));
            MarkerTest.assertTrue((String)"1.1", (!marker.isSubtypeOf("org.eclipse.core.resources.taskmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"1.2", (!marker.isSubtypeOf("org.eclipse.core.resources.problemmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"1.3", (!marker.isSubtypeOf(TEST_PROBLEM_MARKER) ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"1.4", (!marker.isSubtypeOf("does.not.exist.at.AllMarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"2.0", (boolean)task.isSubtypeOf("org.eclipse.core.resources.marker"));
            MarkerTest.assertTrue((String)"2.1", (boolean)task.isSubtypeOf("org.eclipse.core.resources.taskmarker"));
            MarkerTest.assertTrue((String)"2.2", (!task.isSubtypeOf("org.eclipse.core.resources.problemmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"2.3", (!task.isSubtypeOf(TEST_PROBLEM_MARKER) ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"2.4", (!task.isSubtypeOf("does.not.exist.at.AllMarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"3.0", (boolean)problem.isSubtypeOf("org.eclipse.core.resources.marker"));
            MarkerTest.assertTrue((String)"3.1", (!problem.isSubtypeOf("org.eclipse.core.resources.taskmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"3.2", (boolean)problem.isSubtypeOf("org.eclipse.core.resources.problemmarker"));
            MarkerTest.assertTrue((String)"3.3", (!problem.isSubtypeOf(TEST_PROBLEM_MARKER) ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"3.4", (!problem.isSubtypeOf("does.not.exist.at.AllMarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"4.0", (boolean)testProblem.isSubtypeOf("org.eclipse.core.resources.marker"));
            MarkerTest.assertTrue((String)"4.1", (!testProblem.isSubtypeOf("org.eclipse.core.resources.taskmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"4.2", (boolean)testProblem.isSubtypeOf("org.eclipse.core.resources.problemmarker"));
            MarkerTest.assertTrue((String)"4.3", (boolean)testProblem.isSubtypeOf(TEST_PROBLEM_MARKER));
            MarkerTest.assertTrue((String)"4.4", (!testProblem.isSubtypeOf("does.not.exist.at.AllMarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"5.0", (!invalid.isSubtypeOf("org.eclipse.core.resources.marker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"5.1", (!invalid.isSubtypeOf("org.eclipse.core.resources.taskmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"5.2", (!invalid.isSubtypeOf("org.eclipse.core.resources.problemmarker") ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"5.3", (!invalid.isSubtypeOf(TEST_PROBLEM_MARKER) ? 1 : 0) != 0);
            MarkerTest.assertTrue((String)"5.4", (boolean)invalid.isSubtypeOf("does.not.exist.at.AllMarker"));
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testMarkerChangesInDelta() {
        MarkerTest.debug((String)"TestMarkerChangesInDelta");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            IWorkspaceRoot resource;
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource2 = iResourceArray[n2];
                resource = resource2;
                IMarker[] markers = new IMarker[3];
                listener.reset();
                try {
                    markers[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    this.assertExists("1.0." + resource.getFullPath(), markers[0]);
                    MarkerTest.assertEquals((String)("1.1." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("1.2." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, new IMarker[]{markers[0]}, null, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("1.99." + resource.getFullPath()), (Throwable)e);
                }
                listener.reset();
                try {
                    markers[1] = resource.createMarker("org.eclipse.core.resources.bookmark");
                    markers[2] = resource.createMarker("org.eclipse.core.resources.taskmarker");
                    this.assertExists("2.0." + resource.getFullPath(), new IMarker[]{markers[1], markers[2]});
                    MarkerTest.assertEquals((String)("2.1." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("2.2." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, new IMarker[]{markers[1], markers[2]}, null, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("2.99." + resource.getFullPath()), (Throwable)e);
                }
                listener.reset();
                try {
                    markers[0].setAttribute("message", (Object)"My text.");
                    MarkerTest.assertEquals((String)("3.0." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("3.1." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, null, null, new IMarker[]{markers[0]}));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("3.99." + resource.getFullPath()), (Throwable)e);
                }
                listener.reset();
                try {
                    markers[1].setAttribute("severity", (Object)"Low");
                    markers[2].setAttribute("priority", (Object)"Normal");
                    MarkerTest.assertEquals((String)("4.0." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("4.1." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, null, null, new IMarker[]{markers[1], markers[2]}));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("4.99." + resource.getFullPath()), (Throwable)e);
                }
                listener.reset();
                try {
                    markers[0].delete();
                    this.assertDoesNotExist("5.0." + resource.getFullPath(), markers[0]);
                    MarkerTest.assertEquals((String)("5.1." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("5.2." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, null, new IMarker[]{markers[0]}, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("5.99." + resource.getFullPath()), (Throwable)e);
                }
                listener.reset();
                try {
                    resource.deleteMarkers(null, false, 0);
                    this.assertDoesNotExist("6.0." + resource.getFullPath(), new IMarker[]{markers[1], markers[2]});
                    MarkerTest.assertEquals((String)("6.1." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("6.2." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, null, new IMarker[]{markers[1], markers[2]}, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("6.99." + resource.getFullPath()), (Throwable)e);
                }
                try {
                    markers[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    markers[1] = resource.createMarker("org.eclipse.core.resources.bookmark");
                    listener.reset();
                    markers[0].delete();
                    this.assertDoesNotExist("7.0." + resource.getFullPath(), markers[0]);
                    markers[1].setAttribute("message", (Object)this.getRandomString());
                    markers[2] = resource.createMarker("org.eclipse.core.resources.taskmarker");
                    MarkerTest.assertEquals((String)("7.1." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("7.2." + resource.getFullPath()), (boolean)listener.checkChanges((IResource)resource, new IMarker[]{markers[2]}, new IMarker[]{markers[0]}, new IMarker[]{markers[1]}));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("7.99." + resource.getFullPath()), (Throwable)e);
                }
                ++n2;
            }
            try {
                resource = MarkerTest.getWorkspace().getRoot();
                resource.deleteMarkers(null, true, 2);
                IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                listener.reset();
                resource.delete(true, this.getMonitor());
                this.assertDoesNotExist("8.0", marker);
                MarkerTest.assertTrue((String)"8.1", (boolean)listener.checkChanges((IResource)resource, null, new IMarker[]{marker}, null));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"8.99", (Throwable)e);
            }
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltaAttributes() {
        MarkerTest.debug((String)"testMarkerDeltaAttributes");
        IMarker[] markers = new IMarker[3];
        IWorkspaceRunnable body = monitor -> {
            iMarkerArray[0] = this.resources[0].createMarker("org.eclipse.core.resources.bookmark");
            iMarkerArray[1] = this.resources[1].createMarker("org.eclipse.core.resources.bookmark");
            markers[1].setAttribute("charStart", 5);
            iMarkerArray[2] = this.resources[2].createMarker("org.eclipse.core.resources.problemmarker");
            markers[2].setAttribute("done", true);
            markers[2].setAttribute("priority", 2);
            markers[2].setAttribute("message", (Object)"Hello");
        };
        try {
            MarkerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"0.99", (Throwable)e);
        }
        MarkerAttributeChangeListener listener = new MarkerAttributeChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            try {
                listener.expectChanges(markers[0]);
                markers[0].setAttribute("message", (Object)"Message");
                listener.verifyChanges();
                listener.expectChanges(markers[0]);
                markers[0].setAttribute("message", (Object)"NewMessage");
                listener.verifyChanges();
                listener.expectChanges(markers[0]);
                markers[0].setAttribute("message", null);
                listener.verifyChanges();
                listener.expectChanges(markers[2]);
                markers[2].setAttribute("charEnd", 5);
                listener.verifyChanges();
                listener.expectChanges(markers[1]);
                MarkerTest.getWorkspace().run(monitor -> {
                    markers[1].setAttribute("charStart", 5);
                    markers[1].setAttribute("charEnd", 10);
                }, this.getMonitor());
                listener.verifyChanges();
                listener.expectChanges(markers[1]);
                MarkerTest.getWorkspace().run(monitor -> {
                    markers[1].setAttribute("charStart", 5);
                    markers[1].setAttribute("charStart", null);
                }, this.getMonitor());
                listener.verifyChanges();
                listener.expectChanges(markers);
                MarkerTest.getWorkspace().run(monitor -> {
                    markers[0].setAttribute("charStart", 5);
                    markers[1].setAttribute("charStart", 10);
                    markers[2].setAttribute("priority", 0);
                }, this.getMonitor());
                listener.verifyChanges();
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.99", (Throwable)e);
                MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
            }
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltasCopyResource() {
        MarkerTest.debug((String)"testMarkerDeltasCopyResource");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            Hashtable table = new Hashtable(1);
            int[] count = new int[]{0};
            IWorkspaceRunnable body = monitor -> {
                IResourceVisitor visitor = resource -> {
                    if (resource.getType() == 8 || resource.getType() == 4) {
                        return true;
                    }
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                    table.put(resource, marker);
                    nArray[0] = count[0] + 1;
                    return true;
                };
                MarkerTest.getWorkspace().getRoot().accept(visitor);
            };
            try {
                MarkerTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"0.99", (Throwable)e);
            }
            listener.reset();
            try {
                IProject[] projects;
                IProject[] iProjectArray = projects = MarkerTest.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource[] children;
                    IProject project = iProjectArray[n2];
                    IResource[] iResourceArray = children = project.members();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource element = iResourceArray[n4];
                        Path destination = new Path(String.valueOf(element.getName()) + "copy");
                        element.copy((IPath)destination, true, this.getMonitor());
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.99", (Throwable)e);
            }
            MarkerTest.assertEquals((String)"2.5", (int)0, (int)listener.numAffectedResources());
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltasMerge() {
        MarkerTest.debug((String)"testMarkerDeltasMerge");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceRunnable body;
                IMarker[] markers;
                IResource resource = iResourceArray[n2];
                try {
                    IWorkspaceRunnable body2 = monitor -> {
                        listener.reset();
                        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                        this.assertExists("1.0." + resource.getFullPath(), marker);
                        marker.delete();
                        this.assertDoesNotExist("1.1." + resource.getFullPath(), marker);
                    };
                    MarkerTest.getWorkspace().run(body2, this.getMonitor());
                    MarkerTest.assertEquals((String)("1.2." + resource.getFullPath()), (int)0, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("1.3." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, null, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("1.99." + resource.getFullPath()), (Throwable)e);
                }
                try {
                    markers = new IMarker[1];
                    body = monitor -> {
                        listener.reset();
                        iMarkerArray[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
                        this.assertExists("2.0." + resource.getFullPath(), markers[0]);
                        markers[0].setAttribute("message", (Object)"my message text");
                        MarkerTest.assertEquals((String)("2.1." + resource.getFullPath()), (Object)"my message text", (Object)markers[0].getAttribute("message"));
                    };
                    MarkerTest.getWorkspace().run(body, this.getMonitor());
                    MarkerTest.assertEquals((String)("2.2." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("2.3." + resource.getFullPath()), (boolean)listener.checkChanges(resource, new IMarker[]{markers[0]}, null, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("2.99." + resource.getFullPath()), (Throwable)e);
                }
                try {
                    markers = new IMarker[]{resource.createMarker("org.eclipse.core.resources.problemmarker")};
                    this.assertExists("4.0." + resource.getFullPath(), markers[0]);
                    body = monitor -> {
                        listener.reset();
                        markers[0].setAttribute("message", (Object)"my message text");
                        MarkerTest.assertEquals((String)("4.1." + resource.getFullPath()), (Object)"my message text", (Object)markers[0].getAttribute("message"));
                        markers[0].setAttribute("priority", 2);
                        MarkerTest.assertEquals((String)("4.2." + resource.getFullPath()), (int)2, (int)((Integer)markers[0].getAttribute("priority")));
                    };
                    MarkerTest.getWorkspace().run(body, this.getMonitor());
                    MarkerTest.assertEquals((String)("4.3." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("4.4." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, null, new IMarker[]{markers[0]}));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("4.99." + resource.getFullPath()), (Throwable)e);
                }
                try {
                    markers = new IMarker[]{resource.createMarker("org.eclipse.core.resources.problemmarker")};
                    this.assertExists("5.0." + resource.getFullPath(), markers[0]);
                    body = monitor -> {
                        listener.reset();
                        markers[0].setAttribute("message", (Object)"my message text");
                        MarkerTest.assertEquals((String)("5.1." + resource.getFullPath()), (Object)"my message text", (Object)markers[0].getAttribute("message"));
                        markers[0].delete();
                        this.assertDoesNotExist("5.2." + resource.getFullPath(), markers[0]);
                    };
                    MarkerTest.getWorkspace().run(body, this.getMonitor());
                    MarkerTest.assertEquals((String)("5.3." + resource.getFullPath()), (int)1, (int)listener.numAffectedResources());
                    MarkerTest.assertTrue((String)("5.4." + resource.getFullPath()), (boolean)listener.checkChanges(resource, null, new IMarker[]{markers[0]}, null));
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)("5.99." + resource.getFullPath()), (Throwable)e);
                }
                try {
                    resource.deleteMarkers(null, true, 0);
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)"99.99", (Throwable)e);
                }
                ++n2;
            }
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltasMoveFolder() {
        MarkerTest.debug((String)"testMarkerDeltasMoveFolder");
        IWorkspaceRoot root = MarkerTest.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subFile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file, subFile}, true);
        IFolder destFolder = project.getFolder("myOtherFolder");
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IMarker folderMarker = null;
        IMarker subFileMarker = null;
        IMarker[] markers = null;
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            try {
                folderMarker = folder.createMarker("org.eclipse.core.resources.bookmark");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                subFileMarker = subFile.createMarker("org.eclipse.core.resources.bookmark");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.1", (Throwable)e);
            }
            listener.reset();
            try {
                folder.move(destFolder.getFullPath(), 1, this.getMonitor());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.0", (Throwable)e);
            }
            MarkerTest.assertTrue((String)"3.1", (boolean)listener.checkChanges((IResource)folder, null, new IMarker[]{folderMarker}, null));
            try {
                markers = destFolder.findMarkers(null, true, 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"3.2", (Throwable)e);
            }
            MarkerTest.assertEquals((String)"3.3", (int)1, (int)markers.length);
            MarkerTest.assertEquals((String)"3.4", (long)folderMarker.getId(), (long)markers[0].getId());
            MarkerTest.assertTrue((String)"3.5", (boolean)listener.checkChanges((IResource)destFolder, new IMarker[]{markers[0]}, null, null));
            MarkerTest.assertTrue((String)"3.7", (boolean)listener.checkChanges((IResource)subFile, null, new IMarker[]{subFileMarker}, null));
            try {
                markers = destSubFile.findMarkers(null, true, 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"3.8", (Throwable)e);
            }
            MarkerTest.assertEquals((String)"3.9", (int)1, (int)markers.length);
            MarkerTest.assertEquals((String)"3.10", (long)subFileMarker.getId(), (long)markers[0].getId());
            MarkerTest.assertTrue((String)"3.11", (boolean)listener.checkChanges((IResource)destSubFile, new IMarker[]{markers[0]}, null, null));
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltasMoveFile() {
        MarkerTest.debug((String)"testMarkerDeltasMoveFile");
        IWorkspaceRoot root = MarkerTest.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subFile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file, subFile}, true);
        IFile destFile = folder.getFile(file.getName());
        IFile destSubFile = project.getFile(subFile.getName());
        IMarker fileMarker = null;
        IMarker subFileMarker = null;
        IMarker[] markers = null;
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            try {
                fileMarker = file.createMarker("org.eclipse.core.resources.bookmark");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                subFileMarker = subFile.createMarker("org.eclipse.core.resources.bookmark");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.1", (Throwable)e);
            }
            listener.reset();
            try {
                file.move(destFile.getFullPath(), 1, this.getMonitor());
                subFile.move(destSubFile.getFullPath(), 1, this.getMonitor());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.0", (Throwable)e);
            }
            MarkerTest.assertTrue((String)"3.1", (boolean)listener.checkChanges((IResource)file, null, new IMarker[]{fileMarker}, null));
            try {
                markers = destFile.findMarkers(null, true, 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"3.2", (Throwable)e);
            }
            MarkerTest.assertEquals((String)"3.3", (int)1, (int)markers.length);
            MarkerTest.assertEquals((String)"3.4", (long)fileMarker.getId(), (long)markers[0].getId());
            MarkerTest.assertTrue((String)"3.5", (boolean)listener.checkChanges((IResource)destFile, new IMarker[]{markers[0]}, null, null));
            MarkerTest.assertTrue((String)"3.7", (boolean)listener.checkChanges((IResource)subFile, null, new IMarker[]{subFileMarker}, null));
            try {
                markers = destSubFile.findMarkers(null, true, 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"3.8", (Throwable)e);
            }
            MarkerTest.assertEquals((String)"3.9", (int)1, (int)markers.length);
            MarkerTest.assertEquals((String)"3.10", (long)subFileMarker.getId(), (long)markers[0].getId());
            MarkerTest.assertTrue((String)"3.11", (boolean)listener.checkChanges((IResource)destSubFile, new IMarker[]{markers[0]}, null, null));
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerDeltasMoveProject() {
        MarkerTest.debug((String)"testMarkerDeltasMoveProject");
        MarkersChangeListener listener = new MarkersChangeListener();
        MarkerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            IProject[] projects;
            Hashtable table = new Hashtable(1);
            int[] count = new int[]{0};
            IWorkspaceRunnable body = monitor -> {
                IResourceVisitor visitor = resource -> {
                    if (resource.getType() == 8) {
                        return true;
                    }
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                    table.put(resource, marker);
                    nArray[0] = count[0] + 1;
                    return true;
                };
                MarkerTest.getWorkspace().getRoot().accept(visitor);
            };
            try {
                MarkerTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"0.99", (Throwable)e);
            }
            listener.reset();
            IProject[] iProjectArray = projects = MarkerTest.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                Path destination = new Path(String.valueOf(project.getName()) + "move");
                try {
                    project.move((IPath)destination, true, this.getMonitor());
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)"1.99", (Throwable)e);
                }
                ++n2;
            }
            IResourceVisitor visitor = resource -> {
                if (resource.getType() == 8) {
                    return true;
                }
                String name = resource.getFullPath().segment(0);
                IPath path = new Path(name.substring(0, name.length() - 4)).makeAbsolute();
                path = path.append(resource.getFullPath().removeFirstSegments(1));
                Resource oldResource = ((Workspace)MarkerTest.getWorkspace()).newResource(path, resource.getType());
                IMarker marker = (IMarker)table.get(oldResource);
                MarkerTest.assertNotNull((String)("2.1." + oldResource.getFullPath()), (Object)marker);
                MarkerTest.assertTrue((String)("2.2." + oldResource.getFullPath()), (boolean)listener.checkChanges((IResource)oldResource, null, new IMarker[]{marker}, null));
                IMarker[] markers = resource.findMarkers(null, true, 0);
                MarkerTest.assertEquals((String)("2.3." + resource.getFullPath()), (int)1, (int)markers.length);
                MarkerTest.assertEquals((String)("2.4." + resource.getFullPath()), (long)marker.getId(), (long)markers[0].getId());
                MarkerTest.assertTrue((String)("2.5." + resource.getFullPath()), (boolean)listener.checkChanges(resource, new IMarker[]{markers[0]}, null, null));
                return true;
            };
            MarkerTest.assertEquals((String)"2.6", (int)(count[0] * 2), (int)listener.numAffectedResources());
            try {
                MarkerTest.getWorkspace().getRoot().accept(visitor);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"2.99", (Throwable)e);
            }
        }
        finally {
            MarkerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testMarkerSave() {
        File file;
        IMarker[] expected;
        block32: {
            MarkerTest.debug((String)"TestMarkerSave");
            IMarker[] newMarkers = null;
            expected = null;
            try {
                newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
                expected = new IMarker[newMarkers.length * 3];
                int i = 0;
                while (i < newMarkers.length) {
                    expected[i] = newMarkers[i];
                    ++i;
                }
                newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.bookmark");
                i = 0;
                while (i < newMarkers.length) {
                    expected[i + newMarkers.length] = newMarkers[i];
                    ++i;
                }
                newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.taskmarker");
                i = 0;
                while (i < newMarkers.length) {
                    expected[i + newMarkers.length * 2] = newMarkers[i];
                    ++i;
                }
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.0", (Throwable)e);
            }
            MarkerManager manager = ((Workspace)MarkerTest.getWorkspace()).getMarkerManager();
            file = Platform.getLocation().append(".testmarkers").toFile();
            FileOutputStream fileOutput = null;
            DataOutputStream o1 = null;
            try {
                fileOutput = new FileOutputStream(file);
                o1 = new DataOutputStream(fileOutput);
            }
            catch (FileNotFoundException e) {
                MarkerTest.fail((String)"2.0", (Throwable)e);
            }
            DataOutputStream output = o1;
            ArrayList list = new ArrayList(5);
            IResourceVisitor visitor = resource -> {
                ResourceInfo info;
                block3: {
                    info = ((Resource)resource).getResourceInfo(false, false);
                    if (info != null) break block3;
                    return true;
                }
                try {
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    manager.save(info, requestor, output, list);
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"2.1", (Throwable)e);
                }
                return true;
            };
            try {
                try {
                    MarkerTest.getWorkspace().getRoot().accept(visitor);
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)"2.2", (Throwable)e);
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        MarkerTest.fail((String)"2.3", (Throwable)e2);
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"2.3", (Throwable)e);
                }
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException e) {
                MarkerTest.fail((String)"2.3", (Throwable)e);
            }
        }
        try {
            MarkerTest.getWorkspace().getRoot().deleteMarkers(null, true, 2);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertDoesNotExist("3.1", expected);
        try {
            FileInputStream fileInput = new FileInputStream(file);
            DataInputStream input = new DataInputStream(fileInput);
            IWorkspaceRunnable body = monitor -> {
                MarkerReader reader = new MarkerReader((Workspace)MarkerTest.getWorkspace());
                try {
                    reader.read(input, true);
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"4.0", (Throwable)e);
                }
            };
            try {
                MarkerTest.getWorkspace().run(body, this.getMonitor());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"4.1", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            MarkerTest.fail((String)"4.2", (Throwable)e);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"4.3", (Throwable)e);
        }
        try {
            this.assertExists("5.0", expected);
            IMarker[] actual = MarkerTest.getWorkspace().getRoot().findMarkers(null, false, 2);
            this.assertEquals("5.1", expected, actual);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"5.2", (Throwable)e);
        }
        MarkerTest.assertTrue((String)"6.0", (boolean)file.delete());
    }

    public void testMarkerSaveTransient() {
        File file;
        IMarker[] expected;
        block29: {
            MarkerTest.debug((String)"TestMarkerSaveTransient");
            ArrayList persistentMarkers = new ArrayList();
            IResourceVisitor visitor = resource -> {
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                persistentMarkers.add(marker);
                marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                persistentMarkers.add(marker);
                marker = resource.createMarker(TRANSIENT_MARKER);
                marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                marker.setAttribute("transient", (Object)Boolean.TRUE);
                marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                marker.setAttribute("transient", (Object)Boolean.FALSE);
                persistentMarkers.add(marker);
                marker = resource.createMarker(TRANSIENT_MARKER);
                marker.setAttribute("transient", (Object)Boolean.FALSE);
                return true;
            };
            try {
                MarkerTest.getWorkspace().getRoot().accept(visitor);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.0", (Throwable)e);
            }
            MarkerManager manager = ((Workspace)MarkerTest.getWorkspace()).getMarkerManager();
            expected = persistentMarkers.toArray(new IMarker[persistentMarkers.size()]);
            file = Platform.getLocation().append(".testmarkers").toFile();
            FileOutputStream fileOutput = null;
            DataOutputStream o1 = null;
            try {
                fileOutput = new FileOutputStream(file);
                o1 = new DataOutputStream(fileOutput);
            }
            catch (FileNotFoundException e) {
                MarkerTest.fail((String)"2.0", (Throwable)e);
            }
            DataOutputStream output = o1;
            ArrayList list = new ArrayList(5);
            visitor = resource -> {
                ResourceInfo info;
                block3: {
                    info = ((Resource)resource).getResourceInfo(false, false);
                    if (info != null) break block3;
                    return true;
                }
                try {
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    manager.save(info, requestor, output, list);
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"2.1", (Throwable)e);
                }
                return true;
            };
            try {
                try {
                    MarkerTest.getWorkspace().getRoot().accept(visitor);
                }
                catch (CoreException e) {
                    MarkerTest.fail((String)"2.2", (Throwable)e);
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        MarkerTest.fail((String)"2.3", (Throwable)e2);
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"2.3", (Throwable)e);
                }
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException e) {
                MarkerTest.fail((String)"2.3", (Throwable)e);
            }
        }
        try {
            MarkerTest.getWorkspace().getRoot().deleteMarkers(null, true, 2);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertDoesNotExist("3.1", expected);
        try {
            FileInputStream fileInput = new FileInputStream(file);
            DataInputStream input = new DataInputStream(fileInput);
            IWorkspaceRunnable body = monitor -> {
                MarkerReader reader = new MarkerReader((Workspace)MarkerTest.getWorkspace());
                try {
                    reader.read(input, true);
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"4.0", (Throwable)e);
                }
            };
            try {
                MarkerTest.getWorkspace().run(body, this.getMonitor());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    MarkerTest.fail((String)"4.1", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            MarkerTest.fail((String)"4.2", (Throwable)e);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"4.3", (Throwable)e);
        }
        try {
            this.assertExists("5.0", expected);
            IMarker[] actual = MarkerTest.getWorkspace().getRoot().findMarkers(null, false, 2);
            this.assertEquals("5.1", expected, actual);
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"5.2", (Throwable)e);
        }
        MarkerTest.assertTrue((String)"6.0", (boolean)file.delete());
    }

    public void testMoveResource() {
        MarkerTest.debug((String)"TestMoveResource");
    }

    public void testProjectCloseOpen() {
        MarkerTest.debug((String)"testProjectCloseOpen");
        IProject project = null;
        IMarker marker = null;
        project = MarkerTest.getWorkspace().getRoot().getProjects()[0];
        try {
            marker = project.createMarker("org.eclipse.core.resources.bookmark");
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"1.0", (Throwable)e);
        }
        MarkerTest.assertTrue((String)"2.0", (boolean)marker.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"3.0", (Throwable)e);
        }
        MarkerTest.assertTrue((String)"", (!marker.exists() ? 1 : 0) != 0);
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            MarkerTest.fail((String)"4.0", (Throwable)e);
        }
        MarkerTest.assertTrue((String)"5.0", (boolean)marker.exists());
    }

    public void testSetGetAttribute() {
        MarkerTest.debug((String)"testSetGetAttribute");
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IMarker marker = null;
            try {
                marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                MarkerTest.assertNull((String)("1.1." + resource.getFullPath()), (Object)marker.getAttribute("message"));
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("1.2." + resource.getFullPath()), (Throwable)e);
            }
            String testMessage = this.getRandomString();
            try {
                marker.setAttribute("message", (Object)testMessage);
                Object value = marker.getAttribute("message");
                MarkerTest.assertEquals((String)("2.0." + resource.getFullPath()), (String)testMessage, (String)((String)value));
                marker.setAttribute("message", null);
                value = marker.getAttribute("message");
                MarkerTest.assertNull((String)("2.1." + resource.getFullPath()), (Object)value);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("2.2." + resource.getFullPath()), (Throwable)e);
            }
            try {
                Object[] keys = new String[]{"location", "severity", "done"};
                Object[] values = new Object[]{this.getRandomString(), 5, Boolean.FALSE};
                marker.setAttributes((String[])keys, values);
                Object[] found = marker.getAttributes((String[])keys);
                this.assertEquals("3.0." + resource.getFullPath(), values, found);
                marker.setAttribute("severity", null);
                values[1] = null;
                found = marker.getAttributes((String[])keys);
                this.assertEquals("3.1." + resource.getFullPath(), values, found);
                values[1] = 5;
                marker.setAttribute("severity", values[1]);
                Map all = marker.getAttributes();
                this.assertEquals("3.2." + resource.getFullPath(), all, keys, values);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("3.2." + resource.getFullPath()), (Throwable)e);
            }
            try {
                marker.getAttribute(null);
                MarkerTest.fail((String)"4.0");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.1." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.2", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.getAttributes(null);
                MarkerTest.fail((String)"4.3");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.4." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.5", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttribute(null, (Object)this.getRandomString());
                MarkerTest.fail((String)"4.6");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.7." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.8", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttributes(null, (Object[])new String[]{this.getRandomString()});
                MarkerTest.fail((String)"4.9");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.10." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.11", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttributes(new String[]{"message"}, null);
                MarkerTest.fail((String)"4.12");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.13." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.14", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.delete();
            }
            catch (CoreException e) {
                MarkerTest.fail((String)"5.0", (Throwable)e);
            }
            try {
                marker.setAttribute("message", (Object)"Hello");
                MarkerTest.fail((String)"5.1");
            }
            catch (CoreException coreException) {}
            try {
                marker.setAttributes(new String[]{"lineNumber"}, new Object[]{4});
                MarkerTest.fail((String)"5.2");
            }
            catch (CoreException coreException) {}
            try {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("message", "Hello");
                marker.setAttributes(attributes);
                MarkerTest.fail((String)"5.3");
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    public void testSetGetAttribute2() {
        MarkerTest.debug((String)"testSetGetAttribute2");
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IMarker marker = null;
            try {
                marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("0.0" + resource.getFullPath()), (Throwable)e);
            }
            try {
                MarkerTest.assertNull((String)("1.0." + resource.getFullPath()), (Object)marker.getAttribute("message"));
                MarkerTest.assertEquals((String)("1.1." + resource.getFullPath()), (String)"default", (String)marker.getAttribute("message", "default"));
                MarkerTest.assertEquals((String)("1.2." + resource.getFullPath()), (boolean)true, (boolean)marker.getAttribute("message", true));
                MarkerTest.assertEquals((String)("1.3." + resource.getFullPath()), (int)5, (int)marker.getAttribute("message", 5));
                MarkerTest.assertNull((String)("1.4." + resource.getFullPath()), (Object)marker.getAttributes());
                MarkerTest.assertTrue((String)("1.5." + resource.getFullPath()), (marker.getAttributes(new String[]{"message"})[0] == null ? 1 : 0) != 0);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("1.99." + resource.getFullPath()), (Throwable)e);
            }
            String testMessage = this.getRandomString();
            try {
                marker.setAttribute("message", (Object)testMessage);
                Object value = marker.getAttribute("message");
                MarkerTest.assertEquals((String)("2.0." + resource.getFullPath()), (String)testMessage, (String)((String)value));
                marker.setAttribute("message", null);
                value = marker.getAttribute("message");
                MarkerTest.assertNull((String)("2.1." + resource.getFullPath()), (Object)value);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("2.2." + resource.getFullPath()), (Throwable)e);
            }
            try {
                Object[] keys = new String[]{"location", "severity", "done"};
                Object[] values = new Object[]{this.getRandomString(), 5, Boolean.FALSE};
                marker.setAttributes((String[])keys, values);
                Object[] found = marker.getAttributes((String[])keys);
                this.assertEquals("3.0." + resource.getFullPath(), values, found);
                marker.setAttribute("severity", null);
                values[1] = null;
                found = marker.getAttributes((String[])keys);
                this.assertEquals("3.1." + resource.getFullPath(), values, found);
                values[1] = 5;
                marker.setAttribute("severity", values[1]);
                Map all = marker.getAttributes();
                this.assertEquals("3.2." + resource.getFullPath(), all, keys, values);
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("3.2." + resource.getFullPath()), (Throwable)e);
            }
            try {
                marker.getAttribute(null);
                MarkerTest.fail((String)"4.0");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.1." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.2", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.getAttribute(null, "default");
                MarkerTest.fail((String)"4.3");
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.5", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.getAttribute(null, true);
                MarkerTest.fail((String)"4.6");
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.8", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.getAttribute(null, 5);
                MarkerTest.fail((String)"4.9");
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.11", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.getAttributes(null);
                MarkerTest.fail((String)"4.12");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.13." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.14", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttribute(null, (Object)this.getRandomString());
                MarkerTest.fail((String)"4.15");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.16." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.17", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttributes(null, (Object[])new String[]{this.getRandomString()});
                MarkerTest.fail((String)"4.18");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.19." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.20", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            try {
                marker.setAttributes(new String[]{"message"}, null);
                MarkerTest.fail((String)"4.21");
            }
            catch (CoreException e) {
                MarkerTest.fail((String)("4.22." + resource.getFullPath()), (Throwable)e);
            }
            catch (NullPointerException e) {
                MarkerTest.fail((String)"4.23", (Throwable)e);
            }
            catch (RuntimeException runtimeException) {}
            ++n2;
        }
    }
}

