/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.CheckMissingNaturesListener;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.internal.resources.SimpleNature;
import org.eclipse.core.tests.resources.ResourceTest;
import org.junit.Assert;

public class NatureTest
extends ResourceTest {
    IProject project;

    public NatureTest() {
    }

    public NatureTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NatureTest.class);
    }

    protected void setNatures(String message, IProject project, String[] natures, boolean shouldFail) {
        this.setNatures(message, project, natures, shouldFail, false);
    }

    protected void setNatures(String message, IProject project, String[] natures, boolean shouldFail, boolean silent) {
        block4: {
            try {
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(natures);
                int flags = 2;
                if (silent) {
                    flags |= 0x40;
                }
                project.setDescription(desc, flags, this.getMonitor());
                if (shouldFail) {
                    NatureTest.fail((String)message);
                }
            }
            catch (CoreException e) {
                if (shouldFail) break block4;
                NatureTest.fail((String)message, (Throwable)e);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.project.delete(true, null);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        super.tearDown();
        NatureTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)NatureTest.getWorkspace().getRoot());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getUniqueString());
    }

    public void testInvalidAdditions() {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        this.setNatures("1.0", this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        this.setNatures("2.0", this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "no.such.nature.Missing"}, true);
        try {
            NatureTest.assertTrue((String)"2.1", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"2.2", (!this.project.hasNature("no.such.nature.Missing") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"2.3", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"2.4", (!this.project.isNatureEnabled("no.such.nature.Missing") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
        this.setNatures("3.0", this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"}, true);
        try {
            NatureTest.assertTrue((String)"3.1", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"3.2", (!this.project.hasNature("org.eclipse.core.tests.resources.snowNature") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"3.3", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"3.4", (!this.project.isNatureEnabled("org.eclipse.core.tests.resources.snowNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.99", (Throwable)e);
        }
        this.setNatures("4.0", this.project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        this.setNatures("4.1", this.project, new String[]{"org.eclipse.core.tests.resources.earthNature", "org.eclipse.core.tests.resources.waterNature"}, true);
        try {
            NatureTest.assertTrue((String)"3.1", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.earthNature"));
            NatureTest.assertTrue((String)"3.2", (!this.project.hasNature("org.eclipse.core.tests.resources.waterNature") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"3.3", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature"));
            NatureTest.assertTrue((String)"3.4", (!this.project.isNatureEnabled("org.eclipse.core.tests.resources.waterNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testInvalidRemovals() {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        this.setNatures("1.0", this.project, new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"}, false);
        this.setNatures("2.0", this.project, new String[]{"org.eclipse.core.tests.resources.snowNature"}, true);
        try {
            NatureTest.assertTrue((String)"2.1", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.waterNature"));
            NatureTest.assertTrue((String)"2.2", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.snowNature"));
            NatureTest.assertTrue((String)"2.3", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.waterNature"));
            NatureTest.assertTrue((String)"2.4", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.snowNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
    }

    public void testNatureLifecyle() {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        this.setNatures("1.0", this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        SimpleNature instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"1.1", (boolean)instance.wasConfigured);
        NatureTest.assertTrue((String)"1.2", (!instance.wasDeconfigured ? 1 : 0) != 0);
        instance.reset();
        this.setNatures("1.3", this.project, new String[0], false);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"1.4", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"1.5", (boolean)instance.wasDeconfigured);
        instance.reset();
        this.setNatures("2.0", this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false, true);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"2.1", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"2.2", (!instance.wasDeconfigured ? 1 : 0) != 0);
        try {
            NatureTest.assertTrue((String)"2.3", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"1.99", (Throwable)e);
        }
        instance.reset();
        this.setNatures("2.3", this.project, new String[0], false, true);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"2.4", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"2.5", (!instance.wasDeconfigured ? 1 : 0) != 0);
        try {
            NatureTest.assertTrue((String)"2.6", (!this.project.hasNature("org.eclipse.core.tests.resources.simpleNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
    }

    public void testSimpleNature() {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        String[][] valid = this.getValidNatureSets();
        int i = 0;
        while (i < valid.length) {
            this.setNatures("valid: " + i, this.project, valid[i], false);
            ++i;
        }
        Object[] currentSet = new String[]{"org.eclipse.core.tests.resources.simpleNature"};
        this.setNatures("1.0", this.project, (String[])currentSet, false);
        String[][] invalid = this.getInvalidNatureSets();
        int i2 = 0;
        while (i2 < invalid.length) {
            this.setNatures("invalid: " + i2, this.project, invalid[i2], true);
            try {
                NatureTest.assertTrue((String)"2.0", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
                NatureTest.assertTrue((String)"2.1", (!this.project.hasNature("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
                NatureTest.assertTrue((String)"2.2", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
                NatureTest.assertTrue((String)"2.3", (!this.project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
                this.assertEquals("2.4", this.project.getDescription().getNatureIds(), currentSet);
            }
            catch (CoreException e) {
                NatureTest.fail((String)"2.99", (Throwable)e);
            }
            ++i2;
        }
    }

    public void testBug127562Nature() {
        IJobManager manager;
        IWorkspace ws;
        block13: {
            this.ensureExistsInWorkspace((IResource)this.project, true);
            ws = this.project.getWorkspace();
            String[][] valid = this.getValidNatureSets();
            int i = 0;
            while (i < valid.length) {
                this.setNatures("valid: " + i, this.project, valid[i], false);
                ++i;
            }
            String[] currentSet = new String[]{"org.eclipse.core.tests.resources.bug127562Nature"};
            this.setNatures("1.0", this.project, currentSet, false, true);
            manager = Job.getJobManager();
            try {
                manager.beginRule(ws.getRuleFactory().modifyRule((IResource)this.project), null);
                this.project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure();
                NatureTest.fail((String)"2.0");
            }
            catch (CoreException coreException) {
                NatureTest.fail((String)"2.1");
                manager.endRule(ws.getRuleFactory().modifyRule((IResource)this.project));
                break block13;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    manager.endRule(ws.getRuleFactory().modifyRule((IResource)this.project));
                }
            }
            manager.endRule(ws.getRuleFactory().modifyRule((IResource)this.project));
        }
        try {
            try {
                manager.beginRule((ISchedulingRule)ws.getRoot(), null);
                this.project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure();
            }
            catch (CoreException coreException) {
                NatureTest.fail((String)"3.0");
                manager.endRule((ISchedulingRule)ws.getRoot());
            }
        }
        finally {
            manager.endRule((ISchedulingRule)ws.getRoot());
        }
    }

    public void testBug297871() {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        File desc = null;
        try {
            IFileStore descStore = ((org.eclipse.core.internal.resources.File)this.project.getFile(".project")).getStore();
            desc = descStore.toLocalFile(0, this.getMonitor());
        }
        catch (CoreException coreException) {
            NatureTest.fail((String)"1.0");
        }
        File descTmp = new File(String.valueOf(desc.getPath()) + ".tmp");
        try {
            this.copy(desc, descTmp);
        }
        catch (IOException e) {
            NatureTest.fail((String)"2.0", (Throwable)e);
        }
        this.setNatures("valid ", this.project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        try {
            NatureTest.assertNotNull((Object)this.project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            NatureTest.assertTrue((boolean)this.project.hasNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            NatureTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            this.copy(descTmp, desc);
        }
        catch (IOException e) {
            NatureTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            this.project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NatureTest.fail((String)"7.0", (Throwable)e);
        }
        try {
            NatureTest.assertNull((Object)this.project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"8.0", (Throwable)e);
        }
        try {
            NatureTest.assertFalse((boolean)this.project.hasNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"9.0", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copy(File src, File dst) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream in = new FileInputStream(src);
            try {
                try (FileOutputStream out = new FileOutputStream(dst);){
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, read);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void testBug338055() throws Exception {
        final boolean[] finished = new boolean[1];
        this.ensureExistsInWorkspace((IResource)this.project, true);
        new Job("CheckNatureJob"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (!finished[0]) {
                        if (NatureTest.this.project.exists() && NatureTest.this.project.isOpen()) {
                            NatureTest.this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
                        }
                        this.schedule();
                    }
                }
                catch (CoreException e) {
                    NatureTest.fail((String)"CheckNatureJob failed", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            NatureTest.fail((String)"2.0", (Throwable)e);
        }
        IFileStore descStore = ((org.eclipse.core.internal.resources.File)this.project.getFile(".project")).getStore();
        StringBuilder description = new StringBuilder();
        description.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name></name><comment></comment><projects></projects><buildSpec></buildSpec><natures>");
        description.append("<nature>org.eclipse.core.tests.resources.simpleNature</nature>");
        int i2 = 0;
        while (i2 < 100) {
            description.append("<nature>nature" + i2 + "</nature>");
            ++i2;
        }
        description.append("</natures></projectDescription>\n");
        try {
            Throwable i2 = null;
            Object var5_9 = null;
            try (OutputStream output = descStore.openOutputStream(0, this.getMonitor());){
                output.write(description.toString().getBytes());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (CoreException coreException) {
            NatureTest.fail((String)"1.0");
        }
        try {
            this.project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.0", (Throwable)e);
        }
        finished[0] = true;
        NatureTest.assertTrue((String)"4.0", (boolean)this.project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        NatureTest.assertTrue((String)"5.0", (boolean)this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testMissingNatureAddsMarker() throws Exception {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"no.such.nature.Missing"});
        this.project.setDescription(desc, 65, this.getMonitor());
        this.project.refreshLocal(2, this.getMonitor());
        this.project.build(6, this.getMonitor());
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        IMarker[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assert.assertEquals((long)1L, (long)markers.length);
        IMarker marker = markers[0];
        Assert.assertEquals((Object)"no.such.nature.Missing", (Object)marker.getAttribute("natureId"));
        Assert.assertNotEquals((long)-42L, (long)marker.getAttribute("charStart", -42));
        Assert.assertNotEquals((long)-42L, (long)marker.getAttribute("charEnd", -42));
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                try (InputStream input = ((IFile)marker.getResource()).getContents();){
                    FileUtil.transferStreams((InputStream)input, (OutputStream)bos, (String)"whatever", (IProgressMonitor)this.getMonitor());
                    String marked = bos.toString().substring(marker.getAttribute("charStart", -42), marker.getAttribute("charEnd", -42));
                    Assert.assertEquals((Object)"no.such.nature.Missing", (Object)marked);
                }
                if (bos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bos == null) throw throwable;
                bos.close();
                throw throwable;
            }
            bos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testMissingNatureWithWhitespacesSetChars() throws Exception {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IFile dotProjectFile = this.project.getFile(".project");
        dotProjectFile.setContents((InputStream)new ByteArrayInputStream(("<projectDescription><name>" + this.project.getName() + "</name><natures><nature> " + "no.such.nature.Missing" + "  </nature></natures></projectDescription>").getBytes()), false, false, this.getMonitor());
        this.project.refreshLocal(2, this.getMonitor());
        this.project.build(6, this.getMonitor());
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        IMarker[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assert.assertEquals((long)1L, (long)markers.length);
        IMarker marker = markers[0];
        Assert.assertEquals((Object)"no.such.nature.Missing", (Object)marker.getAttribute("natureId"));
        Assert.assertNotEquals((long)-42L, (long)marker.getAttribute("charStart", -42));
        Assert.assertNotEquals((long)-42L, (long)marker.getAttribute("charEnd", -42));
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                try (InputStream input = ((IFile)marker.getResource()).getContents();){
                    FileUtil.transferStreams((InputStream)input, (OutputStream)bos, (String)"whatever", (IProgressMonitor)this.getMonitor());
                    String marked = bos.toString().substring(marker.getAttribute("charStart", -42), marker.getAttribute("charEnd", -42));
                    Assert.assertEquals((Object)"no.such.nature.Missing", (Object)marked);
                }
                if (bos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bos == null) throw throwable;
                bos.close();
                throw throwable;
            }
            bos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void testKnownNatureDoesntAddMarker() throws Exception {
        this.ensureExistsInWorkspace((IResource)this.project, true);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.project.setDescription(desc, this.getMonitor());
        this.project.refreshLocal(2, this.getMonitor());
        this.project.build(6, this.getMonitor());
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        Assert.assertEquals((long)0L, (long)this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1).length);
    }

    public void testListenToPreferenceChange() throws Exception {
        this.testMissingNatureAddsMarker();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 0);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        IMarker[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assert.assertEquals((long)1L, (long)markers.length);
        Assert.assertEquals((long)0L, (long)markers[0].getAttribute("severity", -42));
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", -1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assert.assertEquals((long)0L, (long)markers.length);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 2);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, this.getMonitor());
        markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assert.assertEquals((long)1L, (long)markers.length);
        Assert.assertEquals((long)2L, (long)markers[0].getAttribute("severity", -42));
    }
}

