/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Random;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.junit.Assert;

public abstract class TestPerformer {
    private int count = 0;
    String name = null;

    public TestPerformer(String name) {
        this.name = name;
    }

    public void cleanUp(Object[] args, int count) {
    }

    public Object[] interestingOldState(Object[] args) throws Exception {
        return null;
    }

    public abstract Object invokeMethod(Object[] var1, int var2) throws Exception;

    public final void performTest(Object[][] inputs) {
        int permutations = 1;
        Object[][] objectArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] input = objectArray[n2];
            permutations *= input.length;
            if (input.length > 2) {
                TestPerformer.scramble(input);
            }
            ++n2;
        }
        this.performTestRecursiveLoop(inputs, new Object[inputs.length], 0);
    }

    private void performTestRecursiveLoop(Object[][] inputs, Object[] args, int nth) {
        int i = 0;
        while (i < inputs[nth].length) {
            args[nth] = inputs[nth][i];
            if (nth == inputs.length - 1) {
                if (this.shouldFail(args, this.count)) {
                    try {
                        this.invokeMethod(args, this.count);
                        StringBuilder buffer = new StringBuilder();
                        buffer.append("invocation " + this.count + " should fail, but it doesn't [");
                        Object[] objectArray = args;
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            buffer.append(arg);
                            buffer.append(',');
                            ++n2;
                        }
                        buffer.deleteCharAt(buffer.length() - 1);
                        buffer.append(']');
                        Assert.assertTrue((String)buffer.toString(), (boolean)false);
                    }
                    catch (Exception exception) {}
                } else {
                    Object[] oldState = null;
                    try {
                        oldState = this.interestingOldState(args);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("call to interestingOldState failed");
                    }
                    Object result = null;
                    try {
                        result = this.invokeMethod(args, this.count);
                    }
                    catch (FussyProgressMonitor.FussyProgressAssertionFailed fussyEx) {
                        Assert.assertTrue((String)("invocation " + this.count + ": " + fussyEx.getMessage()), (boolean)false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Assert.assertTrue((String)("invocation " + this.count + " failed with " + ex), (boolean)false);
                    }
                    boolean success = false;
                    try {
                        success = this.wasSuccess(args, result, oldState);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Assert.assertTrue((String)("invocation " + this.count + " did not produce desired result"), (boolean)success);
                }
                this.cleanUp(args, this.count);
                ++this.count;
            } else {
                this.performTestRecursiveLoop(inputs, args, nth + 1);
            }
            ++i;
        }
    }

    protected static void scramble(Object[] first) {
        Random random = new Random(4711L);
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
            }
            ++i;
        }
    }

    public abstract boolean shouldFail(Object[] var1, int var2);

    public abstract boolean wasSuccess(Object[] var1, Object var2, Object[] var3) throws Exception;
}

