/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_160251
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_160251.class);
    }

    public Bug_160251() {
    }

    public Bug_160251(String name) {
        super(name);
    }

    public void testNonExistentDestination() {
        IProject source = Bug_160251.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = this.getTempStore();
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)source, true);
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        try {
            IProjectDescription description = source.getDescription();
            description.setLocationURI(destination.toURI());
            source.move(description, 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_160251.fail((String)"1.0", (Throwable)e);
        }
        Bug_160251.assertTrue((String)"2.0", (boolean)source.exists());
        Bug_160251.assertTrue((String)"2.1", (boolean)sourceFile.exists());
        Bug_160251.assertTrue((String)"2.2", (boolean)source.isSynchronized(2));
        Bug_160251.assertTrue((String)"2.3", (boolean)URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()));
        Bug_160251.assertTrue((String)"2.4", (boolean)URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()));
    }

    public void testEmptyDestination() {
        IProject source = Bug_160251.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = this.getTempStore();
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)source, true);
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        try {
            destination.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_160251.fail((String)"0.99", (Throwable)e);
        }
        try {
            IProjectDescription description = source.getDescription();
            description.setLocationURI(destination.toURI());
            source.move(description, 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_160251.fail((String)"1.0", (Throwable)e);
        }
        Bug_160251.assertTrue((String)"2.0", (boolean)source.exists());
        Bug_160251.assertTrue((String)"2.1", (boolean)sourceFile.exists());
        Bug_160251.assertTrue((String)"2.2", (boolean)source.isSynchronized(2));
        Bug_160251.assertTrue((String)"2.3", (boolean)URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()));
        Bug_160251.assertTrue((String)"2.4", (boolean)URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()));
    }

    public void testOccupiedDestination() {
        IProject source = Bug_160251.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = this.getTempStore();
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)source, true);
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        try {
            destination.mkdir(0, this.getMonitor());
            this.createFileInFileSystem(destinationFile, this.getRandomContents());
        }
        catch (CoreException e) {
            Bug_160251.fail((String)"0.99", (Throwable)e);
        }
        try {
            IProjectDescription description = source.getDescription();
            description.setLocationURI(destination.toURI());
            source.move(description, 0, this.getMonitor());
            Bug_160251.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        Bug_160251.assertTrue((String)"2.0", (boolean)source.exists());
        Bug_160251.assertTrue((String)"2.1", (boolean)sourceFile.exists());
        Bug_160251.assertTrue((String)"2.2", (boolean)source.isSynchronized(2));
        Bug_160251.assertTrue((String)"2.3", (!URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()) ? 1 : 0) != 0);
        Bug_160251.assertTrue((String)"2.4", (!URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()) ? 1 : 0) != 0);
    }
}

