/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_185247_LinuxTests
extends ResourceTest {
    private static final boolean IS_LINUX = Platform.getOS().equals("linux");
    private final List<IProject> testProjects = new ArrayList<IProject>();
    private IPath testCasesLocation;

    public static Test suite() {
        return new TestSuite(Bug_185247_LinuxTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IPath randomLocation = this.getRandomLocation();
        this.deleteOnTearDown(randomLocation);
        this.testCasesLocation = randomLocation.append("bug185247LinuxTests");
        Bug_185247_LinuxTests.assertTrue((String)("failed to create test location: " + this.testCasesLocation), (boolean)this.testCasesLocation.toFile().mkdirs());
        this.extractTestCasesArchive(this.testCasesLocation);
    }

    private void extractTestCasesArchive(IPath outputLocation) throws Exception {
        if (IS_LINUX) {
            URL testCasesArchive = Platform.getBundle((String)"org.eclipse.core.tests.resources").getEntry("resources/bug185247/bug185247_LinuxTests.zip");
            URL archiveLocation = FileLocator.resolve((URL)testCasesArchive);
            File archive = URIUtil.toFile((URI)archiveLocation.toURI());
            Bug_185247_LinuxTests.assertNotNull((String)"cannot find archive with test cases", (Object)archive);
            Bug_185247_LinuxTests.unzip(archive, outputLocation.toFile());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            for (IProject testProject : this.testProjects) {
                testProject.delete(false, true, this.getMonitor());
            }
        }
        finally {
            super.tearDown();
        }
    }

    public void test1_trivial() throws Exception {
        this.runProjectTestCase();
    }

    public void test2_mutual() throws Exception {
        this.runProjectTestCase();
    }

    public void test3_outside_tree() throws Exception {
        this.runProjectTestCase();
    }

    public void test5_transitive_mutual() throws Exception {
        this.runProjectTestCase();
    }

    public void test6_nonrecursive() throws Exception {
        this.runProjectTestCase();
    }

    private void runProjectTestCase() throws Exception {
        String projectName = this.getName();
        this.importProjectAndRefresh(projectName);
    }

    private void importProjectAndRefresh(String projectName) throws Exception {
        if (IS_LINUX) {
            IProject project = this.importTestProject(projectName);
            project.refreshLocal(2, this.getMonitor());
        }
    }

    private IProject importTestProject(String projectName) throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.testProjects.add(testProject);
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(projectName);
        String projectRoot = String.join((CharSequence)File.separator, this.testCasesLocation.toOSString(), "bug185247", projectName);
        projectDescription.setLocationURI(URI.create(projectRoot));
        testProject.create((IProjectDescription)projectDescription, this.getMonitor());
        testProject.open(this.getMonitor());
        Bug_185247_LinuxTests.assertTrue((String)("expected project to be open: " + projectName), (boolean)testProject.isAccessible());
        return testProject;
    }

    private static void unzip(File archive, File outputDirectory) throws Exception {
        String[] command = new String[]{"unzip", archive.toString(), "-d", outputDirectory.toString()};
        Bug_185247_LinuxTests.executeCommand(command, outputDirectory);
    }

    private static void executeCommand(String[] command, File outputDirectory) throws Exception {
        Bug_185247_LinuxTests.assertTrue((String)("output directory does not exist: " + outputDirectory), (boolean)outputDirectory.exists());
        Bug_185247_LinuxTests.assertTrue((String)"commands only availabe in Linux environment", (boolean)IS_LINUX);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandOutputFile = new File(outputDirectory, "commandOutput.txt");
        if (!commandOutputFile.exists()) {
            Bug_185247_LinuxTests.assertTrue((String)"failed to create standard output and error file for unzip command", (boolean)commandOutputFile.createNewFile());
        }
        processBuilder.redirectOutput(commandOutputFile);
        processBuilder.redirectError(commandOutputFile);
        Process process = processBuilder.start();
        int commandExitCode = process.waitFor();
        String output = Bug_185247_LinuxTests.formatCommandOutput(command, commandOutputFile);
        Bug_185247_LinuxTests.assertTrue((String)("Failed to delete command output file. " + output), (boolean)commandOutputFile.delete());
        Bug_185247_LinuxTests.assertEquals((String)("Failed to execute commmand. " + output), (int)0, (int)commandExitCode);
    }

    private static String formatCommandOutput(String[] command, File commandOutputFile) throws IOException {
        Path commandOutputPath = Paths.get(commandOutputFile.getAbsolutePath(), new String[0]);
        List<String> commandOutputLines = Files.readAllLines(commandOutputPath);
        List<String> commandOutputHeader = Arrays.asList("Command:", Arrays.toString(command), "Output:");
        ArrayList<String> commandToString = new ArrayList<String>();
        commandToString.addAll(commandOutputHeader);
        commandToString.addAll(commandOutputLines);
        String formattedOutput = String.join((CharSequence)System.lineSeparator(), commandToString);
        return formattedOutput;
    }
}

