/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_185247_recursiveLinks
extends ResourceTest {
    private final List<IProject> testProjects = new ArrayList<IProject>();

    public static Test suite() {
        return new TestSuite(Bug_185247_recursiveLinks.class);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.cleanUpTestProjects();
        }
        finally {
            super.tearDown();
        }
    }

    private void cleanUpTestProjects() throws CoreException {
        for (IProject testProject : this.testProjects) {
            testProject.delete(false, true, this.getMonitor());
        }
    }

    public void test1_linkCurrentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> this.createSymlink((File)directory, "link_current", "./");
        this.runTest(createSymlinks);
    }

    public void test2_linkParentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> this.createSymlink((File)directory, "link_parent", "../");
        this.runTest(createSymlinks);
    }

    public void test3_linkGrandparentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            File subdirectory = new File((File)directory, "subdirectory");
            Bug_185247_recursiveLinks.createDirectory(subdirectory);
            this.createSymlink(subdirectory, "link_grandparent", "../../");
        };
        this.runTest(createSymlinks);
    }

    public void test4_linkParentDirectoryTwice() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            String[] subdirectoryNames;
            String[] stringArray = subdirectoryNames = new String[]{"subdirectory1", "subdirectory2"};
            int n = subdirectoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subdirectoryName = stringArray[n2];
                File subdirectory = new File((File)directory, subdirectoryName);
                Bug_185247_recursiveLinks.createDirectory(subdirectory);
                this.createSymlink(subdirectory, "link_parent", "../../");
                ++n2;
            }
        };
        this.runTest(createSymlinks);
    }

    public void test5_linkParentDirectoyTwiceWithAbsolutePath() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            String[] subdirectoryNames;
            String[] stringArray = subdirectoryNames = new String[]{"subdirectory1", "subdirectory2"};
            int n = subdirectoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subdirectoryName = stringArray[n2];
                File subdirectory = new File((File)directory, subdirectoryName);
                Bug_185247_recursiveLinks.createDirectory(subdirectory);
                this.createSymlink(subdirectory, "link_parent", directory.getAbsolutePath());
                ++n2;
            }
        };
        this.runTest(createSymlinks);
    }

    private void runTest(CreateTestProjectStructure createSymlinks) throws MalformedURLException, Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        String projectName = this.getName();
        IPath testRoot = this.getRandomLocation();
        this.deleteOnTearDown(testRoot);
        IPath projectRoot = testRoot.append("bug185247recursive").append(projectName);
        File directory = projectRoot.append("directory").toFile();
        Bug_185247_recursiveLinks.createDirectory(directory);
        createSymlinks.accept(directory);
        URI projectRootLocation = URIUtil.toURI((IPath)projectRoot);
        this.importProjectAndRefresh(projectName, projectRootLocation);
    }

    private static void createDirectory(File directory) {
        Bug_185247_recursiveLinks.assertTrue((String)("failed to create test directory: " + directory), (boolean)directory.mkdirs());
    }

    void createSymlink(File directory, String linkName, String linkTarget) {
        Bug_185247_recursiveLinks.assertTrue((String)"symlinks not supported by platform", (boolean)this.canCreateSymLinks());
        boolean isDir = true;
        this.createSymLink(directory, linkName, linkTarget, isDir);
    }

    private void importProjectAndRefresh(String projectName, URI projectRootLocation) throws Exception {
        IProject project = this.importTestProject(projectName, projectRootLocation);
        project.refreshLocal(2, this.getMonitor());
    }

    private IProject importTestProject(String projectName, URI projectRootLocation) throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.testProjects.add(testProject);
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(projectName);
        projectDescription.setLocationURI(projectRootLocation);
        testProject.create((IProjectDescription)projectDescription, this.getMonitor());
        testProject.open(this.getMonitor());
        Bug_185247_recursiveLinks.assertTrue((String)("expected project to be open: " + projectName), (boolean)testProject.isAccessible());
        return testProject;
    }

    static interface CreateTestProjectStructure
    extends Consumer<File> {
    }
}

