/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_192631
extends ResourceTest {
    private static final String USER_A = "userA";
    private static final String USER_B = "userB";
    private static final String HOST_A = "hostA.example.com";
    private static final String HOST_B = "hostB.example.com";
    private static final int PORT_A = 1111;
    private static final int PORT_B = 2222;
    private static final String COMMON = "/common";
    private static final String FOLDER_A = "/common/folderA";
    private static final String FOLDER_B = "/common/folderB";

    public static Test suite() {
        return new TestSuite(Bug_192631.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MemoryTree.TREE.deleteAll();
    }

    @Override
    protected void tearDown() throws Exception {
        MemoryTree.TREE.deleteAll();
        super.tearDown();
    }

    public void testCompareHost() throws CoreException, URISyntaxException {
        URI commonA = new URI("remote", null, HOST_A, -1, COMMON, null, null);
        URI commonB = new URI("remote", null, HOST_B, -1, COMMON, null, null);
        URI folderA = new URI("remote", null, HOST_A, -1, FOLDER_A, null, null);
        URI folderB = new URI("remote", null, HOST_B, -1, FOLDER_B, null, null);
        HashSet<URI> toVisit = new HashSet<URI>();
        int[] toVisitCount = new int[1];
        IResourceVisitor visitor = resource -> {
            toVisit.remove(resource.getLocationURI());
            nArray[0] = toVisitCount[0] - 1;
            return true;
        };
        EFS.getStore((URI)folderA).mkdir(0, null);
        EFS.getStore((URI)folderB).mkdir(0, null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject projectA = workspace.getRoot().getProject("projectA");
        this.ensureExistsInWorkspace((IResource)projectA, true);
        IFolder linkA = projectA.getFolder("link_to_commonA");
        linkA.createLink(commonA, 0, this.getMonitor());
        IProject projectB = workspace.getRoot().getProject("projectB");
        this.ensureExistsInWorkspace((IResource)projectB, true);
        IFolder linkB = projectB.getFolder("link_to_commonB");
        linkB.createLink(commonB, 0, this.getMonitor());
        toVisit.addAll(Arrays.asList(projectA.getLocationURI(), commonA, folderA, projectA.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectA.accept(visitor);
        Bug_192631.assertTrue((String)"1.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"1.2", (int)0, (int)toVisitCount[0]);
        toVisit.addAll(Arrays.asList(projectB.getLocationURI(), commonB, folderB, projectB.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectB.accept(visitor);
        Bug_192631.assertTrue((String)"2.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"2.2", (int)0, (int)toVisitCount[0]);
        projectA.delete(true, this.getMonitor());
        projectB.delete(true, this.getMonitor());
    }

    public void testCompareUserInfo() throws CoreException, URISyntaxException {
        URI commonA = new URI("remote", USER_A, HOST_A, -1, COMMON, null, null);
        URI commonB = new URI("remote", USER_B, HOST_A, -1, COMMON, null, null);
        URI folderA = new URI("remote", USER_A, HOST_A, -1, FOLDER_A, null, null);
        URI folderB = new URI("remote", USER_B, HOST_A, -1, FOLDER_B, null, null);
        HashSet<URI> toVisit = new HashSet<URI>();
        int[] toVisitCount = new int[1];
        IResourceVisitor visitor = resource -> {
            toVisit.remove(resource.getLocationURI());
            nArray[0] = toVisitCount[0] - 1;
            return true;
        };
        EFS.getStore((URI)folderA).mkdir(0, null);
        EFS.getStore((URI)folderB).mkdir(0, null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject projectA = workspace.getRoot().getProject("projectA");
        this.ensureExistsInWorkspace((IResource)projectA, true);
        IFolder linkA = projectA.getFolder("link_to_commonA");
        linkA.createLink(commonA, 0, this.getMonitor());
        IProject projectB = workspace.getRoot().getProject("projectB");
        this.ensureExistsInWorkspace((IResource)projectB, true);
        IFolder linkB = projectB.getFolder("link_to_commonB");
        linkB.createLink(commonB, 0, this.getMonitor());
        toVisit.addAll(Arrays.asList(projectA.getLocationURI(), commonA, folderA, projectA.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectA.accept(visitor);
        Bug_192631.assertTrue((String)"1.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"1.2", (int)0, (int)toVisitCount[0]);
        toVisit.addAll(Arrays.asList(projectB.getLocationURI(), commonB, folderB, projectB.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectB.accept(visitor);
        Bug_192631.assertTrue((String)"2.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"2.2", (int)0, (int)toVisitCount[0]);
        projectA.delete(true, this.getMonitor());
        projectB.delete(true, this.getMonitor());
    }

    public void testComparePort() throws CoreException, URISyntaxException {
        URI commonA = new URI("remote", null, HOST_A, 1111, COMMON, null, null);
        URI commonB = new URI("remote", null, HOST_A, 2222, COMMON, null, null);
        URI folderA = new URI("remote", null, HOST_A, 1111, FOLDER_A, null, null);
        URI folderB = new URI("remote", null, HOST_A, 2222, FOLDER_B, null, null);
        HashSet<URI> toVisit = new HashSet<URI>();
        int[] toVisitCount = new int[1];
        IResourceVisitor visitor = resource -> {
            toVisit.remove(resource.getLocationURI());
            nArray[0] = toVisitCount[0] - 1;
            return true;
        };
        EFS.getStore((URI)folderA).mkdir(0, null);
        EFS.getStore((URI)folderB).mkdir(0, null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject projectA = workspace.getRoot().getProject("projectA");
        this.ensureExistsInWorkspace((IResource)projectA, true);
        IFolder linkA = projectA.getFolder("link_to_commonA");
        linkA.createLink(commonA, 0, this.getMonitor());
        IProject projectB = workspace.getRoot().getProject("projectB");
        this.ensureExistsInWorkspace((IResource)projectB, true);
        IFolder linkB = projectB.getFolder("link_to_commonB");
        linkB.createLink(commonB, 0, this.getMonitor());
        toVisit.addAll(Arrays.asList(projectA.getLocationURI(), commonA, folderA, projectA.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectA.accept(visitor);
        Bug_192631.assertTrue((String)"1.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"1.2", (int)0, (int)toVisitCount[0]);
        toVisit.addAll(Arrays.asList(projectB.getLocationURI(), commonB, folderB, projectB.getFile(".project").getLocationURI()));
        toVisitCount[0] = 4;
        projectB.accept(visitor);
        Bug_192631.assertTrue((String)"2.1", (boolean)toVisit.isEmpty());
        Bug_192631.assertEquals((String)"2.2", (int)0, (int)toVisitCount[0]);
        projectA.delete(true, this.getMonitor());
        projectB.delete(true, this.getMonitor());
    }
}

