/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_231301
extends ResourceTest {
    public Bug_231301() {
    }

    public Bug_231301(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_231301.class);
    }

    public void testBug() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        project1.create(null);
        project1.open(null);
        final IProject project2 = workspace.getRoot().getProject("Project2");
        project2.create(null);
        project2.open(null);
        WorkspaceJob job = new WorkspaceJob("job"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project2.close(null);
                return Status.OK_STATUS;
            }
        };
        workspace.addResourceChangeListener(event -> {
            if (event.getResource() == project1) {
                job.schedule();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }, 2);
        project1.close(this.getMonitor());
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Bug_231301.fail((String)"1.0", (Throwable)e);
        }
        Bug_231301.assertTrue((String)("2.0: " + job.getResult().toString()), (boolean)job.getResult().isOK());
        Bug_231301.assertTrue((String)"3.0", (!project1.isOpen() ? 1 : 0) != 0);
        Bug_231301.assertTrue((String)"4.0", (!project2.isOpen() ? 1 : 0) != 0);
    }
}

