/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_233939
extends ResourceTest {
    public Bug_233939() {
    }

    public Bug_233939(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_233939.class);
    }

    protected void symLinkAndRefresh(IContainer container, String linkName, IPath linkTarget) {
        this.createSymLink(container.getLocation().toFile(), linkName, linkTarget.toOSString(), false);
        try {
            container.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_233939.fail((String)"2.0", (Throwable)e);
        }
        IResource theLink = container.findMember(linkName);
        this.assertExistsInWorkspace("2.1", theLink);
        Bug_233939.assertTrue((String)"2.2", (boolean)theLink.getResourceAttributes().isSymbolicLink());
    }

    protected boolean isSameLocation(IFile file, IFileStore store) {
        URI loc1 = FileUtil.canonicalURI((URI)file.getLocationURI());
        URI loc2 = FileUtil.canonicalURI((URI)store.toURI());
        return loc1.equals(loc2);
    }

    public void testBug() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        String fileName = "file.txt";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFile file = project.getFile(fileName);
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            Bug_233939.fail((String)"1.0", (Throwable)e);
        }
        IFileStore tempFileStore = this.getTempStore().getChild(fileName);
        this.createFileInFileSystem(tempFileStore);
        IPath fileInTempDirPath = URIUtil.toPath((URI)tempFileStore.toURI());
        this.symLinkAndRefresh((IContainer)project, fileName, fileInTempDirPath);
        IFile[] files = root.findFilesForLocation(file.getLocation());
        Bug_233939.assertEquals((String)"7.0", (int)1, (int)files.length);
        Bug_233939.assertEquals((String)"7.1", (Object)file, (Object)files[0]);
    }

    public void testMultipleLinksToFolder() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IFileStore tempStore = this.getTempStore();
        this.createFileInFileSystem(tempStore.getChild("foo.txt"));
        IPath tempFolderPath = URIUtil.toPath((URI)tempStore.toURI());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectA = root.getProject(this.getUniqueString());
        IProject projectB = root.getProject(this.getUniqueString());
        try {
            this.create((IResource)projectA, true);
            this.create((IResource)projectB, true);
        }
        catch (CoreException e) {
            Bug_233939.fail((String)"1.0", (Throwable)e);
        }
        this.symLinkAndRefresh((IContainer)projectA, "folderA", tempFolderPath);
        this.symLinkAndRefresh((IContainer)projectB, "folderB", tempFolderPath);
    }
}

