/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_265810
extends ResourceTest {
    protected static final String VARIABLE_NAME = "ROOT";
    private final ArrayList<IPath> toDelete = new ArrayList();
    List<IResourceDelta> resourceDeltas = new ArrayList<IResourceDelta>();
    IResourceChangeListener ll = event -> {
        try {
            event.getDelta().accept(delta -> {
                IResource resource = delta.getResource();
                if (resource instanceof IFile && !resource.getName().equals(".project")) {
                    this.addToResourceDelta(delta);
                }
                return delta.getAffectedChildren().length > 0;
            });
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"listener failed", (Throwable)e);
        }
    };

    public Bug_265810() {
    }

    public Bug_265810(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_265810.class);
    }

    @Override
    protected void setUp() throws Exception {
        IPath base = super.getRandomLocation();
        this.toDelete.add(base);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        IPath[] paths = this.toDelete.toArray(new IPath[0]);
        this.toDelete.clear();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            Workspace.clear((File)path.toFile());
            ++n2;
        }
        super.tearDown();
    }

    public IPath getRandomLocation() {
        IPath path = FileSystemHelper.computeRandomLocation((IPath)this.getTempDir());
        try {
            path.toFile().createNewFile();
        }
        catch (IOException e) {
            Bug_265810.fail((String)"can't create the file", (Throwable)e);
        }
        this.toDelete.add(path);
        return path;
    }

    public void testBug() {
        IProject project = Bug_265810.getWorkspace().getRoot().getProject(this.getUniqueString());
        try {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"1.0", (Throwable)e);
        }
        IFile file = project.getFile(this.getUniqueString());
        this.assertDoesNotExistInWorkspace("2.0", (IResource)file);
        try {
            file.createLink(this.getRandomLocation(), 0, (IProgressMonitor)new NullProgressMonitor());
            file.setContents(this.getContents("contents for a file"), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"3.0", (Throwable)e);
        }
        byte[] dotProject1 = this.storeDotProject(project);
        IFile newFile = project.getFile("newFile");
        this.assertDoesNotExistInWorkspace("5.0", (IResource)newFile);
        try {
            newFile.createLink(this.getRandomLocation(), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"6.0", (Throwable)e);
        }
        byte[] dotProject2 = this.storeDotProject(project);
        try {
            this.resourceDeltas = new ArrayList<IResourceDelta>();
            Bug_265810.getWorkspace().addResourceChangeListener(this.ll);
            this.restoreDotProject(project, dotProject1);
            Bug_265810.assertEquals((String)"9.0", (int)1, (int)this.resourceDeltas.size());
            Bug_265810.assertEquals((String)"9.1", (Object)newFile, (Object)this.resourceDeltas.get(0).getResource());
            Bug_265810.assertEquals((String)"9.2", (int)2, (int)this.resourceDeltas.get(0).getKind());
        }
        finally {
            Bug_265810.getWorkspace().removeResourceChangeListener(this.ll);
        }
        try {
            newFile.create(this.getContents("content"), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            Bug_265810.fail((String)"10.0", (Throwable)e1);
        }
        try {
            this.resourceDeltas = new ArrayList<IResourceDelta>();
            Bug_265810.getWorkspace().addResourceChangeListener(this.ll);
            this.restoreDotProject(project, dotProject2);
            Bug_265810.assertEquals((String)"11.0", (int)1, (int)this.resourceDeltas.size());
            Bug_265810.assertEquals((String)"11.1", (Object)newFile, (Object)this.resourceDeltas.get(0).getResource());
            Bug_265810.assertEquals((String)"11.2", (int)262144, (int)(this.resourceDeltas.get(0).getFlags() & 0x40000));
        }
        finally {
            Bug_265810.getWorkspace().removeResourceChangeListener(this.ll);
        }
    }

    private byte[] storeDotProject(IProject project) {
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        byte[] doProject = new byte[]{};
        try {
            InputStream iS = project.getFile(".project").getContents();
            bytesRead = iS.read(buffer);
            iS.close();
        }
        catch (IOException e) {
            Bug_265810.fail((String)"storing dotProject failed", (Throwable)e);
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"storing dotProject failed", (Throwable)e);
        }
        doProject = new byte[bytesRead];
        System.arraycopy(buffer, 0, doProject, 0, bytesRead);
        return doProject;
    }

    private void restoreDotProject(IProject project, byte[] dotProject) {
        try {
            project.getFile(".project").setContents((InputStream)new ByteArrayInputStream(dotProject), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Bug_265810.fail((String)"restoring dotProject failed", (Throwable)e);
        }
    }

    boolean addToResourceDelta(IResourceDelta delta) {
        return this.resourceDeltas.add(delta);
    }
}

