/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class LocalStoreRegressionTests
extends LocalStoreTest {
    public LocalStoreRegressionTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LocalStoreRegressionTests.class);
    }

    public void test_1FU4PJA() throws Throwable {
        IProject project = this.projects[0];
        IFile file = project.getFile("file");
        this.ensureExistsInFileSystem(file);
        LocalStoreRegressionTests.assertTrue((String)"1.0", (!file.exists() ? 1 : 0) != 0);
        file.refreshLocal(0, null);
        LocalStoreRegressionTests.assertTrue((String)"1.1", (boolean)file.exists());
    }

    public void test_1FU4TW7() throws Throwable {
        IFolder folder = this.projects[0].getFolder("folder");
        IFile file = folder.getFile("file");
        this.ensureExistsInFileSystem((IResource)folder);
        this.ensureExistsInFileSystem(file);
        file.refreshLocal(2, null);
        LocalStoreRegressionTests.assertTrue((String)"1.1", (boolean)folder.exists());
        LocalStoreRegressionTests.assertTrue((String)"1.2", (boolean)file.exists());
        this.ensureDoesNotExistInWorkspace((IResource)folder);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
    }

    public void test_1G65KR1() {
        IPath root = LocalStoreRegressionTests.getWorkspace().getRoot().getLocation().append("" + new Date().getTime());
        File temp = root.toFile();
        temp.mkdirs();
        File target = new File(temp, "target");
        Workspace.clear((File)target);
        LocalStoreRegressionTests.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        SafeChunkyOutputStream output = null;
        try {
            output = new SafeChunkyOutputStream(target);
            try (DataOutputStream dos = new DataOutputStream((OutputStream)output);){
                dos.writeLong(1234567890L);
                output.succeed();
            }
        }
        catch (IOException e) {
            LocalStoreRegressionTests.fail((String)"2.0", (Throwable)e);
        }
        SafeChunkyInputStream input = null;
        try {
            input = new SafeChunkyInputStream(target);
            try (DataInputStream dis = new DataInputStream((InputStream)input);){
                LocalStoreRegressionTests.assertEquals((String)"3.0", (long)dis.readLong(), (long)1234567890L);
            }
        }
        catch (IOException e) {
            LocalStoreRegressionTests.fail((String)"3.10", (Throwable)e);
        }
    }
}

