/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestMultiSnap
extends WorkspaceSerializationTest {
    public TestMultiSnap() {
    }

    public TestMultiSnap(String name) {
        super(name);
    }

    public void test1() throws Exception {
        IProject project = TestMultiSnap.getWorkspace().getRoot().getProject("CrashProject");
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        this.workspace.save(false, this.getMonitor());
        IFolder folder = project.getFolder("CrashFolder");
        folder.create(true, true, this.getMonitor());
        this.workspace.save(false, this.getMonitor());
        IFile file = folder.getFile("CrashFile");
        byte[] bytes = "Test bytes".getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        file.create((InputStream)in, true, this.getMonitor());
        this.workspace.save(false, this.getMonitor());
    }

    public void test2() throws CoreException {
        IProject project = TestMultiSnap.getWorkspace().getRoot().getProject("CrashProject");
        IFolder folder = project.getFolder("CrashFolder");
        IFile file = folder.getFile("CrashFile");
        IResource[] children = TestMultiSnap.getWorkspace().getRoot().members();
        TestMultiSnap.assertEquals((String)"1.0", (int)1, (int)children.length);
        TestMultiSnap.assertEquals((String)"1.1", (Object)children[0], (Object)project);
        TestMultiSnap.assertTrue((String)"1.2", (boolean)project.exists());
        TestMultiSnap.assertTrue((String)"1.3", (boolean)project.isOpen());
        this.assertExistsInWorkspace("1.4", new IResource[]{project, folder, file});
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestMultiSnap.class);
    }
}

