/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.usecase.Snapshot1Test;
import org.eclipse.core.tests.resources.usecase.SnapshotTest;

public class Snapshot2Test
extends SnapshotTest {
    public Snapshot2Test() {
    }

    public Snapshot2Test(String name) {
        super(name);
    }

    protected static String[] defineHierarchy1() {
        String[] old;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = old = Snapshot1Test.defineHierarchy1();
        int n = old.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            result.add(element);
            ++n2;
        }
        result.add(new Path("MyProject").append("added file").toString());
        result.add(new Path("MyProject").append("yet another file").toString());
        result.add(new Path("MyProject").append("a folder").addTrailingSeparator().toString());
        return result.toArray(new String[result.size()]);
    }

    protected static String[] defineHierarchy2() {
        return new String[]{"/added file", "/yet another file", "/a folder/"};
    }

    public void testChangeMyProject() {
        IProject project = Snapshot2Test.getWorkspace().getRoot().getProject("MyProject");
        Snapshot2Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot2Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot2Test.defineHierarchy1());
        this.ensureExistsInWorkspace(resources, true);
        this.assertExistsInFileSystem("1.1", resources);
        this.assertExistsInWorkspace("1.2", resources);
    }

    public void testChangeProject2() {
        IProject project = Snapshot2Test.getWorkspace().getRoot().getProject("Project2");
        Snapshot2Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot2Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        try {
            IResource[] children = project.members();
            Snapshot2Test.getWorkspace().delete(children, true, null);
        }
        catch (CoreException e) {
            Snapshot2Test.fail((String)"0.5", (Throwable)e);
        }
        IResource[] resources = this.buildResources((IContainer)project, Snapshot2Test.defineHierarchy2());
        this.ensureExistsInWorkspace(resources, true);
        this.assertExistsInFileSystem("1.1", resources);
        this.assertExistsInWorkspace("1.2", resources);
    }

    public void testSnapshotWorkspace() {
        try {
            Snapshot2Test.getWorkspace().save(false, null);
        }
        catch (CoreException e) {
            Snapshot2Test.fail((String)"1.0", (Throwable)e);
        }
    }

    public void testVerifyPreviousSession() {
        IProject project = Snapshot2Test.getWorkspace().getRoot().getProject("MyProject");
        Snapshot2Test.assertTrue((String)"0.0", (boolean)project.exists());
        Snapshot2Test.assertTrue((String)"0.1", (!project.isOpen() ? 1 : 0) != 0);
        try {
            project.open(null);
        }
        catch (CoreException e) {
            Snapshot2Test.fail((String)"1.0", (Throwable)e);
        }
        Snapshot2Test.assertTrue((String)"1.2", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot1Test.defineHierarchy1());
        this.assertExistsInFileSystem("2.1", resources);
        this.assertExistsInWorkspace("2.2", resources);
        project = Snapshot2Test.getWorkspace().getRoot().getProject("Project2");
        Snapshot2Test.assertTrue((String)"3.0", (boolean)project.exists());
        Snapshot2Test.assertTrue((String)"3.1", (boolean)project.isOpen());
        resources = this.buildResources((IContainer)project, Snapshot1Test.defineHierarchy2());
        this.assertExistsInFileSystem("5.1", resources);
        this.assertExistsInWorkspace("5.2", resources);
    }
}

