/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests;

import java.util.function.Function;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.progress.UIJob;

public class AbstractDebugTest
extends TestCase {
    private static boolean welcomeClosed;
    protected long testTimeout = 30000L;

    public AbstractDebugTest() {
    }

    public AbstractDebugTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestUtil.log(1, this.getName(), "setUp", new Throwable[0]);
        this.assertWelcomeScreenClosed();
    }

    protected void tearDown() throws Exception {
        TestUtil.log(1, this.getName(), "tearDown", new Throwable[0]);
        TestUtil.cleanUp(this.getName());
        super.tearDown();
    }

    protected final void assertWelcomeScreenClosed() throws Exception {
        if (!welcomeClosed && PlatformUI.isWorkbenchRunning()) {
            final IWorkbench wb = PlatformUI.getWorkbench();
            if (wb == null) {
                return;
            }
            if (Display.getCurrent() != null) {
                AbstractDebugTest.closeIntro(wb);
                return;
            }
            UIJob job = new UIJob("close welcome screen for debug test suite"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AbstractDebugTest.closeIntro(wb);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setSystem(true);
            job.schedule();
        }
    }

    public void waitWhile(Function<AbstractDebugTest, Boolean> condition, long timeout, Function<AbstractDebugTest, String> errorMessage) throws Exception {
        TestUtil.waitWhile(condition, this, timeout, errorMessage);
    }

    public void waitWhile(Function<AbstractDebugTest, Boolean> condition, Function<AbstractDebugTest, String> errorMessage) throws Exception {
        TestUtil.waitWhile(condition, this, this.testTimeout, errorMessage);
    }

    private static void closeIntro(IWorkbench wb) {
        IIntroManager im;
        IIntroPart intro;
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window != null && (intro = (im = wb.getIntroManager()).getIntro()) != null) {
            welcomeClosed = im.closeIntro(intro);
        }
    }
}

