/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.tests.TestsPlugin;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;

public class TestUtil {
    static Set<Job> runningJobs = new LinkedHashSet<Job>();

    public static void cleanUp(String owner) {
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
        boolean timedOut = TestUtil.waitForJobs(owner, 5L, 5000L);
        if (timedOut) {
            TestUtil.log(1, owner, "Trying to cancel running jobs: " + TestUtil.getRunningOrWaitingJobs(null, new Object[0]), new Throwable[0]);
            TestUtil.getRunningOrWaitingJobs(null, new Object[0]).forEach(job -> {
                boolean bl = job.cancel();
            });
            TestUtil.waitForJobs(owner, 5L, 1000L);
        }
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
    }

    public static void log(int severity, String owner, String message, Throwable ... optionalError) {
        message = "[" + owner + "] " + message;
        Throwable error = null;
        if (optionalError != null && optionalError.length > 0) {
            error = optionalError[0];
        }
        Status status = new Status(severity, TestsPlugin.getDefault().getBundle().getSymbolicName(), message, error);
        TestsPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void processUIEvents() {
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static void processUIEvents(long millis) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < millis) {
            Display display = Display.getCurrent();
            if (display != null && !display.isDisposed()) {
                while (display.readAndDispatch()) {
                }
                continue;
            }
            Thread.sleep(10L);
        }
    }

    public static <T> void waitWhile(Function<T, Boolean> condition, T context, long timeout, Function<T, String> errorMessage) throws Exception {
        long start = System.currentTimeMillis();
        Display display = Display.getCurrent();
        while (System.currentTimeMillis() - start < timeout && condition.apply(context).booleanValue()) {
            if (display != null && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                Thread.sleep(0L);
                continue;
            }
            Thread.sleep(5L);
        }
        Boolean stillTrue = condition.apply(context);
        if (stillTrue.booleanValue()) {
            TestCase.fail((String)errorMessage.apply(context));
        }
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs) {
        return TestUtil.waitForJobs(owner, minTimeMs, maxTimeMs, null);
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs, Object ... excludedFamilies) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            TestUtil.processUIEvents();
            try {
                Thread.sleep(Math.min(10L, minTimeMs));
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!Job.getJobManager().isIdle()) {
            List<Job> jobs = TestUtil.getRunningOrWaitingJobs(null, excludedFamilies);
            if (jobs.isEmpty()) break;
            if (!Collections.disjoint(runningJobs, jobs)) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            if (System.currentTimeMillis() - start >= maxTimeMs) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            TestUtil.processUIEvents();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        runningJobs.clear();
        return false;
    }

    private static void dumpRunningOrWaitingJobs(String owner, List<Job> jobs) {
        String message = "Some job is still running or waiting to run: " + TestUtil.dumpRunningOrWaitingJobs(jobs);
        TestUtil.log(4, owner, message, new Throwable[0]);
    }

    private static String dumpRunningOrWaitingJobs(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return "";
        }
        runningJobs.clear();
        StringBuilder sb = new StringBuilder();
        for (Job job : jobs) {
            ThreadInfo[] threadInfos;
            runningJobs.add(job);
            sb.append("\n'").append(job.toString()).append("'/");
            sb.append(job.getClass().getName());
            Thread thread = job.getThread();
            if (thread != null && (threadInfos = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{thread.getId()}, true, true))[0] != null) {
                sb.append("\nthread info: ").append(threadInfos[0]);
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static List<Job> getRunningOrWaitingJobs(Object jobFamily, Object ... excludedFamilies) {
        Job[] jobs;
        ArrayList<Job> running = new ArrayList<Job>();
        Job[] jobArray = jobs = Job.getJobManager().find(jobFamily);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (TestUtil.isRunningOrWaitingJob(job) && !TestUtil.belongsToFamilies(job, excludedFamilies)) {
                running.add(job);
            }
            ++n2;
        }
        return running;
    }

    private static boolean isRunningOrWaitingJob(Job job) {
        int state = job.getState();
        return state == 4 || state == 2;
    }

    private static boolean belongsToFamilies(Job job, Object ... excludedFamilies) {
        if (excludedFamilies == null || excludedFamilies.length == 0) {
            return false;
        }
        Object[] objectArray = excludedFamilies;
        int n = excludedFamilies.length;
        int n2 = 0;
        while (n2 < n) {
            Object family = objectArray[n2];
            if (job.belongsTo(family)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

