/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.IExpressionsListener2;
import org.eclipse.debug.tests.AbstractDebugTest;

public class ExpressionManagerTests
extends AbstractDebugTest {
    protected IExpressionManager getManager() {
        return DebugPlugin.getDefault().getExpressionManager();
    }

    @Override
    protected void tearDown() throws Exception {
        this.getManager().removeExpressions(this.getManager().getExpressions());
        super.tearDown();
    }

    private int indexOf(IExpression expression, IExpression[] list) {
        int i = 0;
        while (i < list.length) {
            if (expression.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void testAddExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)3, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)single.addedCallbacks, (int)3);
            ExpressionManagerTests.assertEquals((int)3, (int)single.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)single.added.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)single.added.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)2, (int)single.added.indexOf(exp3));
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp3, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    public void testRemoveExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            manager.removeExpressions(new IExpression[]{exp1, exp3});
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)1, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)single.addedCallbacks, (int)3);
            ExpressionManagerTests.assertEquals((int)3, (int)single.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)single.added.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)single.added.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)2, (int)single.added.indexOf(exp3));
            ExpressionManagerTests.assertEquals((int)2, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.removed.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)single.removed.indexOf(exp3));
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removed.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)multi.removed.indexOf(exp3));
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)-1, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)-1, (int)this.indexOf((IExpression)exp3, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    public void testChangeExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            IExpression[] expressions = manager.getExpressions();
            exp1.setEnabled(false);
            exp2.setExpressionText("exp2changed");
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)3, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)single.addedCallbacks, (int)3);
            ExpressionManagerTests.assertEquals((int)3, (int)single.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)single.added.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)single.added.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)2, (int)single.added.indexOf(exp3));
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changed.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)single.changed.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)1, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changed.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)multi.changed.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp3, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    public void testInsertBeforeExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)3, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp3, expressions));
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.insertExpressions(new IExpression[]{exp4, exp5}, (IExpression)exp2, true);
            ExpressionManagerTests.assertEquals((int)2, (int)single.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)single.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)multi.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)insert.insertedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)insert.insertIndex);
            ExpressionManagerTests.assertEquals((int)0, (int)insert.movedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)insert.inserted.size());
            ExpressionManagerTests.assertEquals((int)0, (int)insert.inserted.indexOf(exp4));
            ExpressionManagerTests.assertEquals((int)1, (int)insert.inserted.indexOf(exp5));
            expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)5, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp4, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp5, expressions));
            ExpressionManagerTests.assertEquals((int)3, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)4, (int)this.indexOf((IExpression)exp3, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    public void testInsertAfterExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)3, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp3, expressions));
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.insertExpressions(new IExpression[]{exp4, exp5}, (IExpression)exp2, false);
            ExpressionManagerTests.assertEquals((int)2, (int)single.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)single.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)multi.added.size());
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)insert.insertedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)insert.insertIndex);
            ExpressionManagerTests.assertEquals((int)0, (int)insert.movedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)insert.inserted.size());
            ExpressionManagerTests.assertEquals((int)0, (int)insert.inserted.indexOf(exp4));
            ExpressionManagerTests.assertEquals((int)1, (int)insert.inserted.indexOf(exp5));
            expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)5, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp4, expressions));
            ExpressionManagerTests.assertEquals((int)3, (int)this.indexOf((IExpression)exp5, expressions));
            ExpressionManagerTests.assertEquals((int)4, (int)this.indexOf((IExpression)exp3, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    public void testMoveBeforeExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.moveExpressions(new IExpression[]{exp1, exp2}, (IExpression)exp5, true);
            ExpressionManagerTests.assertEquals((int)0, (int)single.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)insert.insertedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)insert.movedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)insert.moved.size());
            ExpressionManagerTests.assertEquals((int)0, (int)insert.moved.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)insert.moved.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)2, (int)insert.insertIndex);
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)5, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp3, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp4, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)3, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)4, (int)this.indexOf((IExpression)exp5, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    public void testMoveAfterExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.moveExpressions(new IExpression[]{exp1, exp2}, (IExpression)exp3, false);
            ExpressionManagerTests.assertEquals((int)0, (int)single.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)single.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.addedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.removedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)multi.changedCallbacks);
            ExpressionManagerTests.assertEquals((int)0, (int)insert.insertedCallbacks);
            ExpressionManagerTests.assertEquals((int)1, (int)insert.movedCallbacks);
            ExpressionManagerTests.assertEquals((int)2, (int)insert.moved.size());
            ExpressionManagerTests.assertEquals((int)0, (int)insert.moved.indexOf(exp1));
            ExpressionManagerTests.assertEquals((int)1, (int)insert.moved.indexOf(exp2));
            ExpressionManagerTests.assertEquals((int)1, (int)insert.insertIndex);
            IExpression[] expressions = manager.getExpressions();
            ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)5, (int)expressions.length);
            ExpressionManagerTests.assertEquals((int)0, (int)this.indexOf((IExpression)exp3, expressions));
            ExpressionManagerTests.assertEquals((int)1, (int)this.indexOf((IExpression)exp1, expressions));
            ExpressionManagerTests.assertEquals((int)2, (int)this.indexOf((IExpression)exp2, expressions));
            ExpressionManagerTests.assertEquals((int)3, (int)this.indexOf((IExpression)exp4, expressions));
            ExpressionManagerTests.assertEquals((int)4, (int)this.indexOf((IExpression)exp5, expressions));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    public void testPersistExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        IWatchExpression exp1 = manager.newWatchExpression("exp1");
        IWatchExpression exp2 = manager.newWatchExpression("exp2");
        IWatchExpression exp3 = manager.newWatchExpression("exp3");
        IWatchExpression exp4 = manager.newWatchExpression("exp4");
        IWatchExpression exp5 = manager.newWatchExpression("exp5");
        manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
        manager.storeWatchExpressions();
        ExpressionManager manager2 = new ExpressionManager();
        IExpression[] expressions = manager2.getExpressions();
        ExpressionManagerTests.assertEquals((String)"Wrong number of expressions", (int)5, (int)expressions.length);
        ExpressionManagerTests.assertEquals((String)"exp1", (String)expressions[0].getExpressionText());
        ExpressionManagerTests.assertEquals((String)"exp2", (String)expressions[1].getExpressionText());
        ExpressionManagerTests.assertEquals((String)"exp3", (String)expressions[2].getExpressionText());
        ExpressionManagerTests.assertEquals((String)"exp4", (String)expressions[3].getExpressionText());
        ExpressionManagerTests.assertEquals((String)"exp5", (String)expressions[4].getExpressionText());
    }

    public void testConcurrentAccess() throws InterruptedException {
        boolean[] done = new boolean[1];
        Exception[] ex = new Exception[1];
        Runnable add = () -> {
            try {
                int i = 0;
                while (i < 1000) {
                    this.getManager().addExpression((IExpression)this.getManager().newWatchExpression(Integer.toHexString(i)));
                    ++i;
                }
                blArray[0] = true;
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        };
        Runnable remove = () -> {
            try {
                do {
                    this.getManager().removeExpressions(this.getManager().getExpressions());
                } while (!done[0] || this.getManager().getExpressions().length > 0);
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        };
        Thread t1 = new Thread(add);
        Thread t2 = new Thread(remove);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        ExpressionManagerTests.assertEquals((int)0, (int)this.getManager().getExpressions().length);
        ExpressionManagerTests.assertNull((Object)ex[0]);
    }

    class InsertMoveListener
    extends MultiListener
    implements IExpressionsListener2 {
        List<IExpression> moved;
        List<IExpression> inserted;
        int insertIndex;
        int movedCallbacks;
        int insertedCallbacks;

        InsertMoveListener() {
            this.moved = new ArrayList<IExpression>();
            this.inserted = new ArrayList<IExpression>();
            this.insertIndex = -1;
            this.movedCallbacks = 0;
            this.insertedCallbacks = 0;
        }

        public void expressionsMoved(IExpression[] expressions, int index) {
            int i = 0;
            while (i < expressions.length) {
                this.moved.add(expressions[i]);
                ++i;
            }
            ++this.movedCallbacks;
            this.insertIndex = index;
        }

        public void expressionsInserted(IExpression[] expressions, int index) {
            int i = 0;
            while (i < expressions.length) {
                this.inserted.add(expressions[i]);
                ++i;
            }
            ++this.insertedCallbacks;
            this.insertIndex = index;
        }
    }

    class MultiListener
    implements IExpressionsListener {
        List<IExpression> added = new ArrayList<IExpression>();
        List<IExpression> removed = new ArrayList<IExpression>();
        List<IExpression> changed = new ArrayList<IExpression>();
        int addedCallbacks = 0;
        int removedCallbacks = 0;
        int changedCallbacks = 0;

        MultiListener() {
        }

        public void expressionsAdded(IExpression[] expressions) {
            int i = 0;
            while (i < expressions.length) {
                this.added.add(expressions[i]);
                ++i;
            }
            ++this.addedCallbacks;
        }

        public void expressionsRemoved(IExpression[] expressions) {
            int i = 0;
            while (i < expressions.length) {
                this.removed.add(expressions[i]);
                ++i;
            }
            ++this.removedCallbacks;
        }

        public void expressionsChanged(IExpression[] expressions) {
            int i = 0;
            while (i < expressions.length) {
                this.changed.add(expressions[i]);
                ++i;
            }
            ++this.changedCallbacks;
        }
    }

    class SinlgeListener
    implements IExpressionListener {
        List<IExpression> added = new ArrayList<IExpression>();
        List<IExpression> removed = new ArrayList<IExpression>();
        List<IExpression> changed = new ArrayList<IExpression>();
        int addedCallbacks = 0;
        int removedCallbacks = 0;
        int changedCallbacks = 0;

        SinlgeListener() {
        }

        public void expressionAdded(IExpression expression) {
            this.added.add(expression);
            ++this.addedCallbacks;
        }

        public void expressionRemoved(IExpression expression) {
            this.removed.add(expression);
            ++this.removedCallbacks;
        }

        public void expressionChanged(IExpression expression) {
            this.changed.add(expression);
            ++this.changedCallbacks;
        }
    }
}

