/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;

public class LaunchGroupTests
extends AbstractLaunchTest {
    private static final String GROUP_TYPE = "org.eclipse.debug.core.groups.GroupLaunchConfigurationType";
    private static final String DEF_GRP_NAME = "Test Group";
    private final AtomicInteger launchCount = new AtomicInteger(0);
    private ILaunchConfiguration lcToCount = null;
    private ILaunchListener lcListener = new ILaunchListener(){

        public void launchRemoved(ILaunch launch) {
        }

        public void launchChanged(ILaunch launch) {
        }

        public void launchAdded(ILaunch launch) {
            if (launch.getLaunchConfiguration().contentsEqual(LaunchGroupTests.this.lcToCount)) {
                LaunchGroupTests.this.launchCount.incrementAndGet();
            }
        }
    };

    public LaunchGroupTests() {
        super("Launch Groups Test");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.launchCount.set(0);
    }

    @Override
    protected void tearDown() throws Exception {
        ILaunch[] launches;
        this.getLaunchManager().removeLaunchListener(this.lcListener);
        ILaunch[] iLaunchArray = launches = this.getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                if (!launch.isTerminated()) {
                    IProcess[] processes;
                    IProcess[] iProcessArray = processes = launch.getProcesses();
                    int n3 = processes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProcess process = iProcessArray[n4];
                        process.terminate();
                        ++n4;
                    }
                    launch.terminate();
                }
            }
            catch (Exception e) {
                TestUtil.log(4, this.getName(), "Error terminating launch: " + launch, e);
            }
            ++n2;
        }
        super.tearDown();
    }

    private ILaunchConfiguration createLaunchGroup(String name, GroupLaunchElement ... children) throws CoreException {
        ILaunchConfigurationWorkingCopy grp = this.getLaunchManager().getLaunchConfigurationType(GROUP_TYPE).newInstance(null, name);
        GroupLaunchConfigurationDelegate.storeLaunchElements((ILaunchConfigurationWorkingCopy)grp, Arrays.asList(children));
        return grp.doSave();
    }

    private GroupLaunchElement createLaunchGroupElement(ILaunchConfiguration source, GroupLaunchElement.GroupElementPostLaunchAction action, Object param, boolean adopt) {
        GroupLaunchElement e = new GroupLaunchElement();
        e.name = source.getName();
        e.data = source;
        e.action = action;
        e.actionParam = param;
        e.mode = "inherit";
        e.enabled = true;
        e.adoptIfRunning = adopt;
        return e;
    }

    private LaunchHistory getRunLaunchHistory() {
        LaunchHistory h = this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration[] iLaunchConfigurationArray = h.getHistory();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            h.removeFromHistory(c);
            ++n2;
        }
        return h;
    }

    public void testNone() throws Exception {
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration t2 = this.getLaunchConfiguration("Test2");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false), this.createLaunchGroupElement(t2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        LaunchHistory runHistory = this.getRunLaunchHistory();
        grp.launch("run", (IProgressMonitor)new NullProgressMonitor());
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertEquals((int)3, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Test Group", (boolean)history[0].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[1] should be Test2", (boolean)history[1].contentsEqual(t2));
        LaunchGroupTests.assertTrue((String)"history[2] should be Test1", (boolean)history[2].contentsEqual(t1));
    }

    public void testDelay() throws Exception {
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration t2 = this.getLaunchConfiguration("Test2");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.DELAY, 2, false), this.createLaunchGroupElement(t2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        long start = System.currentTimeMillis();
        LaunchHistory runHistory = this.getRunLaunchHistory();
        grp.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchGroupTests.assertTrue((String)"delay was not awaited", (System.currentTimeMillis() - start >= 2000L ? 1 : 0) != 0);
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertEquals((int)3, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Test Group", (boolean)history[0].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[1] should be Test2", (boolean)history[1].contentsEqual(t2));
        LaunchGroupTests.assertTrue((String)"history[2] should be Test1", (boolean)history[2].contentsEqual(t1));
    }

    public void testTerminated() throws Exception {
        final ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration t2 = this.getLaunchConfiguration("Test2");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.WAIT_FOR_TERMINATION, null, false), this.createLaunchGroupElement(t2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        long start = System.currentTimeMillis();
        new Thread("Terminate Test1"){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    ILaunch[] iLaunchArray = LaunchGroupTests.this.getLaunchManager().getLaunches();
                    int n = iLaunchArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch l = iLaunchArray[n2];
                        if (l.getLaunchConfiguration().contentsEqual(t1)) {
                            LaunchGroupTests.attachDummyProcess(l);
                            l.terminate();
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    TestUtil.log(4, this.getName(), e.getMessage(), e);
                }
            }
        }.start();
        LaunchHistory runHistory = this.getRunLaunchHistory();
        grp.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchGroupTests.assertTrue((String)"returned before termination of Test1", (System.currentTimeMillis() - start >= 2000L ? 1 : 0) != 0);
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertEquals((int)3, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Test Group", (boolean)history[0].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[1] should be Test2", (boolean)history[1].contentsEqual(t2));
        LaunchGroupTests.assertTrue((String)"history[2] should be Test1", (boolean)history[2].contentsEqual(t1));
    }

    public void testAdopt() throws Exception {
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false), this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, true));
        LaunchHistory runHistory = this.getRunLaunchHistory();
        this.lcToCount = t1;
        this.getLaunchManager().addLaunchListener(this.lcListener);
        grp.launch("run", (IProgressMonitor)new NullProgressMonitor());
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertEquals((int)2, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Test Group", (boolean)history[0].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[1] should be Test1", (boolean)history[1].contentsEqual(t1));
        LaunchGroupTests.assertEquals((String)"Test1 should be launched only once", (int)1, (int)this.launchCount.get());
    }

    public void testAdoptComplex() throws Exception {
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        ILaunchConfiguration grp2 = this.createLaunchGroup("Group 2", this.createLaunchGroupElement(grp, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        ILaunchConfiguration grp3 = this.createLaunchGroup("Group 3", this.createLaunchGroupElement(grp2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false), this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.DELAY, 10, true));
        LaunchHistory runHistory = this.getRunLaunchHistory();
        this.lcToCount = t1;
        this.getLaunchManager().addLaunchListener(this.lcListener);
        long startTime = System.currentTimeMillis();
        grp3.launch("run", (IProgressMonitor)new NullProgressMonitor());
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertTrue((String)"post launch should not be run", (System.currentTimeMillis() - startTime < 9000L ? 1 : 0) != 0);
        LaunchGroupTests.assertEquals((int)4, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Group 3", (boolean)history[0].contentsEqual(grp3));
        LaunchGroupTests.assertTrue((String)"history[1] should be Group 2", (boolean)history[1].contentsEqual(grp2));
        LaunchGroupTests.assertTrue((String)"history[2] should be Group 1", (boolean)history[2].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[3] should be Test1", (boolean)history[3].contentsEqual(t1));
        LaunchGroupTests.assertEquals((String)"Test1 should be launched only once", (int)1, (int)this.launchCount.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWaitForOutput() throws Exception {
        String testOutput = "TestOutput";
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration t2 = this.getLaunchConfiguration("Test2");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP, testOutput, false), this.createLaunchGroupElement(t2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        final DummyAttachListener attachListener = new DummyAttachListener(t1);
        this.getLaunchManager().addLaunchListener((ILaunchListener)attachListener);
        final AtomicBoolean finished = new AtomicBoolean();
        long start = System.currentTimeMillis();
        new Thread("Output Producer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        attachListener.getStream().write("TestOutput");
                        finished.set(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        LaunchHistory runHistory = this.getRunLaunchHistory();
        grp.launch("run", (IProgressMonitor)new NullProgressMonitor());
        AtomicBoolean atomicBoolean = finished;
        synchronized (atomicBoolean) {
            this.getLaunchManager().removeLaunchListener((ILaunchListener)attachListener);
        }
        LaunchGroupTests.assertTrue((String)"thread did not finish", (boolean)finished.get());
        LaunchGroupTests.assertTrue((String)"output was not awaited", (System.currentTimeMillis() - start >= 2000L ? 1 : 0) != 0);
        ILaunchConfiguration[] history = runHistory.getHistory();
        LaunchGroupTests.assertEquals((int)3, (int)history.length);
        LaunchGroupTests.assertTrue((String)"history[0] should be Test Group", (boolean)history[0].contentsEqual(grp));
        LaunchGroupTests.assertTrue((String)"history[1] should be Test2", (boolean)history[1].contentsEqual(t2));
        LaunchGroupTests.assertTrue((String)"history[2] should be Test1", (boolean)history[2].contentsEqual(t1));
    }

    public void testRename() throws Exception {
        ILaunchConfiguration t1 = this.getLaunchConfiguration("Test1");
        ILaunchConfiguration t2 = this.getLaunchConfiguration("Test2");
        ILaunchConfiguration grp = this.createLaunchGroup(DEF_GRP_NAME, this.createLaunchGroupElement(t1, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false), this.createLaunchGroupElement(t2, GroupLaunchElement.GroupElementPostLaunchAction.NONE, null, false));
        ILaunchConfigurationWorkingCopy workingCopy = t1.getWorkingCopy();
        workingCopy.rename("AnotherTest");
        workingCopy.doSave();
        LaunchGroupTests.assertTrue((String)"name should not be transiently updated", (boolean)grp.getName().equals(DEF_GRP_NAME));
        grp = this.getLaunchConfiguration(DEF_GRP_NAME);
        List elements = GroupLaunchConfigurationDelegate.createLaunchElements((ILaunchConfiguration)grp);
        LaunchGroupTests.assertTrue((String)"group element should be updated", (boolean)((GroupLaunchElement)elements.get((int)0)).name.equals("AnotherTest"));
    }

    private static DummyStream attachDummyProcess(final ILaunch l) {
        final DummyStream dummy = new DummyStream();
        final InvocationHandler streamProxyHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if (name.equals("getOutputStreamMonitor")) {
                    return dummy;
                }
                return null;
            }
        };
        InvocationHandler handler = new InvocationHandler(){
            boolean terminated = false;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if (name.equals("equals")) {
                    if (args.length == 1 && proxy == args[0]) {
                        return true;
                    }
                    return false;
                }
                if (name.equals("getStreamsProxy")) {
                    return Proxy.newProxyInstance(LaunchGroupTests.class.getClassLoader(), new Class[]{IStreamsProxy.class}, streamProxyHandler);
                }
                if (name.equals("getLaunch")) {
                    return l;
                }
                if (name.equals("getLabel")) {
                    return l.getLaunchConfiguration().getName();
                }
                if (name.equals("getAttribute")) {
                    return null;
                }
                if (name.equals("isTerminated")) {
                    return this.terminated;
                }
                if (name.equals("terminate")) {
                    this.terminated = true;
                }
                if (name.equals("getAdapter")) {
                    return null;
                }
                if (name.equals("hashCode")) {
                    return 0;
                }
                return Boolean.TRUE;
            }
        };
        IProcess process = (IProcess)Proxy.newProxyInstance(LaunchGroupTests.class.getClassLoader(), new Class[]{IProcess.class, IDisconnect.class}, handler);
        l.addProcess(process);
        return dummy;
    }

    private static final class DummyAttachListener
    implements ILaunchListener {
        private ILaunchConfiguration cfg;
        private DummyStream stream;

        public DummyAttachListener(ILaunchConfiguration cfg) {
            this.cfg = cfg;
        }

        public DummyStream getStream() {
            return this.stream;
        }

        public void launchRemoved(ILaunch launch) {
        }

        public void launchAdded(ILaunch launch) {
            if (launch.getLaunchConfiguration().equals(this.cfg)) {
                this.stream = LaunchGroupTests.attachDummyProcess(launch);
            }
        }

        public void launchChanged(ILaunch launch) {
        }
    }

    private static final class DummyStream
    implements IStreamMonitor {
        private final List<IStreamListener> listeners = new ArrayList<IStreamListener>();

        private DummyStream() {
        }

        public void addListener(IStreamListener listener) {
            this.listeners.add(listener);
        }

        public String getContents() {
            return null;
        }

        public void removeListener(IStreamListener listener) {
            this.listeners.remove(listener);
        }

        public void write(String s) {
            for (IStreamListener l : this.listeners) {
                l.streamAppended(s, null);
            }
        }
    }
}

