/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;

public class LaunchHistoryTests
extends AbstractLaunchTest {
    public LaunchHistoryTests(String name) {
        super(name);
    }

    private LaunchHistory getRunLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
    }

    private int getMaxHistorySize() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_history_size");
    }

    private void setMaxHistorySize(int value) {
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.max_history_size", value);
    }

    private LaunchHistory getDebugLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
    }

    public void testHistoryAddition() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    public void testHistoriesInSync() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        LaunchHistory debughistory = this.getDebugLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"the debug launch history should not be null", (Object)debughistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"the run history should contain LaunchHistoryTest", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"the run recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        LaunchHistoryTests.assertTrue((String)"the debug history should contain LaunchHistoryTest", (boolean)debughistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"the debug recent launch should be LaunchHistoryTest", (Object)debughistory.getRecentLaunch(), (Object)config);
    }

    public void testHistoryReodering() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest2 config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest2", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    public void testRenameConfigHistoryUpdate() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
        copy.rename("RenamedLaunchHistoryItem");
        config = copy.doSave();
        LaunchHistoryTests.assertEquals((String)"the renamed config should still be the first on in the history", (Object)runhistory.getRecentLaunch(), (Object)config);
        copy = config.getWorkingCopy();
        copy.rename("LaunchHistoryTest");
        config = copy.doSave();
    }

    public void testDeleteLaunchConfigurationHistoryUpdate() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"The run history should contain the LaunchHistoryTest2 config", (boolean)runhistory.contains(config));
        LaunchHistoryTests.assertEquals((String)"The most recent launch should be LaunchHistoryTest2", (Object)runhistory.getRecentLaunch(), (Object)config);
        config.delete();
        config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertEquals((String)"the run history should have LaunchHistoryTest as the recent launch after delete", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    public void testLaunchHistorySize() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        LaunchHistoryTests.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        int oldsize = this.getMaxHistorySize();
        this.setMaxHistorySize(2);
        LaunchHistoryTests.assertTrue((String)"the maximum history size should be 2", (this.getMaxHistorySize() == 2 ? 1 : 0) != 0);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        LaunchHistoryTests.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LaunchHistoryTests.assertTrue((String)"there should only be two items in the history", (runhistory.getHistory().length == this.getMaxHistorySize() ? 1 : 0) != 0);
        LaunchHistoryTests.assertTrue((String)"the complete launch history should be greater than or equal to the history size", (runhistory.getCompleteLaunchHistory().length >= runhistory.getHistory().length ? 1 : 0) != 0);
        this.setMaxHistorySize(oldsize);
    }
}

