/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;

public class LaunchTests
extends AbstractLaunchTest {
    private InvocationHandler handler;
    private Runnable readIsTerminatedTask;
    private Runnable readIsDisconnectedTask;
    private Runnable writeProcessesTask;
    private Runnable writeDebugTargetsTask;

    public LaunchTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Launch launch = new Launch(null, "run", null);
        this.handler = (proxy, method, args) -> {
            String name = method.getName();
            if (name.equals("equals")) {
                if (args.length == 1 && proxy == args[0]) {
                    return true;
                }
                return false;
            }
            return Boolean.TRUE;
        };
        this.readIsTerminatedTask = () -> {
            boolean bl = launch.isTerminated();
        };
        this.readIsDisconnectedTask = () -> {
            boolean bl = launch.isDisconnected();
        };
        this.writeProcessesTask = () -> {
            IProcess process = this.createProcessProxy();
            launch.addProcess(process);
            launch.removeProcess(process);
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
            launch.addProcess(process);
            launch.removeProcess(process);
        };
        this.writeDebugTargetsTask = () -> {
            IDebugTarget target2 = this.createDebugTargetProxy();
            launch.addDebugTarget(target2);
            launch.removeDebugTarget(target2);
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
            launch.addDebugTarget(target2);
            launch.removeDebugTarget(target2);
        };
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTerminatedAndWriteTargets() throws Exception {
        LaunchTests.assertTrue((boolean)this.testExecution(this.readIsTerminatedTask, this.writeDebugTargetsTask));
    }

    public void testDisconnectedAndWriteTargets() throws Exception {
        LaunchTests.assertTrue((boolean)this.testExecution(this.readIsDisconnectedTask, this.writeDebugTargetsTask));
    }

    public void testTerminatedAndWriteProcesses() throws Exception {
        LaunchTests.assertTrue((boolean)this.testExecution(this.readIsTerminatedTask, this.writeProcessesTask));
    }

    public void testDisconnectedAndWriteProcesses() throws Exception {
        LaunchTests.assertTrue((boolean)this.testExecution(this.readIsDisconnectedTask, this.writeProcessesTask));
    }

    private boolean testExecution(Runnable readTask, final Runnable writeTask) {
        final Semaphore semaphore = new Semaphore(0);
        final AtomicInteger runs = new AtomicInteger();
        Job job = new Job("modify debug target"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    semaphore.acquire();
                    int i = 0;
                    while (i < 2000) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            writeTask.run();
                            ++i;
                        }
                        catch (Exception exception) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                }
                finally {
                    runs.set(2000);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        semaphore.release();
        try {
            while (runs.get() < 2000) {
                readTask.run();
                if (job.getResult() == null) continue;
                break;
            }
        }
        finally {
            System.out.println(String.valueOf(this.getName()) + " runs: " + runs);
            job.cancel();
        }
        LaunchTests.assertEquals((int)2000, (int)runs.get());
        return true;
    }

    private IDebugTarget createDebugTargetProxy() {
        IDebugTarget debugTarget = (IDebugTarget)Proxy.newProxyInstance(LaunchTests.class.getClassLoader(), new Class[]{IDebugTarget.class}, this.handler);
        return debugTarget;
    }

    private IProcess createProcessProxy() {
        IProcess process = (IProcess)Proxy.newProxyInstance(LaunchTests.class.getClassLoader(), new Class[]{IProcess.class, IDisconnect.class}, this.handler);
        return process;
    }
}

