/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.sourcelookup;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.sourcelookup.TestLaunch;
import org.eclipse.debug.tests.sourcelookup.TestSourceDirector;
import org.eclipse.debug.tests.sourcelookup.TestSourceLocator;
import org.eclipse.debug.tests.sourcelookup.TestStackFrame;

public class SourceLookupFacilityTests
extends AbstractDebugTest {
    TestStackFrame fReusableFrame = new TestStackFrame(new TestLaunch());
    TestSourceDirector fTestDirector = new TestSourceDirector();
    TestSourceLocator fTestLocator = new TestSourceLocator();

    public SourceLookupFacilityTests(String name) {
        super(name);
    }

    public void testLookupStringNoLocatorNoForce() throws Exception {
        try {
            String artifact = "Empty";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, null, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertNull((String)"Source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStringNoForce() throws Exception {
        try {
            String artifact = "One";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertEquals((String)"The results should be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStringForce() throws Exception {
        try {
            String artifact = "Two";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStringLocatorNoForce() throws Exception {
        try {
            String artifact = "Three";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertNull((String)"The source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeNoForce() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertEquals((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeForce() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeWithDebugElement1() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)new TestStackFrame(null), null, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertNull((String)"Source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeWithDebugElement2() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertEquals((String)"The results should be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeWithDebugElement3() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeWithDebugElement4() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertEquals((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLookupStackframeWithDebugElement5() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, true);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            SourceLookupFacilityTests.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            SourceLookupFacilityTests.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    public void testLRU() throws Exception {
        try {
            Field field = SourceLookupFacility.class.getDeclaredField("fLookupResults");
            field.setAccessible(true);
            HashMap map = (HashMap)field.get(null);
            LinkedHashMap<String, SourceLookupResult> cached = new LinkedHashMap<String, SourceLookupResult>();
            int i = 0;
            while (i < 11) {
                String artifact = "" + i;
                SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
                SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
                SourceLookupFacilityTests.assertFalse((boolean)cached.containsValue(result));
                cached.put(artifact, result);
                result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
                SourceLookupFacilityTests.assertTrue((boolean)cached.containsValue(result));
                SourceLookupFacilityTests.assertTrue((map.size() <= 10 ? 1 : 0) != 0);
                ++i;
            }
            SourceLookupFacilityTests.assertEquals((int)10, (int)map.size());
            SourceLookupFacilityTests.assertFalse((boolean)map.containsValue(cached.values().iterator().next()));
            String artifact = "0";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
            SourceLookupFacilityTests.assertNotNull((String)"There should be a result", (Object)result);
            SourceLookupFacilityTests.assertFalse((boolean)cached.containsValue(result));
            SourceLookupFacilityTests.assertEquals((int)10, (int)map.size());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }
}

