/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.debug.tests.viewer.model.TreeModelViewerAutopopulateAgent;
import org.eclipse.debug.tests.viewer.model.TreePathWrapper;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JFaceViewerTopIndexTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    public JFaceViewerTopIndexTests(String name) {
        super(name);
    }

    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    protected final TreeModelViewer getCTargetViewer() {
        return (TreeModelViewer)this.fViewer;
    }

    protected TreeModelViewer createViewer(Display display, Shell shell) {
        return new TreeModelViewer((Composite)this.fShell, 0x10000002, (IPresentationContext)new PresentationContext("TestViewer"));
    }

    public void testRestoreTopIndex() throws Exception {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[8];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        int indexRevealElem = 4;
        this.getCTargetViewer().reveal(TreePath.EMPTY, indexRevealElem);
        TestUtil.processUIEvents();
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates((IInternalTreeModelViewer)this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        TestUtil.processUIEvents();
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreTopAndExpand() throws Exception {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[10];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = i == 0 ? new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(text) + ".2", new TestModel.TestElement[0])}) : new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        int indexFirstElem = 0;
        TestModel.TestElement firstElem = elements[indexFirstElem];
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta delta = model.getBaseDelta(rootDelta);
        TreePath firstElemPath = model.findElement(firstElem.getLabel());
        this.fListener.addUpdates(firstElemPath, firstElem, 1, 48);
        delta.addNode((Object)firstElem, indexFirstElem, 0x100000, firstElem.getChildren().length);
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(66), this.createListenerErrorMessage());
        JFaceViewerTopIndexTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)firstElemPath));
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 1);
        TestUtil.processUIEvents();
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates((IInternalTreeModelViewer)this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(256), this.createListenerErrorMessage());
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        TestUtil.processUIEvents();
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreTopTriggersExpand() throws Exception {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[10];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = i == elements.length - 1 ? new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(text) + ".2", new TestModel.TestElement[0])}) : new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        this.fViewer.setAutoExpandLevel(-1);
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        int indexLastElem = elements.length - 1;
        TestModel.TestElement lastElem = elements[indexLastElem];
        TreePath lastElemePath = model.findElement(lastElem.getLabel());
        JFaceViewerTopIndexTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)lastElemePath));
        this.fViewer.setAutoExpandLevel(0);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, indexLastElem - 1);
        TestUtil.processUIEvents();
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates((IInternalTreeModelViewer)this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        TestUtil.processUIEvents();
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreRevealAfterRevealCancel() throws Exception {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 2);
        TestUtil.processUIEvents();
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        this.fListener.reset();
        TreePath elementPath = model.findElement("3");
        this.fListener.addUpdates(this.fViewer, elementPath, model.getElement(elementPath), 1, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(1088), this.createListenerErrorMessage());
        ModelDelta revealDelta = model.makeElementDelta(model.findElement("2.1"), 0x1000000);
        this.fListener.reset();
        model.postDelta((IModelDelta)revealDelta);
        this.waitWhile(t -> !this.fListener.isFinished(66), this.createListenerErrorMessage());
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(512), this.createListenerErrorMessage());
        autopopulateAgent.dispose();
    }

    public void testRestoreRevealAfterRevealCancel2() throws Exception {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 2);
        TestUtil.processUIEvents();
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        this.fListener.reset();
        TreePath elementPath = model.findElement("2");
        this.fListener.addUpdates(this.fViewer, elementPath, model.getElement(elementPath), 1, 1060);
        elementPath = model.findElement("3");
        this.fListener.addUpdates(this.fViewer, elementPath, model.getElement(elementPath), 0, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(1024), this.createListenerErrorMessage());
        TreePath pathToBeRevealed = model.findElement("2.1");
        ModelDelta revealDelta = model.makeElementDelta(pathToBeRevealed, 0x1000000);
        revealDelta.accept(new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                ((ModelDelta)delta).setFlags(delta.getFlags() | 0x100000);
                return true;
            }
        });
        model.postDelta((IModelDelta)revealDelta);
        this.waitWhile(t -> !this.fListener.isFinished(100), this.createListenerErrorMessage());
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(pathToBeRevealed, topPath);
    }

    public void testRestoreDeepTreeAndReveal() throws Exception {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = TestModel.simpleDeepMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(model.findElement("3.6.3.16.16.16.16.16"), 1);
        TestUtil.processUIEvents();
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates((IInternalTreeModelViewer)this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(256), this.createListenerErrorMessage());
        this.fListener.reset(false, false);
        this.fListener.addUpdates((IInternalTreeModelViewer)this.getCTargetViewer(), originalTopPath, (TestModel.TestElement)((Object)originalTopPath.getLastSegment()), 0, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(1026), this.createListenerErrorMessage());
        TestUtil.processUIEvents();
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRevealWithContentChanges() throws Exception {
        TreePath element2Path;
        new TreeModelViewerAutopopulateAgent(this.getCTargetViewer());
        TestModel model = TestModel.simpleDeepMultiLevel();
        this.fViewer.setAutoExpandLevel(1);
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.getCTargetViewer().reveal(TreePath.EMPTY, 1);
        TestUtil.processUIEvents();
        TreePath pathToBeRevealed = element2Path = model.findElement("2");
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(pathToBeRevealed, topPath);
        pathToBeRevealed = model.findElement("3");
        ModelDelta revealDelta = model.makeElementDelta(pathToBeRevealed, 0x1000000);
        ModelDelta element2Delta = model.makeElementDelta(element2Path, 1024);
        element2Delta = (ModelDelta)element2Delta.getChildDeltas()[0];
        revealDelta.addNode(element2Delta.getElement(), element2Delta.getIndex(), element2Delta.getFlags(), element2Delta.getChildCount());
        model.removeElementChild(element2Path, 0);
        model.removeElementChild(element2Path, 0);
        this.fListener.reset();
        model.setQeueueingUpdate(true);
        model.postDelta((IModelDelta)revealDelta);
        this.waitWhile(t -> !this.fListener.isFinished(0x100000), this.createListenerErrorMessage());
        model.setQeueueingUpdate(false);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(pathToBeRevealed, topPath);
    }
}

