/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class PopupTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    public PopupTests(String name) {
        super(name);
    }

    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    protected IInternalTreeModelViewer getCTargetViewer() {
        return this.fViewer;
    }

    @Override
    protected IInternalTreeModelViewer createViewer(Display display, Shell shell) {
        return this.createViewer(display, shell, 8);
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2, int var3);

    public void testRefreshStruct() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        TestModel.TestElement[] newChildren = new TestModel.TestElement[]{new TestModel.TestElement(model, "1.1 - new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.2 - new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.3 - new", new TestModel.TestElement[0])};
        ModelDelta delta = model.setElementChildren(elementPath, newChildren);
        this.fListener.reset(elementPath, element, -1, true, false);
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    public void testExpandAndSelect() throws Exception {
        ModelDelta delta;
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        TestModel.TestElement element = model.getRootElement();
        TreePath path_root = TreePath.EMPTY;
        ModelDelta deltaRoot = delta = new ModelDelta((Object)model.getRootElement(), -1, 0x100000, element.getChildren().length);
        element = element.getChildren()[2];
        TreePath path_root_3 = path_root.createChildPath((Object)element);
        delta.addNode((Object)element, 2, 0x300000, element.fChildren.length);
        IInternalTreeModelViewer contentProviderViewer = this.fViewer;
        PopupTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        model.postDelta((IModelDelta)deltaRoot);
        TestUtil.processUIEvents();
        this.waitWhile(t -> !this.fListener.isFinished(64) && (this.fListener.isFinished(131072) || !this.fListener.isFinished(131072) && !this.fListener.isFinished(2)), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        PopupTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof ITreeSelection) {
            List<TreePath> selectionPathsList = Arrays.asList(((ITreeSelection)selection).getPaths());
            PopupTests.assertFalse((boolean)selectionPathsList.contains(path_root_3));
        } else {
            PopupTests.fail((String)"Not a tree selection");
        }
    }

    public void testPreserveExpandedOnSubTreeContent() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        TreeSelection originalSelection = new TreeSelection(model.findElement("3.3.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        model.addElementChild(model.findElement("3"), null, 0, new TestModel.TestElement(model, "3.0 - new", new TestModel.TestElement[0]));
        TreePath elementPath = model.findElement("3");
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta elementDelta = model.getElementDelta(rootDelta, elementPath, true);
        elementDelta.setFlags(1024);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getCTargetViewer(), elementPath, model.getElement(elementPath), -1, 12479);
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        PopupTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)model.findElement("3")));
        PopupTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)model.findElement("3.1")));
        PopupTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)model.findElement("3.2")));
        PopupTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)model.findElement("3.3")));
        PopupTests.assertTrue((boolean)this.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    private boolean areTreeSelectionsEqual(ITreeSelection sel1, ITreeSelection sel2) {
        HashSet<TreePath> sel1Set = new HashSet<TreePath>();
        sel1Set.addAll(Arrays.asList(sel1.getPaths()));
        HashSet<TreePath> sel2Set = new HashSet<TreePath>();
        sel2Set.addAll(Arrays.asList(sel2.getPaths()));
        return sel1Set.equals(sel2Set);
    }
}

