/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;

public class TestModel
implements IElementContentProvider,
IElementLabelProvider,
IModelProxyFactory2,
IElementMementoProvider,
IModelSelectionPolicyFactory {
    private TestElement fRoot;
    private Object fInput = null;
    private TreePath fRootPath = TreePath.EMPTY;
    private ModelProxy fModelProxy;
    private IModelSelectionPolicy fModelSelectionPolicy;
    private boolean fQueueingUpdates = false;
    private boolean fDelayUpdates = false;
    private List<IViewerUpdate> fQueuedUpdates = new LinkedList<IViewerUpdate>();
    public static final String ELEMENT_MEMENTO_ID = "id";

    public TestElement getRootElement() {
        return this.fRoot;
    }

    public void setSelectionPolicy(IModelSelectionPolicy modelSelectionPolicy) {
        this.fModelSelectionPolicy = modelSelectionPolicy;
    }

    public IModelSelectionPolicy createModelSelectionPolicyAdapter(Object element, IPresentationContext context) {
        return this.fModelSelectionPolicy;
    }

    public ModelDelta getBaseDelta(ModelDelta rootDelta) {
        ModelDelta delta = rootDelta;
        int i = 0;
        while (i < this.fRootPath.getSegmentCount()) {
            ModelDelta subDelta = delta.getChildDelta(this.fRootPath.getSegment(i));
            if (subDelta == null) {
                subDelta = delta.addNode(this.fRootPath.getSegment(i), 0);
            }
            delta = subDelta;
            ++i;
        }
        delta.setChildCount(this.getRootElement().getChildren().length);
        return delta;
    }

    public int getModelDepth() {
        return this.getDepth(this.getRootElement(), 0);
    }

    private int getDepth(TestElement element, int atDepth) {
        TestElement[] children = element.getChildren();
        if (children.length == 0) {
            return atDepth;
        }
        int depth = atDepth + 1;
        int i = 0;
        while (i < children.length) {
            depth = Math.max(depth, this.getDepth(children[i], atDepth + 1));
            ++i;
        }
        return depth;
    }

    public void setQeueueingUpdate(boolean queueingUpdates) {
        this.fQueueingUpdates = queueingUpdates;
        if (!this.fQueueingUpdates) {
            this.processQueuedUpdates();
        }
    }

    public void setDelayUpdates(boolean delayUpdates) {
        this.fDelayUpdates = delayUpdates;
    }

    public List<IViewerUpdate> getQueuedUpdates() {
        return this.fQueuedUpdates;
    }

    public void processQueuedUpdates() {
        ArrayList<IViewerUpdate> updates = new ArrayList<IViewerUpdate>(this.fQueuedUpdates);
        this.fQueuedUpdates.clear();
        int i = 0;
        while (i < updates.size()) {
            this.processUpdate((IViewerUpdate)updates.get(i));
            ++i;
        }
    }

    public void processUpdate(IViewerUpdate update) {
        if (update instanceof IHasChildrenUpdate) {
            this.doHasChildrenUpdate((IHasChildrenUpdate)update);
        } else if (update instanceof IChildrenCountUpdate) {
            this.doChildrenCountUpdate((IChildrenCountUpdate)update);
        } else if (update instanceof IChildrenUpdate) {
            this.doChildrenUpdate((IChildrenUpdate)update);
        } else if (update instanceof ILabelUpdate) {
            this.doLabelUpdate((ILabelUpdate)update);
        } else if (update instanceof IElementCompareRequest) {
            this.doCompareElements((IElementCompareRequest)update);
        } else if (update instanceof IElementMementoRequest) {
            this.doEncodeElements((IElementMementoRequest)update);
        }
    }

    private void processUpdates(IViewerUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            this.processUpdate(updates[i]);
            ++i;
        }
    }

    private void doUpdate(IViewerUpdate[] updates) {
        if (this.fQueueingUpdates) {
            this.fQueuedUpdates.addAll(Arrays.asList(updates));
        } else if (this.fDelayUpdates) {
            Display.getDefault().asyncExec(() -> this.processUpdates(updates));
        } else {
            this.processUpdates(updates);
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doHasChildrenUpdate(IHasChildrenUpdate update) {
        TestElement element = (TestElement)((Object)update.getElement());
        update.setHasChilren(element.getChildren().length > 0);
        update.done();
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doChildrenCountUpdate(IChildrenCountUpdate update) {
        TestElement element = (TestElement)((Object)update.getElement());
        update.setChildCount(element.getChildren().length);
        update.done();
    }

    public void update(IChildrenUpdate[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doChildrenUpdate(IChildrenUpdate update) {
        TestElement element = (TestElement)((Object)update.getElement());
        int endOffset = update.getOffset() + update.getLength();
        int j = update.getOffset();
        while (j < endOffset) {
            if (j < element.getChildren().length) {
                update.setChild((Object)element.getChildren()[j], j);
            }
            ++j;
        }
        update.done();
    }

    public void update(ILabelUpdate[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doLabelUpdate(ILabelUpdate update) {
        TestElement element = (TestElement)((Object)update.getElement());
        update.setLabel(element.getLabel(), 0);
        if (update instanceof ICheckUpdate && Boolean.TRUE.equals(update.getPresentationContext().getProperty("org.eclipse.debug.ui.check"))) {
            ((ICheckUpdate)update).setChecked(element.getChecked(), element.getGrayed());
        }
        update.done();
    }

    public void compareElements(IElementCompareRequest[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doCompareElements(IElementCompareRequest update) {
        String elementID = ((TestElement)((Object)update.getElement())).getID();
        String mementoID = update.getMemento().getString(ELEMENT_MEMENTO_ID);
        update.setEqual(elementID.equals(mementoID));
        update.done();
    }

    public void encodeElements(IElementMementoRequest[] updates) {
        this.doUpdate((IViewerUpdate[])updates);
    }

    private void doEncodeElements(IElementMementoRequest update) {
        String elementID = ((TestElement)((Object)update.getElement())).getID();
        update.getMemento().putString(ELEMENT_MEMENTO_ID, elementID);
        update.done();
    }

    public void elementChecked(IPresentationContext context, Object viewerInput, TreePath path, boolean checked) {
        TestElement element = this.getElement(path);
        Assert.assertFalse((boolean)element.getGrayed());
        element.setChecked(checked, false);
    }

    public IModelProxy createTreeModelProxy(Object input, TreePath path, IPresentationContext context) {
        this.fModelProxy = new ModelProxy();
        this.fInput = input;
        this.fRootPath = path;
        return this.fModelProxy;
    }

    public IModelProxy getModelProxy() {
        return this.fModelProxy;
    }

    public TestElement getElement(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return this.getRootElement();
        }
        return (TestElement)((Object)path.getLastSegment());
    }

    public void setAllExpanded() {
        this.doSetExpanded(this.fRoot);
    }

    private void doSetExpanded(TestElement element) {
        element.fExpanded = true;
        int i = 0;
        while (i < element.fChildren.length) {
            this.doSetExpanded(element.fChildren[i]);
            ++i;
        }
    }

    public void setAllAppendix(String appendix) {
        this.doSetAllAppendix(this.fRoot, appendix);
    }

    private void doSetAllAppendix(TestElement element, String appendix) {
        element.setLabelAppendix(appendix);
        int i = 0;
        while (i < element.fChildren.length) {
            this.doSetAllAppendix(element.fChildren[i], appendix);
            ++i;
        }
    }

    public void validateData(ITreeModelViewer viewer, TreePath path) {
        this.validateData(viewer, path, false);
    }

    public void validateData(ITreeModelViewer _viewer, TreePath path, boolean expandedElementsOnly) {
        this.validateData(_viewer, path, expandedElementsOnly, TestModelUpdatesListener.EMPTY_FILTER_ARRAY);
    }

    public void validateData(ITreeModelViewer _viewer, TreePath path, boolean expandedElementsOnly, ViewerFilter[] filters) {
        IInternalTreeModelViewer viewer = (IInternalTreeModelViewer)_viewer;
        TestElement element = this.getElement(path);
        if (Boolean.TRUE.equals(_viewer.getPresentationContext().getProperty("org.eclipse.debug.ui.check"))) {
            Assert.assertTrue((element.getChecked() == viewer.getElementChecked(path) ? 1 : 0) != 0);
            Assert.assertTrue((element.getGrayed() == viewer.getElementGrayed(path) ? 1 : 0) != 0);
        }
        if (!expandedElementsOnly || path.getSegmentCount() == 0 || viewer.getExpandedState((Object)path)) {
            TestElement[] children = element.getChildren();
            int viewerIndex = 0;
            int i = 0;
            while (i < children.length) {
                if (!TestModelUpdatesListener.isFiltered((Object)children[i], filters)) {
                    Assert.assertEquals((Object)((Object)children[i]), (Object)viewer.getChildElement(path, viewerIndex));
                    this.validateData((ITreeModelViewer)viewer, path.createChildPath((Object)children[i]), expandedElementsOnly, filters);
                    ++viewerIndex;
                }
                ++i;
            }
            Assert.assertEquals((long)viewerIndex, (long)viewer.getChildCount(path));
        } else if (!viewer.getExpandedState((Object)path)) {
            Assert.assertTrue((viewer.getHasChildren((Object)path) == element.getChildren().length > 0 ? 1 : 0) != 0);
        }
    }

    public void setRoot(TestElement root) {
        this.fRoot = root;
    }

    public void postDelta(IModelDelta delta) {
        this.fModelProxy.fireModelChanged(delta);
    }

    public ModelDelta getElementDelta(ModelDelta baseDelta, TreePath path, boolean combine) {
        TestElement element = this.getRootElement();
        ModelDelta delta = baseDelta;
        int i = 0;
        while (i < path.getSegmentCount()) {
            TestElement[] children = element.getChildren();
            delta.setChildCount(children.length);
            Object segment = path.getSegment(i);
            int j = 0;
            while (j < children.length) {
                if (segment.equals((Object)children[j])) {
                    element = children[j];
                    ModelDelta nextDelta = null;
                    if (combine) {
                        nextDelta = delta.getChildDelta((Object)element);
                    }
                    if (nextDelta == null) {
                        nextDelta = delta.addNode((Object)element, j, 0, element.getChildren().length);
                    }
                    delta = nextDelta;
                    break;
                }
                ++j;
            }
            if (j == children.length) {
                throw new IllegalArgumentException("Invalid path");
            }
            ++i;
        }
        return delta;
    }

    private TreePath getRelativePath(TreePath path) {
        Object[] segments = new Object[path.getSegmentCount() - this.fRootPath.getSegmentCount()];
        int i = this.fRootPath.getSegmentCount();
        int _i = 0;
        while (i < path.getSegmentCount()) {
            segments[_i] = path.getSegment(i);
            ++i;
            ++_i;
        }
        return new TreePath(segments);
    }

    public ModelDelta appendElementLabel(TreePath path, String labelAppendix) {
        Assert.assertTrue((boolean)path.startsWith(this.fRootPath, null));
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(path);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, false);
        element.setLabelAppendix(labelAppendix);
        delta.setFlags(delta.getFlags() | 0x800);
        return rootDelta;
    }

    public ModelDelta setElementChecked(TreePath path, boolean checked, boolean grayed) {
        Assert.assertTrue((boolean)path.startsWith(this.fRootPath, null));
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(path);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, false);
        element.setChecked(checked, grayed);
        delta.setFlags(delta.getFlags() | 0x800);
        return rootDelta;
    }

    public ModelDelta setElementChildren(TreePath path, TestElement[] children) {
        Assert.assertTrue((boolean)path.startsWith(this.fRootPath, null));
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(path);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, false);
        element.fChildren = children;
        delta.setFlags(delta.getFlags() | 0x400);
        delta.setChildCount(children.length);
        return rootDelta;
    }

    public ModelDelta replaceElementChild(TreePath parentPath, int index, TestElement child) {
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(parentPath);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, false);
        TestElement oldChild = element.fChildren[index];
        element.fChildren[index] = child;
        delta.addNode((Object)oldChild, (Object)child, 8);
        return rootDelta;
    }

    public ModelDelta addElementChild(TreePath parentPath, ModelDelta rootDelta, int index, TestElement newChild) {
        if (rootDelta == null) {
            rootDelta = new ModelDelta(this.fInput, 0);
        }
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(parentPath);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, true);
        element.fChildren = this.doInsertElementInArray(element.fChildren, index, newChild);
        delta.setChildCount(element.getChildren().length);
        delta.addNode((Object)newChild, index, 1);
        return rootDelta;
    }

    public ModelDelta insertElementChild(TreePath parentPath, int index, TestElement newChild) {
        return this.insertElementChild(null, parentPath, index, newChild);
    }

    public ModelDelta insertElementChild(ModelDelta rootDelta, TreePath parentPath, int index, TestElement newChild) {
        if (rootDelta == null) {
            rootDelta = new ModelDelta(this.fInput, 0);
        }
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TreePath relativePath = this.getRelativePath(parentPath);
        TestElement element = this.getElement(relativePath);
        ModelDelta delta = this.getElementDelta(baseDelta, relativePath, false);
        element.fChildren = this.doInsertElementInArray(element.fChildren, index, newChild);
        delta.setChildCount(element.getChildren().length);
        delta.addNode((Object)newChild, index, 16);
        return rootDelta;
    }

    private TestElement[] doInsertElementInArray(TestElement[] children, int index, TestElement newChild) {
        TestElement[] newChildren = new TestElement[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, index);
        newChildren[index] = newChild;
        System.arraycopy(children, index, newChildren, index + 1, children.length - index);
        return newChildren;
    }

    public ModelDelta removeElementChild(TreePath parentPath, int index) {
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        TestElement element = this.getElement(parentPath);
        ModelDelta delta = this.getElementDelta(baseDelta, parentPath, false);
        TestElement[] children = element.getChildren();
        TestElement childToRemove = children[index];
        TestElement[] newChildren = new TestElement[children.length - 1];
        System.arraycopy(children, 0, newChildren, 0, index);
        System.arraycopy(children, index + 1, newChildren, index, children.length - index - 1);
        element.fChildren = newChildren;
        delta.setChildCount(element.getChildren().length);
        delta.addNode((Object)childToRemove, index, 2);
        return rootDelta;
    }

    public ModelDelta makeElementDelta(TreePath path, int flags) {
        ModelDelta rootDelta = new ModelDelta(this.fInput, 0);
        ModelDelta baseDelta = this.getBaseDelta(rootDelta);
        ModelDelta delta = this.getElementDelta(baseDelta, path, false);
        delta.setFlags(flags);
        return rootDelta;
    }

    public TreePath findElement(String label) {
        return this.findElement(TreePath.EMPTY, label);
    }

    public TreePath findElement(TreePath startPath, String label) {
        TestElement element = this.getElement(startPath);
        int i = 0;
        while (i < element.getChildren().length) {
            TestElement child = element.getChildren()[i];
            TreePath path = startPath.createChildPath((Object)child);
            if (label.equals(child.getLabel())) {
                return path;
            }
            TreePath subPath = this.findElement(path, label);
            if (subPath != null) {
                return subPath;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.getElementString(this.fRoot, "");
    }

    public String getElementString(TestElement element, String indent) {
        StringBuffer builder = new StringBuffer();
        builder.append(indent);
        builder.append(element.toString());
        builder.append('\n');
        TestElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            builder.append(this.getElementString(children[i], String.valueOf(indent) + "  "));
            ++i;
        }
        return builder.toString();
    }

    public static TestModel simpleSingleLevel() {
        TestModel model = new TestModel();
        model.setRoot(new TestElement(model, "root", TestModel.makeSingleLevelModelElements(model, 6, "")));
        return model;
    }

    public static TestElement[] makeSingleLevelModelElements(TestModel model, int length, String prefix) {
        TestElement[] elements = new TestElement[length];
        int i = 1;
        while (i <= length) {
            String name = String.valueOf(prefix) + i;
            elements[i - 1] = new TestElement(model, name, new TestElement[0]);
            ++i;
        }
        return elements;
    }

    public static TestElement[] makeMultiLevelElements(TestModel model, int depth, String prefix) {
        TestElement[] elements = new TestElement[depth];
        int i = 0;
        while (i < depth) {
            String name = String.valueOf(prefix) + i;
            elements[i] = new TestElement(model, name, TestModel.makeMultiLevelElements(model, i, String.valueOf(name) + "."));
            ++i;
        }
        return elements;
    }

    public static TestElement[] makeMultiLevelElements2(TestModel model, int[] levelCounts, String prefix) {
        if (levelCounts.length == 0) {
            return new TestElement[0];
        }
        int count = levelCounts[0];
        int[] oldLevelCounts = levelCounts;
        levelCounts = new int[levelCounts.length - 1];
        System.arraycopy(oldLevelCounts, 1, levelCounts, 0, levelCounts.length);
        TestElement[] elements = new TestElement[count];
        int i = 0;
        while (i < count) {
            String name = String.valueOf(prefix) + i;
            elements[i] = new TestElement(model, name, TestModel.makeMultiLevelElements2(model, levelCounts, String.valueOf(name) + "."));
            ++i;
        }
        return elements;
    }

    public static TestModel simpleMultiLevel() {
        TestModel model = new TestModel();
        model.setRoot(new TestElement(model, "root", new TestElement[]{new TestElement(model, "1", new TestElement[0]), new TestElement(model, "2", true, false, new TestElement[]{new TestElement(model, "2.1", true, true, new TestElement[0]), new TestElement(model, "2.2", false, true, new TestElement[0]), new TestElement(model, "2.3", true, false, new TestElement[0])}), new TestElement(model, "3", new TestElement[]{new TestElement(model, "3.1", new TestElement[]{new TestElement(model, "3.1.1", new TestElement[0]), new TestElement(model, "3.1.2", new TestElement[0]), new TestElement(model, "3.1.3", new TestElement[0])}), new TestElement(model, "3.2", new TestElement[]{new TestElement(model, "3.2.1", new TestElement[0]), new TestElement(model, "3.2.2", new TestElement[0]), new TestElement(model, "3.2.3", new TestElement[0])}), new TestElement(model, "3.3", new TestElement[]{new TestElement(model, "3.3.1", new TestElement[0]), new TestElement(model, "3.3.2", new TestElement[0]), new TestElement(model, "3.3.3", new TestElement[0])})})}));
        return model;
    }

    public static TestModel compositeMultiLevel() {
        TestModel m2 = new TestModel();
        m2.setRoot(new TestElement(m2, "m2.root", new TestElement[]{new TestElement(m2, "m2.1", new TestElement[0]), new TestElement(m2, "m2.2", true, false, new TestElement[]{new TestElement(m2, "m2.2.1", true, true, new TestElement[0]), new TestElement(m2, "m2.2.2", false, true, new TestElement[0]), new TestElement(m2, "m2.2.3", true, false, new TestElement[0])})}));
        TestModel m3 = new TestModel();
        m3.setRoot(new TestElement(m3, "m3.root", new TestElement[]{new TestElement(m3, "m3.1", new TestElement[0]), new TestElement(m3, "m3.2", true, false, new TestElement[]{new TestElement(m3, "m3.2.1", true, true, new TestElement[0]), new TestElement(m3, "m3.2.2", false, true, new TestElement[0]), new TestElement(m3, "m3.2.3", true, false, new TestElement[0])})}));
        TestModel m4 = new TestModel();
        m4.setRoot(new TestElement(m4, "m4.root", new TestElement[]{new TestElement(m4, "m4.1", new TestElement[0]), new TestElement(m4, "m4.2", true, false, new TestElement[]{new TestElement(m4, "m4.2.1", true, true, new TestElement[0]), new TestElement(m4, "m4.2.2", false, true, new TestElement[0]), new TestElement(m4, "m4.2.3", true, false, new TestElement[0])})}));
        TestModel m1 = new TestModel();
        m1.setRoot(new TestElement(m1, "m1.root", new TestElement[]{new TestElement(m1, "m1.1", new TestElement[0]), new TestElement(m1, "m1.2", true, false, new TestElement[]{m2.fRoot, m3.fRoot, m4.fRoot})}));
        return m1;
    }

    public static TestModel simpleDeepMultiLevel() {
        TestModel model = new TestModel();
        model.setRoot(new TestElement(model, "root", new TestElement[]{new TestElement(model, "1", new TestElement[0]), new TestElement(model, "2", true, false, new TestElement[]{new TestElement(model, "2.1", true, true, new TestElement[0]), new TestElement(model, "2.2", false, true, new TestElement[0]), new TestElement(model, "2.3", true, false, new TestElement[0])}), new TestElement(model, "3", new TestElement[]{new TestElement(model, "3.1", new TestElement[]{new TestElement(model, "3.1.1", new TestElement[0]), new TestElement(model, "3.1.2", new TestElement[0]), new TestElement(model, "3.1.3", new TestElement[0])}), new TestElement(model, "3.2", new TestElement[]{new TestElement(model, "3.2.1", new TestElement[0]), new TestElement(model, "3.2.2", new TestElement[0]), new TestElement(model, "3.2.3", new TestElement[0])}), new TestElement(model, "3.3", new TestElement[]{new TestElement(model, "3.3.1", new TestElement[0]), new TestElement(model, "3.3.2", new TestElement[0]), new TestElement(model, "3.3.3", new TestElement[0])}), new TestElement(model, "3.4", new TestElement[]{new TestElement(model, "3.4.1", new TestElement[0]), new TestElement(model, "3.4.2", new TestElement[0]), new TestElement(model, "3.4.3", new TestElement[0])}), new TestElement(model, "3.5", new TestElement[]{new TestElement(model, "3.5.1", new TestElement[0]), new TestElement(model, "3.5.2", new TestElement[0]), new TestElement(model, "3.5.3", new TestElement[0])}), new TestElement(model, "3.6", new TestElement[]{new TestElement(model, "3.6.1", new TestElement[0]), new TestElement(model, "3.6.2", new TestElement[0]), new TestElement(model, "3.6.3", new TestElement[]{new TestElement(model, "3.6.3.1", new TestElement[0]), new TestElement(model, "3.6.3.2", new TestElement[0]), new TestElement(model, "3.6.3.4", new TestElement[0]), new TestElement(model, "3.6.3.5", new TestElement[0]), new TestElement(model, "3.6.3.6", new TestElement[0]), new TestElement(model, "3.6.3.7", new TestElement[0]), new TestElement(model, "3.6.3.8", new TestElement[0]), new TestElement(model, "3.6.3.9", new TestElement[0]), new TestElement(model, "3.6.3.10", new TestElement[0]), new TestElement(model, "3.6.3.11", new TestElement[0]), new TestElement(model, "3.6.3.12", new TestElement[0]), new TestElement(model, "3.6.3.13", new TestElement[0]), new TestElement(model, "3.6.3.14", new TestElement[0]), new TestElement(model, "3.6.3.15", new TestElement[0]), new TestElement(model, "3.6.3.16", new TestElement[]{new TestElement(model, "3.6.3.16.1", new TestElement[0]), new TestElement(model, "3.6.3.16.2", new TestElement[0]), new TestElement(model, "3.6.3.16.4", new TestElement[0]), new TestElement(model, "3.6.3.16.5", new TestElement[0]), new TestElement(model, "3.6.3.16.6", new TestElement[0]), new TestElement(model, "3.6.3.16.7", new TestElement[0]), new TestElement(model, "3.6.3.16.8", new TestElement[0]), new TestElement(model, "3.6.3.16.9", new TestElement[0]), new TestElement(model, "3.6.3.16.10", new TestElement[0]), new TestElement(model, "3.6.3.16.11", new TestElement[0]), new TestElement(model, "3.6.3.16.12", new TestElement[0]), new TestElement(model, "3.6.3.16.13", new TestElement[0]), new TestElement(model, "3.6.3.16.14", new TestElement[0]), new TestElement(model, "3.6.3.16.15", new TestElement[0]), new TestElement(model, "3.6.3.16.16", new TestElement[]{new TestElement(model, "3.6.3.16.16.1", new TestElement[0]), new TestElement(model, "3.6.3.16.16.2", new TestElement[0]), new TestElement(model, "3.6.3.16.16.4", new TestElement[0]), new TestElement(model, "3.6.3.16.16.5", new TestElement[0]), new TestElement(model, "3.6.3.16.16.6", new TestElement[0]), new TestElement(model, "3.6.3.16.16.7", new TestElement[0]), new TestElement(model, "3.6.3.16.16.8", new TestElement[0]), new TestElement(model, "3.6.3.16.16.9", new TestElement[0]), new TestElement(model, "3.6.3.16.16.10", new TestElement[0]), new TestElement(model, "3.6.3.16.16.11", new TestElement[0]), new TestElement(model, "3.6.3.16.16.12", new TestElement[0]), new TestElement(model, "3.6.3.16.16.13", new TestElement[0]), new TestElement(model, "3.6.3.16.16.14", new TestElement[0]), new TestElement(model, "3.6.3.16.16.15", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16", new TestElement[]{new TestElement(model, "3.6.3.16.16.16.1", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.2", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.4", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.5", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.6", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.7", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.8", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.9", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.10", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.11", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.12", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.13", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.14", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.15", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16", new TestElement[]{new TestElement(model, "3.6.3.16.16.16.16.1", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.2", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.4", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.5", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.6", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.7", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.8", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.9", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.10", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.11", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.12", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.13", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.14", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.15", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16", new TestElement[]{new TestElement(model, "3.6.3.16.16.16.16.16.1", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.2", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.4", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.5", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.6", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.7", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.8", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.9", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.10", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.11", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.12", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.13", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.14", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.15", new TestElement[0]), new TestElement(model, "3.6.3.16.16.16.16.16.16", new TestElement[0])})})})})})})})})}));
        return model;
    }

    private class ModelProxy
    extends AbstractModelProxy {
        private ModelProxy() {
        }

        public void installed(Viewer viewer) {
            super.installed(viewer);
            ModelDelta rootDelta = TestModel.this.getBaseDelta(new ModelDelta(TestModel.this.fInput, 0));
            this.installSubModelProxies(TestModel.this.fRootPath, rootDelta);
            this.fireModelChanged((IModelDelta)rootDelta);
        }

        private void installSubModelProxies(TreePath path, ModelDelta delta) {
            TestElement element = TestModel.this.getElement(path);
            if (element.fModel != TestModel.this) {
                delta.setFlags(delta.getFlags() | 0x400000);
            } else {
                TestElement[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.installSubModelProxies(path.createChildPath((Object)children[i]), delta.addNode((Object)children[i], 0));
                    ++i;
                }
            }
        }
    }

    public static class TestElement
    extends PlatformObject {
        private final TestModel fModel;
        private final String fID;
        TestElement[] fChildren;
        String fLabelAppendix = "";
        boolean fExpanded;
        boolean fChecked;
        boolean fGrayed;

        public TestElement(TestModel model, String text, TestElement[] children) {
            this(model, text, false, false, children);
        }

        public TestElement(TestModel model, String text, boolean checked, boolean grayed, TestElement[] children) {
            this.fModel = model;
            this.fID = text;
            this.fChildren = children;
            this.fChecked = checked;
            this.fGrayed = grayed;
        }

        public TestModel getModel() {
            return this.fModel;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance(this.fModel)) {
                return (T)this.fModel;
            }
            return null;
        }

        public String getID() {
            return this.fID;
        }

        public void setLabelAppendix(String appendix) {
            this.fLabelAppendix = appendix;
        }

        public String getLabel() {
            return String.valueOf(this.fID) + this.fLabelAppendix;
        }

        public TestElement[] getChildren() {
            return this.fChildren;
        }

        public boolean isExpanded() {
            return this.fExpanded;
        }

        public boolean getGrayed() {
            return this.fGrayed;
        }

        public boolean getChecked() {
            return this.fChecked;
        }

        public void setChecked(boolean checked, boolean grayed) {
            this.fChecked = checked;
            this.fGrayed = grayed;
        }

        public boolean equals(Object obj) {
            return obj instanceof TestElement && this.fID.equals(((TestElement)((Object)obj)).fID);
        }

        public int hashCode() {
            return this.fID.hashCode();
        }

        public String toString() {
            return this.getLabel();
        }

        public int indexOf(TestElement child) {
            return Arrays.asList(this.fChildren).indexOf((Object)child);
        }
    }
}

