/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeModelViewerAutopopulateAgent
implements IViewerUpdateListener {
    private TreeModelViewer fViewer;

    public TreeModelViewerAutopopulateAgent(TreeModelViewer viewer) {
        this.fViewer = viewer;
        this.fViewer.addViewerUpdateListener((IViewerUpdateListener)this);
    }

    public void dispose() {
        this.fViewer.removeViewerUpdateListener((IViewerUpdateListener)this);
        this.fViewer = null;
    }

    public void updateComplete(IViewerUpdate update) {
        if (update instanceof IChildrenCountUpdate) {
            TreePath path = update.getElementPath();
            ILazyTreePathContentProvider contentProvider = (ILazyTreePathContentProvider)this.fViewer.getContentProvider();
            Widget[] items = this.fViewer.testFindItems(update.getElement());
            int i = 0;
            while (i < items.length) {
                if (path.equals((Object)this.getTreePath(items[i]))) {
                    int itemCount = this.getItemChildCount(items[i]);
                    int j = 0;
                    while (j < itemCount) {
                        contentProvider.updateElement(path, j);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public void viewerUpdatesBegin() {
    }

    public void viewerUpdatesComplete() {
    }

    private TreePath getTreePath(Widget w) {
        if (w instanceof TreeItem) {
            TreeItem item = (TreeItem)w;
            LinkedList<Object> segments = new LinkedList<Object>();
            while (item != null) {
                Object segment = item.getData();
                Assert.isNotNull((Object)segment);
                segments.addFirst(segment);
                item = item.getParentItem();
            }
            return new TreePath(segments.toArray());
        }
        return TreePath.EMPTY;
    }

    private int getItemChildCount(Widget w) {
        if (w instanceof Tree) {
            return ((Tree)w).getItemCount();
        }
        if (w instanceof TreeItem) {
            return ((TreeItem)w).getItemCount();
        }
        return 0;
    }
}

