/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.FeatureClassLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.tools.emf.ui.internal.imp.ModelImportWizard;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PartStackEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private final IListProperty ELEMENT_CONTAINER__CHILDREN = EMFProperties.list((EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> actionsImport = new ArrayList<Action>();
    @Inject
    @Optional
    private IProject project;
    private TableViewer viewer;

    @Inject
    public PartStackEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.PartStackEditor_AddPart, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                PartStackEditor.this.handleAddChild(BasicPackageImpl.Literals.PART);
            }
        });
        this.actions.add(new Action(this.Messages.PartStackEditor_AddCompositePart, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.PartSashContainer")){

            public void run() {
                PartStackEditor.this.handleAddChild(BasicPackageImpl.Literals.COMPOSITE_PART);
            }
        });
        this.actions.add(new Action(this.Messages.PartStackEditor_AddPlaceholder, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Placeholder")){

            public void run() {
                PartStackEditor.this.handleAddChild(AdvancedPackageImpl.Literals.PLACEHOLDER);
            }
        });
        List<IEditorFeature.FeatureClass> list = this.getEditor().getFeatureClasses(BasicPackageImpl.Literals.PART_STACK, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        if (!list.isEmpty()) {
            for (IEditorFeature.FeatureClass c : list) {
                final EClass ec = c.eClass;
                this.actions.add(new Action(c.label, this.createImageDescriptor(c.iconId)){

                    public void run() {
                        PartStackEditor.this.handleAddChild(ec);
                    }
                });
            }
        }
        this.actionsImport.add(new Action(this.Messages.PartStackEditor_Views, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                PartStackEditor.this.handleImportChild(BasicPackageImpl.Literals.PART);
            }
        });
        this.actionsImport.add(new Action(this.Messages.PartStackEditor_Editors, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                PartStackEditor.this.handleImportChild(BasicPackageImpl.Literals.PART);
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.PartStackEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.PartStackEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        this.viewer.setInput((Object)prop.observeDetail((IObservableValue)this.getMaster()));
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID));
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, (IObservableValue)this.getMaster(), context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__ACCESSIBILITY_PHRASE));
        ControlFactory.createSelectedElement(parent, this, context, this.Messages.PartStackEditor_SelectedElement);
        ControlFactory.createTextField(parent, this.Messages.PartStackEditor_ContainerData, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__CONTAINER_DATA));
        E4PickList pickList = new E4PickList(parent, 0, null, (AbstractComponentEditor)this, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN){

            @Override
            protected void addPressed() {
                EClass eClass = ((IEditorFeature.FeatureClass)this.getSelection().getFirstElement()).eClass;
                PartStackEditor.this.handleAddChild(eClass);
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.PartStackEditor_Parts);
        this.viewer = pickList.getList();
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        this.viewer.setInput((Object)prop.observeDetail((IObservableValue)this.getMaster()));
        pickList.setLabelProvider((ILabelProvider)new FeatureClassLabelProvider(this.getEditor()));
        ArrayList<IEditorFeature.FeatureClass> eClassList = new ArrayList<IEditorFeature.FeatureClass>();
        eClassList.add(new IEditorFeature.FeatureClass(this.Messages.PartStackEditor_Part, BasicPackageImpl.Literals.PART));
        eClassList.add(new IEditorFeature.FeatureClass(this.Messages.PartStackEditor_CompositePart, BasicPackageImpl.Literals.COMPOSITE_PART));
        eClassList.add(new IEditorFeature.FeatureClass(this.Messages.PartStackEditor_Placeholder, AdvancedPackageImpl.Literals.PLACEHOLDER));
        eClassList.addAll(this.getEditor().getFeatureClasses(BasicPackageImpl.Literals.PART_STACK, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN));
        pickList.setInput(eClassList);
        pickList.setSelection((ISelection)new StructuredSelection(eClassList.get(0)));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MPartStack.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList getChildList(Object element) {
        return this.ELEMENT_CONTAINER__CHILDREN.observe(element);
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    protected void handleAddChild(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        this.addToModel(eObject);
    }

    private void addToModel(EObject eObject) {
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(eObject);
        }
    }

    protected void handleImportChild(EClass eClass) {
        if (eClass == BasicPackageImpl.Literals.PART) {
            ModelImportWizard wizard = new ModelImportWizard(MPart.class, this, this.resourcePool);
            WizardDialog wizardDialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)wizard);
            if (wizardDialog.open() == 0) {
                MPart[] parts;
                MPart[] mPartArray = parts = (MPart[])wizard.getElements(MPart.class);
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    MPart part = mPartArray[n2];
                    this.addToModel((EObject)part);
                    ++n2;
                }
            }
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    @Override
    public List<Action> getActionsImport(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActionsImport(element));
        l.addAll(this.actionsImport);
        return l;
    }
}

