/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tests.verifier;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.tests.verifier.Activator;
import org.eclipse.equinox.internal.p2.tests.verifier.EclipseAdaptorMsg;
import org.eclipse.equinox.internal.p2.tests.verifier.MigrationWizardTestHelper;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.MigrationWizard;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class VerifierApplication
implements IApplication {
    private static final File DEFAULT_PROPERTIES_FILE = new File("verifier.properties");
    private static final String ARG_PROPERTIES = "-verifier.properties";
    private IProvisioningAgent agent;
    private Properties properties = null;
    private List<String> ignoreResolved = null;

    private static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.tests.verifier", message);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.processArguments(args);
        this.agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), IProvisioningAgent.class);
        IStatus result = this.verify();
        if (!result.isOK()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(System.err));){
                out.println("Error from dropin verifier application: " + result.getMessage());
                Throwable t = result.getException();
                if (t != null) {
                    t.printStackTrace(out);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            LogHelper.log((IStatus)result);
        }
        return result.isOK() ? IApplication.EXIT_OK : Integer.valueOf(13);
    }

    private void processArguments(String[] args) {
        if (args == null) {
            return;
        }
        int i = 1;
        while (i < args.length) {
            String filename;
            if (ARG_PROPERTIES.equals(args[i - 1]) && !(filename = args[i]).startsWith("-")) {
                try {
                    this.properties = this.readProperties(new File(filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.properties == null) {
            try {
                if (DEFAULT_PROPERTIES_FILE.exists()) {
                    this.properties = this.readProperties(DEFAULT_PROPERTIES_FILE);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    private Properties readProperties(File file) throws IOException {
        Properties result = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            result.load(input);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void stop() {
    }

    protected boolean shouldCheckResolved(String bundle) {
        if (this.ignoreResolved == null) {
            this.ignoreResolved = new ArrayList<String>();
            String list = this.properties.getProperty("ignore.unresolved");
            if (list == null) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(list, ",");
            while (tokenizer.hasMoreTokens()) {
                this.ignoreResolved.add(tokenizer.nextToken().trim());
            }
        }
        Iterator<String> iter = this.ignoreResolved.iterator();
        while (iter.hasNext()) {
            if (!bundle.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    private IStatus checkResolved() {
        String message;
        BundleRevision revision;
        ArrayList<IStatus> allProblems = new ArrayList<IStatus>();
        ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
        Bundle[] bundleArray = Activator.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            BundleRevision revision2 = (BundleRevision)b.adapt(BundleRevision.class);
            if (revision2 != null && revision2.getWiring() == null) {
                unresolved.add(b);
            }
            ++n2;
        }
        ResolutionReport report = VerifierApplication.getResolutionReport(unresolved);
        Map entries = report.getEntries();
        HashSet unresolvedResources = new HashSet(entries.keySet());
        HashSet<Resource> leafResources = new HashSet<Resource>();
        for (Map.Entry resourceEntry : entries.entrySet()) {
            for (ResolutionReport.Entry reportEntry : (List)resourceEntry.getValue()) {
                if (reportEntry.getType().equals((Object)ResolutionReport.Entry.Type.UNRESOLVED_PROVIDER)) continue;
                leafResources.add((Resource)resourceEntry.getKey());
                unresolvedResources.remove(resourceEntry.getKey());
            }
        }
        for (Resource leafResource : leafResources) {
            revision = (BundleRevision)leafResource;
            message = String.valueOf(NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, (Object)revision.getBundle().getLocation())) + '\n';
            message = String.valueOf(message) + report.getResolutionReportMessage(leafResource);
            allProblems.add(VerifierApplication.createError(message));
        }
        for (Resource unresolvedResource : unresolvedResources) {
            revision = (BundleRevision)unresolvedResource;
            message = String.valueOf(NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, (Object)revision.getBundle().getLocation())) + '\n';
            message = String.valueOf(message) + report.getResolutionReportMessage(unresolvedResource);
            allProblems.add(VerifierApplication.createError(message));
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 0, "Problems checking resolved bundles.", null);
        Iterator iter = allProblems.iterator();
        while (iter.hasNext()) {
            result.add((IStatus)iter.next());
        }
        return result;
    }

    private static ResolutionReport getResolutionReport(Collection<Bundle> bundles) {
        BundleContext context = Activator.getBundleContext();
        DiagReportListener reportListener = new DiagReportListener(bundles);
        ServiceRegistration hookReg = context.registerService(ResolverHookFactory.class, (Object)reportListener, null);
        try {
            Bundle systemBundle = context.getBundle("System Bundle");
            FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            frameworkWiring.resolveBundles(bundles);
            ResolutionReport resolutionReport = reportListener.getReport();
            return resolutionReport;
        }
        finally {
            hookReg.unregister();
        }
    }

    private IStatus checkProfileRegistry() {
        IQueryResult results;
        IProfileRegistry registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            return VerifierApplication.createError("Profile registry service not available.");
        }
        IProfile profile = registry.getProfile("_SELF_");
        if (profile == null) {
            return VerifierApplication.createError("SELF profile not available in profile registry.");
        }
        if (this.properties.get("checkPresenceOfVerifier") != null && !Boolean.FALSE.toString().equals(this.properties.get("checkPresenceOfVerifier")) && (results = profile.query(QueryUtil.createIUQuery((String)"org.eclipse.equinox.p2.tests.verifier"), null)).isEmpty()) {
            return VerifierApplication.createError(NLS.bind((String)"IU for {0} not found in SELF profile.", (Object)"org.eclipse.equinox.p2.tests.verifier"));
        }
        return Status.OK_STATUS;
    }

    public IStatus verify() {
        String message = "Problems occurred during verification.";
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 0, message, null);
        IStatus temp = this.checkResolved();
        if (!temp.isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkProfileRegistry()).isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.hasProfileFlag()).isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkAbsenceOfBundles()).isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkPresenceOfBundles()).isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkSystemProperties()).isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkMigrationWizard()).isOK()) {
            result.merge(temp);
        }
        this.assumeMigrated();
        this.handleWizardCancellation();
        return result;
    }

    private void handleWizardCancellation() {
        if (this.properties.getProperty("checkMigration.cancelAnswer") == null) {
            return;
        }
        new Display();
        IProfileRegistry reg = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = reg.getProfile("_SELF_");
        MigrationWizard wizardPage = new MigrationWizard(profile, Collections.emptyList(), new URI[0], false);
        int cancelAnswer = Integer.parseInt(this.properties.getProperty("checkMigration.cancelAnswer"));
        wizardPage.rememberCancellationDecision(cancelAnswer);
    }

    private IStatus checkSystemProperties() {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 4, "System properties validation", null);
        Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String property;
            String key = (String)entry.getKey();
            if (key.startsWith("not.sysprop.") && System.getProperty(property = key.substring("not.sysprop.".length())) != null) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.tests.verifier", "Property " + property + " should not be set."));
            }
            if (!key.startsWith("sysprop.")) continue;
            property = key.substring("sysprop.".length());
            String foundValue = System.getProperty(property);
            if (entry.getValue().equals(foundValue)) continue;
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.tests.verifier", "Property " + property + " should be set to " + entry.getValue() + " and is set to " + foundValue + "."));
        }
        if (result.getChildren().length == 0) {
            return Status.OK_STATUS;
        }
        return result;
    }

    private IStatus checkAbsenceOfBundles() {
        String[] unexpectedBundles;
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 4, "Some bundles should not be there", null);
        String unexpectedBundlesString = this.properties.getProperty("unexpectedBundleList");
        if (unexpectedBundlesString == null) {
            return Status.OK_STATUS;
        }
        String[] stringArray = unexpectedBundles = unexpectedBundlesString.split(",");
        int n = unexpectedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bsn = stringArray[n2];
            if (this.containsBundle(bsn)) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.tests.verifier", String.valueOf(bsn) + " should not have been found in the install"));
            }
            ++n2;
        }
        if (result.getChildren().length == 0) {
            return Status.OK_STATUS;
        }
        return result;
    }

    private boolean containsBundle(final String bsn) {
        FrameworkWiring fWiring = (FrameworkWiring)Activator.getBundleContext().getBundle("System Bundle").adapt(FrameworkWiring.class);
        Collection existing = fWiring.findProviders(new Requirement(){

            public String getNamespace() {
                return "osgi.identity";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.identity=" + bsn + ")");
            }

            public Map<String, Object> getAttributes() {
                return Collections.EMPTY_MAP;
            }

            public Resource getResource() {
                return null;
            }
        });
        return !existing.isEmpty();
    }

    private IStatus checkPresenceOfBundles() {
        String[] expectedBundles;
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 4, "Some bundles should not be there", null);
        String expectedBundlesString = this.properties.getProperty("expectedBundleList");
        if (expectedBundlesString == null) {
            return Status.OK_STATUS;
        }
        String[] stringArray = expectedBundles = expectedBundlesString.split(",");
        int n = expectedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bsn = stringArray[n2];
            if (!this.containsBundle(bsn)) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.tests.verifier", String.valueOf(bsn) + " is missing from the install"));
            }
            ++n2;
        }
        if (result.getChildren().length == 0) {
            return Status.OK_STATUS;
        }
        return result;
    }

    private IStatus hasProfileFlag() {
        long[] history;
        long lastTimestamp;
        IProfile profile;
        String profileId;
        if (this.properties.getProperty("checkProfileResetFlag") == null || "false".equals(this.properties.getProperty("checkProfileResetFlag"))) {
            return Status.OK_STATUS;
        }
        IProfileRegistry reg = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        if ("new".equals(reg.getProfileStateProperties(profileId = (profile = reg.getProfile("_SELF_")).getProfileId(), lastTimestamp = (history = reg.listProfileTimestamps(profileId))[history.length - 1]).get("org.eclipse.equinox.p2.state.shared"))) {
            return Status.OK_STATUS;
        }
        if (history.length == 1) {
            return new Status(4, "org.eclipse.equinox.p2.tests.verifier", "The flag indicating that a profile has been reset is incorrectly setup");
        }
        long previousToLastTimestamp = history[history.length - 2];
        if ("new".equals(reg.getProfileStateProperties(profileId, previousToLastTimestamp).get("org.eclipse.equinox.p2.state.shared"))) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.equinox.p2.tests.verifier", "The flag indicating that a profile has been reset is incorrectly setup");
    }

    private IStatus checkMigrationWizard() {
        if (this.properties.getProperty("checkMigrationWizard") == null) {
            return Status.OK_STATUS;
        }
        IProfileRegistry reg = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = reg.getProfile("_SELF_");
        MigrationWizardTestHelper migrationSupport = new MigrationWizardTestHelper();
        migrationSupport.performMigration(this.agent, reg, profile);
        boolean wizardExpectedToOpen = Boolean.parseBoolean(this.properties.getProperty("checkMigrationWizard.open"));
        if (migrationSupport.wizardOpened == wizardExpectedToOpen) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.equinox.p2.tests.verifier", "The migration wizard did " + (wizardExpectedToOpen ? "not" : "") + " open");
    }

    private void assumeMigrated() {
        if (this.properties.getProperty("checkMigrationWizard.simulate.reinstall") == null) {
            return;
        }
        new MigrationWizardTestHelper().rememberMigrationCompleted();
    }

    private static class DiagReportListener
    implements ResolverHookFactory {
        private final Collection<BundleRevision> targetTriggers = new ArrayList<BundleRevision>();
        volatile ResolutionReport report = null;

        public DiagReportListener(Collection<Bundle> bundles) {
            for (Bundle bundle : bundles) {
                BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
                if (revision == null || revision.getWiring() != null) continue;
                this.targetTriggers.add(revision);
            }
        }

        public ResolverHook begin(Collection<BundleRevision> triggers) {
            if (triggers.containsAll(this.targetTriggers)) {
                return new DiagResolverHook();
            }
            return null;
        }

        ResolutionReport getReport() {
            return this.report;
        }

        class DiagResolverHook
        implements ResolverHook,
        ResolutionReport.Listener {
            DiagResolverHook() {
            }

            public void handleResolutionReport(ResolutionReport handleReport) {
                DiagReportListener.this.report = handleReport;
            }

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
            }

            public void end() {
            }
        }
    }
}

