/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.preferences.tests;

import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class EclipsePreferencesTest {
    @Test
    public void testConcurrentPreferenceChangeListener() throws InterruptedException, CoreException {
        final IEclipsePreferences node = EclipsePreferencesTest.createTestNode();
        EclipsePreferencesTest.executeInTwoThreads(new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IEclipsePreferences.IPreferenceChangeListener listener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    }
                };
                int i = 0;
                while (i < 100000 && !monitor.isCanceled()) {
                    node.addPreferenceChangeListener(listener);
                    node.put("x", "y");
                    node.remove("x");
                    node.removePreferenceChangeListener(listener);
                    ++i;
                }
            }
        });
    }

    @Test
    public void testConcurrentNodeChangeListener() throws InterruptedException, CoreException {
        final IEclipsePreferences node = EclipsePreferencesTest.createTestNode();
        EclipsePreferencesTest.executeInTwoThreads(new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IEclipsePreferences.INodeChangeListener listener = new IEclipsePreferences.INodeChangeListener(){

                    public void removed(IEclipsePreferences.NodeChangeEvent event) {
                    }

                    public void added(IEclipsePreferences.NodeChangeEvent event) {
                    }
                };
                int i = 0;
                while (i < 100000 && !monitor.isCanceled()) {
                    node.addNodeChangeListener(listener);
                    try {
                        node.node(Thread.currentThread().getName()).removeNode();
                    }
                    catch (BackingStoreException backingStoreException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.runtime", 0, "", null));
                    }
                    node.removeNodeChangeListener(listener);
                    ++i;
                }
            }
        });
    }

    private static void executeInTwoThreads(final ICoreRunnable runnable) throws InterruptedException, CoreException {
        final CountDownLatch latch = new CountDownLatch(1);
        Job job = Job.create((String)"", (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                latch.countDown();
                runnable.run(monitor);
            }
        });
        job.schedule();
        try {
            latch.await();
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            job.cancel();
            job.join();
            IStatus result = job.getResult();
            Assert.assertNotNull((String)"Job is expected to complete", (Object)result);
            if (!result.isOK()) {
                throw new CoreException(result);
            }
        }
    }

    @After
    public void after() throws BackingStoreException {
        EclipsePreferencesTest.getScopeRoot().removeNode();
    }

    private static String getUniqueString() {
        return String.valueOf(System.currentTimeMillis()) + "-" + Math.random();
    }

    private static IEclipsePreferences createTestNode() {
        return (IEclipsePreferences)EclipsePreferencesTest.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
    }

    private static IEclipsePreferences getScopeRoot() {
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("EclipsePreferencesTest");
    }
}

