/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSComponentTestCase
extends AbstractDSModelTestCase {
    public void testAddDefaultComponent() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSComponentTestCase.assertNotNull((Object)component);
        DSComponentTestCase.assertEquals((String)component.getName(), (String)"sample");
        DSComponentTestCase.assertEquals((String)component.getActivateMethod(), null);
        DSComponentTestCase.assertEquals((String)component.getDeactivateMethod(), null);
        DSComponentTestCase.assertEquals((String)component.getModifiedMethod(), null);
        DSComponentTestCase.assertTrue((boolean)component.getEnabled());
    }

    public void testAddComponentwithAllAttributes() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSComponentTestCase.assertNotNull((Object)component);
        DSComponentTestCase.assertEquals((String)component.getName(), (String)"sample");
        component.setEnabled(false);
        component.setAttributeName("NewName");
        component.setFactory("NewFactory");
        component.setImmediate(true);
        component.setActivateMethod("start");
        component.setDeactivateMethod("stop");
        component.setModifiedeMethod("modified");
        DSComponentTestCase.assertFalse((boolean)component.getEnabled());
        DSComponentTestCase.assertEquals((String)component.getAttributeName(), (String)"NewName");
        DSComponentTestCase.assertEquals((String)component.getFactory(), (String)"NewFactory");
        DSComponentTestCase.assertTrue((boolean)component.getImmediate());
        DSComponentTestCase.assertEquals((String)component.getActivateMethod(), (String)"start");
        DSComponentTestCase.assertEquals((String)component.getDeactivateMethod(), (String)"stop");
        DSComponentTestCase.assertEquals((String)component.getModifiedMethod(), (String)"modified");
    }

    public void testAddMoveRemoveChildrens() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSComponentTestCase.assertNotNull((Object)component);
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation implementation = factory.createImplementation();
        implementation.setClassName("ImplementationClassName");
        component.setImplementation(implementation);
        IDSProperties properties = factory.createProperties();
        properties.setEntry("PropertiesEntry");
        component.addPropertiesElement(properties);
        IDSProperty property = factory.createProperty();
        property.setPropertyElemBody("Body Values");
        property.setPropertyType("java.lang.String");
        component.addPropertyElement(property);
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        component.setService(service);
        IDSReference reference = factory.createReference();
        reference.setReferenceBind("methodBind");
        reference.setReferenceUnbind("methodUnBind");
        reference.setReferenceInterface("ReferenceInterface");
        reference.setReferenceName("ReferenceName");
        component.addReference(reference);
        IDocumentElementNode childAt4 = component.getChildAt(4);
        component.moveChildNode((IDocumentElementNode)reference, -1, true);
        IDocumentElementNode childAt3 = component.getChildAt(3);
        DSComponentTestCase.assertEquals((Object)childAt4, (Object)childAt3);
        DSComponentTestCase.assertTrue((component.getChildCount() == 5 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertiesElements().length == 1 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getService() != null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getReferences().length == 1 ? 1 : 0) != 0);
        component.removeReference(reference);
        DSComponentTestCase.assertTrue((component.getChildCount() == 4 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertiesElements().length == 1 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getService() != null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
        component.removeService(service);
        component.removePropertiesElement(properties);
        DSComponentTestCase.assertTrue((component.getChildCount() == 2 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertiesElements().length == 0 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getService() == null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
        component.removeChildNode((IDocumentElementNode)implementation);
        component.removePropertyElement(property);
        DSComponentTestCase.assertTrue((component.getChildCount() == 0 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getImplementation() == null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertyElements().length == 0 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getPropertiesElements().length == 0 ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getService() == null ? 1 : 0) != 0);
        DSComponentTestCase.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
    }
}

