/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import java.util.ArrayList;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSObjectTestCase
extends AbstractDSModelTestCase {
    public void testObject() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSObjectTestCase.assertNotNull((Object)component);
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation implementation = factory.createImplementation();
        implementation.setClassName("ImplementationClassName");
        component.setImplementation(implementation);
        IDSProperties properties = factory.createProperties();
        properties.setEntry("PropertiesEntry");
        component.addPropertiesElement(properties);
        IDSProperty property = factory.createProperty();
        property.setPropertyElemBody("Body Values");
        property.setPropertyType("java.lang.String");
        component.addPropertyElement(property);
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        component.setService(service);
        IDSReference reference = factory.createReference();
        reference.setReferenceBind("methodBind");
        reference.setReferenceUnbind("methodUnBind");
        reference.setReferenceInterface("ReferenceInterface");
        reference.setReferenceName("ReferenceName");
        component.addReference(reference);
        ArrayList children = component.getChildNodesList();
        DSObjectTestCase.assertTrue((children.size() == 5 ? 1 : 0) != 0);
        DSObjectTestCase.assertEquals((Object)component.getModel(), (Object)this.fModel);
        IDSObject child = (IDSObject)children.get(0);
        DSObjectTestCase.assertEquals((Object)child.getComponent(), (Object)component);
        DSObjectTestCase.assertEquals((Object)child.getParentNode(), (Object)component);
    }
}

