/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSReferenceTestCase
extends AbstractDSModelTestCase {
    public void testServiceReference() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSReferenceTestCase.assertNotNull((Object)component);
        IDSReference reference = this.fModel.getFactory().createReference();
        String name = "HTTP";
        String interfaceName = "org.osgi.service.http.HttpService";
        String cardinality = "0..n";
        String policy = "dynamic";
        String bind = "setPage";
        String unbind = "unsetPage";
        String target = "(component.factory=acme.application)";
        reference.setReferenceName(name);
        reference.setReferenceInterface(interfaceName);
        reference.setReferenceCardinality(cardinality);
        reference.setReferencePolicy(policy);
        reference.setReferenceBind(bind);
        reference.setReferenceUnbind(unbind);
        reference.setReferenceTarget(target);
        component.addReference(reference);
        IDSReference[] references = component.getReferences();
        DSReferenceTestCase.assertTrue((references.length == 1 ? 1 : 0) != 0);
        IDSReference reference0 = references[0];
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceName(), (String)name);
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceInterface(), (String)interfaceName);
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceCardinality(), (String)cardinality);
        DSReferenceTestCase.assertEquals((String)reference0.getReferencePolicy(), (String)policy);
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceBind(), (String)bind);
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceUnbind(), (String)unbind);
        DSReferenceTestCase.assertEquals((String)reference0.getName(), (String)name);
    }

    public void testDefaultServiceReference() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSReferenceTestCase.assertNotNull((Object)component);
        IDSReference reference = this.fModel.getFactory().createReference();
        component.addReference(reference);
        IDSReference[] references = component.getReferences();
        DSReferenceTestCase.assertTrue((references.length == 1 ? 1 : 0) != 0);
        IDSReference reference0 = references[0];
        String defautCardinality = "1..1";
        String defaultPolicy = "static";
        DSReferenceTestCase.assertEquals((String)reference0.getReferenceCardinality(), (String)defautCardinality);
        DSReferenceTestCase.assertEquals((String)reference0.getReferencePolicy(), (String)defaultPolicy);
    }
}

