/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browser.demos;

public class Pawns {
    byte[] game = new byte[64];
    int bestIndex = -1;
    int bestScore = Integer.MIN_VALUE;
    static int[] gameWallWeight = new int[64];
    Thread thread = null;
    boolean threadStop = false;
    static final byte EMPTY = 0;
    static final byte WHITE = 1;
    static final byte BLACK = 2;
    static final byte WALL = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playRequest(byte[][] game, int type) {
        this.threadStop = true;
        Pawns pawns = this;
        synchronized (pawns) {
            this.bestIndex = -1;
            this.bestScore = Integer.MIN_VALUE;
            Pawns.convert(game, this.game);
            Pawns.initPawnBorders(this.game, gameWallWeight);
            int i = 0;
            while (i < this.game.length) {
                if (this.game[i] == 0) {
                    this.bestIndex = i;
                    break;
                }
                ++i;
            }
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Pawns pawns = Pawns.this;
                    synchronized (pawns) {
                        Pawns.this.threadStop = false;
                        int[] result = new int[2];
                        Pawns.evalBest(Pawns.this.game, (byte)2, 2, result);
                        Pawns.this.bestIndex = result[0];
                        Pawns.this.bestScore = result[1];
                    }
                }
            }.start();
        }
    }

    public void getBestMove(int[] point) {
        Pawns.convert(this.bestIndex, point);
        this.threadStop = true;
    }

    static void convert(byte[][] board, byte[] g) {
        int i = 0;
        while (i < board.length) {
            System.arraycopy(board[i], 0, g, i * 8, 8);
            ++i;
        }
    }

    static void set(byte[] g, int x, int y, byte type) {
        g[x * 8 + y] = type;
    }

    static void convert(int index, int[] point) {
        point[0] = index / 8;
        point[1] = index % 8;
    }

    static int getNeighbourIndex(byte[] g, int index, int neighbour) {
        if (index < 0 || index >= g.length) {
            return -1;
        }
        int result = -1;
        switch (neighbour) {
            case 0: {
                result = index < 8 || index % 8 == 0 ? -1 : index - 9;
                break;
            }
            case 1: {
                result = index < 8 ? -1 : index - 8;
                break;
            }
            case 2: {
                result = index < 8 || index % 8 == 7 ? -1 : index - 7;
                break;
            }
            case 3: {
                result = index % 8 == 0 ? -1 : index - 1;
                break;
            }
            case 4: {
                result = index % 8 == 7 ? -1 : index + 1;
                break;
            }
            case 5: {
                result = index % 8 == 0 || index >= 56 ? -1 : index + 7;
                break;
            }
            case 6: {
                result = index >= 56 ? -1 : index + 8;
                break;
            }
            case 7: {
                result = index % 8 == 7 || index >= 56 ? -1 : index + 9;
            }
        }
        return result;
    }

    static void play(byte[] g, int index, byte type) {
        byte opponentType = type == 1 ? (byte)2 : 1;
        int neighbour = 0;
        while (neighbour <= 7) {
            int nIndex = Pawns.getNeighbourIndex(g, index, neighbour);
            int[] reversiIndeces = new int[6];
            int nReversi = 0;
            while (nIndex != -1 && nReversi < 6 && g[nIndex] == opponentType) {
                reversiIndeces[nReversi] = nIndex;
                ++nReversi;
                nIndex = Pawns.getNeighbourIndex(g, nIndex, neighbour);
            }
            if (nReversi > 0 && nIndex != -1 && g[nIndex] == type) {
                int i = 0;
                while (i < nReversi) {
                    g[reversiIndeces[i]] = type;
                    ++i;
                }
            }
            ++neighbour;
        }
        g[index] = type;
    }

    static int eval(byte[] g) {
        int cntWhite = 0;
        int cntBlack = 0;
        int cntEmpty = 0;
        int cntWhiteWallAdvantage = 0;
        int cntBlackWallAdvantage = 0;
        int i = 0;
        while (i < 64) {
            if (g[i] == 1) {
                ++cntWhite;
                cntWhiteWallAdvantage += gameWallWeight[i];
            } else if (g[i] == 2) {
                ++cntBlack;
                cntBlackWallAdvantage += gameWallWeight[i];
            } else if (g[i] == 0) {
                ++cntEmpty;
            }
            ++i;
        }
        if (cntEmpty == 0) {
            if (cntWhite > cntBlack) {
                return Integer.MAX_VALUE;
            }
            if (cntWhite < cntBlack) {
                return Integer.MIN_VALUE;
            }
            return 0;
        }
        return cntWhite + cntWhiteWallAdvantage - cntBlack - cntBlackWallAdvantage;
    }

    static void initPawnBorders(byte[] g, int[] gameWallWeight) {
        int[] nTypes = new int[8];
        int i = 0;
        while (i < 64) {
            int nWalls = 0;
            int nAxis = 0;
            int n = 0;
            while (n < 8) {
                int nIndex = Pawns.getNeighbourIndex(g, i, n);
                int n2 = nTypes[n] = nIndex != -1 ? g[nIndex] : 3;
                if (nTypes[n] == 3) {
                    ++nWalls;
                }
                ++n;
            }
            int score = nWalls;
            if (nWalls > 0) {
                if (nTypes[0] == 3 || nTypes[7] == 3) {
                    ++nAxis;
                }
                if (nTypes[1] == 3 || nTypes[6] == 3) {
                    ++nAxis;
                }
                if (nTypes[2] == 3 || nTypes[5] == 3) {
                    ++nAxis;
                }
                if (nTypes[4] == 3 || nTypes[3] == 3) {
                    ++nAxis;
                }
                block0 : switch (nAxis) {
                    case 4: {
                        switch (nWalls) {
                            case 4: {
                                score = 16;
                                break;
                            }
                            case 5: {
                                score = 14;
                                break;
                            }
                            case 6: {
                                score = 9;
                            }
                            case 7: {
                                score = 6;
                                break;
                            }
                            case 8: {
                                score = 0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (nWalls) {
                            case 3: {
                                score = 9;
                                break;
                            }
                            case 4: {
                                score = 8;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (nWalls) {
                            case 2: {
                                score = 6;
                                break;
                            }
                            case 3: {
                                score = 4;
                                break;
                            }
                            case 4: {
                                score = 2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (nWalls) {
                            case 1: {
                                score = 2;
                                break block0;
                            }
                            case 2: {
                                score = 1;
                            }
                        }
                    }
                }
            }
            gameWallWeight[i] = score;
            ++i;
        }
    }

    static void evalBest(byte[] g, byte type, int depth, int[] result) {
        byte[] tmp = new byte[64];
        byte opponentType = type == 1 ? (byte)2 : 1;
        result[0] = -1;
        result[1] = Integer.MIN_VALUE;
        int i = 0;
        while (i < 64) {
            if (g[i] == 0) {
                System.arraycopy(g, 0, tmp, 0, 64);
                Pawns.play(tmp, i, type);
                int score = Pawns.eval(tmp);
                if (depth > 1) {
                    int[] tmpResult = new int[2];
                    Pawns.evalBest(tmp, opponentType, depth - 1, tmpResult);
                    score = tmpResult[1];
                }
                if (type == 1 && score > result[1] || type == 2 && score < result[1] || result[0] == -1) {
                    result[0] = i;
                    result[1] = score;
                }
            }
            ++i;
        }
    }
}

