/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;

class ItemDescriptor {
    private String id;
    private String name;
    private String description;
    private Image icon;
    private String view;
    private String mainType;
    private String pluginId;
    private IConfigurationElement element;

    public ItemDescriptor(String id, String name, String description, Image icon, String view, String mainType, String pluginId, IConfigurationElement element) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.view = view;
        this.mainType = mainType;
        this.pluginId = pluginId;
        this.element = element;
    }

    public Object createItemInstance() throws CoreException {
        if (this.element == null) {
            return null;
        }
        return this.element.createExecutableExtension("mainClass");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getView() {
        return this.view;
    }

    public String getMainType() {
        return this.mainType;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public boolean isFolder() {
        return this.mainType == null && this.view == null;
    }

    public boolean equals(Object other) {
        if (other instanceof ItemDescriptor) {
            ItemDescriptor otherDescriptor = (ItemDescriptor)other;
            return this.getId().equalsIgnoreCase(otherDescriptor.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.toUpperCase().hashCode();
    }
}

