/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SplitLayout
extends Layout {
    private static final int splitHorizontally = 0;
    private static final int splitVertically = 1;
    private int splitDirection = 0;
    public int spacing = 3;
    public int marginTop = 3;
    public int marginLeft = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint == -1) {
            if (hHint == -1) {
                Point hSplitSize = this.computeHSplitSize(composite, wHint, hHint, flushCache);
                Point vSplitSize = this.computeVSplitSize(composite, wHint, hHint, false);
                int hSplitArea = hSplitSize.x * hSplitSize.y;
                int vSplitArea = vSplitSize.x * vSplitSize.y;
                if (hSplitArea < vSplitArea) {
                    this.splitDirection = 0;
                    return hSplitSize;
                }
                this.splitDirection = 1;
                return vSplitSize;
            }
            this.splitDirection = 1;
            return this.computeVSplitSize(composite, wHint, hHint, flushCache);
        }
        if (hHint == -1) {
            this.splitDirection = 0;
            return this.computeHSplitSize(composite, wHint, hHint, flushCache);
        }
        if (hHint < wHint) {
            this.splitDirection = 1;
            return this.computeVSplitSize(composite, wHint, hHint, flushCache);
        }
        this.splitDirection = 0;
        return this.computeHSplitSize(composite, wHint, hHint, flushCache);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        this.computeSize(composite, clientArea.width, clientArea.height, false);
        Control[] children = composite.getChildren();
        clientArea.x += this.marginLeft;
        clientArea.y += this.marginTop;
        clientArea.width -= this.marginRight + this.marginLeft;
        clientArea.height -= this.marginBottom + this.marginTop;
        Point position = new Point(clientArea.x, clientArea.y);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle bounds;
            Control child = controlArray[n2];
            if (this.splitDirection == 0) {
                int height = clientArea.height / children.length;
                bounds = new Rectangle(position.x, position.y, clientArea.width, height);
                position.y += height + this.spacing;
            } else {
                int width = clientArea.width / children.length;
                bounds = new Rectangle(position.x, position.y, width, clientArea.height);
                position.x += width + this.spacing;
            }
            bounds.width = Math.max(bounds.width, 0);
            bounds.height = Math.max(bounds.height, 0);
            child.setBounds(bounds);
            ++n2;
        }
    }

    private Point computeHSplitSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children;
        Point size = new Point(this.marginLeft + this.marginRight, this.marginTop + this.marginBottom);
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point childSize = child.computeSize(wHint, hHint, flushCache);
            size.x = Math.max(size.x, childSize.x);
            size.y += childSize.y + this.spacing;
            ++n2;
        }
        return size;
    }

    private Point computeVSplitSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children;
        Point size = new Point(this.marginLeft + this.marginRight, this.marginTop + this.marginBottom);
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point childSize = child.computeSize(wHint, hHint, flushCache);
            size.x += childSize.x + this.spacing;
            size.y = Math.max(size.y, childSize.y);
            ++n2;
        }
        return size;
    }
}

