/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class Test_org_eclipse_swt_browser_Browser
extends Test_org_eclipse_swt_widgets_Composite {
    boolean debug_show_browser = false;
    int debug_show_browser_timeout_seconds = 2;
    boolean debug_verbose_output = false;
    int secondsToWaitTillFail;
    @Rule
    public TestName name = new TestName();
    Browser browser;
    boolean isWebkit1 = false;
    boolean isWebkit2 = false;
    static int[] webkitGtkVersionInts = new int[3];
    StringBuilder testLog;
    ProgressListener callCustomFunctionUponLoad = ProgressListener.completedAdapter(event -> {
        boolean bl = this.browser.execute("callCustomFunction()");
    });

    private void testLogAppend(String msg) {
        this.testLog.append("  " + msg + "\n");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.secondsToWaitTillFail = Math.max(15, this.debug_show_browser_timeout_seconds);
        System.out.println("Running Test_org_eclipse_swt_browser_Browser#" + this.name.getMethodName());
        this.shell.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this.shell, 0);
        String shellTitle = this.name.getMethodName();
        if (SwtTestUtil.isGTK && this.browser.getBrowserType().equals("webkit")) {
            String webkitGtkVersionStr = System.getProperty("org.eclipse.swt.internal.webkitgtk.version");
            shellTitle = String.valueOf(shellTitle) + " Webkit version: " + webkitGtkVersionStr;
            String[] webkitGtkVersionStrParts = webkitGtkVersionStr.split("\\.");
            int i = 0;
            while (i < 3) {
                Test_org_eclipse_swt_browser_Browser.webkitGtkVersionInts[i] = Integer.parseInt(webkitGtkVersionStrParts[i]);
                ++i;
            }
            if (webkitGtkVersionInts[0] == 1 || webkitGtkVersionInts[0] == 2 && webkitGtkVersionInts[1] <= 4) {
                this.isWebkit1 = true;
            } else if (webkitGtkVersionInts[0] == 2 && webkitGtkVersionInts[1] > 4) {
                this.isWebkit2 = true;
            }
        }
        this.shell.setText(shellTitle);
        this.setWidget((Widget)this.browser);
        this.testLog = new StringBuilder("\nTest log:\n");
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        Browser browser = new Browser((Composite)this.shell, 0);
        browser.dispose();
        browser = new Browser((Composite)this.shell, 2048);
        browser.dispose();
        browser = new Browser(null, 0);
    }

    @Test
    public void test_evalute_Cookies() {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("http://www.eclipse.org/swt");
        this.waitForPassCondition(loaded::get);
        this.browser.evaluate("document.cookie = \"cookie1=value1\";");
        this.browser.evaluate("document.cookie = \"cookie2=value2\";");
        String res = (String)this.browser.evaluate("return document.cookie;");
        Assert.assertTrue((!res.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void test_ClearAllSessionCookies() {
        String e2;
        String e1;
        String v2;
        String v1;
        if (this.isWebkit2) {
            Assume.assumeTrue((webkitGtkVersionInts[1] >= 16 ? 1 : 0) != 0);
        }
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("http://www.eclipse.org/swt");
        this.waitForPassCondition(loaded::get);
        if (this.isWebkit2) {
            this.browser.evaluate("document.cookie = \"cookie1=value1\";");
            this.browser.evaluate("document.cookie = \"cookie2=value2\";");
        } else {
            Browser.setCookie((String)"cookie1=value1", (String)"http://www.eclipse.org/swt");
            Browser.setCookie((String)"cookie2=value2", (String)"http://www.eclipse.org/swt");
        }
        if (this.isWebkit2) {
            v1 = (String)this.browser.evaluate(this.toCookieEvalString("cookie1"));
            v2 = (String)this.browser.evaluate(this.toCookieEvalString("cookie2"));
        } else {
            v1 = Browser.getCookie((String)"cookie1", (String)"http://www.eclipse.org/swt");
            v2 = Browser.getCookie((String)"cookie2", (String)"http://www.eclipse.org/swt");
        }
        Assert.assertEquals((Object)"value1", (Object)v1);
        Assert.assertEquals((Object)"value2", (Object)v2);
        Browser.clearSessions();
        if (this.isWebkit2) {
            e1 = (String)this.browser.evaluate(this.toCookieEvalString("cookie1"));
            e2 = (String)this.browser.evaluate(this.toCookieEvalString("cookie2"));
        } else {
            e1 = Browser.getCookie((String)"cookie1", (String)"http://www.eclipse.org/swt");
            e2 = Browser.getCookie((String)"cookie2", (String)"http://www.eclipse.org/swt");
        }
        Assert.assertTrue((e1 == null || e1.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((e2 == null || e2.isEmpty() ? 1 : 0) != 0);
    }

    private String toCookieEvalString(String key) {
        return "var name = \"" + key + "=\";\n" + "    var decodedCookie = decodeURIComponent(document.cookie);\n" + "    var ca = decodedCookie.split(';');\n" + "    for(var i = 0; i < ca.length; i++) {\n" + "        var c = ca[i];\n" + "        while (c.charAt(0) == ' ') {\n" + "            c = c.substring(1);\n" + "        }\n" + "        if (c.indexOf(name) == 0) {\n" + "            return c.substring(name.length, c.length);\n" + "        }\n" + "    }\n" + "    return \"\";";
    }

    @Test
    public void test_get_set_Cookies() {
        Assume.assumeFalse((String)"Not implemented on webkit2 yet. Bug 522181.", (boolean)this.isWebkit2);
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("http://www.eclipse.org/swt");
        this.waitForPassCondition(loaded::get);
        Browser.setCookie((String)"cookie1=value1", (String)"http://www.eclipse.org/swt");
        Browser.setCookie((String)"cookie2=value2", (String)"http://www.eclipse.org/swt");
        String v1 = Browser.getCookie((String)"cookie1", (String)"http://www.eclipse.org/swt");
        Assert.assertEquals((Object)"value1", (Object)v1);
        String v2 = Browser.getCookie((String)"cookie2", (String)"http://www.eclipse.org/swt");
        Assert.assertEquals((Object)"value2", (Object)v2);
    }

    @Override
    @Test
    public void test_getChildren() {
        if (SwtTestUtil.isWindows) {
            int childCount = this.composite.getChildren().length;
            String msg = "Browser on Win32 is a special case, the first child is an OleFrame (ActiveX control). Actual child count is: " + childCount;
            Assert.assertTrue((String)msg, (childCount == 1 ? 1 : 0) != 0);
        } else {
            super.test_getChildren();
        }
    }

    @Test
    public void test_CloseWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addCloseWindowListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_CloseWindowListener_addWithNullArg() {
        this.browser.addCloseWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_CloseWindowListener_removeWithNullArg() {
        this.browser.removeCloseWindowListener(null);
    }

    @Test
    public void test_CloseWindowListener_addAndRemove() {
        CloseWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addCloseWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeCloseWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_CloseWindowListener_close() {
        AtomicBoolean browserCloseListenerFired = new AtomicBoolean(false);
        this.browser.addCloseWindowListener(e -> {
            this.disposedIntentionally = true;
            browserCloseListenerFired.set(true);
        });
        this.browser.setText("<script language='JavaScript'>window.close()</script>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(browserCloseListenerFired::get);
        Assert.assertTrue((String)"Test timed out.", (boolean)passed);
    }

    @Test
    public void test_LocationListener_adapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        LocationAdapter adapter = new LocationAdapter(){};
        browser.addLocationListener((LocationListener)adapter);
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_LocationListener_addWithNullArg() {
        this.browser.addLocationListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_LocationListener_removeWithNullArg() {
        this.browser.removeLocationListener(null);
    }

    @Test
    public void test_LocationListener_addAndRemove() {
        LocationListener listener = new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addLocationListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeLocationListener(listener);
            ++i;
        }
    }

    @Test
    public void test_LocationListener_changing() {
        AtomicBoolean changingFired = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changingAdapter(e -> changingFired.set(true)));
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(changingFired::get);
        Assert.assertTrue((String)"LocationListener.changing() event was never fixed", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changed() {
        AtomicBoolean changedFired = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> changedFired.set(true)));
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(changedFired::get);
        Assert.assertTrue((String)"LocationListener.changing() event was never fixed", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changingAndOnlyThenChanged() {
        final AtomicBoolean changingFired = new AtomicBoolean(false);
        final AtomicBoolean changedFired = new AtomicBoolean(false);
        final AtomicBoolean changedFiredTooEarly = new AtomicBoolean(false);
        final AtomicBoolean finished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                changingFired.set(true);
            }

            public void changed(LocationEvent event) {
                if (!changingFired.get()) {
                    changedFiredTooEarly.set(true);
                }
                changedFired.set(true);
                finished.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(finished::get);
        if (finished.get() && changingFired.get() && changedFired.get() && !changedFiredTooEarly.get()) {
            return;
        }
        if (!finished.get()) {
            Assert.fail((String)"Test timed out. 'changed()' never fired");
        } else if (changedFiredTooEarly.get()) {
            Assert.fail((String)"changed() was fired before changing(). Wrong signal order");
        } else if (!changingFired.get()) {
            Assert.fail((String)"changing() was never fired");
        } else {
            Assert.fail((String)("LocationListener test failed. changing():" + changingFired.get() + "  changed():" + changedFired.get() + " changedFiredTooEarly:" + changedFiredTooEarly.get()));
        }
    }

    @Test
    public void test_LocationListener_then_ProgressListener() {
        AtomicBoolean locationChanged = new AtomicBoolean(false);
        AtomicBoolean progressChanged = new AtomicBoolean(false);
        AtomicBoolean progressChangedAfterLocationChanged = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changedAdapter(event -> locationChanged.set(true)));
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (locationChanged.get()) {
                progressChangedAfterLocationChanged.set(true);
            }
            progressChanged.set(true);
        }));
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(progressChanged::get);
        String errorMsg = "\nUnexpected listener states. Expecting true for all, but have:\nLocation changed: " + locationChanged.get() + "\n" + "ProgressChangedAfterLocationChanged: " + progressChangedAfterLocationChanged.get() + "\n" + "progressChanged: " + progressChanged.get();
        Assert.assertTrue((String)errorMsg, (boolean)progressChangedAfterLocationChanged.get());
    }

    @Test
    public void test_LocationListener_ProgressListener_cancledLoad() {
        final AtomicBoolean locationChanging = new AtomicBoolean(false);
        final AtomicBoolean unexpectedLocationChanged = new AtomicBoolean(false);
        AtomicBoolean unexpectedProgressCompleted = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                event.doit = false;
                locationChanging.set(true);
            }

            public void changed(LocationEvent event) {
                if (event.location.length() != 0) {
                    unexpectedLocationChanged.set(true);
                }
            }
        });
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String location = this.browser.getUrl();
            if (location.length() != 0) {
                unexpectedProgressCompleted.set(true);
            }
        }));
        this.shell.open();
        this.browser.setText("You should not see this message.");
        this.waitForMilliseconds(1000);
        boolean passed = locationChanging.get() && !unexpectedLocationChanged.get() && !unexpectedProgressCompleted.get();
        String errMsg = "\nUnexpected event fired. \nLocationChanging (should be true): " + locationChanging.get() + "\n" + "LocationChanged unexpectedly (should be false): " + unexpectedLocationChanged.get() + "\n" + "ProgressChanged unexpectedly (should be false): " + unexpectedProgressCompleted.get() + "\n";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_LocationListener_ProgressListener_noExtraEvents() {
        AtomicInteger changedCount = new AtomicInteger(0);
        AtomicInteger completedCount = new AtomicInteger(0);
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> {
            int n = changedCount.incrementAndGet();
        }));
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> {
            int n = completedCount.incrementAndGet();
        }));
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForMilliseconds(600);
        boolean passed = changedCount.get() == 1 && completedCount.get() == 1;
        String errorMsg = "\nIncorrect event sequences. Events missing or too many fired:\nExpected one of each, but received:\nChanged count: " + changedCount.get() + "\nCompleted count: " + completedCount.get();
        Assert.assertTrue((String)errorMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addOpenWindowListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_OpenWindowListener_addWithNulArg() {
        this.browser.addOpenWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_OpenWindowListener_removeWithNullArg() {
        this.browser.removeOpenWindowListener(null);
    }

    @Test
    public void test_OpenWindowListener_addAndRemove() {
        OpenWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addOpenWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeOpenWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_OpenWindowListener_openHasValidEventDetails() {
        AtomicBoolean openFiredCorrectly = new AtomicBoolean(false);
        Browser browserChild = new Browser((Composite)this.shell, 0);
        this.browser.addOpenWindowListener(event -> {
            Assert.assertTrue((String)"Expected Browser1 instance, but have another instance", ((Browser)event.widget == this.browser ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expected event.browser to be null", (event.browser == null ? 1 : 0) != 0);
            openFiredCorrectly.set(true);
            event.browser = browserChild;
        });
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>window.open()</script>\n<body>This test uses javascript to open a new window.</body></html>");
        boolean passed = this.waitForPassCondition(openFiredCorrectly::get);
        Assert.assertTrue((String)"Test timed out. OpenWindow event not fired.", (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_open_ChildPopup() {
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        Shell childShell = new Shell(this.shell, 0);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        Browser browserChild = new Browser((Composite)childShell, 0);
        this.browser.addOpenWindowListener(event -> {
            event.browser = browserChild;
        });
        browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event -> {
            childShell.open();
            browserChild.setText("Child Browser");
        }));
        browserChild.addProgressListener(ProgressListener.completedAdapter(event -> childCompleted.set(true)));
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>var newWin = window.open();</script>\n<body>This test uses javascript to open a new window.</body></html>");
        boolean passed = this.waitForPassCondition(childCompleted::get);
        String errMsg = "\nTest timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindow_Progress_Listener_ValidateEventOrder() {
        AtomicBoolean windowOpenFired = new AtomicBoolean(false);
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        AtomicBoolean visibilityShowed = new AtomicBoolean(false);
        Shell childShell = new Shell(this.shell, 0);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        Browser browserChild = new Browser((Composite)childShell, 0);
        this.browser.addOpenWindowListener(event -> {
            event.browser = browserChild;
            Assert.assertFalse((String)"OpenWindowListenr should have been fired first", (visibilityShowed.get() || childCompleted.get() ? 1 : 0) != 0);
            windowOpenFired.set(true);
        });
        browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event -> {
            childShell.open();
            Assert.assertTrue((String)"Child Visibility.show should have fired before progress completed", (windowOpenFired.get() && !childCompleted.get() ? 1 : 0) != 0);
            visibilityShowed.set(true);
        }));
        browserChild.addProgressListener(ProgressListener.completedAdapter(event -> {
            Assert.assertTrue((String)"Child's Progress Completed before parent's expected events", (windowOpenFired.get() && visibilityShowed.get() ? 1 : 0) != 0);
            childCompleted.set(true);
            browserChild.setText("Child Browser!");
        }));
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>var newWin = window.open();</script>\n<body>This test uses javascript to open a new window.</body></html>");
        boolean passed = this.waitForPassCondition(() -> windowOpenFired.get() && visibilityShowed.get() && childCompleted.get());
        String errMsg = "\nTest timed out.\nExpected true for the below, but have:\nWindoOpenFired:" + windowOpenFired.get() + "\nVisibilityShowed:" + visibilityShowed.get() + "\nChildCompleted:" + childCompleted.get();
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_ProgressListener_newProgressAdapter() {
        new ProgressAdapter(){};
    }

    @Test
    public void test_ProgressListener_newProgressAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addProgressListener((ProgressListener)new ProgressAdapter(){});
        shell.close();
    }

    @Test
    public void test_ProgressListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        });
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ProgressListener_addWithNullArg() {
        this.browser.addProgressListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ProgressListener_removeWithNullArg() {
        this.browser.removeProgressListener(null);
    }

    @Test
    public void test_ProgressListener_addAndRemove() {
        ProgressListener listener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addProgressListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeProgressListener(listener);
            ++i;
        }
    }

    @Test
    public void test_ProgressListener_completed_Called() {
        final AtomicBoolean childCompleted = new AtomicBoolean(false);
        ProgressListener l = new ProgressListener(){

            public void completed(ProgressEvent event) {
                childCompleted.set(true);
            }

            public void changed(ProgressEvent event) {
            }
        };
        this.browser.addProgressListener(l);
        this.browser.setText("<html><body>This test ensures that the completed listener is called.</body></html>");
        boolean passed = this.waitForPassCondition(childCompleted::get);
        Assert.assertTrue((boolean)passed);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_StatusTextListener_addWithNull() {
        this.browser.addStatusTextListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_StatusTextListener_removeWithNullArg() {
        this.browser.removeStatusTextListener(null);
    }

    @Test
    public void test_StatusTextListener_addAndRemove() {
        StatusTextListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addStatusTextListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeStatusTextListener(listener);
            ++i;
        }
    }

    @Test
    public void test_StatusTextListener_hoverMouseOverLink() {
        AtomicBoolean statusChanged = new AtomicBoolean(false);
        int size = 500;
        Browser browser = new Browser((Composite)this.shell, 0);
        StringBuilder longhtml = new StringBuilder();
        int i = 0;
        while (i < 200) {
            longhtml.append("text text text text text text text text text text text text text text text text text text text text text text text text<br>");
            ++i;
        }
        browser.setText("<a href='http://localhost'>" + longhtml + "</a>");
        this.shell.setLocation(0, 0);
        this.shell.setSize(size, size);
        browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Display display = event.display;
            Point cachedLocation = display.getCursorLocation();
            display.setCursorLocation(20, 10);
            browser.getBounds();
            int i = 0;
            while (i < size) {
                display.setCursorLocation(i, i);
                this.waitForMilliseconds(this.debug_show_browser ? 3 : 1);
                i += 5;
            }
            display.setCursorLocation(cachedLocation);
        }));
        browser.addStatusTextListener(event -> statusChanged.set(true));
        this.shell.open();
        boolean passed = this.waitForPassCondition(statusChanged::get);
        String msg = "Mouse movent over text was suppose to trigger StatusTextListener. But it didn't";
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_TitleListener_addListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addTitleListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TitleListener_addwithNull() {
        this.browser.addTitleListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TitleListener_removeWithNullArg() {
        this.browser.removeTitleListener(null);
    }

    @Test
    public void test_TitleListener_addAndRemove() {
        TitleListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addTitleListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeTitleListener(listener);
            ++i;
        }
    }

    @Test
    public void test_TitleListener_event() {
        AtomicBoolean titleListenerFired = new AtomicBoolean(false);
        this.browser.addTitleListener(event -> titleListenerFired.set(true));
        this.browser.setText("<html><title>Hello world</title><body>Page with a title</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(titleListenerFired::get);
        String errMsg = "Title listener never fired. Test timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_setText() {
        String expectedTitle = "Website Title";
        Runnable browserSetFunc = () -> {
            String html = "<html><title>Website Title</title><body>Html page with custom title</body></html>";
            boolean opSuccess = this.browser.setText(html);
            Assert.assertTrue((String)"Expecting setText() to return true", (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setUrl_local() {
        String expectedTitle = "Website Title";
        Runnable browserSetFunc = () -> {
            String pluginPath = System.getProperty("PLUGIN_PATH");
            this.testLogAppend("PLUGIN_PATH: " + pluginPath);
            String url = pluginPath != null ? String.valueOf(pluginPath) + "/data/testWebsiteWithTitle.html" : Test_org_eclipse_swt_browser_Browser.class.getClassLoader().getResource("testWebsiteWithTitle.html").toString();
            this.testLogAppend("URL: " + url);
            boolean opSuccess = this.browser.setUrl(url);
            Assert.assertTrue((String)("Expecting setUrl() to return true" + this.testLog.toString()), (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setUrl_remote() {
        this.secondsToWaitTillFail = 35;
        String url = "http://example.com";
        Assume.assumeTrue((String)"Skipping test due to bad internet connection", (boolean)Test_org_eclipse_swt_browser_Browser.checkInternet(url));
        this.testLog.append("checkInternet() passed");
        String expectedTitle = "Example Domain";
        Runnable browserSetFunc = () -> {
            this.testLog.append("Setting Browser url to:" + url);
            boolean opSuccess = this.browser.setUrl(url);
            Assert.assertTrue((String)"Expecting setUrl() to return true", (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setUrl_remote_with_post() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        this.secondsToWaitTillFail = 35;
        String url = "https://bugs.eclipse.org/bugs/buglist.cgi";
        Assume.assumeTrue((String)"Skipping test due to bad internet connection", (boolean)Test_org_eclipse_swt_browser_Browser.checkInternet(url));
        this.testLog.append("checkInternet() passed");
        Runnable browserSetFunc = () -> {
            this.testLog.append("Setting Browser url to:" + url);
            boolean opSuccess = this.browser.setUrl(url, "bug_severity=enhancement&bug_status=NEW&email1=rgrunber&emailassigned_to1=1&emailtype1=substring", null);
            Assert.assertTrue((String)"Expecting setUrl() to return true", (boolean)opSuccess);
        };
        AtomicReference<Boolean> completed = new AtomicReference<Boolean>(new Boolean(false));
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            this.testLog.append("ProgressListener fired");
            completed.set(true);
        }));
        browserSetFunc.run();
        this.shell.open();
        boolean hasFinished = this.waitForPassCondition(() -> (boolean)((Boolean)completed.get()));
        Assert.assertTrue((String)("Test timed out. ProgressListener not fired " + this.testLog.toString()), (boolean)hasFinished);
        int numChars = this.browser.getText().length();
        Assert.assertTrue((String)("Response data contained " + numChars + " chars."), (numChars > 10000 ? 1 : 0) != 0);
    }

    private void validateTitleChanged(String expectedTitle, Runnable browserSetFunc) {
        AtomicReference<String> actualTitle = new AtomicReference<String>("");
        this.browser.addTitleListener(event -> {
            this.testLog.append("TitleListener fired");
            Assert.assertTrue((String)("event title is empty" + this.testLog.toString()), (event.title != null ? 1 : 0) != 0);
            actualTitle.set(event.title);
        });
        browserSetFunc.run();
        this.shell.open();
        boolean hasFinished = this.waitForPassCondition(() -> ((String)actualTitle.get()).length() != 0 && !((String)actualTitle.get()).contains("about:blank"));
        boolean passed = hasFinished && actualTitle.get().equals(expectedTitle);
        String errMsg = "";
        if (!hasFinished) {
            errMsg = "Test timed out. TitleListener not fired";
        } else if (!actualTitle.get().equals(expectedTitle)) {
            errMsg = "\nExpected title and actual title do not match.\nExpected: " + expectedTitle + "\nActual: " + actualTitle;
        }
        Assert.assertTrue((String)(String.valueOf(errMsg) + this.testLog.toString()), (boolean)passed);
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter() {
        new VisibilityWindowAdapter(){};
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){});
        shell.close();
    }

    @Test
    public void test_VisibilityWindowListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        });
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_VisibilityWindowListener_addWithNull() {
        this.browser.addVisibilityWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_VisibilityWindowListener_removeWithNullArg() {
        this.browser.removeVisibilityWindowListener(null);
    }

    @Test
    public void test_VisibilityWindowListener_addAndRemove() {
        VisibilityWindowListener listener = new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addVisibilityWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeVisibilityWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_VisibilityWindowListener_multiple_shells() {
        final AtomicBoolean secondChildCompleted = new AtomicBoolean(false);
        AtomicInteger childCount = new AtomicInteger(0);
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild;
            Shell childShell = new Shell(this.shell);
            childShell.setText("Child shell " + childCount.get());
            childShell.setLayout((Layout)new FillLayout());
            event.browser = browserChild = new Browser((Composite)childShell, 0);
            browserChild.setText("Child window");
            browserChild.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(childCount){
                AtomicInteger invocationCount = new AtomicInteger(1);
                AtomicInteger childID;
                {
                    this.childID = new AtomicInteger(atomicInteger.get());
                }

                public void show(WindowEvent event) {
                    if (this.childID.get() == 0 && this.invocationCount.get() >= 2 && (event.location != null || event.size != null)) {
                        Assert.fail((String)"Child browser's visibility show listener should only be fired once");
                    }
                    this.invocationCount.incrementAndGet();
                }
            });
            if (childCount.get() == 1) {
                browserChild.addProgressListener((ProgressListener)new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        secondChildCompleted.set(true);
                    }
                });
            }
            childShell.open();
            childCount.incrementAndGet();
        });
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>window.open();window.open();</script>\n<body>This test uses javascript to open a new window.</body></html>");
        boolean passed = this.waitForPassCondition(secondChildCompleted::get);
        String errMsg = "\nTest timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_VisibilityWindowListener_eventSize() {
        this.shell.setSize(200, 300);
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        AtomicReference<Point> result = new AtomicReference<Point>(new Point(0, 0));
        Shell childShell = new Shell(this.shell);
        childShell.setSize(250, 350);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        Browser browserChild = new Browser((Composite)childShell, 0);
        this.browser.addOpenWindowListener(event -> {
            event.browser = browserChild;
            this.testLog.append("openWindowListener fired");
        });
        browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event -> {
            this.testLog.append("Visibilty show eventfired.\nEvent size: " + event.size);
            result.set(event.size);
            childShell.open();
            childCompleted.set(true);
        }));
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>window.open('javascript:\"Child Window\"','', \"height=200,width=300\")\n</script>\n<body>This test uses javascript to open a new window.</body></html>");
        boolean finishedWithoutTimeout = this.waitForPassCondition(childCompleted::get);
        browserChild.dispose();
        boolean passed = false;
        passed = this.isWebkit1 || SwtTestUtil.isCocoa ? finishedWithoutTimeout && result.get().x != 0 && result.get().y != 0 : finishedWithoutTimeout && result.get().x == 300 && result.get().y == 200;
        String errMsg = finishedWithoutTimeout ? "Incorrect size received:\nexpected width=300, actual:" + result.get().x + "\nexpected height=100, actual:" + result.get().y : "test timed out. Child's visibility Window listener didn't trigger";
        Assert.assertTrue((String)(String.valueOf(errMsg) + this.testLog.toString()), (boolean)passed);
    }

    @Override
    @Test
    public void test_isVisible() {
        super.test_isVisible();
    }

    @Test
    public void test_back() {
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        boolean result = this.browser.back();
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_setTextNull() {
        this.browser.setText(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_setUrlWithNullArg() {
        this.browser.setUrl(null);
    }

    @Test
    public void test_setJavascriptEnabled() {
        AtomicInteger pageLoadCount = new AtomicInteger(0);
        AtomicBoolean testFinished = new AtomicBoolean(false);
        AtomicBoolean testPassed = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            pageLoadCount.incrementAndGet();
            if (pageLoadCount.get() == 1) {
                this.browser.setJavascriptEnabled(false);
                this.browser.setText("Second page with javascript dissabled");
            } else if (pageLoadCount.get() == 2) {
                Boolean expectedNull = null;
                try {
                    expectedNull = (Boolean)this.browser.evaluate("return true");
                }
                catch (Exception exception) {
                    Assert.fail((String)"1) if javascript is dissabled, browser.evaluate() should return null. But an Exception was thrown");
                }
                Assert.assertNull((String)("2) Javascript should not have executed. But not-null was returned:" + expectedNull), (Object)expectedNull);
                testPassed.set(true);
                testFinished.set(true);
            }
        }));
        this.shell.open();
        this.browser.setText("First page with javascript enabled. This should not be visiable as a second page should load");
        this.waitForPassCondition(testFinished::get);
        Assert.assertTrue((String)"3) Javascript was executed on the second page. But it shouldn't have", (boolean)testPassed.get());
    }

    @Test
    public void test_setJavascriptEnabled_multipleInstances() {
        AtomicInteger pageLoadCount = new AtomicInteger(1);
        final AtomicInteger pageLoadCountSecondInstance = new AtomicInteger(1);
        AtomicBoolean instanceOneFinishedCorrectly = new AtomicBoolean(false);
        final AtomicBoolean instanceTwoFinishedCorrectly = new AtomicBoolean(false);
        final Browser browserSecondInsance = new Browser((Composite)this.shell, 0);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (pageLoadCount.get() == 1) {
                this.browser.setJavascriptEnabled(false);
                pageLoadCount.set(2);
                this.browser.setText("First instance, second page (with javascript turned off)");
                pageLoadCountSecondInstance.set(2);
                browserSecondInsance.setText("Second instance, second page (javascript execution not changed)");
            } else if (pageLoadCount.get() == 2) {
                pageLoadCount.set(3);
                Boolean shouldBeNull = (Boolean)this.browser.evaluate("return true");
                Assert.assertNull((String)"1) Evaluate execution should be null, but 'true was returned'", (Object)shouldBeNull);
                instanceOneFinishedCorrectly.set(true);
            }
        }));
        browserSecondInsance.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                if (pageLoadCountSecondInstance.get() == 2) {
                    pageLoadCountSecondInstance.set(3);
                    Boolean shouldBeTrue = (Boolean)browserSecondInsance.evaluate("return true");
                    Assert.assertTrue((String)("2) Javascript should be executable in second instance (as javascript was not turned off), but it was not. Expected:'someStr', Actual:" + shouldBeTrue), (boolean)shouldBeTrue);
                    instanceTwoFinishedCorrectly.set(true);
                }
            }
        });
        this.browser.setText("First Instance, first page");
        browserSecondInsance.setText("Second instance, first page");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (instanceOneFinishedCorrectly.get() && instanceTwoFinishedCorrectly.get()) {
                return true;
            }
            return false;
        });
        String message = "3) Test timed out. Debug Info:\nInstanceOneFinishedCorrectly: " + instanceOneFinishedCorrectly.get() + "\n" + "InstanceTwoFinishedCorrectly: " + instanceTwoFinishedCorrectly.get() + "\n" + "Instance 1 & 2 page counts: " + pageLoadCount.get() + " & " + pageLoadCountSecondInstance.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_LocationListener_evaluateInCallback() {
        Assume.assumeTrue((this.isWebkit2 || SwtTestUtil.isCocoa || SwtTestUtil.isWindows ? 1 : 0) != 0);
        final AtomicBoolean changingFinished = new AtomicBoolean(false);
        final AtomicBoolean changedFinished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanging = true");
                changingFinished.set(true);
            }

            public void changed(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanged = true");
                changedFinished.set(true);
            }
        });
        this.browser.setText("<body>Hello <b>World</b></body>");
        if (SwtTestUtil.isWindows) {
            this.waitForPassCondition(changingFinished::get);
        } else {
            this.waitForPassCondition(() -> changingFinished.get() && changedFinished.get());
        }
        Boolean changed = false;
        try {
            changed = (Boolean)this.browser.evaluate("return SWTchanged");
        }
        catch (SWTException sWTException) {}
        Boolean changing = false;
        try {
            changing = (Boolean)this.browser.evaluate("return SWTchanging");
        }
        catch (SWTException sWTException) {}
        String errMsg = "\n  changing:  fired:" + changingFinished.get() + "    evaluated:" + changing + "\n  changed:   fired:" + changedFinished.get() + "    evaluated:" + changed;
        boolean passed = false;
        if (this.isWebkit2) {
            passed = changingFinished.get() && changedFinished.get() && changed != false && changing != false;
        } else if (this.isWebkit1) {
            passed = changingFinished.get() && changedFinished.get() && changed != false;
        } else if (SwtTestUtil.isCocoa) {
            passed = changingFinished.get() && changedFinished.get() && changed != false;
        } else if (SwtTestUtil.isWindows) {
            passed = changingFinished.get();
        }
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_evaluateInCallback() {
        Assume.assumeTrue((!this.isWebkit1 ? 1 : 0) != 0);
        AtomicBoolean eventFired = new AtomicBoolean(false);
        this.browser.addOpenWindowListener(event -> {
            this.browser.evaluate("SWTopenListener = true");
            eventFired.set(true);
            event.required = true;
        });
        this.shell.open();
        this.browser.evaluate("window.open()");
        boolean fired = this.waitForPassCondition(eventFired::get);
        boolean evaluated = false;
        try {
            evaluated = (Boolean)this.browser.evaluate("return SWTopenListener");
        }
        catch (SWTException sWTException) {}
        boolean passed = fired && evaluated;
        String errMsg = "Event fired:" + fired + "   evaluated:" + evaluated;
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_forward() {
        int i = 0;
        while (i < 2) {
            this.browser.forward();
            ++i;
        }
        boolean result = this.browser.forward();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_getUrl() {
        String string = this.browser.getUrl();
        Assert.assertNotNull((Object)string);
    }

    @Test
    public void test_isBackEnabled() {
        Assert.assertEquals((Object)this.browser.isBackEnabled(), (Object)this.browser.back());
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        boolean result = this.browser.isBackEnabled();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_isForwardEnabled() {
        Assert.assertEquals((Object)this.browser.isForwardEnabled(), (Object)this.browser.forward());
        int i = 0;
        while (i < 10) {
            this.browser.forward();
            ++i;
        }
        boolean result = this.browser.isForwardEnabled();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_refresh() {
        int i = 0;
        while (i < 2) {
            this.browser.refresh();
            ++i;
        }
    }

    @Test
    public void test_getText() {
        if (SwtTestUtil.isWindows) {
            this.getText_helper("helloWorld", "<html><head></head><body>helloWorld</body></html>");
        } else {
            this.getText_helper("helloWorld", "helloWorld");
        }
    }

    @Test
    public void test_getText_html() {
        String testString = "<html><head></head><body>hello<b>World</b></body></html>";
        this.getText_helper(testString, testString);
    }

    @Test
    public void test_getText_script() {
        String testString = "<html><head></head><body>hello World<script>document.body.style.backgroundColor = \"red\";</script></body></html>";
        if (SwtTestUtil.isWindows) {
            this.getText_helper(testString, "<html><head></head><body style=\"background-color: red;\">hello World<script>document.body.style.backgroundColor = \"red\";</script></body></html>");
        } else {
            this.getText_helper(testString, testString);
        }
    }

    @Test
    public void test_getText_doctype() {
        String testString = "<!DOCTYPE html><html><head></head><body>hello World</body></html>";
        if (SwtTestUtil.isWindows) {
            this.getText_helper(testString, "<html><head></head><body>hello World</body></html>");
        } else {
            this.getText_helper(testString, testString);
        }
    }

    private void getText_helper(String testString, String expectedOutput) {
        AtomicReference<String> returnString = new AtomicReference<String>("");
        AtomicBoolean finished = new AtomicBoolean(false);
        this.browser.setText(testString);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            returnString.set(this.browser.getText());
            if (this.debug_verbose_output) {
                System.out.println((String)returnString.get());
            }
            finished.set(true);
        }));
        this.shell.open();
        this.waitForPassCondition(finished::get);
        boolean passed = returnString.get().equals(expectedOutput);
        String error_msg = finished.get() ? "Test did not return correct string.\nExpected:" + testString + "\n" + "Actual:" + returnString.get() : "Test timed out";
        Assert.assertTrue((String)error_msg, (boolean)passed);
    }

    @Test
    public void test_stop() {
        this.browser.setUrl("http://www.eclipse.org/swt");
        this.waitForMilliseconds(1000);
        this.browser.stop();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_execute_withNullArg() {
        this.browser.execute(null);
    }

    @Test
    public void test_execute_and_closeListener() {
        AtomicBoolean hasClosed = new AtomicBoolean(false);
        this.browser.setText("You should not see this page, it should have been closed by javascript");
        this.browser.addCloseWindowListener(e -> hasClosed.set(true));
        this.browser.execute("window.close()");
        this.shell.open();
        boolean passed = this.waitForPassCondition(hasClosed::get);
        if (passed) {
            this.disposedIntentionally = true;
        }
        String message = "Either browser.execute() did not work (if you still see the html page) or closeListener Was not triggered if browser looks disposed, but test still fails.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_string() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String evalResult = (String)this.browser.evaluate("return document.getElementById('myid').childNodes[0].nodeValue;");
            returnValue.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "HelloWorld".equals(returnValue.get()));
        Assert.assertTrue((String)"Evaluation did not return a value. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_returnMoved() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String evalResult = (String)this.browser.evaluate("var x = 1; return 'hello'");
            returnValue.set(evalResult);
        }));
        this.browser.setText("test text");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "hello".equals(returnValue.get()));
        Assert.assertTrue((String)"Evaluation did not return a value. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_number_normal() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = 123.0;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    @Test
    public void test_evaluate_number_negative() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = -123.0;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    @Test
    public void test_evaluate_number_big() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = 1.0E10;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    boolean evaluate_number_helper(Double testNum) {
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Double evalResult = (Double)this.browser.evaluate("return " + testNum.toString());
            returnValue.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> testNum.equals(returnValue.get()));
        return passed;
    }

    @Test
    public void test_evaluate_boolean() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Boolean evalResult = (Boolean)this.browser.evaluate("return true");
            atomicBoolean.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(atomicBoolean::get);
        Assert.assertTrue((String)"Evaluation did not return a boolean. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_null() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReference<Boolean> returnValue = new AtomicReference<Boolean>(new Boolean(true));
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object evalResult = this.browser.evaluate("return null");
            returnValue.set((Boolean)evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnValue.get() == null);
        Assert.assertTrue((String)"Evaluate did not return a null. Timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_invalid_return_value() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        if (SwtTestUtil.isWindows) {
            return;
        }
        AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            try {
                this.browser.evaluate("return new Date()");
            }
            catch (SWTException e) {
                exception.set(e.code);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicBoolean wrongExceptionCode = new AtomicBoolean(false);
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 51) {
                    return true;
                }
                if (exception.get() == 50) {
                    wrongExceptionCode.set(true);
                    return true;
                }
            }
            return false;
        });
        if (wrongExceptionCode.get()) {
            System.err.println("SWT Warning: test_evaluate_invalid_return_value threw wrong exception code. Expected ERROR_INVALID_RETURN_VALUE but got ERROR_FAILED_EVALUATE");
        }
        String message = exception.get() == -1 ? "Exception was not thrown. Test timed out" : "Exception thrown, but wrong code: " + exception.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_evaluation_failed_exception() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            try {
                this.browser.evaluate("return runSomeUndefinedFunctionInJavaScriptWhichCausesUndefinedError()");
            }
            catch (SWTException e) {
                exception.set(e.code);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 50) {
                    return true;
                }
                additionalErrorInfo.set("Invalid exception thrown: " + exception.get());
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not throw an error. Test timed out" : "Javascript threw an error, but not the right one." + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_numbers() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicIntegerArray atomicIntArray = new AtomicIntegerArray(3);
        atomicIntArray.set(0, -1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(1,2,3)");
            atomicIntArray.set(0, ((Double)evalResult[0]).intValue());
            atomicIntArray.set(1, ((Double)evalResult[1]).intValue());
            atomicIntArray.set(2, ((Double)evalResult[2]).intValue());
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicIntArray.get(0) != -1) {
                if (atomicIntArray.get(0) == 1 && atomicIntArray.get(1) == 2 && atomicIntArray.get(2) == 3) {
                    return true;
                }
                additionalErrorInfo.set("Resulting numbers in the array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javasscript called java, but passed wrong values: " + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_strings() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReferenceArray<String> atomicStringArray = new AtomicReferenceArray<String>(3);
        atomicStringArray.set(0, "executing");
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(\"str1\", \"str2\", \"str3\")");
            atomicStringArray.set(0, (String)evalResult[0]);
            atomicStringArray.set(1, (String)evalResult[1]);
            atomicStringArray.set(2, (String)evalResult[2]);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicStringArray.get(0))) {
                if (((String)atomicStringArray.get(0)).equals("str1") && ((String)atomicStringArray.get(1)).equals("str2") && ((String)atomicStringArray.get(2)).equals("str3")) {
                    return true;
                }
                additionalErrorInfo.set("Resulting strings in array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Expected an array of strings, but did not receive array or got the wrong result." : "Received a callback from javascript, but: " + additionalErrorInfo.get() + " : " + atomicStringArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_mixedTypes() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(\"str1\", 2, true)");
            atomicArray.set(2, (String)evalResult[2]);
            atomicArray.set(1, (String)evalResult[1]);
            atomicArray.set(0, (String)evalResult[0]);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicArray.get(0))) {
                if (atomicArray.get(0).equals("str1") && (Double)atomicArray.get(1) == 2.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                    return true;
                }
                additionalErrorInfo.set("Resulting String are not as exected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javascript called java but passed wrong values: " + atomicArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava()\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$javaCallbackExecuted.set(true);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "Java failed to get a callback from javascript. Test timed out";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_integer() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(5)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnedDouble = (Double)arguments[0];
                this.val$returnInt.set(returnedDouble.intValue());
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 5);
        String message = "Javascript should have passed an integer to java. But this did not happen";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_boolean() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(true)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Boolean returnBool = (Boolean)arguments[0];
                this.val$javaCallbackExecuted.set(returnBool);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "Javascript did not pass a boolean back to java";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_String() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReference returnValue = new AtomicReference();
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava('hellojava')\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReference val$returnValue;

            JavascriptCallback(Browser browser, String name, AtomicReference atomicReference) {
                this.val$returnValue = atomicReference;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                String returnString = (String)arguments[0];
                this.val$returnValue.set(returnString);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnValue);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "hellojava".equals(returnValue.get()));
        String message = "Javascript was suppose to call java with a String. But it seems java did not receive the call or wrong value was passed";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_multipleValues() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava('hellojava', 5, true)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReferenceArray val$atomicArray;

            JavascriptCallback(Browser browser, String name, AtomicReferenceArray atomicReferenceArray) {
                this.val$atomicArray = atomicReferenceArray;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$atomicArray.set(1, arguments[1]);
                this.val$atomicArray.set(2, arguments[2]);
                this.val$atomicArray.set(0, arguments[0]);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", atomicArray);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicArray.get(0).equals("hellojava") && (Double)atomicArray.get(1) == 5.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                return true;
            }
            return false;
        });
        String msg = "Values not set. Test timed out. Array should be [\"hellojava\", 5, true], but is: " + atomicArray.toString();
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_javaReturningInt() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n     var retVal = jsCallbackToJava()\n\t\tdocument.write(retVal)\n     jsSuccess(retVal)\n}</script>\n</head>\n<body> If you see this, javascript did not receive anything from Java. This page should just be '42' </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            JavascriptCallback(Browser browser, String name) {
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                return 42;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava");
        class JavascriptCallback_javascriptReceivedJavaInt
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback_javascriptReceivedJavaInt(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnVal = (Double)arguments[0];
                this.val$returnInt.set(returnVal.intValue());
                return null;
            }
        }
        new JavascriptCallback_javascriptReceivedJavaInt(this.browser, "jsSuccess", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 42);
        String message = "Java should have returned something back to javascript. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_afterPageReload() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        AtomicInteger callCount = new AtomicInteger(0);
        this.browser.setText("1st (initial) page load");
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$callCount;
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean) {
                this.val$callCount = atomicInteger;
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                if (this.val$callCount.get() == 0) {
                    this.val$callCount.set(1);
                    Test_org_eclipse_swt_browser_Browser.this.browser.setText("2nd page load");
                } else {
                    this.val$javaCallbackExecuted.set(true);
                }
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", callCount, javaCallbackExecuted);
        this.browser.execute("jsCallbackToJava()");
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> {
            boolean bl = this.browser.execute("jsCallbackToJava()");
        }));
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "A javascript callback should work after a page has been reloaded. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    private boolean waitForPassCondition(Supplier<Boolean> passTest) {
        return this.waitForPassCondition(passTest, 1000 * this.secondsToWaitTillFail);
    }

    private boolean waitForPassCondition(Supplier<Boolean> passTest, int millisecondsToWait) {
        AtomicBoolean passed = new AtomicBoolean(false);
        Instant timeOut = Instant.now().plusMillis(millisecondsToWait);
        Instant debug_showBrowserTimeout = Instant.now().plusSeconds(this.debug_show_browser_timeout_seconds);
        Display display = this.shell.getDisplay();
        new Thread(() -> {
            while (Instant.now().isBefore(timeOut)) {
                if (((Boolean)passTest.get()).booleanValue()) {
                    passed.set(true);
                    break;
                }
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (this.debug_show_browser && Instant.now().isBefore(debug_showBrowserTimeout)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            display.wake();
        }).start();
        while (Instant.now().isBefore(timeOut)) {
            if (passed.get() && (!this.debug_show_browser || Instant.now().isAfter(debug_showBrowserTimeout))) break;
            if (this.shell.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
        return passed.get();
    }

    void waitForMilliseconds(int milliseconds) {
        this.waitForPassCondition(() -> false, milliseconds);
    }

    private String webkit1SkipMsg() {
        return "Test_org_eclipse_swt_browser. Bug 509411. Skipping test on Webkit1 due to sporadic crash: " + this.name.getMethodName();
    }

    private static Boolean checkInternet(String url) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("HEAD");
            int code = connection.getResponseCode();
            if (code == 200) {
                Boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Given url is malformed: " + url + "Try a fully formed url like: http://www.example.com");
            e.printStackTrace();
        }
        catch (IOException iOException) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }
}

