/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_StyleRange {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB GREEN = new RGB(0, 255, 0);
    Map<RGB, Color> colors = new HashMap<RGB, Color>();

    private Color getColor(RGB rgb) {
        return this.colors.get(rgb);
    }

    protected void initializeColors() {
        Display display = Display.getDefault();
        this.colors.put(RED, new Color((Device)display, RED));
        this.colors.put(GREEN, new Color((Device)display, GREEN));
        this.colors.put(BLUE, new Color((Device)display, BLUE));
    }

    @Before
    public void setUp() {
        this.initializeColors();
    }

    @After
    public void tearDown() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
    }

    @Test
    public void test_Constructor() {
        StyleRange styleRange = new StyleRange();
        Assert.assertTrue((String)":a:", (styleRange.start == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":a:", (styleRange.length == 0 ? 1 : 0) != 0);
        Assert.assertNull((String)":a:", (Object)styleRange.foreground);
        Assert.assertNull((String)":a:", (Object)styleRange.background);
        Assert.assertTrue((String)":a:", (styleRange.fontStyle == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_ConstructorIILorg_eclipse_swt_graphics_ColorLorg_eclipse_swt_graphics_Color() {
        StyleRange styleRange = new StyleRange(5, 10, this.getColor(RED), this.getColor(BLUE));
        Assert.assertTrue((String)":b:", (styleRange.start == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (styleRange.length == 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (styleRange.foreground == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (styleRange.background == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (styleRange.fontStyle == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_ConstructorIILorg_eclipse_swt_graphics_ColorLorg_eclipse_swt_graphics_ColorI() {
        StyleRange styleRange = new StyleRange(5, 10, this.getColor(RED), this.getColor(BLUE), 1);
        Assert.assertTrue((String)":c:", (styleRange.start == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (styleRange.length == 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (styleRange.foreground == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (styleRange.background == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (styleRange.fontStyle == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test_clone() {
        StyleRange styleRangeA = new StyleRange(6, 10, null, this.getColor(BLUE), 0);
        StyleRange styleRangeB = (StyleRange)styleRangeA.clone();
        Assert.assertTrue((String)":g:", (boolean)styleRangeA.equals((Object)styleRangeB));
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        StyleRange styleRangeA = new StyleRange(5, 10, this.getColor(RED), this.getColor(BLUE), 1);
        StyleRange styleRangeB = new StyleRange(5, 10, this.getColor(RED), this.getColor(BLUE), 1);
        StyleRange styleRangeC = new StyleRange(5, 10, this.getColor(BLUE), this.getColor(BLUE), 1);
        StyleRange styleRangeD = new StyleRange(6, 10, this.getColor(RED), this.getColor(BLUE), 1);
        StyleRange styleRangeE = new StyleRange(5, 11, this.getColor(RED), this.getColor(BLUE), 1);
        StyleRange styleRangeF = new StyleRange(5, 11, this.getColor(RED), this.getColor(RED), 1);
        StyleRange styleRangeG = new StyleRange(5, 11, this.getColor(RED), this.getColor(BLUE), 0);
        Assert.assertTrue((String)":d:", (boolean)styleRangeA.equals((Object)styleRangeB));
        Assert.assertTrue((String)":d:", (!styleRangeA.equals((Object)styleRangeC) ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (!styleRangeA.equals((Object)styleRangeD) ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (!styleRangeA.equals((Object)styleRangeE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (!styleRangeA.equals((Object)styleRangeF) ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (!styleRangeA.equals((Object)styleRangeG) ? 1 : 0) != 0);
    }

    @Test
    public void test_hashCode() {
        HashSet<StyleRange> set = new HashSet<StyleRange>();
        Color testColor = new Color((Device)Display.getDefault(), 0, 0, 0);
        set.add(new StyleRange());
        set.add(new StyleRange(0, 1, testColor, null));
        set.add(new StyleRange(0, 1, testColor, testColor));
        set.add(new StyleRange(0, 1, testColor, testColor, 1));
        testColor.dispose();
    }

    @Test
    public void test_isUnstyled() {
        StyleRange styleRangeA = new StyleRange(5, 10, null, null, 0);
        StyleRange styleRangeB = new StyleRange(5, 10, this.getColor(RED), null, 0);
        StyleRange styleRangeC = new StyleRange(5, 10, null, null, 1);
        StyleRange styleRangeD = new StyleRange(6, 10, null, this.getColor(BLUE), 0);
        StyleRange styleRangeE = new StyleRange(5, 10, null, null);
        Assert.assertTrue((String)":e:", (boolean)styleRangeA.isUnstyled());
        Assert.assertTrue((String)":e:", (!styleRangeB.isUnstyled() ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (!styleRangeC.isUnstyled() ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (!styleRangeD.isUnstyled() ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (boolean)styleRangeE.isUnstyled());
    }

    @Test
    public void test_similarToLorg_eclipse_swt_custom_StyleRange() {
        StyleRange styleRangeA = new StyleRange(6, 10, this.getColor(RED), this.getColor(BLUE), 0);
        StyleRange styleRangeB = new StyleRange(5, 5, this.getColor(RED), this.getColor(BLUE), 0);
        StyleRange styleRangeC = new StyleRange(6, 10, this.getColor(RED), this.getColor(BLUE), 0);
        StyleRange styleRangeD = new StyleRange(6, 10, this.getColor(BLUE), this.getColor(BLUE), 0);
        StyleRange styleRangeE = new StyleRange(6, 10, this.getColor(RED), this.getColor(RED), 0);
        StyleRange styleRangeF = new StyleRange(6, 10, this.getColor(RED), this.getColor(BLUE), 1);
        Assert.assertTrue((String)":f:", (boolean)styleRangeA.similarTo(styleRangeB));
        Assert.assertTrue((String)":f:", (boolean)styleRangeA.similarTo(styleRangeC));
        Assert.assertTrue((String)":f:", (!styleRangeA.similarTo(styleRangeD) ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (!styleRangeA.similarTo(styleRangeE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (!styleRangeA.similarTo(styleRangeF) ? 1 : 0) != 0);
    }

    @Test
    public void test_toString() {
        StyleRange styleRange = new StyleRange(6, 10, null, this.getColor(BLUE), 0);
        styleRange.toString();
    }
}

