/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementEvent;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Canvas;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_StyledText
extends Test_org_eclipse_swt_widgets_Canvas {
    StyledText text;
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB YELLOW = new RGB(255, 255, 0);
    static final RGB CYAN = new RGB(0, 255, 255);
    static final RGB PURPLE = new RGB(255, 0, 255);
    static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");
    Map<RGB, Color> colors = new HashMap<RGB, Color>();
    private boolean listenerCalled;
    private boolean listener2Called;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.initializeColors();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
    }

    @Override
    @After
    public void tearDown() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        super.tearDown();
    }

    private StyleRange[] defaultStyles() {
        return new StyleRange[]{this.getStyle(0, 48, RED, YELLOW), this.getStyle(58, 10, BLUE, CYAN), this.getStyle(68, 10, GREEN, PURPLE)};
    }

    protected void getLineBackgrounds() {
        int i = 0;
        while (i < this.text.getLineCount()) {
            this.text.getLineBackground(i);
            ++i;
        }
    }

    private String textString() {
        return "This is the text component in testing\nNew Line1\nNew Line2\nNew Line3\nNew Line4.";
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    private StyleRange getStyle(int start, int length, RGB fg, RGB bg) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.foreground = fg != null ? this.getColor(fg) : null;
        style.background = bg != null ? this.getColor(bg) : null;
        return style;
    }

    private Color getColor(RGB rgb) {
        return this.colors.get(rgb);
    }

    protected void initializeColors() {
        Display display = Display.getDefault();
        this.colors.put(RED, new Color((Device)display, RED));
        this.colors.put(BLUE, new Color((Device)display, BLUE));
        this.colors.put(GREEN, new Color((Device)display, GREEN));
        this.colors.put(YELLOW, new Color((Device)display, YELLOW));
        this.colors.put(CYAN, new Color((Device)display, CYAN));
        this.colors.put(PURPLE, new Color((Device)display, PURPLE));
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        StyledText text = new StyledText((Composite)this.shell, 8);
        Assert.assertFalse((String)":a:", (boolean)text.getEditable());
        text.dispose();
        text = new StyledText((Composite)this.shell, 772);
        Assert.assertNull((String)":b:", (Object)text.getVerticalBar());
        Assert.assertNull((String)":c:", (Object)text.getHorizontalBar());
        text.dispose();
    }

    @Test
    public void test_addExtendedModifyListenerLorg_eclipse_swt_custom_ExtendedModifyListener() {
        boolean exceptionThrown = false;
        ExtendedModifyListener listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)"Line1".length(), (long)event.length);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (Object)"", (Object)event.replacedText);
        };
        try {
            this.text.addExtendedModifyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.text.addExtendedModifyListener(listener);
        this.listenerCalled = false;
        this.text.append("Line1");
        Assert.assertTrue((String)"append does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.insert("Line1");
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeExtendedModifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)"Line1".length(), (long)event.length);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (Object)"Line1".substring(0, 1), (Object)event.replacedText);
        };
        this.text.addExtendedModifyListener(listener);
        this.text.replaceTextRange(0, 1, "Line1");
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeExtendedModifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (long)"Line1".length(), (long)event.length);
            Assert.assertEquals((String)"ExtendedModify event data invalid", (Object)("Line1" + "Line1".substring(1, "Line1".length()) + "Line1"), (Object)event.replacedText);
        };
        this.text.addExtendedModifyListener(listener);
        this.text.setText("Line1");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeExtendedModifyListener(listener);
        this.text.setText("Line1");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_setKeyBindingII() {
        this.text.setKeyBinding(127, 0);
        Assert.assertTrue((String)":a:", (this.text.getKeyBinding(127) == 0 ? 1 : 0) != 0);
        this.text.setKeyBinding(127, 0x1000001);
        Assert.assertTrue((String)":b:", (this.text.getKeyBinding(127) == 0x1000001 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x7F | SWT.MOD2, 16908293);
        Assert.assertTrue((String)":c:", (this.text.getKeyBinding(0x7F | SWT.MOD2) == 16908293 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x7F | SWT.MOD2, 0x1000005);
        Assert.assertTrue((String)":d:", (this.text.getKeyBinding(0x7F | SWT.MOD2) == 0x1000005 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x1000050, 0x1000008);
        Assert.assertTrue((String)":e:", (this.text.getKeyBinding(0x1000050) == 0x1000008 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x1000050 | SWT.MOD1, 0x1000007);
        Assert.assertTrue((String)":f:", (this.text.getKeyBinding(0x1000050 | SWT.MOD1) == 0x1000007 ? 1 : 0) != 0);
        this.text.setKeyBinding(-1, 0x1000005);
        this.text.setKeyBinding(-1, -1);
    }

    @Test
    public void test_addBidiSegmentListenerLorg_eclipse_swt_custom_BidiSegmentListener() {
        String line = "Line1";
        boolean exceptionThrown = false;
        BidiSegmentListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.text.addBidiSegmentListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.listenerCalled = false;
        this.text.setText(line);
        this.text.addBidiSegmentListener(listener);
        this.text.getLocationAtOffset(0);
        if (SwtTestUtil.isBidi()) {
            Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        } else {
            Assert.assertFalse((String)"Listener called when it shouldn't be", (boolean)this.listenerCalled);
        }
        this.listenerCalled = false;
        this.text.removeBidiSegmentListener(listener);
        this.text.getLocationAtOffset(0);
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_addCaretListener_passingNullThrowsException() {
        this.text.addCaretListener(null);
    }

    @Test
    public void test_addCaretListener_CaretListenerCalled() {
        this.listenerCalled = false;
        CaretListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        this.text.setText("Line1");
        this.text.addCaretListener(listener);
        this.text.setCaretOffset(1);
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
    }

    @Test
    public void test_removeCaretListener_CaretListenerNotCalled() {
        this.listenerCalled = false;
        CaretListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        this.text.addCaretListener(listener);
        this.text.removeCaretListener(listener);
        this.text.setCaretOffset(1);
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_addLineBackgroundListenerLorg_eclipse_swt_custom_LineBackgroundListener() {
        String line = "Line1";
        boolean exceptionThrown = false;
        LineBackgroundListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.text.addLineBackgroundListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.listenerCalled = false;
        this.text.setText(line);
        this.text.addLineBackgroundListener(listener);
        this.text.setSelection(0, this.text.getCharCount());
        this.text.copy();
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeLineBackgroundListener(listener);
        this.text.setText(line);
        this.text.setSelection(0, this.text.getCharCount());
        this.text.copy();
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_addLineStyleListenerLorg_eclipse_swt_custom_LineStyleListener() {
        String line = "Line1";
        boolean exceptionThrown = false;
        LineStyleListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.text.addLineStyleListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.listenerCalled = false;
        this.text.setText(line);
        this.text.addLineStyleListener(listener);
        this.text.setSelection(0, this.text.getCharCount());
        this.text.copy();
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeLineStyleListener(listener);
        this.text.setText(line);
        this.text.setSelection(0, this.text.getCharCount());
        this.text.copy();
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_addModifyListenerLorg_eclipse_swt_events_ModifyListener() {
        String line = "Line1";
        boolean exceptionThrown = false;
        ModifyListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.text.addModifyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.text.addModifyListener(listener);
        this.listenerCalled = false;
        this.text.append(line);
        Assert.assertTrue((String)"append does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.insert(line);
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.replaceTextRange(0, 1, line);
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.setText(line);
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeModifyListener(listener);
        this.text.setText(line);
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        String line = "Line1";
        boolean exceptionThrown = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_custom_StyledText.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                Test_org_eclipse_swt_custom_StyledText.this.listener2Called = true;
            }
        };
        try {
            this.text.addSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.text.setText(line);
        this.listenerCalled = false;
        this.listener2Called = false;
        this.text.addSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        Assert.assertFalse((String)"Listener called unexpectedly", (boolean)this.listener2Called);
        this.listenerCalled = false;
        this.listener2Called = false;
        this.text.removeSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
        Assert.assertFalse((String)"Listener called unexpectedly", (boolean)this.listener2Called);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        String line = "Line1";
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.text.setText(line);
        this.listenerCalled = false;
        this.text.addSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerWidgetDefaultSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        String line = "Line1";
        SelectionListener listener = SelectionListener.widgetDefaultSelectedAdapter(e -> {
            boolean bl = this.listener2Called = true;
        });
        this.text.setText(line);
        this.listener2Called = false;
        this.text.addSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertFalse((String)"Listener called unexpectedly", (boolean)this.listener2Called);
        this.listener2Called = false;
        this.text.removeSelectionListener(listener);
        this.text.invokeAction(16908296);
        Assert.assertFalse((String)"Listener called unexpectedly", (boolean)this.listener2Called);
    }

    @Test
    public void test_addVerifyKeyListenerLorg_eclipse_swt_custom_VerifyKeyListener() {
        boolean exceptionThrown = false;
        VerifyKeyListener listener = event -> {};
        try {
            this.text.addVerifyKeyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.text.addVerifyKeyListener(listener);
        this.text.removeVerifyKeyListener(listener);
    }

    @Test
    public void test_addVerifyListenerLorg_eclipse_swt_events_VerifyListener() {
        boolean exceptionThrown = false;
        VerifyListener listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.start = 2;
            event.end = 5;
            event.text = "NewLine1";
        };
        try {
            this.text.addVerifyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        this.text.addVerifyListener(listener);
        this.listenerCalled = false;
        this.text.append("Line1");
        Assert.assertTrue((String)"append does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1", (Object)this.text.getText());
        this.listenerCalled = false;
        this.text.insert("Line1");
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1NewLine1", (Object)this.text.getText());
        this.listenerCalled = false;
        this.text.removeVerifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)1L, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.start = 2;
            event.end = 5;
            event.text = "NewLine1";
        };
        this.text.addVerifyListener(listener);
        int textLength = this.text.getCharCount() - 1 + "NewLine1".length();
        this.text.replaceTextRange(0, 1, "Line1");
        Assert.assertTrue((String)"replaceTextRange does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)("NewLine1" + "NewLine1".substring(1, "NewLine1".length()) + "NewLine1"), (Object)this.text.getText());
        this.listenerCalled = false;
        this.text.removeVerifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)textLength, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.start = 2;
            event.end = 5;
            event.text = "NewLine1";
        };
        this.text.addVerifyListener(listener);
        this.text.setText("Line1");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1", (Object)this.text.getText());
        this.text.removeVerifyListener(listener);
        this.listenerCalled = false;
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)2L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)"NewLine1".length(), (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.doit = false;
        };
        this.text.addVerifyListener(listener);
        this.text.replaceTextRange(2, this.text.getCharCount() - 2, "Line1");
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1", (Object)this.text.getText());
        this.listenerCalled = false;
        this.text.removeVerifyListener(listener);
        this.text.setText("Line1");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_addWordMovementListener_passingNullThrowsException() {
        this.text.addWordMovementListener(null);
    }

    @Test
    public void test_addWordMovementListener_invokeActionSelectWordNextCallsGetNextOffset() {
        RecordingMovementListener listener = new RecordingMovementListener();
        this.listenerCalled = false;
        this.listener2Called = false;
        this.text.setText("Word0 Word1 Word2");
        this.text.addWordMovementListener((MovementListener)listener);
        this.text.invokeAction(17170436);
        Assert.assertFalse((String)"Listener unexpectantly called", (boolean)this.listenerCalled);
        Assert.assertTrue((String)"Listener not called", (boolean)this.listener2Called);
    }

    @Test
    public void test_addWordMovementListener_invokeActionSelectWordPreviousCallsGetPreviousOffset() {
        RecordingMovementListener listener = new RecordingMovementListener();
        this.listenerCalled = false;
        this.listener2Called = false;
        this.text.setText("Word0 Word1 Word2");
        this.text.addWordMovementListener((MovementListener)listener);
        this.text.invokeAction(17170435);
        Assert.assertTrue((String)"Listener not called", (boolean)this.listenerCalled);
        Assert.assertFalse((String)"Listener unexpectantly called", (boolean)this.listener2Called);
    }

    @Test
    public void test_removeWordMovementListener_invokeActionSelectWordCallsNoMethods() {
        RecordingMovementListener listener = new RecordingMovementListener();
        this.listenerCalled = false;
        this.listener2Called = false;
        this.text.setText("Word0 Word1 Word2");
        this.text.addWordMovementListener((MovementListener)listener);
        this.text.removeWordMovementListener((MovementListener)listener);
        this.text.invokeAction(17170436);
        this.text.invokeAction(17170435);
        Assert.assertFalse((String)"Listener unexpectantly called", (boolean)this.listenerCalled);
        Assert.assertFalse((String)"Listener unexpectantly called", (boolean)this.listener2Called);
    }

    @Test
    public void test_appendLjava_lang_String() {
        String line = "Line1";
        this.text.append(line);
        Assert.assertEquals((String)"append to empty text", (Object)line, (Object)this.text.getText());
        boolean exceptionThrown = false;
        try {
            this.text.append(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"append null string", (boolean)exceptionThrown);
        this.text.append("");
        Assert.assertEquals((String)"append empty string", (Object)line, (Object)this.text.getText());
        this.text.append(line);
        Assert.assertEquals((String)"append non-empty string", (Object)(String.valueOf(line) + line), (Object)this.text.getText());
        this.text.setText("");
        String text2 = "line\r";
        this.text.append(text2);
        Assert.assertEquals((String)"append string ending with line delimiter", (Object)text2, (Object)this.text.getText());
        String text3 = "line\r\nline3";
        this.text.append(text3);
        Assert.assertEquals((String)"append multi line string", (Object)(String.valueOf(text2) + text3), (Object)this.text.getText());
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_computeSizeAlignment() {
        this.shell.setLayout((Layout)new GridLayout());
        StyledText singleText = new StyledText((Composite)this.shell, 4);
        this.shell.layout(true);
        Point beforeAlignment = singleText.computeSize(100, -1);
        singleText.setAlignment(131072);
        Point afterAlignment = singleText.computeSize(100, -1);
        Assert.assertEquals((Object)beforeAlignment, (Object)afterAlignment);
        singleText.dispose();
    }

    @Test
    public void test_marginsCorrect() {
        this.shell.setLayout((Layout)new GridLayout());
        StyledText singleText = new StyledText((Composite)this.shell, 4);
        int leftMargin = 10;
        singleText.setLeftMargin(leftMargin);
        this.shell.layout(true);
        singleText.setAlignment(131072);
        Assert.assertEquals((long)leftMargin, (long)singleText.getLeftMargin());
        singleText.setLeftMargin(leftMargin);
        Assert.assertEquals((long)leftMargin, (long)singleText.getLeftMargin());
        singleText.dispose();
    }

    @Test
    public void test_copy() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copy(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_StyledText).");
            }
            return;
        }
        Clipboard clipboard = new Clipboard(this.text.getDisplay());
        TextTransfer transfer = TextTransfer.getInstance();
        String before = (String)clipboard.getContents((Transfer)transfer);
        this.text.setSelectionRange(0, 0);
        this.text.copy();
        String clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":a:", (boolean)(before == null ? clipboardText == null : before.equals(clipboardText)));
        before = (String)clipboard.getContents((Transfer)transfer);
        this.text.setText("0123456789");
        this.text.setSelectionRange(0, 0);
        this.text.copy();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":c:", (boolean)(before == null ? clipboardText == null : before.equals(clipboardText)));
        this.text.setSelectionRange(0, 1);
        this.text.copy();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":d:", (clipboardText != null && clipboardText.equals("0") ? 1 : 0) != 0);
        this.text.setSelectionRange(1, 2);
        this.text.copy();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":e:", (clipboardText != null && clipboardText.equals("12") ? 1 : 0) != 0);
        this.text.setText("\rLine1\nLine2\r\nLine3\n\rLine4\n");
        this.text.setSelectionRange(0, this.text.getCharCount());
        this.text.copy();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        String convertedText = SwtTestUtil.isWindowsOS ? "\r\nLine1\r\nLine2\r\nLine3\r\n\r\nLine4\r\n" : "\nLine1\nLine2\nLine3\n\nLine4\n";
        Assert.assertTrue((String)":f:", (clipboardText != null && clipboardText.equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("Line1\r\nLine2");
        this.text.setSelectionRange(0, this.text.getCharCount());
        this.text.copy();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        convertedText = SwtTestUtil.isWindowsOS ? "Line1\r\nLine2" : "Line1\nLine2";
        Assert.assertTrue((String)":g:", (clipboardText != null && clipboardText.equals(convertedText) ? 1 : 0) != 0);
        this.rtfCopy();
        clipboard.dispose();
    }

    @Test
    public void test_cut() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_cut(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_StyledText).");
            }
            return;
        }
        Clipboard clipboard = new Clipboard(this.text.getDisplay());
        TextTransfer transfer = TextTransfer.getInstance();
        String before = (String)clipboard.getContents((Transfer)transfer);
        this.text.setSelectionRange(0, 0);
        this.text.cut();
        String clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":a:", (boolean)(before == null ? clipboardText == null : before.equals(clipboardText)));
        before = (String)clipboard.getContents((Transfer)transfer);
        this.text.setText("0123456789");
        this.text.setSelectionRange(0, 0);
        this.text.cut();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":c:", (boolean)(before == null ? clipboardText == null : before.equals(clipboardText)));
        this.text.setSelectionRange(0, 1);
        this.text.cut();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":d:", (clipboardText != null && clipboardText.equals("0") ? 1 : 0) != 0);
        this.text.setSelectionRange(1, 2);
        this.text.cut();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        Assert.assertTrue((String)":e:", (clipboardText != null && clipboardText.equals("23") ? 1 : 0) != 0);
        this.text.setText("\rLine1\nLine2\r\nLine3\n\rLine4\n");
        this.text.setSelectionRange(0, this.text.getCharCount());
        this.text.cut();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        String convertedText = SwtTestUtil.isWindowsOS ? "\r\nLine1\r\nLine2\r\nLine3\r\n\r\nLine4\r\n" : "\nLine1\nLine2\nLine3\n\nLine4\n";
        Assert.assertTrue((String)":f:", (clipboardText != null && clipboardText.equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("Line1\r\nLine2");
        this.text.setSelectionRange(0, this.text.getCharCount());
        this.text.cut();
        clipboardText = (String)clipboard.getContents((Transfer)transfer);
        convertedText = SwtTestUtil.isWindowsOS ? "Line1\r\nLine2" : "Line1\nLine2";
        Assert.assertTrue((String)":g:", (clipboardText != null && clipboardText.equals(convertedText) ? 1 : 0) != 0);
        clipboard.dispose();
    }

    @Test
    public void test_getCaretOffset() {
        Assert.assertTrue((String)":a:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0\r\n");
        Assert.assertTrue((String)":b:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":c:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.replaceTextRange(this.text.getCharCount(), 0, "Line1");
        Assert.assertTrue((String)":d:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        String newText = "Line-1\r\n";
        this.text.replaceTextRange(0, 0, newText);
        Assert.assertTrue((String)":e:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(1);
        Assert.assertTrue((String)":f:", (this.text.getCaretOffset() == 1 ? 1 : 0) != 0);
        this.text.replaceTextRange(2, 0, newText);
        Assert.assertTrue((String)":g:", (this.text.getCaretOffset() == 1 ? 1 : 0) != 0);
        this.text.replaceTextRange(0, 0, newText);
        Assert.assertTrue((String)":h:", (this.text.getCaretOffset() == newText.length() + 1 ? 1 : 0) != 0);
    }

    @Test
    public void test_getContent() {
        StyledTextContent content = this.text.getContent();
        Assert.assertNotNull((Object)content);
        content = new StyledTextContent(){

            public void addTextChangeListener(TextChangeListener listener) {
            }

            public int getCharCount() {
                return 0;
            }

            public String getLine(int lineIndex) {
                return "";
            }

            public int getLineAtOffset(int offset) {
                return 0;
            }

            public int getLineCount() {
                return 0;
            }

            public String getLineDelimiter() {
                return "";
            }

            public int getOffsetAtLine(int lineIndex) {
                return 0;
            }

            public String getTextRange(int start, int length) {
                return "";
            }

            public void removeTextChangeListener(TextChangeListener listener) {
            }

            public void replaceTextRange(int start, int replaceLength, String text) {
            }

            public void setText(String text) {
            }
        };
        this.text.setContent(content);
        Assert.assertEquals((Object)content, (Object)this.text.getContent());
    }

    @Test
    public void test_getDoubleClickEnabled() {
        Assert.assertTrue((String)":a:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((String)":b:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((String)":d:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((String)":e:", (boolean)this.text.getDoubleClickEnabled());
    }

    @Test
    public void test_getEditable() {
        Assert.assertTrue((String)":a:", (boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((String)":b:", (boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((String)":d:", (boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((String)":e:", (boolean)this.text.getEditable());
    }

    @Test
    public void test_getHorizontalIndex() {
        Assert.assertTrue((String)":a:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":b:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":c:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0");
        Assert.assertTrue((String)":d:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":e:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":f:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(500);
        Assert.assertTrue((String)":g:", (this.text.getHorizontalIndex() > 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":h:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":i:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
        this.shell.open();
        this.text.setSize(10, 50);
        this.text.setText("Line0");
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":j:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test_getHorizontalPixel() {
        Assert.assertTrue((String)":a:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":b:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":c:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0");
        Assert.assertTrue((String)":d:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":e:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":f:", (this.text.getHorizontalPixel() > 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":g:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":h:", (this.text.getHorizontalPixel() > 0 ? 1 : 0) != 0);
        this.shell.open();
        this.text.setSize(10, 50);
        this.text.setText("Line0");
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":i:", (this.text.getHorizontalPixel() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getKeyBindingI() {
        Assert.assertTrue((String)":a:", (this.text.getKeyBinding(127) == 127 ? 1 : 0) != 0);
        this.text.setKeyBinding(127, 0x1000001);
        Assert.assertTrue((String)":b:", (this.text.getKeyBinding(127) == 0x1000001 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x7F | SWT.MOD2, 16908293);
        Assert.assertTrue((String)":c:", (this.text.getKeyBinding(0x7F | SWT.MOD2) == 16908293 ? 1 : 0) != 0);
        this.text.setKeyBinding(0x7F | SWT.MOD2, 0x1000005);
        Assert.assertTrue((String)":d:", (this.text.getKeyBinding(0x7F | SWT.MOD2) == 0x1000005 ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (this.text.getKeyBinding(-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (this.text.getKeyBinding(0x100000B) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getCharCount() {
        Assert.assertTrue((String)":a:", (this.text.getCharCount() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0");
        Assert.assertTrue((String)":b:", (this.text.getCharCount() == 5 ? 1 : 0) != 0);
        this.text.setText("");
        Assert.assertTrue((String)":c:", (this.text.getCharCount() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0\n");
        Assert.assertTrue((String)":d:", (this.text.getCharCount() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void test_getLineBackgroundI() {
        String textString = "L1\nL2\nL3\nL4";
        this.text.setText(textString);
        Assert.assertNull((String)":1:", (Object)this.text.getLineBackground(0));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        Assert.assertTrue((String)":1:", (this.text.getLineBackground(1) == this.getColor(YELLOW) ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (this.text.getLineBackground(2) == this.getColor(BLUE) ? 1 : 0) != 0);
    }

    @Test
    public void test_getLineCount() {
        String delimiterString = "\r\n";
        Assert.assertTrue((String)":a:", (this.text.getLineCount() == 1 ? 1 : 0) != 0);
        this.text.append("dddasd" + delimiterString);
        Assert.assertTrue((String)":b:", (this.text.getLineCount() == 2 ? 1 : 0) != 0);
        this.text.append("ddasdasdasdasd" + delimiterString);
        Assert.assertTrue((String)":c:", (this.text.getLineCount() == 3 ? 1 : 0) != 0);
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertTrue((String)":a:", (this.text.getLineCount() == 1 ? 1 : 0) != 0);
        this.text.insert(delimiterString);
        Assert.assertTrue((String)":b:", (this.text.getLineCount() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void test_getLineAtOffsetI() {
        boolean exceptionThrown = false;
        Assert.assertTrue((String)":a:", (this.text.getLineAtOffset(0) == 0 ? 1 : 0) != 0);
        try {
            this.text.getLineAtOffset(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":b:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.getLineAtOffset(100);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":c:", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.text.setText("Line0\r\n");
        Assert.assertTrue((String)":d:", (this.text.getLineAtOffset(4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (this.text.getLineAtOffset(5) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (this.text.getLineAtOffset(6) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":g:", (this.text.getLineAtOffset(7) == 1 ? 1 : 0) != 0);
        try {
            this.text.getLineAtOffset(8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":h:", (boolean)exceptionThrown);
        exceptionThrown = false;
    }

    @Test
    public void test_getLineDelimiter() {
        StyledTextContent content = this.text.getContent();
        Assert.assertEquals((Object)content.getLineDelimiter(), (Object)this.text.getLineDelimiter());
        content = new StyledTextContent(){

            public void addTextChangeListener(TextChangeListener listener) {
            }

            public int getCharCount() {
                return 0;
            }

            public String getLine(int lineIndex) {
                return "";
            }

            public int getLineAtOffset(int offset) {
                return 0;
            }

            public int getLineCount() {
                return 0;
            }

            public String getLineDelimiter() {
                return "\n";
            }

            public int getOffsetAtLine(int lineIndex) {
                return 0;
            }

            public String getTextRange(int start, int length) {
                return "";
            }

            public void removeTextChangeListener(TextChangeListener listener) {
            }

            public void replaceTextRange(int start, int replaceLength, String text) {
            }

            public void setText(String text) {
            }
        };
        this.text.setContent(content);
        Assert.assertEquals((Object)"\n", (Object)this.text.getLineDelimiter());
    }

    @Test
    public void test_getLineHeight() {
        Assert.assertTrue((String)":a:", (this.text.getLineHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getLineIndex() {
        this.test_getLineIndex(this.text);
        StyledText text2 = new StyledText((Composite)this.shell, 64);
        this.test_getLineIndex(text2);
        text2.dispose();
    }

    void test_getLineIndex(StyledText text) {
        int lineHeight = text.getLineHeight();
        text.setText("Line0\nLine1\nLine2");
        text.setSize(400, lineHeight * 3);
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-100));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-1));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(lineHeight / 2));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(lineHeight - 1));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(lineHeight));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(lineHeight + lineHeight / 2));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(2 * lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(2 * lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(2 * lineHeight + lineHeight / 2));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(3 * lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(3 * lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(10 * lineHeight));
        text.setSize(400, lineHeight);
        text.setTopIndex(1);
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-10 * lineHeight));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-lineHeight));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-lineHeight / 2));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(2 * lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(10 * lineHeight));
        text.setTopIndex(2);
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-10 * lineHeight));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-2 * lineHeight));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-lineHeight - 1));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(-lineHeight));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(-1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(10 * lineHeight));
        text.setTopIndex(0);
        text.setSize(400, 0);
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-100));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-1));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(lineHeight / 2));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(lineHeight - 1));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(lineHeight));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(lineHeight + lineHeight / 2));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(2 * lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(2 * lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(2 * lineHeight + lineHeight / 2));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(3 * lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(3 * lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(10 * lineHeight));
        text.setTopPixel(3 * lineHeight);
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-3 * lineHeight - 100));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-3 * lineHeight));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-2 * lineHeight - 1));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(-2 * lineHeight));
        Assert.assertEquals((long)1L, (long)text.getLineIndex(-lineHeight - 1));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(-lineHeight));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)2L, (long)text.getLineIndex(100));
        text.setTopPixel(0);
        text.setText("");
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-1));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(-100));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(0));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(1));
        Assert.assertEquals((long)0L, (long)text.getLineIndex(100));
    }

    @Test
    public void test_getLinePixel() {
        this.test_getLinePixel(this.text);
        StyledText text2 = new StyledText((Composite)this.shell, 64);
        this.test_getLinePixel(text2);
        text2.dispose();
    }

    void test_getLinePixel(StyledText text) {
        int lineHeight = text.getLineHeight();
        text.setText("Line0\nLine1\nLine2");
        text.setSize(400, lineHeight * 3);
        Assert.assertEquals((long)0L, (long)text.getLinePixel(-100));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(0));
        Assert.assertEquals((long)lineHeight, (long)text.getLinePixel(1));
        Assert.assertEquals((long)(2 * lineHeight), (long)text.getLinePixel(2));
        Assert.assertEquals((long)(3 * lineHeight), (long)text.getLinePixel(3));
        Assert.assertEquals((long)(3 * lineHeight), (long)text.getLinePixel(100));
        text.setSize(400, 0);
        Assert.assertEquals((long)0L, (long)text.getLinePixel(-100));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(0));
        Assert.assertEquals((long)lineHeight, (long)text.getLinePixel(1));
        Assert.assertEquals((long)(2 * lineHeight), (long)text.getLinePixel(2));
        Assert.assertEquals((long)(3 * lineHeight), (long)text.getLinePixel(3));
        Assert.assertEquals((long)(3 * lineHeight), (long)text.getLinePixel(100));
        text.setSize(400, lineHeight);
        text.setTopIndex(1);
        Assert.assertEquals((long)(-lineHeight), (long)text.getLinePixel(-100));
        Assert.assertEquals((long)(-lineHeight), (long)text.getLinePixel(0));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(1));
        Assert.assertEquals((long)lineHeight, (long)text.getLinePixel(2));
        Assert.assertEquals((long)(2 * lineHeight), (long)text.getLinePixel(3));
        Assert.assertEquals((long)(2 * lineHeight), (long)text.getLinePixel(100));
        text.setSize(400, 0);
        text.setTopPixel(3 * lineHeight);
        Assert.assertEquals((long)(-3 * lineHeight), (long)text.getLinePixel(-100));
        Assert.assertEquals((long)(-3 * lineHeight), (long)text.getLinePixel(0));
        Assert.assertEquals((long)(-2 * lineHeight), (long)text.getLinePixel(1));
        Assert.assertEquals((long)(-lineHeight), (long)text.getLinePixel(2));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(3));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(100));
        text.setTopPixel(0);
        text.setText("");
        Assert.assertEquals((long)0L, (long)text.getLinePixel(-10));
        Assert.assertEquals((long)0L, (long)text.getLinePixel(0));
        Assert.assertEquals((long)lineHeight, (long)text.getLinePixel(1));
        Assert.assertEquals((long)lineHeight, (long)text.getLinePixel(10));
    }

    @Test
    public void test_getLocationAtOffsetI() {
        int XINSET = this.isBidiCaret() ? 2 : 0;
        Assert.assertTrue((String)":a:", (boolean)this.text.getLocationAtOffset(0).equals((Object)new Point(XINSET, 0)));
        try {
            this.text.getLocationAtOffset(-1);
            Assert.fail((String)"No exception thrown for offset == -1");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.text.getLocationAtOffset(100);
            Assert.fail((String)"No exception thrown for illegal offset argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.text.setText("Line0\r\nLine1");
        Assert.assertTrue((String)":d:", (this.text.getLocationAtOffset((int)4).x > 0 && this.text.getLocationAtOffset((int)4).y == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (this.text.getLocationAtOffset((int)6).x > 0 && this.text.getLocationAtOffset((int)6).y == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (this.text.getLocationAtOffset((int)7).x == XINSET && this.text.getLocationAtOffset((int)7).y > 0 ? 1 : 0) != 0);
        try {
            this.text.getLocationAtOffset(13);
            Assert.fail((String)"No exception thrown for illegal offset argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":h:", (this.text.getLocationAtOffset((int)4).x > 0 && this.text.getLocationAtOffset((int)4).y < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":i:", (this.text.getLocationAtOffset((int)7).x == XINSET && this.text.getLocationAtOffset((int)7).y == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":j:", (this.text.getLocationAtOffset((int)0).x < 0 && this.text.getLocationAtOffset((int)0).y < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":k:", (this.text.getLocationAtOffset((int)7).x < 0 && this.text.getLocationAtOffset((int)7).y == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getOffsetAtLineI() {
        boolean exceptionThrown = false;
        Assert.assertEquals((String)":a:", (long)0L, (long)this.text.getOffsetAtLine(0));
        try {
            this.text.getOffsetAtLine(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":b:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.getOffsetAtLine(100);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":c:", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.text.setText("Line0\r\n");
        Assert.assertEquals((String)":d:", (long)0L, (long)this.text.getOffsetAtLine(0));
        Assert.assertEquals((String)":e:", (long)7L, (long)this.text.getOffsetAtLine(1));
        try {
            this.text.getOffsetAtLine(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":f:", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.text.setText("");
        Assert.assertEquals((String)":g:", (long)0L, (long)this.text.getOffsetAtLine(0));
    }

    @Test
    public void test_getOffsetAtLocationLorg_eclipse_swt_graphics_Point() {
        boolean exceptionThrown = false;
        int XINSET = this.isBidiCaret() ? 2 : 0;
        Assert.assertTrue((String)":a:", (this.text.getOffsetAtLocation(new Point(XINSET, 0)) == 0 ? 1 : 0) != 0);
        try {
            this.text.getOffsetAtLocation(new Point(-1, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":b:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.getOffsetAtLocation(new Point(0, -1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":c:", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.text.setText("Line0\r\nLine1");
        Point location = this.text.getLocationAtOffset(5);
        Assert.assertTrue((String)":d:", (this.text.getOffsetAtLocation(new Point(10, 0)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (this.text.getOffsetAtLocation(new Point(location.x - 1, 0)) == 5 ? 1 : 0) != 0);
        location = this.text.getLocationAtOffset(7);
        Assert.assertTrue((String)":f:", (this.text.getOffsetAtLocation(location) == 7 ? 1 : 0) != 0);
        try {
            this.text.getOffsetAtLocation(new Point(100, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":g:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.getOffsetAtLocation(new Point(100, 50));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":h:", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":i:", (this.text.getOffsetAtLocation(new Point(XINSET, -5)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":j:", (this.text.getOffsetAtLocation(new Point(XINSET, 0)) == 7 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":k:", (this.text.getOffsetAtLocation(new Point(XINSET + -5, -5)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":l:", (this.text.getOffsetAtLocation(new Point(XINSET + -5, 0)) == 7 ? 1 : 0) != 0);
        Assert.assertTrue((String)":m:", (this.text.getOffsetAtLocation(this.text.getLocationAtOffset(2)) == 2 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(0);
        Assert.assertTrue((String)":n:", (this.text.getOffsetAtLocation(this.text.getLocationAtOffset(2)) == 2 ? 1 : 0) != 0);
    }

    @Test
    public void test_getOffsetAtPointLorg_eclipse_swt_graphics_Point() {
        int XINSET = this.isBidiCaret() ? 2 : 0;
        Assert.assertEquals((String)":a:", (long)0L, (long)this.text.getOffsetAtPoint(new Point(XINSET, 0)));
        Assert.assertEquals((String)":b:", (long)-1L, (long)this.text.getOffsetAtPoint(new Point(-1, 0)));
        Assert.assertEquals((String)":c:", (long)-1L, (long)this.text.getOffsetAtPoint(new Point(0, -1)));
        this.text.setText("Line0\r\nLine1");
        Point location = this.text.getLocationAtOffset(5);
        Assert.assertTrue((String)":d:", (this.text.getOffsetAtPoint(new Point(10, 0)) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)":e:", (long)5L, (long)this.text.getOffsetAtPoint(new Point(location.x - 1, 0)));
        location = this.text.getLocationAtOffset(7);
        Assert.assertEquals((String)":f:", (long)7L, (long)this.text.getOffsetAtPoint(location));
        Assert.assertEquals((String)":g:", (long)-1L, (long)this.text.getOffsetAtPoint(new Point(100, 0)));
        Assert.assertEquals((String)":h:", (long)-1L, (long)this.text.getOffsetAtPoint(new Point(100, 50)));
        this.text.setTopIndex(1);
        Assert.assertEquals((String)":i:", (long)0L, (long)this.text.getOffsetAtPoint(new Point(XINSET, -5)));
        Assert.assertEquals((String)":j:", (long)7L, (long)this.text.getOffsetAtPoint(new Point(XINSET, 0)));
        this.text.setHorizontalIndex(1);
        Assert.assertEquals((String)":k:", (long)0L, (long)this.text.getOffsetAtPoint(new Point(XINSET + -5, -5)));
        Assert.assertEquals((String)":l:", (long)7L, (long)this.text.getOffsetAtPoint(new Point(XINSET + -5, 0)));
        Assert.assertEquals((String)":m:", (long)2L, (long)this.text.getOffsetAtPoint(this.text.getLocationAtOffset(2)));
        this.text.setHorizontalIndex(0);
        Assert.assertEquals((String)":n:", (long)2L, (long)this.text.getOffsetAtPoint(this.text.getLocationAtOffset(2)));
    }

    void testStyles(String msg, int[] resultRanges, int[] expectedRanges, StyleRange[] resultStyles, StyleRange[] expectedStyles) {
        Assert.assertNotNull((String)("resultRanges is null on: " + msg), (Object)resultRanges);
        Assert.assertNotNull((String)("expectedRanges is null on: " + msg), (Object)expectedRanges);
        Assert.assertNotNull((String)("resultStyles is null on: " + msg), (Object)resultStyles);
        Assert.assertNotNull((String)("expectedStyles is null on: " + msg), (Object)expectedStyles);
        Assert.assertEquals((String)("result ranges and styles length don't match on: " + msg), (long)resultRanges.length, (long)(resultStyles.length * 2));
        Assert.assertEquals((String)("expected ranges and styles length don't match on: " + msg), (long)expectedRanges.length, (long)(expectedStyles.length * 2));
        Assert.assertArrayEquals((String)("expected and result ranges are differnt on: " + msg), (int[])expectedRanges, (int[])resultRanges);
        Assert.assertArrayEquals((String)("expected and result styles are differnt on: " + msg), (Object[])expectedStyles, (Object[])resultStyles);
    }

    @Test
    public void test_getRanges() {
        StyleRange style0 = new StyleRange();
        style0.rise = 10;
        StyleRange style1 = new StyleRange();
        style1.rise = 5;
        StyleRange style2 = new StyleRange();
        style2.rise = 30;
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray = new int[2];
        nArray[1] = 10;
        this.text.setStyleRanges(0, 0, nArray, new StyleRange[]{style0});
        StyleRange[] expectedStyles = new StyleRange[]{style0};
        int[] nArray2 = new int[2];
        nArray2[1] = 10;
        int[] expectedRanges = nArray2;
        this.testStyles("Test 1", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        expectedStyles = new StyleRange[]{style1};
        expectedRanges = new int[]{3, 4};
        this.testStyles("Test 2", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray3 = new int[2];
        nArray3[1] = 10;
        this.text.setStyleRanges(0, 0, nArray3, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        expectedStyles = new StyleRange[]{style0, style1, style0};
        int[] nArray4 = new int[6];
        nArray4[1] = 3;
        nArray4[2] = 3;
        nArray4[3] = 4;
        nArray4[4] = 7;
        nArray4[5] = 3;
        expectedRanges = nArray4;
        this.testStyles("Test 3", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray5 = new int[2];
        nArray5[1] = 10;
        this.text.setStyleRanges(0, 0, nArray5, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{1, 4}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style1, style0};
        int[] nArray6 = new int[8];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[3] = 4;
        nArray6[4] = 5;
        nArray6[5] = 2;
        nArray6[6] = 7;
        nArray6[7] = 3;
        expectedRanges = nArray6;
        this.testStyles("Test 4", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray7 = new int[2];
        nArray7[1] = 10;
        this.text.setStyleRanges(0, 0, nArray7, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{1, 8}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style0};
        int[] nArray8 = new int[6];
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArray8[3] = 8;
        nArray8[4] = 9;
        nArray8[5] = 1;
        expectedRanges = nArray8;
        this.testStyles("Test 5", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray9 = new int[2];
        nArray9[1] = 10;
        this.text.setStyleRanges(0, 0, nArray9, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        int[] nArray10 = new int[2];
        nArray10[1] = 5;
        this.text.setStyleRanges(0, 0, nArray10, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style2, style1, style0};
        int[] nArray11 = new int[6];
        nArray11[1] = 5;
        nArray11[2] = 5;
        nArray11[3] = 2;
        nArray11[4] = 7;
        nArray11[5] = 3;
        expectedRanges = nArray11;
        this.testStyles("Test 6", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray12 = new int[2];
        nArray12[1] = 10;
        this.text.setStyleRanges(0, 0, nArray12, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{1, 6}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style0};
        int[] nArray13 = new int[6];
        nArray13[1] = 1;
        nArray13[2] = 1;
        nArray13[3] = 6;
        nArray13[4] = 7;
        nArray13[5] = 3;
        expectedRanges = nArray13;
        this.testStyles("Test 7", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray14 = new int[2];
        nArray14[1] = 10;
        this.text.setStyleRanges(0, 0, nArray14, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style0};
        int[] nArray15 = new int[6];
        nArray15[1] = 3;
        nArray15[2] = 3;
        nArray15[3] = 4;
        nArray15[4] = 7;
        nArray15[5] = 3;
        expectedRanges = nArray15;
        this.testStyles("Test 8", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray16 = new int[2];
        nArray16[1] = 10;
        this.text.setStyleRanges(0, 0, nArray16, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        int[] nArray17 = new int[2];
        nArray17[1] = 3;
        this.text.setStyleRanges(0, 0, nArray17, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style2, style1, style0};
        int[] nArray18 = new int[6];
        nArray18[1] = 3;
        nArray18[2] = 3;
        nArray18[3] = 4;
        nArray18[4] = 7;
        nArray18[5] = 3;
        expectedRanges = nArray18;
        this.testStyles("Test 9", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray19 = new int[2];
        nArray19[1] = 10;
        this.text.setStyleRanges(0, 0, nArray19, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{7, 3}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style1, style2};
        int[] nArray20 = new int[6];
        nArray20[1] = 3;
        nArray20[2] = 3;
        nArray20[3] = 4;
        nArray20[4] = 7;
        nArray20[5] = 3;
        expectedRanges = nArray20;
        this.testStyles("Test 10", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray21 = new int[2];
        nArray21[1] = 10;
        this.text.setStyleRanges(0, 0, nArray21, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{4, 2}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style1, style2, style1, style0};
        int[] nArray22 = new int[10];
        nArray22[1] = 3;
        nArray22[2] = 3;
        nArray22[3] = 1;
        nArray22[4] = 4;
        nArray22[5] = 2;
        nArray22[6] = 6;
        nArray22[7] = 1;
        nArray22[8] = 7;
        nArray22[9] = 3;
        expectedRanges = nArray22;
        this.testStyles("Test 11", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray23 = new int[2];
        nArray23[1] = 10;
        this.text.setStyleRanges(0, 0, nArray23, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{3, 4}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{2, 6}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style0};
        int[] nArray24 = new int[6];
        nArray24[1] = 2;
        nArray24[2] = 2;
        nArray24[3] = 6;
        nArray24[4] = 8;
        nArray24[5] = 2;
        expectedRanges = nArray24;
        this.testStyles("Test 12", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        int[] nArray25 = new int[2];
        nArray25[1] = 10;
        this.text.setStyleRanges(0, 0, nArray25, new StyleRange[]{style0});
        int[] nArray26 = new int[2];
        nArray26[1] = 10;
        this.text.setStyleRanges(0, 0, nArray26, new StyleRange[]{style1});
        expectedStyles = new StyleRange[]{style1};
        int[] nArray27 = new int[2];
        nArray27[1] = 10;
        expectedRanges = nArray27;
        this.testStyles("Test 13", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789AB");
        this.text.setStyleRanges(0, 0, new int[]{1, 3}, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{5, 1}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{7, 1}, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{9, 2}, new StyleRange[]{style1});
        expectedStyles = new StyleRange[]{style0, style1, style0, style1};
        expectedRanges = new int[]{1, 3, 5, 1, 7, 1, 9, 2};
        this.testStyles("Test 14", this.text.getRanges(0, 12), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789AB");
        this.text.setStyleRanges(0, 0, new int[]{1, 3}, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{5, 1}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{7, 1}, new StyleRange[]{style0});
        this.text.setStyleRanges(0, 0, new int[]{9, 2}, new StyleRange[]{style1});
        this.text.setStyleRanges(0, 0, new int[]{2, 8}, new StyleRange[]{style2});
        expectedStyles = new StyleRange[]{style0, style2, style1};
        expectedRanges = new int[]{1, 1, 2, 8, 10, 1};
        this.testStyles("Test 15", this.text.getRanges(0, 12), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(new StyleRange[]{new StyleRange(3, 4, null, null, 1)});
        expectedStyles = new StyleRange[]{new StyleRange(3, 4, null, null, 1)};
        expectedRanges = new int[]{3, 4};
        this.testStyles("Test 16", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(new int[]{1, 3, 6, 3}, new StyleRange[]{style0, style0});
        this.text.setStyleRanges(0, 0, new int[]{4, 2}, new StyleRange[]{style0});
        expectedStyles = new StyleRange[]{style0};
        expectedRanges = new int[]{1, 8};
        this.testStyles("Test 17", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(new int[]{1, 3, 6, 3}, new StyleRange[]{style0, style0});
        this.text.setStyleRanges(0, 0, new int[]{2, 6}, new StyleRange[]{style0});
        expectedStyles = new StyleRange[]{style0};
        expectedRanges = new int[]{1, 8};
        this.testStyles("Test 18", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(new int[]{1, 3, 6, 3}, new StyleRange[]{style0, style0});
        int[] nArray28 = new int[4];
        nArray28[1] = 1;
        nArray28[2] = 9;
        nArray28[3] = 1;
        this.text.setStyleRanges(3, 4, nArray28, new StyleRange[]{style0, style0});
        expectedStyles = new StyleRange[]{style0, style0};
        int[] nArray29 = new int[4];
        nArray29[1] = 3;
        nArray29[2] = 7;
        nArray29[3] = 3;
        expectedRanges = nArray29;
        this.testStyles("Test 19", this.text.getRanges(0, 10), expectedRanges, this.text.getStyleRanges(false), expectedStyles);
        this.text.setText("");
        this.text.setText("0123456789");
        this.text.setStyleRanges(new StyleRange[]{new StyleRange(3, 4, null, null, 1)});
        expectedStyles = new StyleRange[]{};
        expectedRanges = new int[]{};
        this.testStyles("Test 20", this.text.getRanges(3, 0), expectedRanges, this.text.getStyleRanges(3, 0, false), expectedStyles);
        this.text.setText("");
        this.text.setText("The Eclipse Foundation is currently going through the exercise");
        this.text.setStyleRanges(new int[]{12, 10, 36, 5}, new StyleRange[]{style0, style1});
        expectedStyles = new StyleRange[]{style0};
        expectedRanges = new int[]{12, 10};
        this.testStyles("Test 21 (bug 250859)", this.text.getRanges(12, 10), expectedRanges, this.text.getStyleRanges(12, 10, false), expectedStyles);
        this.text.setText("");
        this.text.setText("The Eclipse Foundation is currently going through the exercise");
        StyleRange sr1 = new StyleRange();
        sr1.underline = true;
        StyleRange sr2 = new StyleRange();
        sr2.strikeout = true;
        sr1.start = 12;
        sr1.length = 10;
        sr2.start = 36;
        sr2.length = 5;
        this.text.setStyleRange(sr1);
        this.text.setStyleRange(sr2);
        this.text.replaceTextRange(12, 10, "");
        expectedStyles = new StyleRange[]{sr2};
        expectedRanges = new int[]{26, 5};
        this.testStyles("Test 22 (bug 250193)", this.text.getRanges(26, 5), expectedRanges, this.text.getStyleRanges(26, 5, false), expectedStyles);
        this.text.setText("");
        this.text.setText("line0\nline1\nline2");
        int[] nArray30 = new int[8];
        nArray30[1] = 2;
        nArray30[2] = 2;
        nArray30[3] = 2;
        nArray30[4] = 4;
        nArray30[5] = 4;
        nArray30[6] = 13;
        nArray30[7] = 3;
        this.text.setStyleRanges(nArray30, new StyleRange[]{style0, style1, style2, style0});
        expectedRanges = new int[]{6, 2};
        expectedStyles = new StyleRange[]{style2};
        this.testStyles("Test 23 (bug 212851 - getRanges)", this.text.getRanges(6, 6), expectedRanges, this.text.getStyleRanges(6, 6, false), expectedStyles);
        StyleRange[] styles = this.text.getStyleRanges(6, 6, true);
        int[] ranges = new int[styles.length * 2];
        int i = 0;
        while (i < ranges.length) {
            ranges[i] = styles[i / 2].start;
            ranges[i + 1] = styles[i / 2].length;
            i += 2;
        }
        this.testStyles("Test 24 (bug 212851 - getStyleRanges)", ranges, expectedRanges, this.text.getStyleRanges(6, 6, false), expectedStyles);
        expectedRanges = new int[]{6, 2, 13, 1};
        expectedStyles = new StyleRange[]{style2, style0};
        this.testStyles("Test 25 ", this.text.getRanges(6, 8), expectedRanges, this.text.getStyleRanges(6, 8, false), expectedStyles);
        styles = this.text.getStyleRanges(6, 8, true);
        ranges = new int[styles.length * 2];
        i = 0;
        while (i < ranges.length) {
            ranges[i] = styles[i / 2].start;
            ranges[i + 1] = styles[i / 2].length;
            i += 2;
        }
        this.testStyles("Test 26 ", ranges, expectedRanges, this.text.getStyleRanges(6, 8, false), expectedStyles);
    }

    @Test
    public void test_getSelection() {
        this.text.setText("01234567890");
        this.text.setSelection(new Point(2, 2));
        Assert.assertTrue((String)":b:", (boolean)this.text.getSelection().equals((Object)new Point(2, 2)));
        this.text.setSelection(new Point(2, 3));
        Assert.assertTrue((String)":c:", (boolean)this.text.getSelection().equals((Object)new Point(2, 3)));
        this.text.setSelection(new Point(3, 11));
        Assert.assertTrue((String)":d:", (boolean)this.text.getSelection().equals((Object)new Point(3, 11)));
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertTrue((String)":a:", (boolean)this.text.getSelection().equals((Object)new Point(4, 4)));
        this.text.setSelection(11);
        Assert.assertTrue((String)":b:", (boolean)this.text.getSelection().equals((Object)new Point(11, 11)));
        this.text.setSelection(new Point(3, 2));
        Assert.assertTrue((String)":c:", (boolean)this.text.getSelection().equals((Object)new Point(2, 3)));
    }

    @Test
    public void test_getSelectionBackground() {
        Assert.assertNotNull((String)":1:", (Object)this.text.getSelectionBackground());
        this.text.setSelectionBackground(this.getColor(YELLOW));
        Assert.assertTrue((String)":1:", (this.text.getSelectionBackground() == this.getColor(YELLOW) ? 1 : 0) != 0);
    }

    @Test
    public void test_getSelectionForeground() {
        Assert.assertNotNull((String)":1:", (Object)this.text.getSelectionForeground());
        this.text.setSelectionForeground(this.getColor(RED));
        Assert.assertTrue((String)":1:", (this.text.getSelectionForeground() == this.getColor(RED) ? 1 : 0) != 0);
    }

    @Test
    public void test_getSelectionRange() {
        int length;
        int start;
        String testText = "Line1\r\nLine2";
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-1, -1};
        nArrayArray[2] = new int[]{100, 1};
        nArrayArray[3] = new int[]{100, -1};
        nArrayArray[4] = new int[]{12, 1};
        nArrayArray[5] = new int[]{11, 2};
        nArrayArray[6] = new int[]{2, -3};
        nArrayArray[7] = new int[]{50, -1};
        int[][] invalidRanges = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray2[0] = nArray2;
        nArrayArray2[1] = new int[2];
        nArrayArray2[2] = new int[]{2, 3};
        int[] nArray3 = new int[2];
        nArray3[0] = 12;
        nArrayArray2[3] = nArray3;
        nArrayArray2[4] = new int[]{2, -2};
        nArrayArray2[5] = new int[]{5, -1};
        int[][] selectionRanges = nArrayArray2;
        int i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            length = invalidRanges[i][1];
            try {
                this.text.setSelectionRange(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
        this.text.setSelectionRange(0, 0);
        Assert.assertTrue((String)":b:", (this.text.getSelectionRange().x == 0 && this.text.getSelectionRange().y == 0 ? 1 : 0) != 0);
        this.text.setText(testText);
        i = 0;
        while (i < selectionRanges.length) {
            start = selectionRanges[i][0];
            length = selectionRanges[i][1];
            this.text.setSelectionRange(start, length);
            if (length < 0) {
                start += length;
                length *= -1;
                Assert.assertEquals((String)(":c:a:" + i), (long)start, (long)this.text.getCaretOffset());
            } else {
                Assert.assertEquals((String)(":c:a:" + i), (long)(start + length), (long)this.text.getCaretOffset());
            }
            Assert.assertTrue((String)(":c:" + i), (this.text.getSelectionRange().x == start && this.text.getSelectionRange().y == length ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            length = invalidRanges[i][1];
            try {
                this.text.setSelectionRange(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
    }

    @Test
    public void test_getSelectionCount() {
        this.text.setText("01234567890");
        Assert.assertTrue((String)":a:", (this.text.getSelectionCount() == 0 ? 1 : 0) != 0);
        this.text.setSelection(2, 4);
        Assert.assertTrue((String)":b:", (this.text.getSelectionCount() == 2 ? 1 : 0) != 0);
        this.text.setSelection(2, 11);
        Assert.assertTrue((String)":c:", (this.text.getSelectionCount() == 9 ? 1 : 0) != 0);
        this.text.setText("0123\n4567890");
        Assert.assertTrue((String)":d:", (this.text.getSelectionCount() == 0 ? 1 : 0) != 0);
        this.text.setSelection(2, 4);
        Assert.assertTrue((String)":e:", (this.text.getSelectionCount() == 2 ? 1 : 0) != 0);
        this.text.setSelection(2, 12);
        Assert.assertTrue((String)":f:", (this.text.getSelectionCount() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_getSelectionText() {
        String testText = "Line1\r\nLine2";
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[2];
        nArrayArray[2] = new int[]{2, 3};
        int[] nArray2 = new int[2];
        nArray2[0] = 12;
        nArrayArray[3] = nArray2;
        int[][] selectionRanges = nArrayArray;
        this.text.setSelectionRange(0, 0);
        Assert.assertEquals((String)":b:", (Object)"", (Object)this.text.getSelectionText());
        this.text.setText(testText);
        int i = 0;
        while (i < selectionRanges.length) {
            int start = selectionRanges[i][0];
            int length = selectionRanges[i][1];
            this.text.setSelectionRange(start, length);
            Assert.assertEquals((String)(":c:" + i), (Object)testText.substring(start, start + length), (Object)this.text.getSelectionText());
            ++i;
        }
    }

    @Test
    public void test_getStyleRangeAtOffsetI() {
        String line = "Line1\r\nLine2";
        int styleStart = 0;
        int styleLength = 5;
        boolean exceptionThrown = false;
        StyleRange style = new StyleRange(styleStart, styleLength, this.getColor(BLUE), this.getColor(RED), 1);
        try {
            this.text.getStyleRangeAtOffset(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"offset out of range no text", (boolean)exceptionThrown);
        this.text.setText(line);
        exceptionThrown = false;
        try {
            this.text.getStyleRangeAtOffset(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"offset out of range negative", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.getStyleRangeAtOffset(line.length());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"offset out of range positive", (boolean)exceptionThrown);
        this.text.setStyleRange(style);
        style.length = 1;
        int i = styleStart;
        while (i < styleStart + styleLength) {
            style.start = i;
            Assert.assertEquals((Object)style, (Object)this.text.getStyleRangeAtOffset(i));
            ++i;
        }
        Assert.assertEquals(null, (Object)this.text.getStyleRangeAtOffset(i));
        style = new StyleRange(5, 2, null, this.getColor(BLUE), 0);
        this.text.setStyleRange(style);
        style.length = 1;
        Assert.assertEquals((Object)style, (Object)this.text.getStyleRangeAtOffset(5));
        style.start = 6;
        Assert.assertEquals((Object)style, (Object)this.text.getStyleRangeAtOffset(6));
        Assert.assertEquals(null, (Object)this.text.getStyleRangeAtOffset(10));
    }

    @Test
    public void test_getStyleRanges() {
        this.text.setText("package test;\n/* Line 1\n * Line 2\n */\npublic class SimpleClass {\n}");
        this.text.setStyleRange(this.getStyle(0, 7, BLUE, null));
        this.text.setStyleRange(this.getStyle(14, 23, RED, null));
        this.text.setStyleRange(this.getStyle(38, 6, BLUE, null));
        this.text.setStyleRange(this.getStyle(45, 5, BLUE, null));
        this.text.replaceTextRange(14, 23, "\t/*Line 1\n\t * Line 2\n\t */");
        String newText = this.text.getTextRange(0, this.text.getCharCount());
        Assert.assertTrue((String)":1:", (boolean)newText.equals("package test;\n\t/*Line 1\n\t * Line 2\n\t */\npublic class SimpleClass {\n}"));
        StyleRange[] styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 7, BLUE, null)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(40, 6, BLUE, null)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(47, 5, BLUE, null)));
    }

    @Test
    public void test_getStyleRangesII() {
        this.text.setText("0123456789");
        this.text.setStyleRange(this.getStyle(1, 4, BLUE, null));
        this.text.setStyleRange(this.getStyle(5, 2, RED, null));
        this.text.setStyleRange(this.getStyle(7, 2, YELLOW, null));
        StyleRange[] styles = this.text.getStyleRanges(0, 1);
        Assert.assertTrue((String)":1:", (styles.length == 0 ? 1 : 0) != 0);
        styles = this.text.getStyleRanges(0, 5);
        Assert.assertTrue((String)":2:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(1, 4, BLUE, null)));
        styles = this.text.getStyleRanges(7, 3);
        Assert.assertTrue((String)":3:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(7, 2, YELLOW, null)));
        styles = this.text.getStyleRanges(0, 10);
        Assert.assertTrue((String)":4:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(1, 4, BLUE, null)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(5, 2, RED, null)));
        Assert.assertTrue((String)":4:", (boolean)styles[2].equals((Object)this.getStyle(7, 2, YELLOW, null)));
        styles = this.text.getStyleRanges(0, 4);
        Assert.assertTrue((String)":5:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(1, 3, BLUE, null)));
        styles = this.text.getStyleRanges(2, 6);
        Assert.assertTrue((String)":6:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(2, 3, BLUE, null)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(5, 2, RED, null)));
        Assert.assertTrue((String)":6:", (boolean)styles[2].equals((Object)this.getStyle(7, 1, YELLOW, null)));
        this.text.setText("0123456789\r\nABCDEFGHIJKL");
        this.text.setStyleRange(this.getStyle(4, 3, BLUE, null));
        this.text.setStyleRange(this.getStyle(7, 5, RED, null));
        this.text.setStyleRange(this.getStyle(15, 1, YELLOW, null));
        styles = this.text.getStyleRanges(15, 1);
        Assert.assertTrue((String)":1a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1a:", (boolean)styles[0].equals((Object)this.getStyle(15, 1, YELLOW, null)));
        styles = this.text.getStyleRanges(15, 0);
        Assert.assertTrue((String)":2a:", (styles.length == 0 ? 1 : 0) != 0);
        styles = this.text.getStyleRanges(0, 20);
        Assert.assertTrue((String)":3a:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3a:", (boolean)styles[0].equals((Object)this.getStyle(4, 3, BLUE, null)));
        Assert.assertTrue((String)":3a:", (boolean)styles[1].equals((Object)this.getStyle(7, 5, RED, null)));
        Assert.assertTrue((String)":3a:", (boolean)styles[2].equals((Object)this.getStyle(15, 1, YELLOW, null)));
        styles = this.text.getStyleRanges(8, 2);
        Assert.assertTrue((String)":4a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(8, 2, RED, null)));
    }

    @Test
    public void test_getTabs() {
        this.text.setTabs(1);
        Assert.assertTrue((String)":a:", (this.text.getTabs() == 1 ? 1 : 0) != 0);
        this.text.setTabs(8);
        Assert.assertTrue((String)":b:", (this.text.getTabs() == 8 ? 1 : 0) != 0);
        this.text.setText("Line\t1\r\n");
        Assert.assertTrue((String)":c:", (this.text.getTabs() == 8 ? 1 : 0) != 0);
        this.text.setTabs(7);
        Assert.assertTrue((String)":d:", (this.text.getTabs() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void test_getText() {
        String testText = "Line1\r\nLine2";
        Assert.assertTrue((String)":a:", (this.text.getText().length() == 0 ? 1 : 0) != 0);
        this.text.setText(testText);
        Assert.assertTrue((String)":b:", (boolean)this.text.getText().equals(testText));
        this.text.setText("");
        Assert.assertTrue((String)":c:", (this.text.getText().length() == 0 ? 1 : 0) != 0);
        this.text.setText(testText);
        Assert.assertTrue((String)":a:", (boolean)this.text.getText().equals(testText));
        this.text.setText(String.valueOf(testText) + "\r\n");
        Assert.assertTrue((String)":b:", (boolean)this.text.getText().equals(String.valueOf(testText) + "\r\n"));
        this.text.setText("");
        Assert.assertTrue((String)":c:", (this.text.getText().length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getTextII() {
        boolean exceptionThrown;
        int end;
        int start;
        String testText = "Line1\r\nLine2";
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = -1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{-1, -1};
        nArrayArray[3] = new int[]{100, 1};
        nArrayArray[4] = new int[]{100, -1};
        nArrayArray[5] = new int[]{2, testText.length()};
        nArrayArray[6] = new int[]{5, 2};
        int[][] invalidRanges = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray2[0] = nArray3;
        nArrayArray2[1] = new int[2];
        nArrayArray2[2] = new int[]{2, 5};
        nArrayArray2[3] = new int[]{7, 11};
        int[][] ranges = nArrayArray2;
        int i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            end = invalidRanges[i][1];
            exceptionThrown = false;
            try {
                this.text.getText(start, end);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)":a:", (boolean)exceptionThrown);
            ++i;
        }
        this.text.setText(testText);
        i = 0;
        while (i < ranges.length) {
            start = ranges[i][0];
            end = ranges[i][1];
            Assert.assertEquals((String)(":b:" + i), (Object)testText.substring(start, end + 1), (Object)this.text.getText(start, end));
            ++i;
        }
        i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            end = invalidRanges[i][1];
            exceptionThrown = false;
            try {
                this.text.getText(start, end);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)":a:", (boolean)exceptionThrown);
            ++i;
        }
        this.text.setText("testing");
        Assert.assertTrue((String)":d:", (boolean)this.text.getText(0, 0).equals("t"));
        Assert.assertTrue((String)":d:", (boolean)this.text.getText(0, 1).equals("te"));
        Assert.assertTrue((String)":d:", (boolean)this.text.getText(1, 5).equals("estin"));
    }

    @Test
    public void test_getTextRangeII() {
        boolean exceptionThrown;
        int length;
        int start;
        String testText = "Line1\r\nLine2";
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = -1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{-1, -1};
        nArrayArray[3] = new int[]{100, 1};
        nArrayArray[4] = new int[]{100, -1};
        nArrayArray[5] = new int[]{1, testText.length()};
        nArrayArray[6] = new int[]{5, -1};
        int[][] invalidRanges = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray2[0] = nArray3;
        nArrayArray2[1] = new int[2];
        nArrayArray2[2] = new int[]{5, 1};
        nArrayArray2[3] = new int[]{7, 5};
        int[] nArray4 = new int[2];
        nArray4[0] = 12;
        nArrayArray2[4] = nArray4;
        int[][] ranges = nArrayArray2;
        int i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            length = invalidRanges[i][1];
            exceptionThrown = false;
            try {
                this.text.getTextRange(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)":a:", (boolean)exceptionThrown);
            ++i;
        }
        this.text.setText(testText);
        i = 0;
        while (i < ranges.length) {
            start = ranges[i][0];
            length = ranges[i][1];
            Assert.assertEquals((String)(":b:" + i), (Object)testText.substring(start, start + length), (Object)this.text.getTextRange(start, length));
            ++i;
        }
        i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            length = invalidRanges[i][1];
            exceptionThrown = false;
            try {
                this.text.getTextRange(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)":a:", (boolean)exceptionThrown);
            ++i;
        }
        this.text.setText("testing");
        Assert.assertTrue((String)":d:", (boolean)this.text.getTextRange(0, 0).isEmpty());
        Assert.assertTrue((String)":d:", (boolean)this.text.getTextRange(0, 1).equals("t"));
        Assert.assertTrue((String)":d:", (boolean)this.text.getTextRange(0, 2).equals("te"));
        Assert.assertTrue((String)":d:", (boolean)this.text.getTextRange(1, 5).equals("estin"));
    }

    @Test
    public void test_getTextLimit() {
        Assert.assertTrue((String)":a:", (this.text.getTextLimit() < 0 ? 1 : 0) != 0);
        this.text.setTextLimit(10);
        Assert.assertTrue((String)":b:", (this.text.getTextLimit() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_getTopIndex() {
        this.text.setText("Line0\r\nLine0a\r\n");
        Assert.assertTrue((String)":a:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(-2);
        Assert.assertTrue((String)":b:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(-1);
        Assert.assertTrue((String)":c:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":d:", (this.text.getTopIndex() == 1 ? 1 : 0) != 0);
        this.text.setTopIndex(2);
        Assert.assertTrue((String)":e:", (this.text.getTopIndex() == 2 ? 1 : 0) != 0);
        this.text.setTopIndex(0);
        Assert.assertTrue((String)":f:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(3);
        Assert.assertTrue((String)":g:", (this.text.getTopIndex() == 2 ? 1 : 0) != 0);
        this.text.replaceTextRange(this.text.getCharCount(), 0, "Line1");
        Assert.assertTrue((String)":h:", (this.text.getTopIndex() == 2 ? 1 : 0) != 0);
        this.text.setText("");
        Assert.assertTrue((String)":i:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getTopPixel() {
        this.text.setText("Line0\r\nLine0a\r\n");
        Assert.assertTrue((String)":a:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(-2);
        Assert.assertTrue((String)":b:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(-1);
        Assert.assertTrue((String)":c:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":d:", (this.text.getTopPixel() == this.text.getLineHeight() ? 1 : 0) != 0);
        this.text.setTopIndex(2);
        Assert.assertTrue((String)":e:", (this.text.getTopPixel() == this.text.getLineHeight() * 2 ? 1 : 0) != 0);
        this.text.setTopIndex(0);
        Assert.assertTrue((String)":f:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(3);
        Assert.assertTrue((String)":g:", (this.text.getTopPixel() == this.text.getLineHeight() * 2 ? 1 : 0) != 0);
        this.text.replaceTextRange(this.text.getCharCount(), 0, "Line1");
        Assert.assertTrue((String)":h:", (this.text.getTopPixel() == this.text.getLineHeight() * 2 ? 1 : 0) != 0);
        this.text.setText("");
        Assert.assertTrue((String)":i:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getWordWrap() {
        Assert.assertFalse((String)":a:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(true);
        Assert.assertTrue((String)":b:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(false);
        Assert.assertFalse((String)":d:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(true);
        Assert.assertTrue((String)":e:", (boolean)this.text.getWordWrap());
    }

    @Test
    public void test_insertLjava_lang_String() {
        String delimiterString = "\n";
        try {
            this.text.insert(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertTrue((String)":a:", (boolean)this.text.getText().isEmpty());
        this.text.insert("");
        Assert.assertTrue((String)":b:", (boolean)this.text.getText().isEmpty());
        this.text.insert("fred");
        Assert.assertTrue((String)":c:", (boolean)this.text.getText().equals("fred"));
        this.text.setSelection(2);
        this.text.insert("helmut");
        Assert.assertTrue((String)":d:", (boolean)this.text.getText().equals("frhelmuted"));
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertTrue((String)":e:", (this.text.getLineCount() == 1 ? 1 : 0) != 0);
        this.text.insert(delimiterString);
        Assert.assertTrue((String)":f:", (this.text.getLineCount() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void test_invokeActionI() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_invokeAction(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_StyledText).");
            }
            return;
        }
        this.text.invokeAction(0x1000002);
        this.text.invokeAction(0x1000001);
        this.text.invokeAction(0x1000008);
        this.text.invokeAction(0x1000007);
        this.text.invokeAction(0x1000004);
        this.text.invokeAction(0x1000006);
        this.text.invokeAction(0x1000005);
        this.text.invokeAction(0x1040004);
        this.text.invokeAction(17039363);
        this.text.invokeAction(17039368);
        this.text.invokeAction(17039367);
        this.text.invokeAction(17039366);
        this.text.invokeAction(17039365);
        this.text.invokeAction(0x1020002);
        this.text.invokeAction(0x1020001);
        this.text.invokeAction(16908295);
        this.text.invokeAction(16908296);
        this.text.invokeAction(16908291);
        this.text.invokeAction(16908292);
        this.text.invokeAction(16908293);
        this.text.invokeAction(16908294);
        this.text.invokeAction(17170435);
        this.text.invokeAction(17170436);
        this.text.invokeAction(17170440);
        this.text.invokeAction(17170439);
        this.text.invokeAction(17170437);
        this.text.invokeAction(0x1060006);
        this.text.invokeAction(131199);
        this.text.invokeAction(17039369);
        this.text.invokeAction(16908297);
        this.text.invokeAction(8);
        this.text.invokeAction(127);
        this.text.invokeAction(0x1000009);
        this.text.setText("LineL\r\nLineW");
        this.text.invokeAction(0x1000002);
        Assert.assertEquals((long)7L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000001);
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000008);
        Assert.assertEquals((long)5L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000007);
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000004);
        Assert.assertEquals((long)1L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000006);
        Assert.assertEquals((long)8L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1000005);
        Assert.assertEquals((long)1L, (long)this.text.getCaretOffset());
        this.text.invokeAction(17039367);
        this.text.invokeAction(0x1040004);
        this.text.invokeAction(0x1040004);
        Assert.assertEquals((long)7L, (long)this.text.getCaretOffset());
        this.text.invokeAction(17039363);
        Assert.assertEquals((long)5L, (long)this.text.getCaretOffset());
        this.text.invokeAction(17039368);
        Assert.assertEquals((long)this.text.getCharCount(), (long)this.text.getCaretOffset());
        this.text.invokeAction(17039367);
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        this.text.invokeAction(17039366);
        Assert.assertEquals((long)5L, (long)this.text.getCaretOffset());
        this.text.invokeAction(17039365);
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        this.text.invokeAction(0x1020002);
        Assert.assertEquals((Object)"LineL\r\n", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000008);
        this.text.invokeAction(0x1020001);
        Assert.assertEquals((Object)"\r\nLineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(16908295);
        Assert.assertEquals((Object)"LineL\r\nLineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000007);
        this.text.invokeAction(16908296);
        Assert.assertEquals((Object)"LineL", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000008);
        this.text.invokeAction(16908291);
        Assert.assertEquals((Object)"L", (Object)this.text.getSelectionText());
        this.text.invokeAction(16908292);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.invokeAction(16908293);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.invokeAction(16908294);
        Assert.assertEquals((Object)"\r\nLineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000008);
        this.text.invokeAction(17170435);
        Assert.assertEquals((Object)"LineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000007);
        this.text.invokeAction(17170436);
        Assert.assertEquals((Object)"LineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000007);
        this.text.invokeAction(17170440);
        Assert.assertEquals((Object)"LineW", (Object)this.text.getSelectionText());
        this.text.invokeAction(17170439);
        Assert.assertEquals((Object)"LineL\r\n", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1000007);
        this.text.invokeAction(17170437);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.invokeAction(0x1060006);
        Assert.assertEquals((Object)"LineL", (Object)this.text.getSelectionText());
        this.text.invokeAction(16908296);
        this.text.invokeAction(131199);
        Assert.assertEquals((Object)"\r\nLineW", (Object)this.text.getText());
        this.text.invokeAction(0x1020002);
        this.text.invokeAction(17039369);
        Assert.assertEquals((Object)"\r\nLineW", (Object)this.text.getText());
        this.text.invokeAction(0x1000008);
        this.text.invokeAction(16908297);
        Assert.assertEquals((Object)("\r\nLineW" + PLATFORM_LINE_DELIMITER), (Object)this.text.getText());
        this.text.invokeAction(8);
        Assert.assertEquals((Object)"\r\nLineW", (Object)this.text.getText());
        this.text.invokeAction(17039367);
        this.text.invokeAction(127);
        Assert.assertEquals((Object)"LineW", (Object)this.text.getText());
        this.text.invokeAction(0x1000009);
    }

    @Test
    public void test_paste() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_paste(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_StyledText).");
            }
            return;
        }
        Clipboard clipboard = new Clipboard(this.text.getDisplay());
        TextTransfer transfer = TextTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{"x"}, new Transfer[]{transfer});
        this.text.copy();
        this.text.paste();
        Assert.assertTrue((String)":a:", (this.text.getCharCount() == 1 ? 1 : 0) != 0);
        this.text.setSelectionRange(0, 0);
        this.text.copy();
        this.text.paste();
        Assert.assertTrue((String)":b:", (this.text.getCharCount() == 2 ? 1 : 0) != 0);
        this.text.setText("0123456789");
        this.text.setSelectionRange(0, 1);
        this.text.copy();
        this.text.setCaretOffset(0);
        this.text.paste();
        Assert.assertTrue((String)":c:", (boolean)this.text.getText().equals("00123456789"));
        this.text.setSelectionRange(1, 2);
        this.text.copy();
        this.text.setText("");
        this.text.paste();
        Assert.assertTrue((String)":d:", (boolean)this.text.getText().equals("01"));
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"\rLine1\nLine2\r\nLine3\n\rLine4\n"}, new Transfer[]{transfer});
        this.text.paste();
        String convertedText = SwtTestUtil.isWindowsOS ? "\r\nLine1\r\nLine2\r\nLine3\r\n\r\nLine4\r\n" : "\nLine1\nLine2\nLine3\n\nLine4\n";
        Assert.assertTrue((String)":f:", (this.text.getText() != null && this.text.getText().equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"Line1\r\nLine2"}, new Transfer[]{transfer});
        this.text.paste();
        convertedText = SwtTestUtil.isWindowsOS ? "Line1\r\nLine2" : "Line1\nLine2";
        Assert.assertTrue((String)":g:", (this.text.getText() != null && this.text.getText().equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"Line1\rLine2"}, new Transfer[]{transfer});
        this.text.paste();
        convertedText = SwtTestUtil.isWindowsOS ? "Line1\r\nLine2" : "Line1\nLine2";
        Assert.assertTrue((String)":h:", (this.text.getText() != null && this.text.getText().equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"Line1\nLine2"}, new Transfer[]{transfer});
        this.text.paste();
        convertedText = SwtTestUtil.isWindowsOS ? "Line1\r\nLine2" : "Line1\nLine2";
        Assert.assertTrue((String)":i:", (this.text.getText() != null && this.text.getText().equals(convertedText) ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"abcde"}, new Transfer[]{transfer});
        this.text.setTextLimit(3);
        this.text.copy();
        this.text.paste();
        Assert.assertTrue((String)":j:", (this.text.getText() != null && this.text.getText().equals("abc") ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"abcde"}, new Transfer[]{transfer});
        this.text.setTextLimit(3);
        this.text.setText("123");
        this.text.setSelection(0, 3);
        this.text.paste();
        Assert.assertTrue((String)":k:", (this.text.getText() != null && this.text.getText().equals("abc") ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.setContents((Object[])new String[]{"abcde"}, new Transfer[]{transfer});
        this.text.setTextLimit(3);
        this.text.setText("123");
        this.text.setSelection(0, 1);
        this.text.paste();
        Assert.assertTrue((String)":l:", (this.text.getText() != null && this.text.getText().equals("a23") ? 1 : 0) != 0);
        this.text.setText("");
        clipboard.dispose();
    }

    @Test
    public void test_print() {
        if (Printer.getDefaultPrinterData() == null) {
            return;
        }
    }

    @Test
    public void test_printLorg_eclipse_swt_printing_Printer() {
        if (Printer.getDefaultPrinterData() == null) {
            return;
        }
        boolean exceptionThrown = false;
        try {
            this.text.print(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"no exception thrown for print(null)", (boolean)exceptionThrown);
        Printer printer = new Printer();
        this.text.print(printer);
        this.text.setText("Line1");
        this.text.print(printer);
        printer.dispose();
    }

    @Override
    @Test
    public void test_redraw() {
    }

    @Override
    @Test
    public void test_redrawIIIIZ() {
    }

    @Test
    public void test_redrawRangeIIZ() {
        boolean exceptionThrown;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                exceptionThrown = false;
                                this.text.redrawRange(0, 0, true);
                                this.text.redrawRange(0, 0, false);
                                try {
                                    this.text.redrawRange(0, 1, true);
                                }
                                catch (IllegalArgumentException e) {
                                    if (!e.getMessage().equals("Index out of bounds")) break block12;
                                    exceptionThrown = true;
                                }
                            }
                            Assert.assertTrue((boolean)exceptionThrown);
                            exceptionThrown = false;
                            try {
                                this.text.redrawRange(0, 1, false);
                            }
                            catch (IllegalArgumentException e) {
                                if (!e.getMessage().equals("Index out of bounds")) break block13;
                                exceptionThrown = true;
                            }
                        }
                        Assert.assertTrue((boolean)exceptionThrown);
                        exceptionThrown = false;
                        try {
                            this.text.redrawRange(-1, 2, true);
                        }
                        catch (IllegalArgumentException e) {
                            if (!e.getMessage().equals("Index out of bounds")) break block14;
                            exceptionThrown = true;
                        }
                    }
                    Assert.assertTrue((boolean)exceptionThrown);
                    exceptionThrown = false;
                    try {
                        this.text.redrawRange(-1, 2, false);
                    }
                    catch (IllegalArgumentException e) {
                        if (!e.getMessage().equals("Index out of bounds")) break block15;
                        exceptionThrown = true;
                    }
                }
                Assert.assertTrue((boolean)exceptionThrown);
                this.text.setText("0123456789");
                this.text.redrawRange(0, 0, true);
                this.text.redrawRange(0, 0, false);
                this.text.redrawRange(0, 1, true);
                this.text.redrawRange(0, 1, false);
                this.text.redrawRange(8, 2, true);
                this.text.redrawRange(8, 2, false);
                this.text.redrawRange(10, 0, true);
                this.text.redrawRange(10, 0, false);
                exceptionThrown = false;
                try {
                    this.text.redrawRange(10, 1, true);
                }
                catch (IllegalArgumentException e) {
                    if (!e.getMessage().equals("Index out of bounds")) break block16;
                    exceptionThrown = true;
                }
            }
            Assert.assertTrue((boolean)exceptionThrown);
            exceptionThrown = false;
            try {
                this.text.redrawRange(10, 1, false);
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().equals("Index out of bounds")) break block17;
                exceptionThrown = true;
            }
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void test_removeBidiSegmentListenerLorg_eclipse_swt_custom_BidiSegmentListener() {
    }

    @Test
    public void test_removeExtendedModifyListenerLorg_eclipse_swt_custom_ExtendedModifyListener() {
    }

    @Test
    public void test_removeLineBackgroundListenerLorg_eclipse_swt_custom_LineBackgroundListener() {
    }

    @Test
    public void test_removeLineStyleListenerLorg_eclipse_swt_custom_LineStyleListener() {
    }

    @Test
    public void test_removeModifyListenerLorg_eclipse_swt_events_ModifyListener() {
    }

    @Test
    public void test_removeSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
    }

    @Test
    public void test_removeVerifyListenerLorg_eclipse_swt_events_VerifyListener() {
    }

    @Test
    public void test_removeVerifyKeyListenerLorg_eclipse_swt_custom_VerifyKeyListener() {
    }

    @Test
    public void test_replaceStyleRangesII$Lorg_eclipse_swt_custom_StyleRange() {
        String textString = this.textString();
        this.text.setText(textString);
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(0, 78, new StyleRange[0]);
        StyleRange[] styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":0:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(textString);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":0:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.replaceStyleRanges(0, 78, new StyleRange[0]);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":0:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":0:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":0:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":0:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":0:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(48, 5, new StyleRange[]{this.getStyle(48, 5, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(48, 5, YELLOW, RED)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(10, 10, new StyleRange[]{this.getStyle(10, 10, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(10, 10, YELLOW, RED)));
        Assert.assertTrue((String)":2:", (boolean)styles[2].equals((Object)this.getStyle(20, 28, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[3].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":2:", (boolean)styles[4].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), new StyleRange[0]);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(58, 10, new StyleRange[]{this.getStyle(58, 10, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, YELLOW, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(38, 15, new StyleRange[]{this.getStyle(38, 15, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 38, RED, YELLOW)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(38, 15, YELLOW, RED)));
        Assert.assertTrue((String)":4:", (boolean)styles[2].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":4:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(50, 10, new StyleRange[]{this.getStyle(50, 10, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":5:", (boolean)styles[1].equals((Object)this.getStyle(50, 10, YELLOW, RED)));
        Assert.assertTrue((String)":5:", (boolean)styles[2].equals((Object)this.getStyle(60, 8, BLUE, CYAN)));
        Assert.assertTrue((String)":5:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.replaceStyleRanges(0, this.text.getCharCount(), this.defaultStyles());
        this.text.replaceStyleRanges(48, 20, new StyleRange[]{this.getStyle(48, 20, YELLOW, RED)});
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(48, 20, YELLOW, RED)));
        Assert.assertTrue((String)":6:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        this.text.setText(textString);
        StyleRange[] ranges = new StyleRange[]{this.getStyle(0, 48, RED, YELLOW), this.getStyle(48, 20, BLUE, CYAN), this.getStyle(68, 10, GREEN, PURPLE)};
        this.text.replaceStyleRanges(0, 78, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":7:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":7:", (boolean)styles[1].equals((Object)this.getStyle(48, 20, BLUE, CYAN)));
        Assert.assertTrue((String)":7:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setText("012345678901234");
        ranges = new StyleRange[]{this.getStyle(0, 5, RED, YELLOW), this.getStyle(10, 5, BLUE, CYAN)};
        this.text.replaceStyleRanges(0, 15, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":8:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":8:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":8:", (boolean)styles[1].equals((Object)this.getStyle(10, 5, BLUE, CYAN)));
        this.text.setText("redgreenblueyellowcyanpurple");
        ranges = new StyleRange[]{this.getStyle(0, 3, RED, null), this.getStyle(3, 5, GREEN, null), this.getStyle(8, 4, BLUE, null), this.getStyle(12, 6, YELLOW, null)};
        this.text.replaceStyleRanges(0, 18, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":9:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":9:", (boolean)styles[0].equals((Object)this.getStyle(0, 3, RED, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[1].equals((Object)this.getStyle(3, 5, GREEN, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[2].equals((Object)this.getStyle(8, 4, BLUE, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[3].equals((Object)this.getStyle(12, 6, YELLOW, null)));
        ranges = new StyleRange[]{this.getStyle(18, 4, CYAN, null), this.getStyle(22, 6, PURPLE, null)};
        this.text.replaceStyleRanges(18, 10, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":9:", (styles.length == 6 ? 1 : 0) != 0);
        Assert.assertTrue((String)":9:", (boolean)styles[4].equals((Object)this.getStyle(18, 4, CYAN, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[5].equals((Object)this.getStyle(22, 6, PURPLE, null)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        textString = this.textString();
        this.text.setText(textString);
        ranges = new StyleRange[]{this.getStyle(0, 10, RED, YELLOW), this.getStyle(25, 10, GREEN, PURPLE)};
        this.text.replaceStyleRanges(0, 35, ranges);
        ranges = new StyleRange[]{this.getStyle(5, 15, BLUE, CYAN), this.getStyle(20, 10, GREEN, PURPLE)};
        this.text.replaceStyleRanges(5, 25, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":10:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":10:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":10:", (boolean)styles[1].equals((Object)this.getStyle(5, 15, BLUE, CYAN)));
        Assert.assertTrue((String)":10:", (boolean)styles[2].equals((Object)this.getStyle(20, 15, GREEN, PURPLE)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(0, 10, RED, YELLOW), this.getStyle(10, 10, BLUE, CYAN)};
        this.text.replaceStyleRanges(0, 20, ranges);
        ranges = new StyleRange[]{this.getStyle(5, 3, RED, YELLOW), this.getStyle(12, 5, BLUE, CYAN)};
        this.text.replaceStyleRanges(5, 12, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":11:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":11:", (boolean)styles[0].equals((Object)this.getStyle(0, 8, RED, YELLOW)));
        Assert.assertTrue((String)":11:", (boolean)styles[1].equals((Object)this.getStyle(12, 8, BLUE, CYAN)));
        this.text.setText("0123456789012345");
        ranges = new StyleRange[]{this.getStyle(0, 5, RED, YELLOW), this.getStyle(5, 5, BLUE, CYAN), this.getStyle(10, 5, GREEN, PURPLE)};
        this.text.replaceStyleRanges(0, 15, ranges);
        ranges = new StyleRange[]{this.getStyle(5, 5, RED, YELLOW), this.getStyle(10, 5, RED, YELLOW)};
        this.text.replaceStyleRanges(5, 10, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":12:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":12:", (boolean)styles[0].equals((Object)this.getStyle(0, 15, RED, YELLOW)));
        this.text.setText("0123456789012345");
        ranges = new StyleRange[]{this.getStyle(10, 5, GREEN, PURPLE)};
        this.text.replaceStyleRanges(0, 15, ranges);
        ranges = new StyleRange[]{this.getStyle(0, 5, RED, YELLOW), this.getStyle(5, 5, BLUE, CYAN)};
        this.text.replaceStyleRanges(0, 10, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":13:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":13:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":13:", (boolean)styles[1].equals((Object)this.getStyle(5, 5, BLUE, CYAN)));
        Assert.assertTrue((String)":13:", (boolean)styles[2].equals((Object)this.getStyle(10, 5, GREEN, PURPLE)));
        this.text.setText("012345678901234");
        ranges = new StyleRange[]{this.getStyle(0, 5, RED, YELLOW), this.getStyle(10, 5, BLUE, CYAN)};
        this.text.replaceStyleRanges(0, 15, ranges);
        ranges = new StyleRange[]{this.getStyle(5, 7, BLUE, CYAN)};
        this.text.replaceStyleRanges(5, 7, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":14:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":14:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":14:", (boolean)styles[1].equals((Object)this.getStyle(5, 10, BLUE, CYAN)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        textString = this.textString();
        this.text.setText(textString);
        this.text.setStyleRanges(this.defaultStyles());
        ranges = new StyleRange[]{this.getStyle(38, 25, YELLOW, RED)};
        this.text.replaceStyleRanges(38, 25, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1a:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1a:", (boolean)styles[0].equals((Object)this.getStyle(0, 38, RED, YELLOW)));
        Assert.assertTrue((String)":1a:", (boolean)styles[1].equals((Object)this.getStyle(38, 25, YELLOW, RED)));
        Assert.assertTrue((String)":1a:", (boolean)styles[2].equals((Object)this.getStyle(63, 5, BLUE, CYAN)));
        Assert.assertTrue((String)":1a:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        ranges = new StyleRange[]{this.getStyle(63, 10, YELLOW, RED)};
        this.text.replaceStyleRanges(63, 10, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1a:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1a:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":1a:", (boolean)styles[1].equals((Object)this.getStyle(58, 5, BLUE, CYAN)));
        Assert.assertTrue((String)":1a:", (boolean)styles[2].equals((Object)this.getStyle(63, 10, YELLOW, RED)));
        Assert.assertTrue((String)":1a:", (boolean)styles[3].equals((Object)this.getStyle(73, 5, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        ranges = new StyleRange[]{this.getStyle(0, 78, YELLOW, RED)};
        this.text.replaceStyleRanges(0, 78, ranges);
        styles = this.text.getStyleRanges();
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2a:", (boolean)styles[0].equals((Object)this.getStyle(0, 78, YELLOW, RED)));
        this.text.setStyleRanges(this.defaultStyles());
        ranges = new StyleRange[]{this.getStyle(0, 68, YELLOW, RED)};
        this.text.replaceStyleRanges(0, 68, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2a:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2a:", (boolean)styles[0].equals((Object)this.getStyle(0, 68, YELLOW, RED)));
        Assert.assertTrue((String)":2a:", (boolean)styles[1].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        ranges = new StyleRange[]{this.getStyle(58, 20, YELLOW, RED)};
        this.text.replaceStyleRanges(58, 20, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2a:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2a:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":2a:", (boolean)styles[1].equals((Object)this.getStyle(58, 20, YELLOW, RED)));
        this.text.setText("012345678901234567890123456789");
        this.text.setStyleRanges(new StyleRange[]{this.getStyle(0, 5, RED, RED), this.getStyle(5, 5, YELLOW, YELLOW), this.getStyle(10, 5, CYAN, CYAN), this.getStyle(15, 5, BLUE, BLUE), this.getStyle(20, 5, GREEN, GREEN), this.getStyle(25, 5, PURPLE, PURPLE)});
        ranges = new StyleRange[]{this.getStyle(5, 23, YELLOW, RED)};
        this.text.replaceStyleRanges(5, 23, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3a:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3a:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, RED)));
        Assert.assertTrue((String)":3a:", (boolean)styles[1].equals((Object)this.getStyle(5, 23, YELLOW, RED)));
        Assert.assertTrue((String)":3a:", (boolean)styles[2].equals((Object)this.getStyle(28, 2, PURPLE, PURPLE)));
        this.text.setStyleRanges(new StyleRange[]{this.getStyle(0, 5, RED, RED), this.getStyle(5, 5, YELLOW, YELLOW), this.getStyle(10, 5, CYAN, CYAN), this.getStyle(15, 5, BLUE, BLUE), this.getStyle(20, 5, GREEN, GREEN), this.getStyle(25, 5, PURPLE, PURPLE)});
        ranges = new StyleRange[]{this.getStyle(13, 12, YELLOW, RED)};
        this.text.replaceStyleRanges(13, 12, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3a:", (styles.length == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3a:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, RED)));
        Assert.assertTrue((String)":3a:", (boolean)styles[1].equals((Object)this.getStyle(5, 5, YELLOW, YELLOW)));
        Assert.assertTrue((String)":3a:", (boolean)styles[2].equals((Object)this.getStyle(10, 3, CYAN, CYAN)));
        Assert.assertTrue((String)":3a:", (boolean)styles[3].equals((Object)this.getStyle(13, 12, YELLOW, RED)));
        Assert.assertTrue((String)":3a:", (boolean)styles[4].equals((Object)this.getStyle(25, 5, PURPLE, PURPLE)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(0, 5, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 10, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xa:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xa:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(5, 3, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 10, ranges);
        ranges = new StyleRange[]{this.getStyle(0, 3, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(0, 3, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xb:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xb:", (boolean)styles[0].equals((Object)this.getStyle(0, 3, PURPLE, PURPLE)));
        Assert.assertTrue((String)":1xb:", (boolean)styles[1].equals((Object)this.getStyle(5, 3, RED, YELLOW)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(5, 3, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 10, ranges);
        ranges = new StyleRange[]{this.getStyle(8, 1, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(8, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xc:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xc:", (boolean)styles[0].equals((Object)this.getStyle(5, 3, RED, YELLOW)));
        Assert.assertTrue((String)":1xc:", (boolean)styles[1].equals((Object)this.getStyle(8, 1, PURPLE, PURPLE)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(5, 2, RED, YELLOW), this.getStyle(10, 2, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 20, ranges);
        ranges = new StyleRange[]{this.getStyle(2, 1, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(2, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xe:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xe:", (boolean)styles[0].equals((Object)this.getStyle(2, 1, PURPLE, PURPLE)));
        Assert.assertTrue((String)":1xe:", (boolean)styles[1].equals((Object)this.getStyle(5, 2, RED, YELLOW)));
        Assert.assertTrue((String)":1xe:", (boolean)styles[2].equals((Object)this.getStyle(10, 2, RED, YELLOW)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(5, 2, RED, YELLOW), this.getStyle(10, 2, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 20, ranges);
        ranges = new StyleRange[]{this.getStyle(12, 1, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(12, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xf:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xf:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, RED, YELLOW)));
        Assert.assertTrue((String)":1xf:", (boolean)styles[1].equals((Object)this.getStyle(10, 2, RED, YELLOW)));
        Assert.assertTrue((String)":1xf:", (boolean)styles[2].equals((Object)this.getStyle(12, 1, PURPLE, PURPLE)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(1, 2, RED, YELLOW), this.getStyle(12, 2, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 20, ranges);
        ranges = new StyleRange[]{this.getStyle(5, 3, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(5, 3, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xg:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xg:", (boolean)styles[0].equals((Object)this.getStyle(1, 2, RED, YELLOW)));
        Assert.assertTrue((String)":1xg:", (boolean)styles[1].equals((Object)this.getStyle(5, 3, PURPLE, PURPLE)));
        Assert.assertTrue((String)":1xg:", (boolean)styles[2].equals((Object)this.getStyle(12, 2, RED, YELLOW)));
        this.text.setText("01234567890123456789");
        ranges = new StyleRange[]{this.getStyle(1, 3, RED, PURPLE), this.getStyle(6, 3, PURPLE, YELLOW), this.getStyle(12, 3, RED, YELLOW)};
        this.text.replaceStyleRanges(0, 20, ranges);
        ranges = new StyleRange[]{this.getStyle(4, 2, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(4, 2, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1xh:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1xh:", (boolean)styles[0].equals((Object)this.getStyle(1, 3, RED, PURPLE)));
        Assert.assertTrue((String)":1xh:", (boolean)styles[1].equals((Object)this.getStyle(4, 2, PURPLE, PURPLE)));
        Assert.assertTrue((String)":1xh:", (boolean)styles[2].equals((Object)this.getStyle(6, 3, PURPLE, YELLOW)));
        Assert.assertTrue((String)":1xh:", (boolean)styles[3].equals((Object)this.getStyle(12, 3, RED, YELLOW)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        this.text.setText("0");
        ranges = new StyleRange[]{this.getStyle(0, 1, PURPLE, PURPLE)};
        this.text.replaceStyleRanges(0, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xa:", (styles.length == 1 ? 1 : 0) != 0);
        this.text.setText("01");
        ranges = new StyleRange[]{this.getStyle(0, 1, PURPLE, PURPLE), this.getStyle(1, 1, RED, RED)};
        this.text.replaceStyleRanges(0, 2, ranges);
        ranges = new StyleRange[]{this.getStyle(0, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(0, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xb:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2xb:", (boolean)styles[0].equals((Object)this.getStyle(0, 1, YELLOW, YELLOW)));
        Assert.assertTrue((String)":2xb:", (boolean)styles[1].equals((Object)this.getStyle(1, 1, RED, RED)));
        this.text.setText("01");
        ranges = new StyleRange[]{this.getStyle(0, 1, PURPLE, PURPLE), this.getStyle(1, 1, RED, RED)};
        this.text.replaceStyleRanges(0, 2, ranges);
        ranges = new StyleRange[]{this.getStyle(1, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(1, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xc:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2xc:", (boolean)styles[0].equals((Object)this.getStyle(0, 1, PURPLE, PURPLE)));
        Assert.assertTrue((String)":2xc:", (boolean)styles[1].equals((Object)this.getStyle(1, 1, YELLOW, YELLOW)));
        this.text.setText("012");
        ranges = new StyleRange[]{this.getStyle(0, 1, PURPLE, PURPLE), this.getStyle(1, 1, RED, RED)};
        this.text.replaceStyleRanges(0, 2, ranges);
        ranges = new StyleRange[]{this.getStyle(2, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(2, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xd:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2xd:", (boolean)styles[0].equals((Object)this.getStyle(0, 1, PURPLE, PURPLE)));
        Assert.assertTrue((String)":2xd:", (boolean)styles[1].equals((Object)this.getStyle(1, 1, RED, RED)));
        Assert.assertTrue((String)":2xd:", (boolean)styles[2].equals((Object)this.getStyle(2, 1, YELLOW, YELLOW)));
        this.text.setText("01234");
        ranges = new StyleRange[]{this.getStyle(1, 1, PURPLE, PURPLE), this.getStyle(2, 1, RED, RED), this.getStyle(3, 1, PURPLE, PURPLE)};
        this.text.setStyleRanges(ranges);
        ranges = new StyleRange[]{this.getStyle(4, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(4, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xe:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2xe:", (boolean)styles[3].equals((Object)this.getStyle(4, 1, YELLOW, YELLOW)));
        this.text.setText("01234");
        ranges = new StyleRange[]{this.getStyle(4, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(4, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xf:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2xf:", (boolean)styles[0].equals((Object)this.getStyle(4, 1, YELLOW, YELLOW)));
        this.text.setText("01234");
        ranges = new StyleRange[]{this.getStyle(4, 1, YELLOW, YELLOW)};
        this.text.replaceStyleRanges(4, 1, ranges);
        ranges = new StyleRange[]{};
        this.text.replaceStyleRanges(4, 1, ranges);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2xg:", (styles.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_replaceTextRangeIILjava_lang_String() {
        int defaultTextLength = "line0\n\rline1\n\rline2\n\r".length();
        boolean exceptionThrown = false;
        int newTextLength = "newline0\n\rnewline1".length();
        class TestSelectionListener
        extends SelectionAdapter {
            public Point eventSelection = new Point(0, 0);

            TestSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                this.eventSelection.x = e.x;
                this.eventSelection.y = e.y;
            }
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        this.text.addSelectionListener((SelectionListener)selectionListener);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(15, 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":a:", (this.text.getCharCount() == defaultTextLength + newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (this.text.getSelectionRange().x == 7 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(0, 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":c:", (this.text.getCharCount() == defaultTextLength + newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (this.text.getSelectionRange().x == 7 + newTextLength && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.text.getSelection(), (Object)selectionListener.eventSelection);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(8, 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":e:", (this.text.getCharCount() == defaultTextLength + newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (this.text.getSelectionRange().x == 8 + newTextLength && this.text.getSelectionRange().y == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.text.getSelection(), (Object)selectionListener.eventSelection);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        try {
            this.text.replaceTextRange(-1, 0, "newline0\n\rnewline1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":g:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.replaceTextRange(this.text.getCharCount() + 1, 0, "newline0\n\rnewline1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        exceptionThrown = false;
        try {
            this.text.replaceTextRange(0, 0, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertTrue((String)":h:", (boolean)exceptionThrown);
        Assert.assertTrue((String)":i:", (this.text.getSelectionRange().x == 7 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        exceptionThrown = false;
        this.text.setText("");
        this.text.replaceTextRange(this.text.getCharCount(), 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":j:", (this.text.getCharCount() == newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":k:", (this.text.getSelectionRange().x == 0 && this.text.getSelectionRange().y == 0 ? 1 : 0) != 0);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(this.text.getCharCount(), 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":l:", (this.text.getCharCount() == defaultTextLength + newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":m:", (this.text.getSelectionRange().x == 7 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(this.text.getCharCount(), 0);
        this.text.replaceTextRange(this.text.getCharCount(), 0, "newline0\n\rnewline1");
        Assert.assertTrue((String)":n:", (this.text.getCharCount() == defaultTextLength + newTextLength ? 1 : 0) != 0);
        Assert.assertTrue((String)":o:", (this.text.getSelectionRange().x == this.text.getCharCount() - newTextLength && this.text.getSelectionRange().y == 0 ? 1 : 0) != 0);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(15, 5, "newline0\n\rnewline1");
        Assert.assertTrue((String)":p:", (this.text.getCharCount() == defaultTextLength + newTextLength - 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":q:", (this.text.getSelectionRange().x == 7 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(0, 5, "newline0\n\rnewline1");
        Assert.assertTrue((String)":r:", (this.text.getCharCount() == defaultTextLength + newTextLength - 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":s:", (this.text.getSelectionRange().x == 7 + newTextLength - 5 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.text.getSelection(), (Object)selectionListener.eventSelection);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        this.text.replaceTextRange(8, 5, "newline0\n\rnewline1");
        Assert.assertTrue((String)":t:", (this.text.getCharCount() == defaultTextLength + newTextLength - 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":u:", (this.text.getSelectionRange().x == 8 + newTextLength && this.text.getSelectionRange().y == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.text.getSelection(), (Object)selectionListener.eventSelection);
        this.text.setText("line0\n\rline1\n\rline2\n\r");
        this.text.setSelectionRange(7, 7);
        try {
            this.text.replaceTextRange(-1, 5, "newline0\n\rnewline1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":v:", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.text.replaceTextRange(this.text.getCharCount() + 1, 5, "newline0\n\rnewline1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":w:", (boolean)exceptionThrown);
        Assert.assertTrue((String)":x:", (this.text.getSelectionRange().x == 7 && this.text.getSelectionRange().y == 7 ? 1 : 0) != 0);
        this.text.removeSelectionListener((SelectionListener)selectionListener);
    }

    @Test
    public void test_selectAll() {
        String line = "Line1\rLine2";
        this.text.selectAll();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText(line);
        this.text.selectAll();
        Assert.assertEquals((Object)line, (Object)this.text.getSelectionText());
        this.text.setText("");
        this.text.selectAll();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
    }

    @Override
    @Test
    public void test_setCaretLorg_eclipse_swt_widgets_Caret() {
        Caret caret = new Caret((Canvas)this.text, 0);
        int XINSET = this.isBidiCaret() ? 2 : 0;
        this.text.setCaret(caret);
        Assert.assertEquals((long)XINSET, (long)this.text.getCaret().getLocation().x);
        Assert.assertEquals((long)0L, (long)this.text.getCaret().getLocation().y);
        this.text.setCaret(null);
        this.text.setText("\rLine2");
        this.text.setSelection(2);
        this.text.setTopIndex(0);
        this.text.setCaret(caret);
        Assert.assertTrue((this.text.getCaret().getLocation().x > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getLocation().y);
    }

    @Test
    public void test_setCaretOffsetI() {
        this.text.setCaretOffset(-2);
        Assert.assertTrue((String)":a:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(1);
        Assert.assertTrue((String)":b:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(0);
        Assert.assertTrue((String)":c:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0\r\n");
        this.text.setCaretOffset(-2);
        Assert.assertTrue((String)":d:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(1);
        Assert.assertTrue((String)":e:", (this.text.getCaretOffset() == 1 ? 1 : 0) != 0);
        this.text.setCaretOffset(0);
        Assert.assertTrue((String)":f:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(this.text.getCharCount());
        Assert.assertTrue((String)":g:", (this.text.getCaretOffset() == this.text.getCharCount() ? 1 : 0) != 0);
        this.text.setCaretOffset(this.text.getCharCount() + 1);
        Assert.assertTrue((String)":h:", (this.text.getCaretOffset() == this.text.getCharCount() ? 1 : 0) != 0);
        this.text.setCaretOffset(5);
        Assert.assertTrue((String)":i:", (this.text.getCaretOffset() == 5 ? 1 : 0) != 0);
        this.text.setText("");
        this.text.setCaretOffset(-2);
        Assert.assertTrue((String)":j:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(1);
        Assert.assertTrue((String)":k:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
        this.text.setCaretOffset(0);
        Assert.assertTrue((String)":l:", (this.text.getCaretOffset() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_setContentLorg_eclipse_swt_custom_StyledTextContent() {
        StyledTextContent content = new StyledTextContent(){

            public void addTextChangeListener(TextChangeListener listener) {
            }

            public int getCharCount() {
                return 0;
            }

            public String getLine(int lineIndex) {
                return "";
            }

            public int getLineAtOffset(int offset) {
                return 0;
            }

            public int getLineCount() {
                return 0;
            }

            public String getLineDelimiter() {
                return "";
            }

            public int getOffsetAtLine(int lineIndex) {
                return 0;
            }

            public String getTextRange(int start, int length) {
                return "";
            }

            public void removeTextChangeListener(TextChangeListener listener) {
            }

            public void replaceTextRange(int start, int replaceLength, String text) {
            }

            public void setText(String text) {
            }
        };
        this.text.setContent(content);
        Assert.assertEquals((Object)content, (Object)this.text.getContent());
        boolean exceptionThrown = false;
        try {
            this.text.setContent(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void test_setDoubleClickEnabledZ() {
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((String)":a:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((String)":b:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((String)":d:", (boolean)this.text.getDoubleClickEnabled());
    }

    @Test
    public void test_setEditableZ() {
        this.text.setEditable(true);
        Assert.assertTrue((String)":a:", (boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((String)":b:", (boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((String)":d:", (boolean)this.text.getEditable());
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        FontData fontData = this.text.getFont().getFontData()[0];
        Font font = new Font((Device)this.text.getDisplay(), fontData.getName(), 20, fontData.getStyle());
        this.text.setFont(font);
        int lineHeight = this.text.getLineHeight();
        this.text.setFont(null);
        font.dispose();
        font = new Font((Device)this.text.getDisplay(), fontData.getName(), 25, fontData.getStyle());
        this.text.setFont(font);
        Assert.assertTrue((String)":a:", (this.text.getLineHeight() > lineHeight && font.equals((Object)this.text.getFont()) ? 1 : 0) != 0);
        this.text.setFont(null);
        font.dispose();
    }

    @Test
    public void test_setHorizontalIndexI() {
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":a:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":b:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0");
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":c:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":d:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(500);
        Assert.assertTrue((String)":e:", (this.text.getHorizontalIndex() > 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(-1);
        Assert.assertTrue((String)":f:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":g:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
        this.text.setText("");
        this.text.setHorizontalIndex(2);
        Assert.assertTrue((String)":h:", (this.text.getHorizontalIndex() == 0 ? 1 : 0) != 0);
        this.shell.open();
        this.text.setSize(10, 50);
        this.text.setText("Line0");
        this.text.setHorizontalIndex(1);
        Assert.assertTrue((String)":i:", (this.text.getHorizontalIndex() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test_setHorizontalPixelI() {
        this.text.setHorizontalPixel(-1);
        Assert.assertTrue((String)":a:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalPixel(1);
        Assert.assertTrue((String)":b:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0");
        this.text.setHorizontalPixel(-1);
        Assert.assertTrue((String)":c:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalPixel(1);
        Assert.assertTrue((String)":d:", (this.text.getHorizontalPixel() == 1 ? 1 : 0) != 0);
        this.text.setHorizontalPixel(500);
        Assert.assertTrue((String)":e:", (this.text.getHorizontalPixel() > 0 ? 1 : 0) != 0);
        this.text.setHorizontalPixel(-1);
        Assert.assertTrue((String)":f:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.text.setHorizontalPixel(25);
        Assert.assertTrue((String)":g:", (this.text.getHorizontalPixel() == 25 ? 1 : 0) != 0);
        this.text.setText("");
        this.text.setHorizontalPixel(2);
        Assert.assertTrue((String)":h:", (this.text.getHorizontalPixel() == 0 ? 1 : 0) != 0);
        this.shell.open();
        this.text.setSize(10, 50);
        this.text.setText("Line0");
        this.text.setHorizontalPixel(5);
        Assert.assertTrue((String)":i:", (this.text.getHorizontalPixel() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void test_setLineBackgroundIILorg_eclipse_swt_graphics_Color() {
        String textString = "L1\nL2\nL3\nL4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(1, 5, "");
        Assert.assertTrue((String)":0a:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0a:", (this.text.getLineBackground(1) == this.getColor(GREEN) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(0, 4, "");
        Assert.assertTrue((String)":0b:", (this.text.getLineBackground(0) == this.getColor(YELLOW) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0b:", (this.text.getLineBackground(1) == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0b:", (this.text.getLineBackground(2) == this.getColor(GREEN) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(1, 1, "");
        Assert.assertTrue((String)":0c:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0c:", (this.text.getLineBackground(1) == this.getColor(YELLOW) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0c:", (this.text.getLineBackground(2) == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0c:", (this.text.getLineBackground(3) == this.getColor(GREEN) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(0, 6, "");
        Assert.assertTrue((String)":0d:", (this.text.getLineBackground(0) == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0d:", (this.text.getLineBackground(1) == this.getColor(GREEN) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(1, 3, "");
        Assert.assertTrue((String)":0e:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0e:", (this.text.getLineBackground(1) == this.getColor(BLUE) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0e:", (this.text.getLineBackground(2) == this.getColor(GREEN) ? 1 : 0) != 0);
        textString = "L1\nL2";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(1, 4, "");
        Assert.assertTrue((String)":0a1:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 4, "");
        Assert.assertTrue((String)":0b1:", (this.text.getLineBackground(0) == this.getColor(YELLOW) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(1, 1, "");
        Assert.assertTrue((String)":0c1:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":0c1:", (this.text.getLineBackground(1) == this.getColor(YELLOW) ? 1 : 0) != 0);
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 5, "");
        Assert.assertNull((String)":0d1:", (Object)this.text.getLineBackground(0));
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(1, 3, "");
        Assert.assertTrue((String)":0e1:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertNull((String)":0e1:", (Object)this.text.getLineBackground(1));
        textString = "L1\nL2";
        this.text.setText(textString);
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(1, 4, "");
        Assert.assertNull((String)":0f1:", (Object)this.text.getLineBackground(0));
        this.text.setText(String.valueOf(textString) + "\n");
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 6, "");
        Assert.assertNull((String)":0g1:", (Object)this.text.getLineBackground(0));
        this.text.setText(textString);
        this.text.setLineBackground(0, 0, this.getColor(RED));
        Assert.assertNull((String)":1:", (Object)this.text.getLineBackground(0));
        this.text.setLineBackground(0, 1, this.getColor(RED));
        Assert.assertTrue((String)":1:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        textString = "New Line1\nNew Line2\nNew Line3\nNew Line4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 2, this.getColor(RED));
        this.text.setLineBackground(2, 2, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 0, "\n");
        Assert.assertNull((String)":2:", (Object)this.text.getLineBackground(0));
        Assert.assertTrue((String)":2:", (this.text.getLineBackground(1) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (this.text.getLineBackground(2) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (this.text.getLineBackground(3) == this.getColor(YELLOW) ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (this.text.getLineBackground(4) == this.getColor(YELLOW) ? 1 : 0) != 0);
        textString = "New Line1\nNew Line2\nNew Line3\nNew Line4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 2, this.getColor(RED));
        this.text.setLineBackground(2, 2, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 20, "");
        Assert.assertTrue((String)":3:", (this.text.getLineBackground(0) == this.getColor(YELLOW) ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (this.text.getLineBackground(1) == this.getColor(YELLOW) ? 1 : 0) != 0);
        textString = "Line1\nLine2\nLine3\nLine4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(2, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 18, "");
        Assert.assertNull((String)":4:", (Object)this.text.getLineBackground(0));
        textString = "Line1\nLine2\nLine3\nLine4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(2, 1, this.getColor(YELLOW));
        this.text.replaceTextRange(0, 18, "L1\nL2\nL3\n");
        Assert.assertNull((String)":5:", (Object)this.text.getLineBackground(0));
        Assert.assertNull((String)":5:", (Object)this.text.getLineBackground(1));
        Assert.assertNull((String)":5:", (Object)this.text.getLineBackground(2));
        Assert.assertNull((String)":5:", (Object)this.text.getLineBackground(3));
        textString = "Line1\nLine2\nLine3\nLine4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(3, 9, "L1\nL2\n");
        Assert.assertTrue((String)":6a:", (this.text.getLineBackground(0) == this.getColor(RED) ? 1 : 0) != 0);
        Assert.assertNull((String)":6a:", (Object)this.text.getLineBackground(1));
        textString = "Line1\nLine2\nLine3\nLine4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(11, 11, "L3\nL4");
        Assert.assertNull((String)":6b:", (Object)this.text.getLineBackground(2));
        Assert.assertNull((String)":6b:", (Object)this.text.getLineBackground(3));
        textString = "Line1\nLine2\nLine3\nLine4";
        this.text.setText(textString);
        this.text.setLineBackground(0, 1, this.getColor(RED));
        this.text.setLineBackground(1, 1, this.getColor(YELLOW));
        this.text.setLineBackground(2, 1, this.getColor(BLUE));
        this.text.setLineBackground(3, 1, this.getColor(GREEN));
        this.text.replaceTextRange(0, 18, "L1\n");
        Assert.assertNull((String)":7:", (Object)this.text.getLineBackground(0));
        Assert.assertTrue((String)":7:", (this.text.getLineBackground(1) == this.getColor(GREEN) ? 1 : 0) != 0);
    }

    @Test
    public void test_setSelectionI() {
        int[] invalid = new int[]{-1, 100, 12};
        int i = 0;
        while (i < invalid.length) {
            try {
                this.text.setSelection(invalid[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
        this.text.setText("01234567890");
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        this.text.setSelection(1);
        Assert.assertEquals((long)1L, (long)this.text.getCaretOffset());
        this.text.setSelection(11);
        Assert.assertEquals((long)11L, (long)this.text.getCaretOffset());
        i = 0;
        while (i < invalid.length) {
            try {
                this.text.setSelection(invalid[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
    }

    @Test
    public void test_setSelectionLorg_eclipse_swt_graphics_Point() {
        Point[] invalidRanges = new Point[]{new Point(-1, 0), new Point(-1, -1), new Point(100, 1), new Point(100, -1), new Point(11, 12), new Point(10, 12)};
        int i = 0;
        while (i < invalidRanges.length) {
            try {
                this.text.setSelection(invalidRanges[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 7);
        Assert.assertEquals((Object)"3456", (Object)this.text.getSelectionText());
        i = 0;
        while (i < invalidRanges.length) {
            try {
                this.text.setSelection(invalidRanges[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
    }

    @Test
    public void test_setSelectionII() {
        int end;
        int start;
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-1, -1};
        nArrayArray[2] = new int[]{100, 1};
        nArrayArray[3] = new int[]{100, -1};
        nArrayArray[4] = new int[]{11, 12};
        nArrayArray[5] = new int[]{10, 12};
        nArrayArray[6] = new int[]{2, -3};
        nArrayArray[7] = new int[]{50, -1};
        int[][] invalidRanges = nArrayArray;
        int i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            end = invalidRanges[i][1];
            try {
                this.text.setSelection(start, end);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 7);
        Assert.assertEquals((Object)"3456", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 0);
        Assert.assertEquals((Object)"012", (Object)this.text.getSelectionText());
        Assert.assertEquals((long)0L, (long)this.text.getCaretOffset());
        i = 0;
        while (i < invalidRanges.length) {
            start = invalidRanges[i][0];
            end = invalidRanges[i][1];
            try {
                this.text.setSelection(start, end);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.fail((String)"should not throw exception for out of range");
            }
            ++i;
        }
    }

    @Test
    public void test_addSelectionListener() {
        this.text.setText("0123456789");
        class TestSelectionListener
        extends SelectionAdapter {
            public int counter;
            public Point eventSelection = new Point(0, 0);

            TestSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                this.eventSelection.x = e.x;
                this.eventSelection.y = e.y;
                ++this.counter;
            }
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        this.text.addSelectionListener((SelectionListener)selectionListener);
        Assert.assertEquals((long)0L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(0, 0), (Object)selectionListener.eventSelection);
        this.text.invokeAction(0x1000004);
        Assert.assertEquals((Object)new Point(1, 1), (Object)this.text.getSelection());
        this.text.invokeAction(16908292);
        Assert.assertEquals((long)1L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(1, 2), (Object)selectionListener.eventSelection);
        this.text.invokeAction(16908292);
        Assert.assertEquals((long)2L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(1, 3), (Object)selectionListener.eventSelection);
        this.text.replaceTextRange(0, 1, "a");
        Assert.assertEquals((long)2L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(1, 3), (Object)selectionListener.eventSelection);
        this.text.replaceTextRange(9, 1, "z");
        Assert.assertEquals((long)2L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(1, 3), (Object)selectionListener.eventSelection);
        this.text.replaceTextRange(0, 1, "ab");
        Assert.assertEquals((long)3L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(2, 4), (Object)selectionListener.eventSelection);
        Assert.assertEquals((Object)new Point(2, 4), (Object)this.text.getSelection());
        this.text.invokeAction(0x1000004);
        Assert.assertEquals((long)4L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(4, 4), (Object)selectionListener.eventSelection);
        Assert.assertEquals((Object)new Point(4, 4), (Object)this.text.getSelection());
        this.text.replaceTextRange(0, 2, "a");
        Assert.assertEquals((long)4L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(3, 3), (Object)this.text.getSelection());
        this.text.replaceTextRange(9, 1, "9");
        Assert.assertEquals((long)4L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(3, 3), (Object)this.text.getSelection());
        this.text.replaceTextRange(0, 1, "0");
        Assert.assertEquals((long)4L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(3, 3), (Object)this.text.getSelection());
        this.text.replaceTextRange(0, 9, "");
        Assert.assertEquals((long)4L, (long)selectionListener.counter);
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.text.getSelection());
    }

    @Test
    public void test_setSelectionBackgroundLorg_eclipse_swt_graphics_Color() {
        this.text.setSelectionBackground(this.getColor(YELLOW));
        Assert.assertTrue((String)":1a:", (this.text.getSelectionBackground() == this.getColor(YELLOW) ? 1 : 0) != 0);
        this.text.setSelectionBackground(null);
        Assert.assertTrue((String)":1b:", (boolean)this.text.getSelectionBackground().equals((Object)this.text.getDisplay().getSystemColor(26)));
    }

    @Test
    public void test_setSelectionForegroundLorg_eclipse_swt_graphics_Color() {
        this.text.setSelectionForeground(this.getColor(RED));
        Assert.assertTrue((String)":1a:", (this.text.getSelectionForeground() == this.getColor(RED) ? 1 : 0) != 0);
        this.text.setSelectionForeground(null);
        Assert.assertTrue((String)":1b:", (boolean)this.text.getSelectionForeground().equals((Object)this.text.getDisplay().getSystemColor(27)));
    }

    @Test
    public void test_setSelectionRangeII() {
    }

    @Test
    public void test_setStyleRangeLorg_eclipse_swt_custom_StyleRange() {
        String textString = this.textString();
        this.text.setText(textString);
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(48, 5, YELLOW, RED));
        StyleRange[] styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(48, 5, YELLOW, RED)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(10, 10, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(10, 10, YELLOW, RED)));
        Assert.assertTrue((String)":2:", (boolean)styles[2].equals((Object)this.getStyle(20, 28, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[3].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":2:", (boolean)styles[4].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRange(null);
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(58, 10, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, YELLOW, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(38, 15, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 38, RED, YELLOW)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(38, 15, YELLOW, RED)));
        Assert.assertTrue((String)":4:", (boolean)styles[2].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":4:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(50, 10, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":5:", (boolean)styles[1].equals((Object)this.getStyle(50, 10, YELLOW, RED)));
        Assert.assertTrue((String)":5:", (boolean)styles[2].equals((Object)this.getStyle(60, 8, BLUE, CYAN)));
        Assert.assertTrue((String)":5:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(48, 20, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(48, 20, YELLOW, RED)));
        Assert.assertTrue((String)":6:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 48, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(48, 20, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(68, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(48, 10, RED, YELLOW));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 58, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(15, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(25, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(11, 4, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(11, 14, BLUE, CYAN)));
        Assert.assertTrue((String)":2:", (boolean)styles[2].equals((Object)this.getStyle(25, 10, GREEN, PURPLE)));
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(15, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(25, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(5, 15, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(5, 20, BLUE, CYAN)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(25, 10, GREEN, PURPLE)));
        this.text.setText("01234567890123456789");
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(5, 3, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(12, 5, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(10, 10, BLUE, CYAN)));
        this.text.setText("0123456789012345");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(5, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 5, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(5, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 5, RED, YELLOW));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(0, 15, RED, YELLOW)));
        this.text.setText("012345678901234");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(5, 7, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(5, 10, BLUE, CYAN)));
        this.text.setText("123 456 789");
        this.text.setStyleRange(this.getStyle(4, 3, BLUE, null));
        this.text.setStyleRange(this.getStyle(8, 3, RED, null));
        this.text.setStyleRange(this.getStyle(5, 2, BLUE, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":7:", (boolean)styles[0].equals((Object)this.getStyle(4, 3, BLUE, null)));
        Assert.assertTrue((String)":7:", (boolean)styles[1].equals((Object)this.getStyle(8, 3, RED, null)));
        this.text.setText("123 456 789");
        this.text.setStyleRange(this.getStyle(4, 3, BLUE, null));
        this.text.setStyleRange(this.getStyle(8, 3, RED, null));
        this.text.setStyleRange(this.getStyle(7, 4, BLUE, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":8:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":8:", (boolean)styles[0].equals((Object)this.getStyle(4, 7, BLUE, null)));
        this.text.setText("123 456 789 ABC DEF");
        this.text.setStyleRange(this.getStyle(0, 4, BLUE, null));
        this.text.setStyleRange(this.getStyle(4, 4, RED, null));
        this.text.setStyleRange(this.getStyle(8, 4, BLUE, null));
        this.text.setStyleRange(this.getStyle(12, 4, RED, null));
        this.text.setStyleRange(this.getStyle(16, 3, BLUE, null));
        this.text.setStyleRange(this.getStyle(5, 14, RED, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":9:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":9:", (boolean)styles[0].equals((Object)this.getStyle(0, 4, BLUE, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[1].equals((Object)this.getStyle(4, 15, RED, null)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 48, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(48, 20, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(68, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(38, 20, null, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 38, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setText(textString);
        int length = textString.length();
        this.text.setStyleRange(this.getStyle(0, 48, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(48, 20, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(68, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(0, length, null, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText("01234567890123456789");
        this.text.setStyleRange(this.getStyle(0, 3, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(5, 3, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(9, 8, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(0, 10, GREEN, PURPLE));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 17, GREEN, PURPLE)));
        this.text.setText("0123456789012345");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(5, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 5, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(7, 9, RED, YELLOW));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(5, 2, BLUE, CYAN)));
        Assert.assertTrue((String)":4:", (boolean)styles[2].equals((Object)this.getStyle(7, 9, RED, YELLOW)));
        this.text.setText("012345678901234");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(3, 10, GREEN, PURPLE));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(0, 3, RED, YELLOW)));
        Assert.assertTrue((String)":5:", (boolean)styles[1].equals((Object)this.getStyle(3, 10, GREEN, PURPLE)));
        Assert.assertTrue((String)":5:", (boolean)styles[2].equals((Object)this.getStyle(13, 2, BLUE, CYAN)));
        this.text.setText("redgreenblueyellowcyanpurple");
        this.text.setStyleRange(this.getStyle(0, 3, RED, null));
        this.text.setStyleRange(this.getStyle(3, 5, GREEN, null));
        this.text.setStyleRange(this.getStyle(8, 4, BLUE, null));
        this.text.setStyleRange(this.getStyle(12, 6, YELLOW, null));
        this.text.setStyleRange(this.getStyle(18, 4, CYAN, null));
        this.text.setStyleRange(this.getStyle(22, 6, PURPLE, null));
        this.text.setStyleRange(this.getStyle(8, 14, null, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(0, 3, RED, null)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(3, 5, GREEN, null)));
        Assert.assertTrue((String)":6:", (boolean)styles[2].equals((Object)this.getStyle(8, 14, null, RED)));
        Assert.assertTrue((String)":6:", (boolean)styles[3].equals((Object)this.getStyle(22, 6, PURPLE, null)));
        this.text.setText("redgreenblueyellowcyanpurple");
        this.text.setStyleRange(this.getStyle(0, 3, RED, null));
        this.text.setStyleRange(this.getStyle(3, 5, GREEN, null));
        this.text.setStyleRange(this.getStyle(8, 4, BLUE, null));
        this.text.setStyleRange(this.getStyle(12, 6, YELLOW, null));
        this.text.setStyleRange(this.getStyle(18, 4, CYAN, null));
        this.text.setStyleRange(this.getStyle(22, 6, PURPLE, null));
        this.text.setStyleRange(this.getStyle(0, 28, null, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText("123 456 789");
        this.text.setStyleRange(this.getStyle(4, 3, BLUE, null));
        this.text.setStyleRange(this.getStyle(8, 3, RED, null));
        this.text.setStyleRange(this.getStyle(5, 5, BLUE, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":9:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":9:", (boolean)styles[0].equals((Object)this.getStyle(4, 6, BLUE, null)));
        Assert.assertTrue((String)":9:", (boolean)styles[1].equals((Object)this.getStyle(10, 1, RED, null)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        textString = this.textString();
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 48, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(48, 20, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(68, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(48, 10, RED, YELLOW));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 58, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(58, 10, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(15, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(25, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(11, 4, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(11, 14, BLUE, CYAN)));
        Assert.assertTrue((String)":2:", (boolean)styles[2].equals((Object)this.getStyle(25, 10, GREEN, PURPLE)));
        this.text.setText(textString);
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(15, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(25, 10, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(5, 15, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(5, 20, BLUE, CYAN)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(25, 10, GREEN, PURPLE)));
        this.text.setText("01234567890123456789");
        this.text.setStyleRange(this.getStyle(0, 10, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 10, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(5, 3, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(12, 5, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 10, RED, YELLOW)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(10, 10, BLUE, CYAN)));
        this.text.setText("0123456789012345");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(5, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 5, GREEN, PURPLE));
        this.text.setStyleRange(this.getStyle(5, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 5, RED, YELLOW));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5:", (boolean)styles[0].equals((Object)this.getStyle(0, 15, RED, YELLOW)));
        this.text.setText("012345678901234");
        this.text.setStyleRange(this.getStyle(0, 5, RED, YELLOW));
        this.text.setStyleRange(this.getStyle(10, 5, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(5, 7, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, YELLOW)));
        Assert.assertTrue((String)":6:", (boolean)styles[1].equals((Object)this.getStyle(5, 10, BLUE, CYAN)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        textString = this.textString();
        this.text.setText(textString);
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(38, 25, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 38, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(38, 25, YELLOW, RED)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(63, 5, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[3].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(63, 10, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":1:", (boolean)styles[1].equals((Object)this.getStyle(58, 5, BLUE, CYAN)));
        Assert.assertTrue((String)":1:", (boolean)styles[2].equals((Object)this.getStyle(63, 10, YELLOW, RED)));
        Assert.assertTrue((String)":1:", (boolean)styles[3].equals((Object)this.getStyle(73, 5, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(0, 78, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 78, YELLOW, RED)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(0, 68, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 68, YELLOW, RED)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(68, 10, GREEN, PURPLE)));
        this.text.setStyleRanges(this.defaultStyles());
        this.text.setStyleRange(this.getStyle(58, 20, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(0, 48, RED, YELLOW)));
        Assert.assertTrue((String)":2:", (boolean)styles[1].equals((Object)this.getStyle(58, 20, YELLOW, RED)));
        this.text.setText("012345678901234567890123456789");
        this.text.setStyleRanges(new StyleRange[]{this.getStyle(0, 5, RED, RED), this.getStyle(5, 5, YELLOW, YELLOW), this.getStyle(10, 5, CYAN, CYAN), this.getStyle(15, 5, BLUE, BLUE), this.getStyle(20, 5, GREEN, GREEN), this.getStyle(25, 5, PURPLE, PURPLE)});
        this.text.setStyleRange(this.getStyle(5, 23, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(5, 23, YELLOW, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(28, 2, PURPLE, PURPLE)));
        this.text.setStyleRanges(new StyleRange[]{this.getStyle(0, 5, RED, RED), this.getStyle(5, 5, YELLOW, YELLOW), this.getStyle(10, 5, CYAN, CYAN), this.getStyle(15, 5, BLUE, BLUE), this.getStyle(20, 5, GREEN, GREEN), this.getStyle(25, 5, PURPLE, PURPLE)});
        this.text.setStyleRange(this.getStyle(13, 12, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[1].equals((Object)this.getStyle(5, 5, YELLOW, YELLOW)));
        Assert.assertTrue((String)":3:", (boolean)styles[2].equals((Object)this.getStyle(10, 3, CYAN, CYAN)));
        Assert.assertTrue((String)":3:", (boolean)styles[3].equals((Object)this.getStyle(13, 12, YELLOW, RED)));
        Assert.assertTrue((String)":3:", (boolean)styles[4].equals((Object)this.getStyle(25, 5, PURPLE, PURPLE)));
        this.text.setText("x/");
        this.text.setStyleRange(this.getStyle(0, 2, YELLOW, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, YELLOW, null)));
        this.text.replaceTextRange(2, 0, "/");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, YELLOW, null)));
        this.text.setStyleRange(this.getStyle(0, 1, YELLOW, null));
        Assert.assertTrue((String)":4:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, YELLOW, null)));
        this.text.setStyleRange(this.getStyle(1, 2, RED, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(0, 1, YELLOW, null)));
        Assert.assertTrue((String)":4:", (boolean)styles[1].equals((Object)this.getStyle(1, 2, RED, null)));
        this.text.setText("xxx/");
        this.text.setStyleRange(this.getStyle(0, 2, RED, null));
        this.text.setStyleRange(this.getStyle(2, 2, YELLOW, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4a:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, RED, null)));
        Assert.assertTrue((String)":4a:", (boolean)styles[1].equals((Object)this.getStyle(2, 2, YELLOW, null)));
        this.text.replaceTextRange(4, 0, "/");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4a:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, RED, null)));
        Assert.assertTrue((String)":4a:", (boolean)styles[1].equals((Object)this.getStyle(2, 2, YELLOW, null)));
        this.text.setStyleRange(this.getStyle(2, 1, YELLOW, null));
        Assert.assertTrue((String)":4a:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, RED, null)));
        Assert.assertTrue((String)":4a:", (boolean)styles[1].equals((Object)this.getStyle(2, 2, YELLOW, null)));
        this.text.setStyleRange(this.getStyle(3, 2, RED, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4a:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(0, 2, RED, null)));
        Assert.assertTrue((String)":4a:", (boolean)styles[1].equals((Object)this.getStyle(2, 1, YELLOW, null)));
        Assert.assertTrue((String)":4a:", (boolean)styles[2].equals((Object)this.getStyle(3, 2, RED, null)));
        this.text.setText("xxx/");
        this.text.setStyleRange(this.getStyle(0, 2, RED, null));
        this.text.setStyleRange(this.getStyle(2, 2, YELLOW, null));
        this.text.replaceTextRange(4, 0, "/");
        styles = this.text.getStyleRanges();
        this.text.setStyleRange(this.getStyle(2, 1, YELLOW, null));
        this.text.setStyleRange(this.getStyle(2, 3, RED, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4b:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4b:", (boolean)styles[0].equals((Object)this.getStyle(0, 5, RED, null)));
        this.text.setText("xxx/");
        this.text.setStyleRange(this.getStyle(0, 2, RED, null));
        this.text.setStyleRange(this.getStyle(2, 2, YELLOW, null));
        this.text.replaceTextRange(4, 0, "/");
        styles = this.text.getStyleRanges();
        this.text.setStyleRange(this.getStyle(2, 1, YELLOW, null));
        this.text.setStyleRange(this.getStyle(1, 4, YELLOW, null));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4c:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4c:", (boolean)styles[0].equals((Object)this.getStyle(0, 1, RED, null)));
        Assert.assertTrue((String)":4c:", (boolean)styles[1].equals((Object)this.getStyle(1, 4, YELLOW, null)));
        this.text.setText("New\r\n");
        StyleRange style = this.getStyle(0, 5, null, null);
        style.fontStyle = 1;
        this.text.setStyleRange(style);
        this.text.replaceTextRange(3, 0, "a");
        style = this.text.getStyleRangeAtOffset(4);
        style.start = 3;
        style.length = 1;
        this.text.setStyleRange(style);
        this.text.replaceTextRange(0, 0, "a");
        style = this.text.getStyleRangeAtOffset(1);
        style.start = 0;
        style.length = 1;
        this.text.setStyleRange(style);
        this.text.replaceTextRange(0, 1, "");
        int i = 0;
        while (i < 6) {
            style = this.text.getStyleRangeAtOffset(i);
            Assert.assertTrue((String)":5:", (style.fontStyle == 1 ? 1 : 0) != 0);
            ++i;
        }
        this.text.setText("New L 1\r\nNew L 2\r\n");
        style = this.getStyle(0, 9, null, null);
        style.fontStyle = 1;
        this.text.setStyleRange(style);
        this.text.replaceTextRange(7, 0, "a");
        style = this.text.getStyleRangeAtOffset(8);
        if (style != null) {
            style.start = 7;
            style.length = 1;
            this.text.setStyleRange(style);
        }
        this.text.replaceTextRange(4, 0, "a");
        style = this.text.getStyleRangeAtOffset(5);
        if (style != null) {
            style.start = 4;
            style.length = 1;
            this.text.setStyleRange(style);
        }
        this.text.replaceTextRange(2, 3, "");
        i = 0;
        while (i < 8) {
            style = this.text.getStyleRangeAtOffset(i);
            Assert.assertTrue((String)":5a:", (style.fontStyle == 1 ? 1 : 0) != 0);
            ++i;
        }
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        textString = "1234 1234 1234";
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(5, 2, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1a:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(7, 2, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2a:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(6, 2, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3a:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(3, 4, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4a:", (boolean)styles[0].equals((Object)this.getStyle(3, 6, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(7, 4, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5a:", (boolean)styles[0].equals((Object)this.getStyle(5, 6, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6a:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(3, 10, YELLOW, RED));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7a:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":7a:", (boolean)styles[0].equals((Object)this.getStyle(3, 10, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(5, 2, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1b:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1b:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, BLUE, CYAN)));
        Assert.assertTrue((String)":1b:", (boolean)styles[1].equals((Object)this.getStyle(7, 2, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(7, 2, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2b:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2b:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, YELLOW, RED)));
        Assert.assertTrue((String)":2b:", (boolean)styles[1].equals((Object)this.getStyle(7, 2, BLUE, CYAN)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(6, 2, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3b:", (styles.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3b:", (boolean)styles[0].equals((Object)this.getStyle(5, 1, YELLOW, RED)));
        Assert.assertTrue((String)":3b:", (boolean)styles[1].equals((Object)this.getStyle(6, 2, BLUE, CYAN)));
        Assert.assertTrue((String)":3b:", (boolean)styles[2].equals((Object)this.getStyle(8, 1, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(3, 4, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4b:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4b:", (boolean)styles[0].equals((Object)this.getStyle(3, 4, BLUE, CYAN)));
        Assert.assertTrue((String)":4b:", (boolean)styles[1].equals((Object)this.getStyle(7, 2, YELLOW, RED)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(7, 4, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5b:", (styles.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":5b:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, YELLOW, RED)));
        Assert.assertTrue((String)":5b:", (boolean)styles[1].equals((Object)this.getStyle(7, 4, BLUE, CYAN)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6b:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":6b:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, BLUE, CYAN)));
        this.text.setText("1234 1234 1234");
        this.text.setStyleRange(this.getStyle(5, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(3, 10, BLUE, CYAN));
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7b:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":7b:", (boolean)styles[0].equals((Object)this.getStyle(3, 10, BLUE, CYAN)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        String testString = "1234 1234 1234 1234 1234";
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(12, 2, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":1:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (boolean)styles[0].equals((Object)this.getStyle(10, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(10, 2, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":2:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)styles[0].equals((Object)this.getStyle(10, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(12, 4, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":3:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":3:", (boolean)styles[0].equals((Object)this.getStyle(10, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(8, 4, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":4:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":4:", (boolean)styles[0].equals((Object)this.getStyle(8, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(8, 6, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":5:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(10, 6, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":6:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(8, 12, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":7:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(5, 7, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":8:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":8:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(7, 7, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":9:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":9:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, BLUE, CYAN)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(2, 10, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":10:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":10:", (boolean)styles[0].equals((Object)this.getStyle(2, 2, YELLOW, RED)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(7, 9, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":11:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":11:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, BLUE, CYAN)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(5, 9, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":12:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.replaceTextRange(3, 13, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":11:", (styles.length == 0 ? 1 : 0) != 0);
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(15, 4, GREEN, PURPLE));
        this.text.replaceTextRange(7, 12, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":14:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":14:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, BLUE, CYAN)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(15, 4, GREEN, PURPLE));
        this.text.replaceTextRange(5, 12, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":15:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":15:", (boolean)styles[0].equals((Object)this.getStyle(5, 2, GREEN, PURPLE)));
        this.text.setText(testString);
        this.text.setStyleRange(this.getStyle(5, 4, BLUE, CYAN));
        this.text.setStyleRange(this.getStyle(10, 4, YELLOW, RED));
        this.text.setStyleRange(this.getStyle(15, 4, GREEN, PURPLE));
        this.text.replaceTextRange(9, 10, "");
        styles = this.text.getStyleRanges();
        Assert.assertTrue((String)":16:", (styles.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)":16:", (boolean)styles[0].equals((Object)this.getStyle(5, 4, BLUE, CYAN)));
        this.text.dispose();
        this.text = new StyledText((Composite)this.shell, 0);
        this.setWidget((Widget)this.text);
        StyleRange style1 = this.getStyle(0, 0, null, null);
        StyleRange style2 = this.getStyle(0, 0, RED, YELLOW);
        Assert.assertTrue((String)":1:", (!style1.equals((Object)style2) ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (!style1.similarTo(style2) ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (!style2.equals((Object)style1) ? 1 : 0) != 0);
        Assert.assertTrue((String)":1:", (!style2.similarTo(style1) ? 1 : 0) != 0);
        style1 = this.getStyle(0, 10, RED, YELLOW);
        style2 = this.getStyle(11, 5, RED, YELLOW);
        Assert.assertTrue((String)":2:", (!style1.equals((Object)style2) ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (!style2.equals((Object)style1) ? 1 : 0) != 0);
        Assert.assertTrue((String)":2:", (boolean)style1.similarTo(style2));
        Assert.assertTrue((String)":2:", (boolean)style2.similarTo(style1));
    }

    @Test
    public void test_setStyleRanges$Lorg_eclipse_swt_custom_StyleRange() {
        boolean exceptionThrown = false;
        StyleRange[] ranges = new StyleRange[]{new StyleRange(0, 1, this.getColor(RED), null), new StyleRange(2, 1, this.getColor(RED), null)};
        this.text.setText("Line0\r\n");
        try {
            this.text.setStyleRanges(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        this.text.setStyleRanges(ranges);
        StyleRange[] currentRanges = this.text.getStyleRanges();
        Assert.assertEquals((long)ranges.length, (long)currentRanges.length);
        int i = 0;
        while (i < currentRanges.length) {
            Assert.assertEquals((Object)ranges[i], (Object)currentRanges[i]);
            ++i;
        }
        this.text.setStyleRanges(new StyleRange[0]);
        Assert.assertEquals((long)0L, (long)this.text.getStyleRanges().length);
    }

    @Test
    public void test_setTabsI() {
        this.text.setTabs(1);
        Assert.assertTrue((String)":a:", (this.text.getTabs() == 1 ? 1 : 0) != 0);
        this.text.setTabs(8);
        Assert.assertTrue((String)":b:", (this.text.getTabs() == 8 ? 1 : 0) != 0);
        this.text.setText("Line\t1\r\n");
        this.text.setTabs(7);
        Assert.assertTrue((String)":c:", (this.text.getTabs() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void test_setTextLjava_lang_String() {
        boolean exceptionThrown = false;
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        try {
            this.text.setText(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
    }

    @Test
    public void test_setTextLimitI() {
        boolean exceptionThrown = false;
        this.text.setTextLimit(10);
        Assert.assertTrue((String)":a:", (this.text.getTextLimit() == 10 ? 1 : 0) != 0);
        this.text.setTextLimit(-1);
        Assert.assertTrue((String)":b:", (this.text.getTextLimit() == -1 ? 1 : 0) != 0);
        try {
            this.text.setTextLimit(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)":c:", (boolean)exceptionThrown);
        exceptionThrown = false;
    }

    @Test
    public void test_setTopIndexI() {
        this.text.setTopIndex(-1);
        Assert.assertTrue((String)":a:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":b:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0\r\nLine0a\r\n");
        this.text.setTopIndex(-2);
        Assert.assertTrue((String)":c:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(-1);
        Assert.assertTrue((String)":d:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(1);
        Assert.assertTrue((String)":e:", (this.text.getTopIndex() == 1 ? 1 : 0) != 0);
        this.text.setTopIndex(2);
        Assert.assertTrue((String)":f:", (this.text.getTopIndex() == 2 ? 1 : 0) != 0);
        this.text.setTopIndex(0);
        Assert.assertTrue((String)":g:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
        this.text.setTopIndex(3);
        Assert.assertTrue((String)":h:", (this.text.getTopIndex() == 2 ? 1 : 0) != 0);
        this.text.setText("");
        this.text.setTopIndex(2);
        Assert.assertTrue((String)":i:", (this.text.getTopIndex() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_setTopPixelI() {
        int lineHeight = this.text.getLineHeight();
        this.text.setTopPixel(-1);
        Assert.assertTrue((String)":a:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopPixel(1);
        Assert.assertTrue((String)":b:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setText("Line0\r\n");
        this.text.setTopPixel(-2);
        Assert.assertTrue((String)":c:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopPixel(-1);
        Assert.assertTrue((String)":d:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopPixel(1);
        Assert.assertTrue((String)":e:", (this.text.getTopPixel() == 1 ? 1 : 0) != 0);
        this.text.setTopPixel(2 * lineHeight);
        Assert.assertTrue((String)":f:", (this.text.getTopPixel() == 2 * lineHeight ? 1 : 0) != 0);
        this.text.setTopPixel(0);
        Assert.assertTrue((String)":g:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
        this.text.setTopPixel(3 * lineHeight);
        Assert.assertTrue((String)":h:", (this.text.getTopPixel() == 2 * lineHeight ? 1 : 0) != 0);
        this.text.setText("");
        this.text.setTopPixel(2 * lineHeight);
        Assert.assertTrue((String)":i:", (this.text.getTopPixel() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_setWordWrapZ() {
        String testString = "Line1\nLine2";
        this.text.setWordWrap(true);
        Assert.assertTrue((String)":a:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(false);
        Assert.assertFalse((String)":b:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(false);
        Assert.assertFalse((String)":c:", (boolean)this.text.getWordWrap());
        this.text.setWordWrap(true);
        Assert.assertTrue((String)":d:", (boolean)this.text.getWordWrap());
        this.text.setText(testString);
        Assert.assertEquals((String)":e:", (Object)testString, (Object)this.text.getText());
        Assert.assertEquals((String)":f:", (long)2L, (long)this.text.getLineCount());
    }

    @Test
    public void test_showSelection() {
        this.text.showSelection();
        this.text.setSelectionRange(0, 0);
        this.text.showSelection();
        this.text.setText("Line0\r\n");
        this.text.showSelection();
        this.text.setSelectionRange(5, 2);
        this.text.showSelection();
    }

    @Test
    public void test_isTextSelected() {
        this.text.setText("Sample Text Selection");
        Assert.assertFalse((boolean)this.text.isTextSelected());
        this.text.setSelection(0, this.text.getCharCount());
        Assert.assertTrue((boolean)this.text.isTextSelected());
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < 500) {
            buffer.append("Sample Test Selection" + System.getProperty("line.separator"));
            ++i;
        }
        this.text.setText(buffer.toString());
        this.text.setSize(100, 10000);
        this.text.setBlockSelection(true);
        this.text.setBlockSelectionBounds(0, 0, 100, 10000);
        Assert.assertTrue((boolean)this.text.isTextSelected());
        this.text.setText(System.getProperty("line.separator"));
        this.text.setSize(100, 100);
        this.text.setBlockSelection(true);
        this.text.setBlockSelectionBounds(0, 0, 100, 100);
        Assert.assertTrue((boolean)this.text.isTextSelected());
    }

    @Test
    public void test_clickUpdatesCaretPosition() {
        this.text.setText("1\n2\n3\n");
        Event event = new Event();
        event.button = 1;
        event.count = 1;
        event.x = 0;
        event.y = this.text.getLinePixel(1);
        this.text.notifyListeners(3, event);
        Assert.assertEquals((long)2L, (long)this.text.getCaretOffset());
    }

    @Test
    public void test_caretSizeAndPositionVariableGlyphMetrics() {
        this.text.setText("abcd");
        this.text.setMargins(2, 0, 0, 0);
        this.text.setLineSpacing(0);
        StyleRange range = new StyleRange(2, 1, null, null);
        range.metrics = new GlyphMetrics(100, 0, 10);
        this.text.setStyleRange(range);
        this.text.setCaretOffset(0);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(1);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(2);
        Assert.assertEquals((long)this.text.getLineHeight(0), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)0L, (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(3);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(4);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(3);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(2);
        Assert.assertEquals((long)this.text.getLineHeight(0), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)0L, (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(1);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
        this.text.setCaretOffset(0);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getCaret().getSize().y);
        Assert.assertEquals((long)(this.text.getLineHeight(0) - this.text.getCaret().getSize().y), (long)this.text.getCaret().getBounds().y);
    }

    @Test
    public void test_doubleClickSelectsWord() {
        this.text.setText("Test1 Test2");
        Event event = new Event();
        event.button = 1;
        event.count = 2;
        event.x = 0;
        event.y = 0;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"Test1", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_doubleClickWithRightMouseButtonDoesNotSelectWord() {
        this.text.setText("Test1 Test2");
        Event event = new Event();
        event.button = 3;
        event.count = 2;
        event.x = 0;
        event.y = 0;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_doubleClickDoesNotSelectIfDoubleClickIsDisabled() {
        this.text.setText("Test1 Test2");
        this.text.setDoubleClickEnabled(false);
        Event event = new Event();
        event.button = 1;
        event.count = 2;
        event.x = 0;
        event.y = 0;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_trippleClickSelectsSentance() {
        this.text.setText("Test1 Test2\nTest3 Test4");
        Event event = new Event();
        event.button = 1;
        event.count = 3;
        event.x = 0;
        event.y = 0;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"Test1 Test2\n", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_trippleClickOnLastLineSelectsSentance() {
        this.text.setText("Test1 Test2\nTest3 Test4");
        Event event = new Event();
        event.button = 1;
        event.count = 3;
        event.x = 0;
        event.y = this.text.getLinePixel(1);
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"Test3 Test4", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_trippleClickDoesNotSelectIfDoubleClickIsDisabled() {
        this.text.setText("Test1 Test2\nTest3 Test4");
        this.text.setDoubleClickEnabled(false);
        Event event = new Event();
        event.button = 1;
        event.count = 3;
        event.x = 0;
        event.y = 0;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_isTextSelectedInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        Assert.assertTrue((boolean)this.text.isTextSelected());
        Assert.assertEquals((Object)("Sample" + System.getProperty("line.separator") + "Sample" + System.getProperty("line.separator") + "Sample"), (Object)this.text.getSelectionText());
    }

    @Test
    public void test_isTextSelectedInBlockSelectionForLingleEmptyLine() {
        this.text.setText(System.getProperty("line.separator"));
        this.text.setSize(100, 100);
        this.text.setBlockSelection(true);
        this.text.setBlockSelectionBounds(0, 0, 100, 100);
        Assert.assertTrue((boolean)this.text.isTextSelected());
    }

    @Test
    public void test_selectionIsClearedOnCaretMoveWhenInBlockSelection() {
        this.text.setText("Test" + System.getProperty("line.separator"));
        this.text.setSize(100, 100);
        this.text.setBlockSelection(true);
        this.text.setBlockSelectionBounds(0, 0, 100, 100);
        Assert.assertTrue((boolean)this.text.isTextSelected());
        this.text.setCaretOffset(1);
        Assert.assertFalse((boolean)this.text.isTextSelected());
    }

    @Test
    public void test_setBlockSelectionBounds_updatesNormalSelectionIfNotInBlockMode() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(false);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        Assert.assertTrue((boolean)this.text.isTextSelected());
        Assert.assertEquals((Object)(String.valueOf(this.blockSelectionTestTextOneLine()) + this.blockSelectionTestTextOneLine() + "Sample"), (Object)this.text.getSelectionText());
    }

    @Test
    public void test_selectionIsMaintainedOnDisableOfBlockSelection() {
        this.text.setText("Test" + System.getProperty("line.separator"));
        this.text.setSize(100, 100);
        this.text.setBlockSelection(true);
        this.text.setBlockSelectionBounds(0, 0, 100, 100);
        Assert.assertTrue((boolean)this.text.isTextSelected());
        this.text.setBlockSelection(false);
        Assert.assertTrue((boolean)this.text.isTextSelected());
    }

    @Test
    public void test_selectAllInBlockSelectionMode() {
        this.text.setText("Test" + System.getProperty("line.separator"));
        this.text.setSize(100, 100);
        this.text.setBlockSelection(true);
        this.text.selectAll();
        Assert.assertTrue((boolean)this.text.isTextSelected());
        Assert.assertEquals((Object)("Test" + System.getProperty("line.separator")), (Object)this.text.getSelectionText());
    }

    @Test
    public void test_cutTextInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        this.text.cut();
        Assert.assertTrue((String)this.text.getText(), (boolean)this.text.getText().startsWith(" Test Selection" + System.getProperty("line.separator") + " Test Selection" + System.getProperty("line.separator") + " Test Selection" + System.getProperty("line.separator") + "Sample Test Selection" + System.getProperty("line.separator")));
    }

    @Test
    public void test_pasteInsertsTextInBlockSelectionAsBlock() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        this.text.copy();
        this.text.setCaretOffset(0);
        this.text.paste();
        Assert.assertTrue((String)this.text.getText(), (boolean)this.text.getText().startsWith("Sample" + this.blockSelectionTestTextOneLine() + "Sample" + this.blockSelectionTestTextOneLine() + "Sample" + this.blockSelectionTestTextOneLine() + this.blockSelectionTestTextOneLine()));
    }

    @Test
    public void test_cutAndPasteInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        this.text.cut();
        this.text.paste();
        Assert.assertTrue((String)this.text.getText(), (boolean)this.text.getText().startsWith(String.valueOf(this.blockSelectionTestTextOneLine()) + this.blockSelectionTestTextOneLine() + this.blockSelectionTestTextOneLine() + this.blockSelectionTestTextOneLine()));
    }

    @Test
    public void test_trippleClickInBlockSelectionSelectsLine() {
        this.text.setText("  Sample Test Selection  " + System.getProperty("line.separator") + "  Sample Test Selection  " + System.getProperty("line.separator"));
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(3);
        Event event = new Event();
        event.button = 1;
        event.count = 3;
        event.x = lowerRight.x;
        event.y = lowerRight.y;
        this.text.notifyListeners(3, event);
        Assert.assertEquals((Object)"  Sample Test Selection  ", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_getSelectionRangesInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        int[] nArray = new int[6];
        nArray[1] = 6;
        nArray[2] = 21 + System.getProperty("line.separator").length();
        nArray[3] = 6;
        nArray[4] = 42 + System.getProperty("line.separator").length() * 2;
        nArray[5] = 6;
        Assert.assertArrayEquals((int[])nArray, (int[])this.text.getSelectionRanges());
    }

    @Test
    public void test_getSelectionCountInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y + 1);
        Assert.assertEquals((long)(18 + System.getProperty("line.separator").length() * 2), (long)this.text.getSelectionCount());
    }

    @Test
    public void test_getBlockSelectionlundsInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        Point lowerRight = this.text.getLocationAtOffset(this.blockSelectionTestTextOneLine().length() * 2 + 6);
        this.text.setBlockSelectionBounds(0, 0, lowerRight.x, lowerRight.y);
        Assert.assertEquals((Object)new Rectangle(0, 0, lowerRight.x, lowerRight.y), (Object)this.text.getBlockSelectionBounds());
    }

    @Test
    public void test_insertInBlockSelection() {
        this.text.setText(this.blockSelectionTestText());
        this.text.setSize(1000, 1000);
        this.text.setBlockSelection(true);
        this.text.setSelection(6, 6 + this.blockSelectionTestTextOneLine().length());
        this.text.insert("Foo" + System.getProperty("line.separator") + "Foo" + System.getProperty("line.separator"));
        Assert.assertTrue((String)this.text.getText(), (boolean)this.text.getText().startsWith("SampleFoo Test Selection" + System.getProperty("line.separator") + "SampleFoo Test Selection" + System.getProperty("line.separator") + "Sample Test Selection" + System.getProperty("line.separator")));
    }

    @Test
    public void test_setStyleRanges_render() throws InterruptedException {
        Assume.assumeFalse((String)"Bug 536588 prevents test to work on Mac", (boolean)SwtTestUtil.isCocoa);
        this.shell.setVisible(true);
        this.text.setText("abc");
        this.text.setMargins(0, 0, 0, 0);
        this.text.pack();
        this.processEvents(1000, () -> this.hasPixel(this.text, this.text.getBackground()) && !this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
        Assert.assertTrue((boolean)this.hasPixel(this.text, this.text.getBackground()));
        Assert.assertFalse((boolean)this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
        this.text.setStyleRanges(new StyleRange[]{new StyleRange(0, 1, null, this.text.getDisplay().getSystemColor(3)), new StyleRange(2, 1, null, this.text.getDisplay().getSystemColor(3))});
        this.processEvents(100, () -> this.hasPixel(this.text, this.text.getBackground()) && this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
        Assert.assertTrue((boolean)this.hasPixel(this.text, this.text.getBackground()));
        Assert.assertTrue((boolean)this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
        this.text.replaceStyleRanges(0, 3, new StyleRange[]{new StyleRange(0, 3, null, this.text.getDisplay().getSystemColor(3))});
        this.processEvents(1000, () -> !this.hasPixel(this.text, this.text.getBackground()) && this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
        Assert.assertFalse((boolean)this.hasPixel(this.text, this.text.getBackground()));
        Assert.assertTrue((boolean)this.hasPixel(this.text, this.text.getDisplay().getSystemColor(3)));
    }

    private boolean hasPixel(StyledText text, Color expectedColor) {
        GC gc = new GC((Drawable)text);
        Image image = new Image((Device)text.getDisplay(), text.getSize().x, text.getSize().y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData imageData = image.getImageData();
        RGB expectedRGB = expectedColor.getRGB();
        int x = 1;
        while (x < image.getBounds().width - 1) {
            int y = 0;
            while (y < image.getBounds().height) {
                RGB pixelRGB = imageData.palette.getRGB(imageData.getPixel(x, y));
                if (expectedRGB.equals((Object)pixelRGB)) {
                    image.dispose();
                    return true;
                }
                ++y;
            }
            ++x;
        }
        image.dispose();
        return false;
    }

    private String blockSelectionTestText() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < 20) {
            buffer.append(this.blockSelectionTestTextOneLine());
            ++i;
        }
        return buffer.toString();
    }

    private String blockSelectionTestTextOneLine() {
        return "Sample Test Selection" + System.getProperty("line.separator");
    }

    protected void rtfCopy() {
        String lines = "Line0\nLine1\nLine2\nLine3\nLine4\nLine5";
        int[] linesCalled = new int[1];
        LineStyleListener listener = event -> {
            Display display = Display.getDefault();
            Color red = display.getSystemColor(3);
            StyledText styledText = (StyledText)event.widget;
            int lineIndex = styledText.getLineAtOffset(event.lineOffset);
            int lineStart = event.lineOffset;
            int lineEnd = lineStart + event.lineText.length();
            StyleRange goodRange = new StyleRange(0, 1, red, red);
            event.styles = new StyleRange[2];
            switch (lineIndex % 6) {
                case 0: {
                    event.styles[0] = goodRange;
                    event.styles[1] = new StyleRange(lineEnd, 1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                    break;
                }
                case 1: {
                    event.styles[0] = goodRange;
                    event.styles[1] = new StyleRange(lineEnd, -1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                    break;
                }
                case 2: {
                    event.styles[0] = goodRange;
                    event.styles[1] = new StyleRange(lineEnd - 1, -1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                    break;
                }
                case 3: {
                    event.styles[0] = goodRange;
                    event.styles[1] = new StyleRange(lineStart, -1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                    break;
                }
                case 4: {
                    event.styles[0] = new StyleRange(lineStart, 1, red, red);
                    event.styles[1] = new StyleRange(lineStart, -1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                    break;
                }
                case 5: {
                    event.styles[0] = new StyleRange(lineEnd / 2, 1, red, red);
                    event.styles[1] = new StyleRange(lineEnd / 2, -1, red, red);
                    nArray[0] = linesCalled[0] + 1;
                }
            }
        };
        this.text.setText(lines);
        this.text.setSelection(0, this.text.getCharCount());
        this.text.addLineStyleListener(listener);
        linesCalled[0] = 0;
        this.text.copy();
        Assert.assertTrue((String)"not all lines tested for RTF copy", (linesCalled[0] == this.text.getLineCount() ? 1 : 0) != 0);
        Clipboard clipboard = new Clipboard(this.text.getDisplay());
        RTFTransfer rtfTranfer = RTFTransfer.getInstance();
        String clipboardText = (String)clipboard.getContents((Transfer)rtfTranfer);
        Assert.assertTrue((String)"RTF copy failed", (clipboardText.length() > 0 ? 1 : 0) != 0);
        clipboard.dispose();
        this.text.removeLineStyleListener(listener);
    }

    @Test
    public void test_consistency_Modify() {
        this.consistencyEvent(97, 0, 0, 0, 10);
    }

    @Override
    @Test
    public void test_consistency_MenuDetect() {
        this.consistencyEvent(10, 10, 3, 1, 30);
    }

    @Override
    @Test
    public void test_consistency_DragDetect() {
        this.consistencyEvent(30, 10, 50, 0, 50);
    }

    private class RecordingMovementListener
    implements MovementListener {
        private RecordingMovementListener() {
        }

        public void getPreviousOffset(MovementEvent event) {
            Test_org_eclipse_swt_custom_StyledText.this.listenerCalled = true;
        }

        public void getNextOffset(MovementEvent event) {
            Test_org_eclipse_swt_custom_StyledText.this.listener2Called = true;
        }
    }
}

