/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_ImageLoader {
    boolean loaderListenerCalled;

    @Test
    public void test_Constructor() {
        new ImageLoader();
    }

    @Test
    public void test_addImageLoaderListenerLorg_eclipse_swt_graphics_ImageLoaderListener() {
        InputStream stream;
        Object var4_6;
        Throwable throwable;
        ImageLoader loader = new ImageLoader();
        ImageLoaderListener loaderListener = e -> {
            boolean bl = this.loaderListenerCalled = true;
        };
        try {
            loader.addImageLoaderListener(null);
            Assert.fail((String)"No exception thrown for addImageLoaderListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertFalse((String)":a:", (boolean)loader.hasListeners());
        loader.addImageLoaderListener(loaderListener);
        Assert.assertTrue((String)":b:", (boolean)loader.hasListeners());
        this.loaderListenerCalled = false;
        try {
            throwable = null;
            var4_6 = null;
            try {
                stream = SwtTestUtil.class.getResourceAsStream("interlaced_target.png");
                try {
                    loader.load(stream);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        Assert.assertTrue((String)":c:", (boolean)this.loaderListenerCalled);
        this.loaderListenerCalled = false;
        try {
            throwable = null;
            var4_6 = null;
            try {
                stream = SwtTestUtil.class.getResourceAsStream("target.png");
                try {
                    loader.load(stream);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        Assert.assertFalse((String)":d:", (boolean)this.loaderListenerCalled);
        this.loaderListenerCalled = false;
        loader.notifyListeners(new ImageLoaderEvent(loader, loader.data[0], 0, true));
        Assert.assertTrue((String)":e:", (boolean)this.loaderListenerCalled);
        loader.removeImageLoaderListener(loaderListener);
        Assert.assertFalse((String)":f:", (boolean)loader.hasListeners());
    }

    @Test
    public void test_loadLjava_io_InputStream() {
        InputStream stream;
        Object var3_6;
        Throwable throwable;
        ImageLoader loader = new ImageLoader();
        try {
            throwable = null;
            var3_6 = null;
            try {
                stream = null;
                try {
                    loader.load(stream);
                    Assert.fail((String)"No exception thrown for load inputStream == null");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException exception) {}
        try {
            throwable = null;
            var3_6 = null;
            try {
                stream = SwtTestUtil.class.getResourceAsStream("empty.txt");
                try {
                    loader.load(stream);
                    Assert.fail((String)"No exception thrown for load from invalid inputStream");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | SWTException throwable4) {}
        int numFormats = SwtTestUtil.imageFormats.length;
        String fileName = SwtTestUtil.imageFilenames[0];
        int i = 0;
        while (i < numFormats) {
            String format = SwtTestUtil.imageFormats[i];
            try {
                Throwable throwable5 = null;
                Object var7_14 = null;
                try (InputStream stream2 = SwtTestUtil.class.getResourceAsStream(String.valueOf(fileName) + "." + format);){
                    loader.load(stream2);
                }
                catch (Throwable throwable6) {
                    if (throwable5 == null) {
                        throwable5 = throwable6;
                    } else if (throwable5 != throwable6) {
                        throwable5.addSuppressed(throwable6);
                    }
                    throw throwable5;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    @Test
    public void test_loadLjava_lang_String() {
        ImageLoader loader = new ImageLoader();
        String filename = null;
        try {
            loader.load(filename);
            Assert.fail((String)"No exception thrown for load filename == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_saveLjava_io_OutputStreamI() {
        ByteArrayOutputStream outStream;
        block25: {
            ImageLoader loader = new ImageLoader();
            outStream = null;
            try {
                try {
                    loader.save(outStream, 0);
                    Assert.fail((String)"No exception thrown for save outputStream == null");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                outStream = new ByteArrayOutputStream();
                try {
                    loader.save((OutputStream)outStream, -1);
                    Assert.fail((String)"No exception thrown for save to invalid outputStream format");
                }
                catch (SWTException sWTException) {}
                boolean jpgSupported = false;
                int i = 0;
                while (i < SwtTestUtil.imageFormats.length) {
                    if (SwtTestUtil.imageFormats[i].equals("jpg")) {
                        jpgSupported = true;
                        break;
                    }
                    ++i;
                }
                if (!jpgSupported) break block25;
                String filename = SwtTestUtil.imageFilenames[0];
                String filetype = "jpg";
                try {
                    Throwable throwable = null;
                    Object var7_10 = null;
                    try (InputStream inStream = SwtTestUtil.class.getResourceAsStream(String.valueOf(filename) + "." + filetype);){
                        loader.load(inStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
                int i2 = 0;
                while (i2 < SwtTestUtil.imageFormats.length) {
                    if (SwtTestUtil.imageFormats[i2].equals(filetype)) {
                        loader.save((OutputStream)outStream, i2);
                        break;
                    }
                    ++i2;
                }
            }
            catch (Throwable throwable) {
                try {
                    outStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            outStream.close();
        }
        catch (Exception exception) {}
    }

    @Test
    public void test_saveLjava_lang_StringI() {
        ImageLoader loader = new ImageLoader();
        String filename = null;
        try {
            loader.save(filename, 0);
            Assert.fail((String)"No exception thrown for save filename == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

