/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Rectangle {
    @Test
    public void test_ConstructorIIII() {
        Rectangle r = new Rectangle(3, 4, 5, 6);
        Assert.assertEquals((long)3L, (long)r.x);
        Assert.assertEquals((long)4L, (long)r.y);
        Assert.assertEquals((long)5L, (long)r.width);
        Assert.assertEquals((long)6L, (long)r.height);
        r = new Rectangle(-4, -3, -2, -1);
        Assert.assertEquals((long)-4L, (long)r.x);
        Assert.assertEquals((long)-3L, (long)r.y);
        Assert.assertEquals((long)-2L, (long)r.width);
        Assert.assertEquals((long)-1L, (long)r.height);
        r = new Rectangle(500000, 700000, 200000, 100000);
        Assert.assertEquals((long)500000L, (long)r.x);
        Assert.assertEquals((long)700000L, (long)r.y);
        Assert.assertEquals((long)200000L, (long)r.width);
        Assert.assertEquals((long)100000L, (long)r.height);
    }

    @Test
    public void test_addLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        r1.add(r2);
        Assert.assertEquals((String)"Rectangle add incorrect", (Object)new Rectangle(1, 2, 4, 4), (Object)r1);
        r1.add(r2);
        Assert.assertEquals((String)"Rectangle add incorrect", (Object)new Rectangle(1, 2, 4, 4), (Object)r1);
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, 0, 0);
        r1.add(r2);
        Assert.assertEquals((String)"Rectangle add incorrect", (Object)new Rectangle(1, 2, 3, 4), (Object)r1);
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(6, 6, 0, 0);
        r1.add(r2);
        Assert.assertEquals((String)"Rectangle add incorrect", (Object)new Rectangle(1, 2, 5, 4), (Object)r1);
        try {
            r1.add(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_containsII() {
        Rectangle r = new Rectangle(1, 2, 3, 4);
        Assert.assertTrue((String)"Rectangle should contain point (1, 2)", (boolean)r.contains(1, 2));
        Assert.assertTrue((String)"Rectangle should contain point (3, 4)", (boolean)r.contains(3, 4));
        Assert.assertTrue((String)"Rectangle should contain point (3, 5)", (boolean)r.contains(3, 5));
        Assert.assertTrue((String)"Rectangle should not contain point (9, 10)", (!r.contains(9, 10) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rectangle should not contain point (-1, -1)", (!r.contains(-1, -1) ? 1 : 0) != 0);
    }

    @Test
    public void test_containsLorg_eclipse_swt_graphics_Point() {
        Rectangle r = new Rectangle(1, 2, 3, 4);
        Assert.assertTrue((String)"Rectangle should contain Point(1, 2)", (boolean)r.contains(new Point(1, 2)));
        Assert.assertTrue((String)"Rectangle should contain Point(3, 4)", (boolean)r.contains(new Point(3, 4)));
        Assert.assertTrue((String)"Rectangle should contain point (3, 5)", (boolean)r.contains(new Point(3, 5)));
        Assert.assertFalse((String)"Rectangle should not contain Point(9, 10)", (boolean)r.contains(new Point(9, 10)));
        Assert.assertFalse((String)"Rectangle should not contain point (-1, -1)", (boolean)r.contains(new Point(-1, -1)));
        try {
            r.contains(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Rectangle r1 = new Rectangle(5, 4, 3, 2);
        Rectangle r2 = new Rectangle(5, 4, 3, 2);
        Assert.assertTrue((String)"Rectangles should be equal", (boolean)r1.equals((Object)r2));
        r2 = new Rectangle(3, 4, 5, 6);
        Assert.assertFalse((String)"Rectangles should not be equal", (boolean)r1.equals((Object)r2));
        r2 = new Rectangle(2, 3, 4, 5);
        Assert.assertFalse((String)"Rectangles should not be equal", (boolean)r1.equals((Object)r2));
        r2 = new Rectangle(5, 4, 2, 3);
        Assert.assertFalse((String)"Rectangles should not be equal", (boolean)r1.equals((Object)r2));
        r2 = new Rectangle(4, 5, 3, 2);
        Assert.assertFalse((String)"Rectangles should not be equal", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void test_hashCode() {
        Rectangle r1 = new Rectangle(5, 4, 3, 2);
        Rectangle r2 = new Rectangle(5, 4, 3, 2);
        Assert.assertTrue((String)"Rectangles should have the same hashCode", (r1.hashCode() == r2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void test_intersectLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        r1.intersect(r2);
        Assert.assertEquals((String)"Rectangle intersect incorrect", (Object)new Rectangle(3, 3, 1, 2), (Object)r1);
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, 0, 0);
        r1.intersect(r2);
        Assert.assertEquals((String)"Rectangle intersect incorrect", (Object)new Rectangle(3, 3, 0, 0), (Object)r1);
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, -1, -1);
        r1.intersect(r2);
        Assert.assertEquals((String)"Rectangle intersect incorrect", (Object)new Rectangle(0, 0, 0, 0), (Object)r1);
        try {
            r1.intersect(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_intersectionLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        Assert.assertEquals((String)"Rectangle intersection incorrect", (Object)new Rectangle(3, 3, 1, 2), (Object)r1.intersection(r2));
        r2 = new Rectangle(3, 3, 0, 0);
        Assert.assertEquals((String)"Rectangle intersection incorrect", (Object)new Rectangle(3, 3, 0, 0), (Object)r1.intersection(r2));
        r2 = new Rectangle(3, 3, -1, -1);
        Assert.assertEquals((String)"Rectangle intersection incorrect", (Object)new Rectangle(0, 0, 0, 0), (Object)r1.intersection(r2));
        try {
            r1.intersection(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_intersectsIIII() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(2, 3, 7, 8);
        Assert.assertTrue((String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(2, 3, 7, 8)", (boolean)r1.intersects(2, 3, 7, 8));
        Assert.assertTrue((String)"Rectangle(2, 3, 7, 8) should intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(1, 2, 3, 4));
        r2 = new Rectangle(200, 300, 400, 500);
        Assert.assertFalse((String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(200, 300, 400, 500)", (boolean)r1.intersects(200, 300, 400, 500));
        Assert.assertFalse((String)"Rectangle(200, 300, 400, 500) should not intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(1, 2, 3, 4));
        r2 = new Rectangle(3, 3, 0, 0);
        Assert.assertTrue((String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(3, 3, 0, 0)", (boolean)r1.intersects(3, 3, 0, 0));
        Assert.assertTrue((String)"Rectangle(3, 3, 0, 0) should intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(1, 2, 3, 4));
        r2 = new Rectangle(3, 3, -1, -1);
        Assert.assertFalse((String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(3, 3, -1, -1)", (boolean)r1.intersects(3, 3, -1, -1));
        Assert.assertFalse((String)"Rectangle(3, 3, -1, -1) should not intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(1, 2, 3, 4));
        try {
            r1.intersects(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_intersectsLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(2, 3, 7, 8);
        Assert.assertTrue((String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(2, 3, 7, 8)", (boolean)r1.intersects(r2));
        Assert.assertTrue((String)"Rectangle(2, 3, 7, 8) should intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(r1));
        r2 = new Rectangle(200, 300, 400, 500);
        Assert.assertFalse((String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(200, 300, 400, 500)", (boolean)r1.intersects(r2));
        Assert.assertFalse((String)"Rectangle(200, 300, 400, 500) should not intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(r1));
        r2 = new Rectangle(3, 3, 0, 0);
        Assert.assertTrue((String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(3, 3, 0, 0)", (boolean)r1.intersects(r2));
        Assert.assertTrue((String)"Rectangle(3, 3, 0, 0) should intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(r1));
        r2 = new Rectangle(3, 3, -1, -1);
        Assert.assertFalse((String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(3, 3, -1, -1)", (boolean)r1.intersects(r2));
        Assert.assertFalse((String)"Rectangle(3, 3, -1, -1) should not intersect Rectangle(1, 2, 3, 4)", (boolean)r2.intersects(r1));
        try {
            r1.intersects(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }

    @Test
    public void test_isEmpty() {
        Rectangle r = new Rectangle(1, 2, 0, 0);
        Assert.assertTrue((String)"Rectangle is empty", (boolean)r.isEmpty());
        r = new Rectangle(1, 2, -3, -4);
        Assert.assertTrue((String)"Rectangle is empty", (boolean)r.isEmpty());
        r = new Rectangle(1, 2, 3, 4);
        Assert.assertFalse((String)"Rectangle is not empty", (boolean)r.isEmpty());
    }

    @Test
    public void test_toString() {
        Rectangle r = new Rectangle(3, 4, 5, 6);
        Assert.assertNotNull((Object)r.toString());
        Assert.assertTrue((r.toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Rectangle {3, 4, 5, 6}", (Object)r.toString());
    }

    @Test
    public void test_unionLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        Assert.assertEquals((String)"Rectangle union incorrect", (Object)new Rectangle(1, 2, 4, 4), (Object)r1.union(r2));
        r2 = new Rectangle(3, 3, 0, 0);
        Assert.assertEquals((String)"Rectangle union incorrect", (Object)new Rectangle(1, 2, 3, 4), (Object)r1.union(r2));
        r2 = new Rectangle(3, 3, -1, -1);
        Assert.assertEquals((String)"Rectangle union incorrect", (Object)new Rectangle(1, 2, 3, 4), (Object)r1.union(r2));
        try {
            r1.union(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
    }
}

