/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Canvas;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Decorations
extends Test_org_eclipse_swt_widgets_Canvas {
    Decorations decorations;
    Image[] images = new Image[SwtTestUtil.imageFormats.length * SwtTestUtil.imageFilenames.length];

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
        this.decorations.computeTrim(0, 0, 0, 0);
        this.decorations.computeTrim(0, 0, 10, 20);
    }

    @Override
    @Test
    public void test_getClientArea() {
        Rectangle rect = this.decorations.getClientArea();
        Assert.assertTrue((String)":a:", (rect.height >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (rect.width >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getDefaultButton() {
        Button button = new Button((Composite)this.decorations, 8);
        this.decorations.setDefaultButton(button);
        Assert.assertTrue((String)":a:", (this.decorations.getDefaultButton() == button ? 1 : 0) != 0);
    }

    @Test
    public void test_getImage() {
        Image[] imageArray = new Image[2];
        imageArray[1] = new Image(null, 100, 100);
        Image[] cases = imageArray;
        int i = 0;
        while (i < cases.length) {
            this.decorations.setImage(cases[i]);
            Assert.assertEquals((Object)this.decorations.getImage(), (Object)cases[i]);
            if (cases[i] != null) {
                cases[i].dispose();
            }
            ++i;
        }
    }

    @Override
    @Test
    public void test_getLocation() {
        this.decorations.setLocation(10, 15);
        Assert.assertTrue((String)":a:", (this.decorations.getLocation().x == 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (this.decorations.getLocation().y == 15 ? 1 : 0) != 0);
    }

    @Test
    public void test_getMenuBar() {
        Assert.assertNull((String)":a:", (Object)this.decorations.getMenuBar());
        Menu bar = new Menu(this.decorations, 2);
        this.decorations.setMenuBar(bar);
        Assert.assertTrue((String)":b:", (this.decorations.getMenuBar() == bar ? 1 : 0) != 0);
    }

    @Test
    public void test_getText() {
        this.decorations.setText("test");
        Assert.assertTrue((String)":a:", (boolean)this.decorations.getText().equals("test"));
    }

    @Override
    @Test
    public void test_isReparentable() {
        Assert.assertFalse((boolean)this.decorations.isReparentable());
    }

    @Test
    public void test_setDefaultButtonLorg_eclipse_swt_widgets_Button() {
        Assert.assertNull((Object)this.decorations.getDefaultButton());
        Button button = new Button((Composite)this.decorations, 0);
        this.decorations.setDefaultButton(button);
        Assert.assertTrue((String)"button not default", (this.decorations.getDefaultButton() == button ? 1 : 0) != 0);
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.decorations.setDefaultButton(null);
            Assert.assertNull((Object)this.decorations.getDefaultButton());
        }
    }

    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Assert.assertNull((String)":a:", (Object)this.decorations.getImage());
        this.loadImages();
        this.decorations.setImage(this.images[0]);
        Assert.assertTrue((String)":b:", (this.images[0] == this.decorations.getImage() ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (this.images[1] != this.decorations.getImage() ? 1 : 0) != 0);
        this.decorations.setImage(null);
        Assert.assertNull((String)":d:", (Object)this.decorations.getImage());
        this.freeImages();
    }

    @Test
    public void test_setMaximizedZ() {
        this.decorations.setMaximized(false);
        Assert.assertFalse((String)":1:", (boolean)this.decorations.getMaximized());
        this.decorations.setMaximized(true);
        Assert.assertTrue((String)":2:", (boolean)this.decorations.getMaximized());
        Assert.assertFalse((String)":3:", (boolean)this.decorations.getMinimized());
    }

    @Test
    public void test_setMenuBarLorg_eclipse_swt_widgets_Menu() {
        Assert.assertNull((Object)this.decorations.getMenu());
        Menu testMenu = new Menu((Control)this.decorations);
        this.decorations.setMenu(testMenu);
        Assert.assertTrue((String)"Incorrect menu", (this.decorations.getMenu() == testMenu ? 1 : 0) != 0);
        this.decorations.setMenu(null);
        Assert.assertNull((Object)this.decorations.getMenu());
    }

    @Test
    public void test_setMinimizedZ() {
        this.decorations.setMinimized(false);
        Assert.assertFalse((String)":1:", (boolean)this.decorations.getMinimized());
        this.decorations.setMinimized(true);
        Assert.assertTrue((String)":2:", (boolean)this.decorations.getMinimized());
        Assert.assertFalse((String)":3:", (boolean)this.decorations.getMaximized());
    }

    @Test
    public void test_setTextLjava_lang_String() {
        try {
            this.decorations.setText(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String testStr = "test string";
        this.decorations.setText(testStr);
        Assert.assertTrue((String)"a", (boolean)this.decorations.getText().equals(testStr));
        this.decorations.setText("");
        Assert.assertTrue((String)"b", (boolean)this.decorations.getText().isEmpty());
        try {
            this.decorations.setText(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    @Test
    public void test_setVisibleZ() {
    }

    @Override
    protected void setWidget(Widget w) {
        if (this.decorations != null && !this.decorations.isDisposed()) {
            this.decorations.dispose();
        }
        this.decorations = (Decorations)w;
        super.setWidget(w);
    }

    private void loadImages() {
        int numFormats = SwtTestUtil.imageFormats.length;
        int numFiles = SwtTestUtil.imageFilenames.length;
        int i = 0;
        while (i < numFormats) {
            String format = SwtTestUtil.imageFormats[i];
            int index = i * numFiles;
            int j = 0;
            while (j < numFiles) {
                String fileName = SwtTestUtil.imageFilenames[j];
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (InputStream resource = this.getClass().getResourceAsStream(String.valueOf(fileName) + "." + format);){
                        this.images[index + j] = new Image((Device)this.shell.getDisplay(), resource);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
                ++j;
            }
            ++i;
        }
    }

    private void freeImages() {
        int i = 0;
        while (i < this.images.length) {
            this.images[i].dispose();
            ++i;
        }
    }
}

