/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Dialog;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_FileDialog
extends Test_org_eclipse_swt_widgets_Dialog {
    FileDialog fileDialog;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fileDialog = new FileDialog(this.shell, 0);
        this.setDialog((Dialog)this.fileDialog);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Shell() {
        new FileDialog(this.shell);
        try {
            new FileDialog(null);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_ShellI() {
        FileDialog fd = new FileDialog(this.shell, 0);
        int style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assert.assertTrue(((style &= 0xFBFFFFFF) == 65536 ? 1 : 0) != 0);
        fd = new FileDialog(this.shell, 65536);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assert.assertTrue(((style &= 0xFBFFFFFF) == 65536 ? 1 : 0) != 0);
        fd = new FileDialog(this.shell, 32768);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assert.assertTrue(((style &= 0xFBFFFFFF) == 32768 ? 1 : 0) != 0);
        fd = new FileDialog(this.shell, 131072);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assert.assertTrue(((style &= 0xFBFFFFFF) == 131072 ? 1 : 0) != 0);
    }

    @Test
    public void test_getFileNames() {
        String[] names = this.fileDialog.getFileNames();
        Assert.assertTrue((names.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_open() {
        if (SwtTestUtil.fTestDialogOpen) {
            this.fileDialog.open();
        }
    }

    @Test
    public void test_setFileNameLjava_lang_String() {
        this.fileDialog.setFileName("");
        String name = this.fileDialog.getFileName();
        Assert.assertTrue((boolean)name.isEmpty());
        this.fileDialog.setFileName(null);
        name = this.fileDialog.getFileName();
        Assert.assertNull((Object)name);
        this.fileDialog.setFileName("somefile.test");
        name = this.fileDialog.getFileName();
        Assert.assertTrue((boolean)name.equals("somefile.test"));
    }

    @Test
    public void test_setFilterExtensions$Ljava_lang_String() {
        this.fileDialog.setFilterExtensions(new String[]{"txt", "java"});
        String[] filters = this.fileDialog.getFilterExtensions();
        Assert.assertTrue((filters.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filters[0].equals("txt"));
        Assert.assertTrue((boolean)filters[1].equals("java"));
        this.fileDialog.setFilterExtensions(new String[]{""});
        filters = this.fileDialog.getFilterExtensions();
        Assert.assertTrue((filters.length == 1 ? 1 : 0) != 0);
        this.fileDialog.setFilterExtensions(null);
        filters = this.fileDialog.getFilterExtensions();
        Assert.assertNull((Object)filters);
    }

    @Test
    public void test_setFilterNames$Ljava_lang_String() {
        this.fileDialog.setFilterNames(new String[]{"a.txt", "b.java"});
        String[] filters = this.fileDialog.getFilterNames();
        Assert.assertTrue((filters.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filters[0].equals("a.txt"));
        Assert.assertTrue((boolean)filters[1].equals("b.java"));
        this.fileDialog.setFilterNames(new String[]{""});
        filters = this.fileDialog.getFilterNames();
        Assert.assertTrue((filters.length == 1 ? 1 : 0) != 0);
        this.fileDialog.setFilterNames(null);
        filters = this.fileDialog.getFilterNames();
        Assert.assertNull((Object)filters);
    }

    @Test
    public void test_setFilterPathLjava_lang_String() {
        Assert.assertTrue((String)":1:", (this.fileDialog.getFilterPath() == "" ? 1 : 0) != 0);
        String testStr = "./*";
        this.fileDialog.setFilterPath(testStr);
        Assert.assertTrue((String)":2:", (boolean)this.fileDialog.getFilterPath().equals(testStr));
        this.fileDialog.setFilterPath("");
        Assert.assertTrue((String)":3:", (boolean)this.fileDialog.getFilterPath().isEmpty());
        this.fileDialog.setFilterPath(null);
        Assert.assertNull((String)":4:", (Object)this.fileDialog.getFilterPath());
    }
}

