/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Item;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_TableColumn
extends Test_org_eclipse_swt_widgets_Item {
    protected TableColumn tableColumn;
    protected Table table;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.table = new Table((Composite)this.shell, 4);
        this.tableColumn = new TableColumn(this.table, 0);
        this.setWidget((Widget)this.tableColumn);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TableI() {
        try {
            new TableColumn(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TableII() {
        try {
            new TableColumn(null, 0, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new TableColumn(this.table, 0, -1);
            Assert.fail((String)"No exception thrown for index == -1");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new TableColumn(this.table, 0, 2);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        try {
            this.tableColumn.addSelectionListener(null);
            Assert.fail((String)"No exception thrown for selectionListener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.tableColumn.addSelectionListener(listener);
        this.tableColumn.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.tableColumn.removeSelectionListener(listener);
        this.tableColumn.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_getWidth() {
        int testWidth = 42;
        this.tableColumn.setWidth(0);
        Assert.assertTrue((String)(":a: width=" + this.tableColumn.getWidth() + " should be=" + 0), (this.tableColumn.getWidth() == 0 ? 1 : 0) != 0);
        this.tableColumn.setWidth(testWidth);
        Assert.assertTrue((String)(":b: width=" + this.tableColumn.getWidth() + " should be=" + testWidth), (this.tableColumn.getWidth() == testWidth ? 1 : 0) != 0);
        this.tableColumn.setWidth(testWidth);
        Assert.assertTrue((String)(":c: width=" + this.tableColumn.getWidth() + " should be=" + testWidth), (this.tableColumn.getWidth() == testWidth ? 1 : 0) != 0);
    }

    @Test
    public void test_removeSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        };
        this.tableColumn.removeSelectionListener((SelectionListener)listener);
        this.tableColumn.addSelectionListener((SelectionListener)listener);
        this.tableColumn.removeSelectionListener((SelectionListener)listener);
        try {
            this.tableColumn.removeSelectionListener(null);
            Assert.fail((String)"No exception thrown for selectionListener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setAlignmentI() {
        Assert.assertTrue((String)":a:", (this.tableColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        this.tableColumn.setAlignment(-1);
        Assert.assertTrue((String)":b:", (this.tableColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        this.tableColumn.setAlignment(131072);
        Assert.assertTrue((String)":c: Should not be allowed to set alignment of the first column", (this.tableColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        TableColumn column2 = new TableColumn(this.table, 0);
        column2.setAlignment(131072);
        Assert.assertTrue((String)":d:", (column2.getAlignment() == 131072 ? 1 : 0) != 0);
        column2.setAlignment(0x1000000);
        Assert.assertTrue((String)":e:", (column2.getAlignment() == 0x1000000 ? 1 : 0) != 0);
        column2.setAlignment(16384);
        Assert.assertTrue((String)":f:", (column2.getAlignment() == 16384 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
    }

    @Test
    public void test_setMoveableZ() {
        Assert.assertFalse((String)":a:", (boolean)this.tableColumn.getMoveable());
        this.tableColumn.setMoveable(true);
        Assert.assertTrue((String)":b:", (boolean)this.tableColumn.getMoveable());
        this.tableColumn.setMoveable(true);
        Assert.assertTrue((String)":c:", (boolean)this.tableColumn.getMoveable());
        this.tableColumn.setMoveable(false);
        Assert.assertFalse((String)":d:", (boolean)this.tableColumn.getMoveable());
        TableColumn tableColumn2 = new TableColumn(this.tableColumn.getParent(), 0);
        tableColumn2.dispose();
        try {
            tableColumn2.getMoveable();
            Assert.fail((String)"No exception thrown for widget is Disposed");
        }
        catch (SWTException sWTException) {}
        try {
            tableColumn2.setMoveable(true);
            Assert.fail((String)"No exception thrown for widget is Disposed");
        }
        catch (SWTException sWTException) {}
    }

    @Test
    public void test_setResizableZ() {
        Assert.assertTrue((String)":a:", (boolean)this.tableColumn.getResizable());
        this.tableColumn.setResizable(false);
        Assert.assertFalse((String)":b:", (boolean)this.tableColumn.getResizable());
        this.tableColumn.setResizable(false);
        Assert.assertFalse((String)":c:", (boolean)this.tableColumn.getResizable());
        this.tableColumn.setResizable(true);
        Assert.assertTrue((String)":d:", (boolean)this.tableColumn.getResizable());
    }

    @Override
    @Test
    public void test_setTextLjava_lang_String() {
        Assert.assertEquals((String)":a:", (Object)this.tableColumn.getText(), (Object)"");
        this.tableColumn.setText("text");
        Assert.assertEquals((String)":b:", (Object)this.tableColumn.getText(), (Object)"text");
        try {
            this.tableColumn.setText(null);
            Assert.fail((String)"No exception thrown for column header == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

