/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Import;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.SyncFileChangeListener;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelReplaceOperation;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelUpdateOperation;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.BranchOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutSingleProjectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.operations.WorkspaceResourceMapper;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseRunnable;
import org.eclipse.team.tests.ccvs.core.TestUtil;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class EclipseTest
extends ResourceTest {
    private static final int LOCK_WAIT_TIME = 1000;
    private static final String CVS_TEST_LOCK_FILE = ".lock";
    private static final String CVS_TEST_LOCK_PROJECT = "cvsTestLock";
    protected static IProgressMonitor DEFAULT_MONITOR = new NullProgressMonitor();
    protected static final int RANDOM_CONTENT_SIZE = 3876;
    protected static String eol = System.getProperty("line.separator");
    private static boolean modelSync = true;
    private static final long LOCK_EXPIRATION_THRESHOLD = 600000L;
    private static final int MAX_LOCK_ATTEMPTS = 1800;
    private static final int MAX_RETRY_DELETE = 120;
    private String lockId;

    public static void delete(IResource resource, int updateFlags, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < 120) {
            try {
                resource.delete(updateFlags, progressMonitor);
                i = 120;
            }
            catch (CoreException e) {
                if (i == 119) {
                    CVSProviderPlugin.log((CoreException)e);
                    throw e;
                }
                try {
                    Status status = new Status(4, "org.eclipse.team.cvs.core", 0, "Error deleting resource", (Throwable)new IllegalStateException("sleep before retrying delete() for " + resource.getLocationURI()));
                    CVSProviderPlugin.log((IStatus)status);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    public static Test suite(Class<?> c) {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(c);
            return new CVSTestSetup((Test)suite);
        }
        try {
            return new CVSTestSetup((Test)c.getConstructor(String.class).newInstance(testName));
        }
        catch (Exception e) {
            EclipseTest.fail((String)e.getMessage());
            return null;
        }
    }

    public static boolean isModelSyncEnabled() {
        return modelSync;
    }

    public static void setModelSync(boolean modelSync) {
        EclipseTest.modelSync = modelSync;
    }

    public EclipseTest() {
        if (eol == null) {
            eol = "\n";
        }
    }

    public EclipseTest(String name) {
        super(name);
        if (eol == null) {
            eol = "\n";
        }
    }

    public ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, IProgressMonitor progress) throws TeamException {
        return CVSWorkspaceRoot.getRemoteTree((IResource)resource, (CVSTag)tag, (boolean)false, (int)2, (IProgressMonitor)progress);
    }

    public IResource[] getResources(IContainer container, String[] hierarchy) {
        IResource[] resources = new IResource[hierarchy.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = container.findMember(hierarchy[i]);
            if (resources[i] == null) {
                resources[i] = this.buildResources(container, new String[]{hierarchy[i]})[0];
            }
            ++i;
        }
        return resources;
    }

    public IResource[] addResources(IContainer container, String[] hierarchy, boolean checkin) throws CoreException, TeamException {
        IResource[] newResources = this.buildResources(container, hierarchy, false);
        this.addResources(newResources);
        if (checkin) {
            this.commitResources(newResources, 0);
        }
        return newResources;
    }

    protected void addResources(IResource[] newResources) throws CoreException {
        if (newResources.length == 0) {
            return;
        }
        ResourceMapping[] mappings = this.asResourceMappers(newResources, 2);
        this.add(mappings);
    }

    protected void add(ResourceMapping[] mappings) throws CVSException {
        EclipseTest.executeHeadless((TeamOperation)new AddOperation(null, mappings));
    }

    public IResource[] editResources(IContainer container, String[] hierarchy) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getProvider((IResource)container).edit(resources, true, true, false, 0, DEFAULT_MONITOR);
        this.assertReadOnly(resources, false, true);
        return resources;
    }

    public IResource[] uneditResources(IContainer container, String[] hierarchy) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getProvider((IResource)container).unedit(resources, true, true, DEFAULT_MONITOR);
        this.assertReadOnly(resources, true, true);
        return resources;
    }

    public void appendText(IResource resource, String text, boolean prepend) throws CoreException, IOException, CVSException {
        IFile file = (IFile)resource;
        String contents = EclipseTest.getFileContents(file);
        StringBuffer buffer = new StringBuffer();
        if (prepend) {
            buffer.append(text);
        }
        buffer.append(contents);
        if (!prepend) {
            buffer.append(String.valueOf(eol) + text);
        }
        this.setContentsAndEnsureModified(file, buffer.toString());
    }

    public void assertEndsWith(IFile file, String text) throws IOException, CoreException {
        EclipseTest.assertTrue((boolean)EclipseTest.getFileContents(file).endsWith(text));
    }

    public void assertStartsWith(IFile file, String text) throws IOException, CoreException {
        EclipseTest.assertTrue((boolean)EclipseTest.getFileContents(file).startsWith(text));
    }

    public static String getFileContents(IFile file) throws IOException, CoreException {
        StringBuffer buf = new StringBuffer();
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(file.getContents()));){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        return buf.toString();
    }

    public IResource[] changeResources(IContainer container, String[] hierarchy, boolean checkin) throws CoreException, TeamException {
        ArrayList<IResource> changedResources = new ArrayList<IResource>(hierarchy.length);
        int i = 0;
        while (i < hierarchy.length) {
            IResource resource = container.findMember(hierarchy[i]);
            if (resource.getType() == 1) {
                changedResources.add(resource);
                this.setContentsAndEnsureModified((IFile)resource);
            }
            ++i;
        }
        IResource[] resources = changedResources.toArray(new IResource[changedResources.size()]);
        if (checkin) {
            this.commitResources(resources, 0);
        }
        return resources;
    }

    public IResource[] deleteResources(IContainer container, String[] hierarchy, boolean checkin) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.deleteResources(resources);
        if (checkin) {
            this.commitResources(resources, 2);
        }
        return resources;
    }

    protected void deleteResources(IResource[] resources) throws TeamException, CoreException {
        if (resources.length == 0) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            EclipseTest.delete(resource, 0, DEFAULT_MONITOR);
            ++i;
        }
    }

    public void unmanageResources(IContainer container, String[] hierarchy) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.unmanageResources(resources);
    }

    protected void unmanageResources(IResource[] resources) throws TeamException, CoreException {
        int i = 0;
        while (i < resources.length) {
            CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]).unmanage(null);
            ++i;
        }
    }

    public IResource[] updateResources(IContainer container, String[] hierarchy, boolean ignoreLocalChanges) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        return this.updateResources(resources, ignoreLocalChanges);
    }

    protected IResource[] updateResources(IResource[] resources, boolean ignoreLocalChanges) throws CVSException {
        Command.LocalOption[] options = Command.NO_LOCAL_OPTIONS;
        if (ignoreLocalChanges) {
            options = new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES};
        }
        ResourceMapping[] mappers = this.asResourceMappers(resources, 2);
        this.update(mappers, options);
        return resources;
    }

    protected void update(ResourceMapping[] mappings, Command.LocalOption[] options) throws CVSException {
        if (options == null) {
            options = Command.NO_LOCAL_OPTIONS;
        }
        if (EclipseTest.isModelSyncEnabled() && options == Command.NO_LOCAL_OPTIONS) {
            EclipseTest.executeHeadless((TeamOperation)new ModelUpdateOperation(null, mappings, false){

                protected boolean isAttemptHeadlessMerge() {
                    return true;
                }

                protected void handlePreviewRequest() {
                }

                protected void handleNoChanges() {
                }

                protected void handleValidationFailure(IStatus status) {
                }

                protected void handleMergeFailure(IStatus status) {
                }
            });
        } else {
            EclipseTest.executeHeadless((TeamOperation)new UpdateOperation(null, mappings, options, null));
        }
    }

    protected void replace(IContainer container, String[] hierarchy, CVSTag tag, boolean recurse) throws CoreException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.replace(resources, tag, recurse);
    }

    protected void replace(IResource[] resources, CVSTag tag, boolean recurse) throws CoreException {
        ReplaceOperation op = new ReplaceOperation(null, resources, tag, recurse);
        EclipseTest.executeHeadless((TeamOperation)op);
    }

    protected void replace(ResourceMapping[] mappings) throws CVSException {
        if (EclipseTest.isModelSyncEnabled()) {
            EclipseTest.executeHeadless((TeamOperation)new ModelReplaceOperation(null, mappings, false){

                protected boolean promptForOverwrite() {
                    return true;
                }

                protected void handlePreviewRequest() {
                }

                protected void handleMergeFailure(IStatus status) {
                }

                protected void handleValidationFailure(IStatus status) {
                }
            });
        } else {
            EclipseTest.executeHeadless((TeamOperation)new ReplaceOperation(null, mappings, null));
        }
    }

    public void updateProject(IProject project, CVSTag tag, boolean ignoreLocalChanges) throws TeamException {
        if (tag == null) {
            ResourceMapping[] mappings = this.asResourceMappers(new IResource[]{project}, 2);
            if (ignoreLocalChanges) {
                this.replace(mappings);
            } else {
                this.update(mappings, Command.NO_LOCAL_OPTIONS);
            }
        } else {
            Command.LocalOption[] options = Command.NO_LOCAL_OPTIONS;
            if (ignoreLocalChanges) {
                options = new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES};
            }
            EclipseTest.executeHeadless((TeamOperation)new UpdateOperation(null, new IResource[]{project}, options, tag));
        }
    }

    public void commitProject(IProject project) throws TeamException, CoreException {
        this.commitResources((IContainer)project, true);
    }

    public void commitResources(IContainer container, boolean deep) throws TeamException, CoreException {
        this.commitResources(new IResource[]{container}, deep ? 2 : 0);
    }

    public IResource[] commitResources(IContainer container, String[] hierarchy) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.commitResources(resources, 0);
        return resources;
    }

    protected void commitResources(IResource[] resources, int depth) throws TeamException, CoreException {
        this.commitResources(resources, depth, "");
    }

    protected void commitResources(IResource[] resources, int depth, String message) throws TeamException, CoreException {
        if (resources.length == 0) {
            return;
        }
        ResourceMapping[] resourceMappers = this.asResourceMappers(resources, depth);
        this.commit(resourceMappers, message);
    }

    protected void commit(ResourceMapping[] mappers, String message) throws CVSException {
        EclipseTest.executeHeadless((TeamOperation)new CommitOperation(null, mappers, new Command.LocalOption[0], message));
    }

    protected ResourceMapping[] asResourceMappers(IResource[] resources, int depth) {
        return WorkspaceResourceMapper.asResourceMappers((IResource[])resources, (int)depth);
    }

    protected ICVSResource asCVSResource(IResource resource) {
        return CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
    }

    public void tagProject(IProject project, CVSTag tag, boolean force) throws TeamException {
        ResourceMapping[] mappings = RepositoryProviderOperation.asResourceMappers((IResource[])new IResource[]{project});
        this.tag(mappings, tag, force);
    }

    protected void tag(ResourceMapping[] mappings, CVSTag tag, boolean force) throws TeamException {
        TagOperation op = new TagOperation(null, mappings);
        this.runTag((ITagOperation)op, tag, force);
    }

    public void tagRemoteResource(ICVSRemoteResource resource, CVSTag tag, boolean force) throws TeamException {
        TagInRepositoryOperation op = new TagInRepositoryOperation(null, new ICVSRemoteResource[]{resource});
        this.runTag((ITagOperation)op, tag, force);
    }

    protected void runTag(ITagOperation op, CVSTag tag, boolean force) throws TeamException {
        op.setTag(tag);
        if (force) {
            op.moveTag();
        }
        try {
            ((CVSOperation)op).run(DEFAULT_MONITOR);
        }
        catch (InterruptedException interruptedException) {
            EclipseTest.fail((String)"Tag interrupted.");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof TeamException) {
                throw (TeamException)e.getTargetException();
            }
            e.printStackTrace();
            EclipseTest.fail((String)"Unexpected error while tagging");
        }
    }

    public void makeBranch(IResource[] resources, CVSTag version, CVSTag branch, boolean update) throws CVSException {
        ResourceMapping[] mappings = this.asResourceMappers(resources, 2);
        this.branch(mappings, version, branch, update);
    }

    protected void branch(ResourceMapping[] mappings, CVSTag version, CVSTag branch, boolean update) throws CVSException {
        BranchOperation op = new BranchOperation(null, mappings);
        op.setTags(version, branch, update);
        EclipseTest.executeHeadless((TeamOperation)op);
    }

    public IResource[] buildResources(IContainer container, String[] hierarchy, boolean includeContainer) throws CoreException {
        ArrayList<Object> resources = new ArrayList<Object>(hierarchy.length + 1);
        resources.addAll(Arrays.asList(this.buildResources(container, hierarchy)));
        if (includeContainer) {
            resources.add(container);
        }
        IResource[] result = resources.toArray(new IResource[resources.size()]);
        this.ensureExistsInWorkspace(result, true);
        int i = 0;
        while (i < result.length) {
            if (result[i].getType() == 1) {
                ((IFile)result[i]).setContents(EclipseTest.getRandomContents(3876), true, false, null);
            }
            ++i;
        }
        return result;
    }

    protected IProject checkoutCopy(IProject project, String postfix) throws TeamException {
        IProject copy = EclipseTest.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + postfix);
        EclipseTest.checkout((ICVSRepositoryLocation)this.getRepository(), copy, CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).getFolderSyncInfo().getRepository(), null, DEFAULT_MONITOR);
        return copy;
    }

    protected IProject checkoutCopy(IProject project, CVSTag tag) throws TeamException {
        IProject copy = EclipseTest.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + tag.getName());
        EclipseTest.checkout((ICVSRepositoryLocation)this.getRepository(), copy, CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).getFolderSyncInfo().getRepository(), tag, DEFAULT_MONITOR);
        return copy;
    }

    public static void checkout(ICVSRepositoryLocation repository, IProject project, String sourceModule, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        RemoteFolder remote = new RemoteFolder(null, repository, sourceModule == null ? project.getName() : sourceModule, tag);
        EclipseTest.executeHeadless((TeamOperation)new CheckoutSingleProjectOperation(null, (ICVSRemoteFolder)remote, project, null, false){

            public boolean promptToOverwrite(String title, String msg, IResource resource) {
                return true;
            }
        });
    }

    protected IProject checkoutProject(IProject project, String moduleName, CVSTag tag) throws TeamException {
        if (project == null) {
            project = EclipseTest.getWorkspace().getRoot().getProject(new Path(moduleName).lastSegment());
        }
        EclipseTest.checkout((ICVSRepositoryLocation)this.getRepository(), project, moduleName, tag, DEFAULT_MONITOR);
        return project;
    }

    protected IProject createProject(String prefix, String[] resources) throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject(prefix);
        this.buildResources((IContainer)project, resources, true);
        this.shareProject(project);
        this.assertValidCheckout(project);
        return project;
    }

    protected IProject createProject(String[] strings) throws CoreException {
        return this.createProject(this.getName(), strings);
    }

    protected void assertEquals(IProject project1, IProject project2) throws CoreException, IOException {
        this.assertEquals(project1, project2, false, false);
    }

    protected void assertEquals(IProject project1, IProject project2, boolean includeTimestamps, boolean includeTags) throws CoreException, IOException {
        this.assertEquals(this.getProvider((IResource)project1), this.getProvider((IResource)project2), includeTimestamps, includeTags);
    }

    protected void assertEquals(CVSTeamProvider provider1, CVSTeamProvider provider2, boolean includeTimestamps, boolean includeTags) throws CoreException, IOException {
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSFolderFor((IContainer)provider1.getProject()), CVSWorkspaceRoot.getCVSFolderFor((IContainer)provider2.getProject()), includeTimestamps, includeTags);
    }

    protected void assertContentsEqual(IContainer c1, IContainer c2) throws CoreException {
        EclipseTest.assertTrue((String)("The number of resource in " + c1.getProjectRelativePath().toString() + " differs"), (c1.members().length == c2.members().length ? 1 : 0) != 0);
        IResource[] resources = c1.members();
        int i = 0;
        while (i < resources.length) {
            this.assertContentsEqual(resources[i], c2.findMember(resources[i].getName()));
            ++i;
        }
    }

    protected void assertContentsEqual(IResource resource, IResource resource2) throws CoreException {
        if (resource.getType() == 1) {
            this.assertContentsEqual((IFile)resource, (IFile)resource2);
        } else {
            this.assertContentsEqual((IContainer)resource, (IContainer)resource2);
        }
    }

    protected void assertContentsEqual(IFile resource, IFile resource2) throws CoreException {
        EclipseTest.assertTrue((String)("Contents of " + resource.getProjectRelativePath() + " do not match"), (boolean)this.compareContent(resource.getContents(), resource2.getContents()));
    }

    protected void assertContentsEqual(IFile file, String contents) throws CoreException {
        EclipseTest.assertTrue((boolean)this.compareContent(file.getContents(), new ByteArrayInputStream(contents.getBytes())));
    }

    protected void assertEquals(IPath parent, ICVSResource resource1, ICVSResource resource2, boolean includeTimestamps, boolean includeTags) throws CoreException, CVSException, IOException {
        if (resource1 == null && resource2 == null || resource1 == null && !resource2.exists() || resource2 == null && !resource1.exists()) {
            return;
        }
        if (resource1 == null && resource2 != null) {
            EclipseTest.fail((String)("Expected no resource for " + resource2.getRepositoryRelativePath() + " but there was one"));
        }
        if (resource2 == null && resource1 != null) {
            EclipseTest.fail((String)("Expected resource " + resource1.getRepositoryRelativePath() + " was missing"));
        }
        EclipseTest.assertEquals((String)("Resource types do not match for " + parent.append(resource1.getName())), (boolean)resource1.isFolder(), (boolean)resource2.isFolder());
        if (!resource1.isFolder()) {
            this.assertEquals(parent, (ICVSFile)resource1, (ICVSFile)resource2, includeTimestamps, includeTags);
        } else {
            this.assertEquals(parent, (ICVSFolder)resource1, (ICVSFolder)resource2, includeTimestamps, includeTags);
        }
    }

    protected void assertEquals(IPath parent, ICVSFolder container1, ICVSFolder container2, boolean includeTimestamps, boolean includeTags) throws CoreException, CVSException, IOException {
        IPath path = parent.append(container1.getName());
        this.assertEquals(path, container1.getFolderSyncInfo(), container2.getFolderSyncInfo(), includeTags);
        EclipseTest.assertTrue((String)("The number of resource in " + path.toString() + " differs"), (container1.members(63).length == container2.members(63).length ? 1 : 0) != 0);
        ICVSResource[] resources = container1.members(63);
        int i = 0;
        while (i < resources.length) {
            this.assertEquals(path, resources[i], container2.getChild(resources[i].getName()), includeTimestamps, includeTags);
            ++i;
        }
    }

    protected void assertEquals(IPath parent, ICVSFile file1, ICVSFile file2, boolean includeTimestamps, boolean includeTags) throws CoreException, CVSException {
        if (file1.getName().equals(".project")) {
            return;
        }
        this.assertEquals(parent.append(file1.getName()), file1.getSyncInfo(), file2.getSyncInfo(), includeTimestamps, includeTags);
        EclipseTest.assertTrue((String)("Contents of " + parent.append(file1.getName()) + " do not match"), (boolean)this.compareContent(this.getContents(file1), this.getContents(file2)));
    }

    protected boolean isFailOnSyncInfoMismatch() {
        return true;
    }

    protected void assertEquals(IPath path, ResourceSyncInfo info1, ResourceSyncInfo info2, boolean includeTimestamp, boolean includeTag) {
        String line2;
        String line1;
        if (!this.isFailOnSyncInfoMismatch()) {
            return;
        }
        if (info1 == null || info2 == null) {
            if (info1 == info2) {
                return;
            }
            if (info1 == null) {
                EclipseTest.fail((String)("Expected no resource sync info  for " + path.toString() + " but it was " + info2 + " instead"));
            }
            if (info2 == null) {
                EclipseTest.fail((String)("Expected resource sync info of " + info1 + " for " + path.toString() + " but there was no sync info."));
            }
            EclipseTest.fail((String)"Shouldn't be able to get here");
            return;
        }
        if (includeTimestamp) {
            line1 = info1.getEntryLine();
            line2 = info2.getEntryLine();
        } else {
            line1 = info1.getServerEntryLine(null);
            line2 = info2.getServerEntryLine(null);
        }
        if (!includeTag) {
            line1 = line1.substring(0, line1.lastIndexOf(47));
            line2 = line2.substring(0, line2.lastIndexOf(47));
        }
        EclipseTest.assertEquals((String)("Resource Sync info differs for " + path.toString()), (String)line1, (String)line2);
    }

    protected void assertEquals(IPath path, FolderSyncInfo info1, FolderSyncInfo info2, boolean includeTag) {
        if (info1 == null && info2 == null) {
            return;
        }
        if (info1 == null) {
            EclipseTest.fail((String)("Expected " + path.toString() + " not to be a CVS folder but it is."));
        } else if (info2 == null) {
            EclipseTest.fail((String)("Expected " + path.toString() + " to be a CVS folder but it isn't."));
        }
        if (includeTag) {
            EclipseTest.assertTrue((String)("Folder sync info differs for " + path.toString()), (boolean)info1.equals((Object)info2));
        } else {
            EclipseTest.assertTrue((String)("Repository Root differs for " + path.toString()), (boolean)info1.getRoot().equals(info2.getRoot()));
            EclipseTest.assertTrue((String)("Repository relative path differs for " + path.toString()), (boolean)info1.getRepository().equals(info2.getRepository()));
        }
    }

    protected void assertEquals(IPath parent, RemoteFolder container1, RemoteFolder container2, boolean includeTags) throws CoreException, TeamException, IOException {
        IPath path = parent.append(container1.getName());
        this.assertEquals(path, container1.getFolderSyncInfo(), container2.getFolderSyncInfo(), includeTags);
        ICVSRemoteResource[] members1 = container1.getMembers(DEFAULT_MONITOR);
        ICVSRemoteResource[] members2 = container2.getMembers(DEFAULT_MONITOR);
        EclipseTest.assertTrue((String)("Number of members differ for " + path), (members1.length == members2.length ? 1 : 0) != 0);
        HashMap<String, ICVSRemoteResource> memberMap2 = new HashMap<String, ICVSRemoteResource>();
        int i = 0;
        while (i < members2.length) {
            memberMap2.put(members2[i].getName(), members2[i]);
            ++i;
        }
        i = 0;
        while (i < members1.length) {
            ICVSRemoteResource member2 = (ICVSRemoteResource)memberMap2.get(members1[i].getName());
            EclipseTest.assertNotNull((Object)("Resource does not exist: " + path.append(members1[i].getName()) + member2));
            this.assertEquals(path, members1[i], member2, includeTags);
            ++i;
        }
    }

    protected void assertEquals(IPath parent, ICVSRemoteResource resource1, ICVSRemoteResource resource2, boolean includeTags) throws CoreException, TeamException, IOException {
        EclipseTest.assertEquals((String)("Resource types do not match for " + parent.append(resource1.getName())), (boolean)resource1.isContainer(), (boolean)resource2.isContainer());
        if (resource1.isContainer()) {
            this.assertEquals(parent, (RemoteFolder)resource1, (RemoteFolder)resource2, includeTags);
        } else {
            this.assertEquals(parent, (ICVSFile)resource1, (ICVSFile)resource2, false, includeTags);
        }
    }

    protected void assertLocalStateEqualsRemote(IProject project) throws TeamException, CoreException, IOException {
        this.assertEquals(this.getProvider((IResource)project), this.getProvider((IResource)this.checkoutCopy(project, "-remote")), false, true);
    }

    protected void assertLocalStateEqualsRemote(String message, IProject project, CVSTag tag) throws TeamException, CoreException, IOException {
        this.assertEquals(this.getProvider((IResource)project), this.getProvider((IResource)this.checkoutCopy(project, tag)), true, false);
    }

    protected void assertHasNoRemote(String prefix, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertHasNoRemote(prefix, resources[i]);
            ++i;
        }
    }

    protected void assertHasNoRemote(String prefix, IResource resource) {
        EclipseTest.assertTrue((String)(String.valueOf(prefix) + " resource should not have a remote"), (!CVSWorkspaceRoot.hasRemote((IResource)resource) ? 1 : 0) != 0);
    }

    protected void assertHasRemote(String prefix, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertHasRemote(prefix, resources[i]);
            ++i;
        }
    }

    protected void assertHasRemote(String prefix, IResource resource) {
        EclipseTest.assertTrue((String)(String.valueOf(prefix) + " resource should have a remote"), (boolean)CVSWorkspaceRoot.hasRemote((IResource)resource));
    }

    protected void assertIsModified(String prefix, IResource[] resources) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            this.assertIsModified(prefix, resources[i]);
            ++i;
        }
    }

    protected void assertIsModified(String prefix, IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            EclipseTest.assertTrue((String)(String.valueOf(prefix) + " resource " + resource.getFullPath() + " should be dirty."), (boolean)((ICVSFile)this.getCVSResource(resource)).isModified(null));
        }
    }

    protected void assertNotModified(String prefix, IResource[] resources) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            this.assertNotModified(prefix, resources[i]);
            ++i;
        }
    }

    protected void assertNotModified(String prefix, IResource resource) throws TeamException {
        EclipseTest.assertTrue((String)(String.valueOf(prefix) + " resource should be dirty"), (!((ICVSFile)this.getCVSResource(resource)).isModified(null) ? 1 : 0) != 0);
    }

    protected void assertIsIgnored(IResource resource, boolean ignoredState) throws TeamException {
        EclipseTest.assertEquals((String)("Resource " + resource.getFullPath() + " should be ignored but isn't."), (boolean)ignoredState, (boolean)this.getCVSResource(resource).isIgnored());
    }

    protected void assertValidCheckout(IProject project) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
        EclipseTest.assertNotNull((Object)provider);
    }

    protected void assertReadOnly(IResource[] resources, boolean isReadOnly, boolean recurse) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            resource.accept(resource1 -> {
                if (resource1.getType() == 1) {
                    EclipseTest.assertEquals((boolean)isReadOnly, (boolean)resource1.getResourceAttributes().isReadOnly());
                }
                return recurse;
            });
            ++i;
        }
    }

    protected InputStream getContents(ICVSFile file) throws CVSException {
        if (file instanceof ICVSRemoteFile) {
            return ((RemoteFile)file).getContents(DEFAULT_MONITOR);
        }
        return new BufferedInputStream(file.getContents());
    }

    protected ICVSResource getCVSResource(IResource resource) {
        return CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
    }

    protected IProject getNamedTestProject(String name) throws CoreException {
        IProject target = EclipseTest.getWorkspace().getRoot().getProject(name);
        if (!target.exists()) {
            target.create(null);
            target.open(null);
        }
        this.assertExistsInFileSystem((IResource)target);
        return target;
    }

    protected CVSTeamProvider getProvider(IResource resource) {
        return (CVSTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject());
    }

    protected static InputStream getRandomContents(int sizeAtLeast) {
        StringBuffer randomStuff = new StringBuffer(sizeAtLeast + 100);
        while (randomStuff.length() < sizeAtLeast) {
            randomStuff.append(String.valueOf(EclipseTest.getRandomSnippet()) + eol);
        }
        return new ByteArrayInputStream(randomStuff.toString().getBytes());
    }

    public static String getRandomSnippet() {
        switch ((int)Math.round(Math.random() * 10.0)) {
            case 0: {
                return "este e' o meu conteudo (portuguese)";
            }
            case 1: {
                return "Dann brauchen wir aber auch einen deutschen Satz!";
            }
            case 2: {
                return "I'll be back";
            }
            case 3: {
                return "don't worry, be happy";
            }
            case 4: {
                return "there is no imagination for more sentences";
            }
            case 5: {
                return "customize yours";
            }
            case 6: {
                return "foo";
            }
            case 7: {
                return "bar";
            }
            case 8: {
                return "foobar";
            }
            case 9: {
                return "case 9";
            }
        }
        return "these are my contents";
    }

    protected IProject getUniqueTestProject(String prefix) throws CoreException {
        return this.getNamedTestProject(String.valueOf(prefix) + "-" + Long.toString(System.currentTimeMillis()));
    }

    protected CVSRepositoryLocation getRepository() {
        return CVSTestSetup.repository;
    }

    protected void importProject(IProject project) throws TeamException {
        IStatus status;
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        s.open(DEFAULT_MONITOR, true);
        try (Session s = new Session((ICVSRepositoryLocation)this.getRepository(), root);){
            status = Command.IMPORT.execute(s, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Import.makeArgumentOption((Command.LocalOption)Command.MESSAGE_OPTION, (String)"Initial Import")}, new String[]{project.getName(), this.getRepository().getUsername(), "start"}, null, DEFAULT_MONITOR);
        }
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
    }

    protected void shareProject(IProject project) throws TeamException, CoreException {
        this.mapNewProject(project);
        this.commitNewProject(project);
    }

    protected void mapNewProject(IProject project) throws TeamException {
        this.shareProject(this.getRepository(), project, null, DEFAULT_MONITOR);
    }

    protected void shareProject(CVSRepositoryLocation location, IProject project, String moduleName, IProgressMonitor default_monitor) throws CVSException {
        ShareProjectOperation op = new ShareProjectOperation(null, (ICVSRepositoryLocation)location, project, moduleName);
        EclipseTest.executeHeadless((TeamOperation)op);
    }

    protected void commitNewProject(IProject project) throws CoreException, CVSException, TeamException {
        ArrayList<IResource> resourcesToAdd = new ArrayList<IResource>();
        IResource[] members = project.members();
        int i = 0;
        while (i < members.length) {
            if (!CVSWorkspaceRoot.getCVSResourceFor((IResource)members[i]).isIgnored()) {
                resourcesToAdd.add(members[i]);
            }
            ++i;
        }
        this.addResources(resourcesToAdd.toArray(new IResource[resourcesToAdd.size()]));
        this.commitResources(new IResource[]{project}, 2);
        this.waitMsec(1500);
    }

    public InputStream getRandomContents() {
        return EclipseTest.getRandomContents(3876);
    }

    protected void setContentsAndEnsureModified(IFile file) throws CoreException, TeamException {
        this.setContentsAndEnsureModified(file, this.getRandomContents());
    }

    protected void setContentsAndEnsureModified(IFile file, String contents) throws CoreException, CVSException {
        if (contents == null) {
            contents = "";
        }
        this.setContentsAndEnsureModified(file, new ByteArrayInputStream(contents.getBytes()));
    }

    protected void setContentsAndEnsureModified(IFile file, InputStream stream) throws CoreException, CVSException {
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        int count = 0;
        file.setContents(stream, false, false, null);
        do {
            EclipseTest.assertTrue((String)"Timestamp granularity is too small. Increase test wait factor", (count <= CVSTestSetup.WAIT_FACTOR ? 1 : 0) != 0);
            if (cvsFile.isModified(null)) continue;
            this.waitMsec(1500);
            ++count;
            try {
                file.setContents((InputStream)new ByteArrayInputStream(EclipseTest.getFileContents(file).getBytes()), false, false, null);
            }
            catch (IOException e) {
                CVSStatus status = new CVSStatus(4, "Error reading file contents", (Throwable)e);
                throw new CVSException((IStatus)status);
            }
        } while (!cvsFile.isModified(null));
    }

    public void waitMsec(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            EclipseTest.fail((String)"wait-problem");
        }
    }

    public static void waitForJobCompletion(Job job) {
        while (Display.getCurrent().readAndDispatch()) {
        }
        while (job.getState() != 0) {
            while (Display.getCurrent().readAndDispatch()) {
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public static void waitForIgnoreFileHandling() {
        EclipseTest.waitForJobCompletion(SyncFileChangeListener.getDeferredHandler().getEventHandlerJob());
        EclipseTest.waitForDecorator();
    }

    protected static void waitForDecorator() {
        Job[] decorators = Job.getJobManager().find(DecoratorManager.FAMILY_DECORATE);
        int i = 0;
        while (i < decorators.length) {
            Job job = decorators[i];
            EclipseTest.waitForJobCompletion(job);
            ++i;
        }
    }

    public static void waitForSubscriberInputHandling(SubscriberSyncInfoCollector input) {
        input.waitForCollector(new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
        });
    }

    protected static void executeHeadless(TeamOperation op) throws CVSException {
        EclipseRunnable tempRunnable = new EclipseRunnable(op, DEFAULT_MONITOR);
        Thread tempThread = new Thread(tempRunnable);
        tempThread.start();
        while (tempThread.isAlive()) {
            try {
                Thread.sleep(100L);
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        Exception ex = tempRunnable.getException();
        if (ex instanceof InvocationTargetException) {
            throw CVSException.wrapException((Exception)ex);
        }
    }

    protected void setUp() throws Exception {
        RepositoryProviderOperation.consultModelsWhenBuildingScope = false;
        if (CVSTestSetup.ENSURE_SEQUENTIAL_ACCESS) {
            this.obtainCVSServerLock();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        RepositoryProviderOperation.consultModelsWhenBuildingScope = true;
        if (CVSTestSetup.ENSURE_SEQUENTIAL_ACCESS) {
            this.releaseCVSServerLock();
        }
        super.tearDown();
        if (CVSTestSetup.logListener != null) {
            try {
                CVSTestSetup.logListener.checkErrors();
            }
            catch (CoreException e) {
                if (CVSTestSetup.FAIL_IF_EXCEPTION_LOGGED) {
                    EclipseTest.fail((String)"Exception written to log: ", (Throwable)e);
                }
                this.write(e.getStatus(), 0);
            }
        }
        TestUtil.cleanUp();
    }

    private void obtainCVSServerLock() {
        IProject project = null;
        boolean firstTry = true;
        while (project == null) {
            try {
                project = this.checkoutProject(null, CVS_TEST_LOCK_PROJECT, null);
            }
            catch (TeamException e) {
                if (firstTry) {
                    try {
                        this.createTestLockProject(DEFAULT_MONITOR);
                    }
                    catch (TeamException teamException) {}
                } else {
                    this.write((IStatus)new CVSStatus(4, "Could not obtain the CVS server lock. The test will containue but any performance timings may be affected", (Throwable)e), 0);
                    return;
                }
                firstTry = false;
            }
        }
        if (project != null) {
            IFile lockFile = project.getFile(CVS_TEST_LOCK_FILE);
            boolean obtained = false;
            int attempts = 0;
            while (!obtained) {
                ++attempts;
                if (lockFile.exists()) {
                    if (this.hasExpired(lockFile)) {
                        try {
                            this.overwriteLock(lockFile);
                            return;
                        }
                        catch (CoreException coreException) {}
                    }
                } else {
                    try {
                        this.writeLock(lockFile);
                        return;
                    }
                    catch (CoreException coreException) {}
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                try {
                    this.replace(new IResource[]{lockFile}, null, true);
                }
                catch (CoreException e) {
                    this.write((IStatus)new CVSStatus(4, "Could not obtain the CVS server lock. The test will continue but any performance timings may be affected", (Throwable)e), 0);
                    return;
                }
                if (attempts <= 1800) continue;
                this.write((IStatus)new CVSStatus(4, "Could not obtain the CVS server lock. The test will continue but any performance timings may be affected", (Throwable)new Exception()), 0);
                return;
            }
        }
    }

    private boolean hasExpired(IFile lockFile) {
        long timestamp = lockFile.getLocalTimeStamp();
        return System.currentTimeMillis() - timestamp > 600000L;
    }

    private void overwriteLock(IFile lockFile) throws CoreException {
        lockFile.setContents(this.getLockContents(), true, true, null);
        this.commitResources(new IResource[]{lockFile}, 0);
    }

    private void writeLock(IFile lockFile) throws CoreException {
        lockFile.create(this.getLockContents(), false, null);
        this.addResources(new IResource[]{lockFile});
        this.commitResources(new IResource[]{lockFile}, 0);
    }

    private InputStream getLockContents() {
        this.lockId = Long.toString(System.currentTimeMillis());
        return new ByteArrayInputStream(this.lockId.getBytes());
    }

    private void createTestLockProject(IProgressMonitor monitor) throws TeamException {
        CVSRepositoryLocation repository = this.getRepository();
        RemoteFolderTree root = new RemoteFolderTree(null, (ICVSRepositoryLocation)repository, Path.EMPTY.toString(), null);
        RemoteFolderTree child = new RemoteFolderTree((RemoteFolder)root, CVS_TEST_LOCK_PROJECT, (ICVSRepositoryLocation)repository, new Path(null, root.getRepositoryRelativePath()).append(CVS_TEST_LOCK_PROJECT).toString(), null);
        root.setChildren(new ICVSRemoteResource[]{child});
        s.open(monitor, true);
        try (Session s = new Session((ICVSRepositoryLocation)repository, (ICVSFolder)root);){
            IStatus status = Command.ADD.execute(s, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, new String[]{CVS_TEST_LOCK_PROJECT}, null, monitor);
            if (status.getCode() == -10 || !status.isOK()) {
                throw new CVSServerException(status);
            }
        }
    }

    private void releaseCVSServerLock() {
        if (this.lockId != null) {
            try {
                IProject project = EclipseTest.getWorkspace().getRoot().getProject(CVS_TEST_LOCK_PROJECT);
                IFile file = project.getFile(CVS_TEST_LOCK_FILE);
                String id = EclipseTest.getFileContents(file);
                if (id.equals(this.lockId)) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                    byte[] bytes = cvsFile.getSyncBytes();
                    if (bytes != null) {
                        String revision = ResourceSyncInfo.getRevision((byte[])bytes);
                        this.updateResources(new IResource[]{file}, true);
                        bytes = cvsFile.getSyncBytes();
                        if (bytes == null || !ResourceSyncInfo.getRevision((byte[])bytes).equals(revision)) {
                            this.write((IStatus)new CVSStatus(4, "The CVS server lock expired while this test was running. Any performance timings may be affected", (Throwable)new Exception()), 0);
                            return;
                        }
                    }
                    this.deleteResources((IContainer)project, new String[]{CVS_TEST_LOCK_FILE}, true);
                }
            }
            catch (CoreException e) {
                this.write(e.getStatus(), 0);
            }
            catch (IOException e) {
                this.write((IStatus)new CVSStatus(4, "An error occurred while reading the lock file", (Throwable)e), 0);
            }
        }
    }

    protected void write(IStatus status, int indent) {
        PrintStream output = System.out;
        EclipseTest.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        EclipseTest.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        EclipseTest.indent(output, indent);
        output.println("Code: " + status.getCode());
        EclipseTest.indent(output, indent);
        output.println("Message: " + status.getMessage());
        Throwable t = status.getException();
        if (t != null) {
            t.printStackTrace(output);
            if (t instanceof CoreException) {
                this.write(((CoreException)t).getStatus(), indent + 1);
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.write(children[i], indent + 1);
                ++i;
            }
        }
    }

    protected static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("  ".getBytes());
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public void runBare() throws Throwable {
        try {
            super.runBare();
        }
        catch (CVSException e) {
            if (this.containsCommunicationException(e)) {
                super.runBare();
            }
            throw e;
        }
    }

    private boolean containsCommunicationException(CVSException e) {
        if (e instanceof CVSCommunicationException) {
            return true;
        }
        IStatus status = e.getStatus();
        if (status.getException() instanceof CVSCommunicationException) {
            return true;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (child.getException() instanceof CVSCommunicationException) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void ensureDoesNotExistInWorkspace(IResource resource) {
        block7: {
            if (resource.getType() == 8) {
                allJobs = Job.getJobManager().find(null);
                projects = ((IWorkspaceRoot)resource).getProjects();
                try {
                    this.ensureDoesNotExistInWorkspace(projects);
                    break block7;
                }
                catch (AssertionFailedError e) {
                    System.out.println(e.getMessage());
                    System.out.println("Jobs active at time of deletion failure: ");
                    if (allJobs.length == 0) {
                        System.out.println("None");
                    }
                    i = 0;
                    ** while (i < allJobs.length)
                }
lbl-1000:
                // 1 sources

                {
                    job = allJobs[i];
                    System.out.println(String.valueOf(job.getName()) + ": " + job.getState());
                    ++i;
                    continue;
                }
lbl18:
                // 1 sources

                if (CVSTestSetup.FAIL_IF_EXCEPTION_LOGGED) {
                    throw e;
                }
            } else {
                this.ensureNotReadOnly(resource);
                super.ensureDoesNotExistInWorkspace(resource);
            }
        }
    }

    private void ensureNotReadOnly(IResource resource) {
        if (resource.exists()) {
            try {
                resource.accept(resource1 -> {
                    ResourceAttributes attrs = resource1.getResourceAttributes();
                    if (resource1.exists() && attrs.isReadOnly()) {
                        attrs.setReadOnly(false);
                        resource1.setResourceAttributes(attrs);
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                EclipseTest.fail((String)("#ensureNotReadOnly " + resource.getFullPath()), (Throwable)e);
            }
        }
    }

    public void ensureDoesNotExistInWorkspace(IProject[] projects) {
        HashMap failures = new HashMap();
        IWorkspaceRunnable body = monitor -> {
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].exists()) {
                        try {
                            projects[i].delete(true, null);
                        }
                        catch (CoreException coreException) {
                            this.ensureNotReadOnly((IResource)projects[i]);
                            if (projects[i].exists()) {
                                projects[i].refreshLocal(2, null);
                                projects[i].delete(true, null);
                            }
                        }
                    }
                }
                catch (CoreException e2) {
                    this.write((IStatus)new CVSStatus(4, "Could not delete project " + projects[i].getName(), (Throwable)e2), 0);
                    failures.put(projects[i], e2);
                }
                ++i;
            }
        };
        try {
            EclipseTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            EclipseTest.fail((String)"#ensureDoesNotExistInWorkspace(IResource[])", (Throwable)e);
        }
        if (!failures.isEmpty()) {
            StringBuffer text = new StringBuffer();
            text.append("Could not delete all projects: ");
            for (IProject project : failures.keySet()) {
                text.append(project.getName());
            }
            EclipseTest.fail((String)text.toString());
        }
    }

    protected void assertStatusContainsCode(IStatus status, int code) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (child.getCode() == code) {
                    return;
                }
                ++i;
            }
            EclipseTest.fail((String)"Expected status code was not present");
        } else {
            EclipseTest.assertEquals((String)"Status code is not what is expected", (int)status.getCode(), (int)code);
        }
    }

    protected void runTest() throws Throwable {
        if (!CVSTestSetup.RECORD_PROTOCOL_TRAFFIC) {
            super.runTest();
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Policy.recorder = new PrintStream(os);
        try {
            try {
                try {
                    super.runTest();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    this.write(e.getStatus(), 0);
                    throw e;
                }
            }
            catch (Throwable e) {
                Policy.recorder.close();
                System.out.println(new String(os.toByteArray()));
                throw e;
            }
        }
        finally {
            Policy.recorder.close();
            Policy.recorder = null;
        }
    }

    protected void cleanup() throws CoreException {
        this.ensureDoesNotExistInWorkspace((IResource)EclipseTest.getWorkspace().getRoot());
        EclipseTest.getWorkspace().save(true, null);
        this.waitForBuild();
    }
}

