/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.cvsresources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.cvsresources.BatchedTestSetup;

public class EclipseSynchronizerTest
extends EclipseTest {
    private static EclipseSynchronizer sync = EclipseSynchronizer.getInstance();

    public EclipseSynchronizerTest() {
    }

    public EclipseSynchronizerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EclipseSynchronizerTest.class);
        suite.addTest((Test)new BatchedTestSetup((Test)new TestSuite(EclipseSynchronizerTest.class)));
        return new CVSTestSetup((Test)suite);
    }

    public void testFolderSync() throws CoreException, CVSException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        FolderSyncInfo info = sync.getFolderSync((IContainer)root);
        EclipseSynchronizerTest.assertNull((Object)info);
        sync.deleteFolderSync((IContainer)root);
        sync.setFolderSync((IContainer)root, this.dummyFolderSync((IContainer)root));
        info = sync.getFolderSync((IContainer)root);
        EclipseSynchronizerTest.assertNull((Object)info);
        IProject project = root.getProject(String.valueOf(this.getName()) + "-" + System.currentTimeMillis());
        this.assertDoesNotExistInFileSystem((IResource)project);
        this._testFolderSyncInvalid((IContainer)project);
        project.create(null);
        project.open(null);
        this._testFolderSyncValid((IContainer)project);
        IFolder folder = project.getFolder("folder1");
        this.assertDoesNotExistInFileSystem((IResource)folder);
        this._testFolderSyncInvalid((IContainer)folder);
        IFolder childFolder = folder.getFolder("folder2");
        this.assertDoesNotExistInFileSystem((IResource)childFolder);
        this._testFolderSyncInvalid((IContainer)childFolder);
        folder.create(false, true, null);
        this._testFolderSyncValid((IContainer)folder);
        childFolder.create(false, true, null);
        this._testFolderSyncValid((IContainer)childFolder);
        sync.setFolderSync((IContainer)folder, this.dummyFolderSync((IContainer)folder));
        folder.delete(false, null);
        this._testFolderSyncInvalid((IContainer)folder);
        folder.create(false, true, null);
        sync.setFolderSync((IContainer)folder, this.dummyFolderSync((IContainer)folder));
        folder.delete(false, null);
        folder.create(false, true, null);
        this._testFolderSyncValid((IContainer)folder);
        sync.setFolderSync((IContainer)project, this.dummyFolderSync((IContainer)project));
        project.delete(false, null);
        this._testFolderSyncInvalid((IContainer)project);
    }

    private void _testFolderSyncValid(IContainer container) throws CoreException, CVSException {
        FolderSyncInfo info = sync.getFolderSync(container);
        EclipseSynchronizerTest.assertNull((Object)info);
        sync.deleteFolderSync(container);
        FolderSyncInfo newInfo = this.dummyFolderSync(container);
        sync.setFolderSync(container, newInfo);
        info = sync.getFolderSync(container);
        EclipseSynchronizerTest.assertEquals((Object)newInfo, (Object)info);
        this.buildResources(container, new String[]{"hassync/", "nosync", "hassync.txt", "nosync.txt"}, true);
        IFile resource = container.getFile((IPath)new Path("hassync.txt"));
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        resource = container.getFolder((IPath)new Path("hassync"));
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        EclipseSynchronizerTest.assertNotNull((Object)sync.getResourceSync((IResource)container.getFile((IPath)new Path("hassync.txt"))));
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFile((IPath)new Path("nosync.txt"))));
        EclipseSynchronizerTest.assertNotNull((Object)sync.getResourceSync((IResource)container.getFolder((IPath)new Path("hassync"))));
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFolder((IPath)new Path("nosync"))));
        if (container.getType() == 2) {
            sync.setResourceSync((IResource)container, this.dummyResourceSync((IResource)container));
            EclipseSynchronizerTest.assertNotNull((Object)sync.getResourceSync((IResource)container));
        }
        sync.deleteFolderSync(container);
        info = sync.getFolderSync(container);
        EclipseSynchronizerTest.assertNull((Object)info);
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFile((IPath)new Path("hassync.txt"))));
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFile((IPath)new Path("nosync.txt"))));
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFolder((IPath)new Path("hassync"))));
        EclipseSynchronizerTest.assertNull((Object)sync.getResourceSync((IResource)container.getFolder((IPath)new Path("nosync"))));
        if (container.getType() == 2) {
            EclipseSynchronizerTest.assertNotNull((Object)sync.getResourceSync((IResource)container));
        }
    }

    private void _testFolderSyncInvalid(IContainer container) throws CVSException {
        FolderSyncInfo info = sync.getFolderSync(container);
        EclipseSynchronizerTest.assertNull((Object)info);
        sync.deleteFolderSync(container);
        try {
            sync.setFolderSync(container, this.dummyFolderSync(container));
            EclipseSynchronizerTest.fail((String)"Expected CVSException");
        }
        catch (CVSException cVSException) {}
        info = sync.getFolderSync(container);
        EclipseSynchronizerTest.assertNull((Object)info);
    }

    public void testResourceSync() throws CoreException, CVSException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this._testResourceSyncInvalid((IResource)root);
        IProject project = this.getUniqueTestProject(this.getName());
        this.assertExistsInFileSystem((IResource)project);
        this._testResourceSyncInvalid((IResource)project);
        IFolder folder = project.getFolder("folder1");
        folder.create(false, true, null);
        this._testResourceSyncValid((IResource)folder);
        IFile file = folder.getFile("file1");
        file.create(this.getRandomContents(), false, null);
        this._testResourceSyncValid((IResource)file);
        ResourceSyncInfo info = this.dummyResourceSync((IResource)file);
        sync.setResourceSync((IResource)file, info);
        file.delete(false, null);
        ResourceSyncInfo newInfo = sync.getResourceSync((IResource)file);
        EclipseSynchronizerTest.assertEquals((Object)newInfo, null);
        file.create(this.getRandomContents(), false, null);
        sync.setResourceSync((IResource)file, info);
        newInfo = sync.getResourceSync((IResource)file);
        EclipseSynchronizerTest.assertEquals((Object)newInfo, (Object)info);
        sync.deleteResourceSync((IResource)file);
        file.delete(false, null);
        this._testResourceSyncValid((IResource)file);
        sync.setResourceSync((IResource)file, info);
        folder.delete(false, null);
        info = sync.getResourceSync((IResource)file);
        EclipseSynchronizerTest.assertNull((Object)info);
        IFolder dummyFolder = project.getFolder("folder2");
        this.assertDoesNotExistInFileSystem((IResource)dummyFolder);
        IFile dummyFile = dummyFolder.getFile("file2");
        this.assertDoesNotExistInFileSystem((IResource)dummyFile);
        this._testResourceSyncInvalid((IResource)dummyFile);
    }

    private void _testResourceSyncValid(IResource resource) throws CVSException {
        ResourceSyncInfo info = sync.getResourceSync(resource);
        EclipseSynchronizerTest.assertNull((Object)info);
        sync.deleteResourceSync(resource);
        ResourceSyncInfo newInfo = this.dummyResourceSync(resource);
        sync.setResourceSync(resource, newInfo);
        info = sync.getResourceSync(resource);
        EclipseSynchronizerTest.assertEquals((Object)newInfo, (Object)info);
        sync.deleteResourceSync(resource);
        info = sync.getResourceSync(resource);
        EclipseSynchronizerTest.assertNull((Object)info);
    }

    private void _testResourceSyncInvalid(IResource resource) throws CVSException {
        ResourceSyncInfo info = sync.getResourceSync(resource);
        EclipseSynchronizerTest.assertNull((Object)info);
        sync.deleteResourceSync(resource);
        try {
            sync.setResourceSync(resource, this.dummyResourceSync(resource));
            EclipseSynchronizerTest.fail((String)"Expected CVSException");
        }
        catch (CVSException cVSException) {}
        info = sync.getResourceSync(resource);
        EclipseSynchronizerTest.assertNull((Object)info);
    }

    public void testIsIgnored() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("isIgnoredTests");
        CVSTeamProvider.markAsTempShare((IProject)project);
        this.buildResources((IContainer)project, new String[]{"a.txt", "c.java", "folder1/", "folder1/b.txt", "folder2/"}, true);
        sync.addIgnored((IContainer)project, "*.txt");
        this.assertIsIgnored((IResource)project.getFile("a.txt"), true);
        this.assertIsIgnored((IResource)project.getFile("c.java"), false);
        this.assertIsIgnored((IResource)project.getFolder("folder1"), false);
        this.assertIsIgnored((IResource)project.getFolder("folder2"), false);
        this.assertIsIgnored((IResource)project.getFile("folder1/b.txt"), false);
        this.assertIsIgnored((IResource)project.getFile("folder1/not-existing.txt"), false);
        this.assertIsIgnored((IResource)project.getParent(), false);
        this.assertIsIgnored((IResource)project, false);
        sync.addIgnored((IContainer)project, "folder1");
        this.assertIsIgnored((IResource)project.getFile("a.txt"), true);
        this.assertIsIgnored((IResource)project.getFile("c.java"), false);
        this.assertIsIgnored((IResource)project.getFolder("folder1"), true);
        this.assertIsIgnored((IResource)project.getFolder("folder2"), false);
        this.assertIsIgnored((IResource)project.getFile("folder1/b.txt"), true);
        this.assertIsIgnored((IResource)project.getFile("folder1/not-existing.txt"), true);
        this.assertIsIgnored((IResource)project.getParent(), false);
        this.assertIsIgnored((IResource)project, false);
        IFile cvsIgnore = project.getFile(".cvsignore");
        cvsIgnore.delete(true, null);
        EclipseSynchronizerTest.waitForIgnoreFileHandling();
        this.assertIsIgnored((IResource)project.getFile("a.txt"), false);
        this.assertIsIgnored((IResource)project.getFile("c.java"), false);
        this.assertIsIgnored((IResource)project.getFolder("folder1"), false);
        this.assertIsIgnored((IResource)project.getFolder("folder2"), false);
        this.assertIsIgnored((IResource)project.getFile("folder1/b.txt"), false);
        this.assertIsIgnored((IResource)project.getFile("folder1/not-existing.txt"), false);
        this.assertIsIgnored((IResource)project.getParent(), false);
        this.assertIsIgnored((IResource)project, false);
        project.delete(true, true, null);
    }

    public void testIgnores() throws CoreException, CVSException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this._testIgnoresInvalid((IContainer)root);
        IProject project = root.getProject(String.valueOf(this.getName()) + "-" + System.currentTimeMillis());
        this.assertDoesNotExistInFileSystem((IResource)project);
        this._testIgnoresInvalid((IContainer)project);
        project.create(null);
        project.open(null);
        this._testIgnoresValid((IContainer)project);
        IFolder folder = project.getFolder("folder1");
        this.assertDoesNotExistInFileSystem((IResource)folder);
        this._testIgnoresInvalid((IContainer)folder);
        IFolder childFolder = folder.getFolder("folder2");
        this.assertDoesNotExistInFileSystem((IResource)childFolder);
        this._testIgnoresInvalid((IContainer)childFolder);
        folder.create(false, true, null);
        this._testIgnoresValid((IContainer)folder);
        childFolder.create(false, true, null);
        this._testIgnoresValid((IContainer)childFolder);
        sync.addIgnored((IContainer)folder, "*.foo");
        folder.delete(false, null);
        this._testIgnoresInvalid((IContainer)folder);
        folder.create(false, true, null);
        sync.addIgnored((IContainer)folder, "*.foo");
        folder.delete(false, null);
        folder.create(false, true, null);
        this._testIgnoresValid((IContainer)folder);
        sync.addIgnored((IContainer)project, "*.foo");
        project.delete(false, null);
        this._testIgnoresInvalid((IContainer)project);
    }

    private void _testIgnoresValid(IContainer container) throws CVSException {
        String[] ignored = this.getIgnored(container);
        EclipseSynchronizerTest.assertTrue((ignored.length == 0 ? 1 : 0) != 0);
        sync.addIgnored(container, "*.xyz");
        ignored = this.getIgnored(container);
        this.assertBijection(ignored, new String[]{"*.xyz"}, null);
        sync.addIgnored(container, "*.abc");
        sync.addIgnored(container, "*.def");
        ignored = this.getIgnored(container);
        this.assertBijection(ignored, new String[]{"*.abc", "*.def", "*.xyz"}, null);
    }

    private String[] getIgnored(IContainer container) throws CVSException {
        if (container.getType() == 8) {
            return new String[0];
        }
        String[] ignored = SyncFileWriter.readCVSIgnoreEntries((IContainer)container);
        if (ignored == null) {
            return new String[0];
        }
        return ignored;
    }

    private void _testIgnoresInvalid(IContainer container) {
        try {
            sync.addIgnored(container, "*.xyz");
            EclipseSynchronizerTest.fail((String)"Expected CVSException");
        }
        catch (CVSException cVSException) {}
    }

    public void testIgnorePatterns() throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.shareProject(project);
        this.buildResources((IContainer)project, new String[]{"a/", "a.txt", "a.doc", "a/b/", "a/b.txt", "a/b.doc", "a/b/c/", "a/b/c.txt", "a/b/c.doc", "a/b/c/d/", "a/b/c/d.txt", "a/b/c/d.doc", "a/c/", "a/c/c.txt", "a/c/c.doc", "a/c/d/", "a/c/d.txt", "a/c/d.doc"}, false);
        Team.setAllIgnores((String[])new String[]{"/*/c/*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("a/b/c")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("a/b/c.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("a/b/c/d")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("a/b/c/d.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("a/c/d")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("a/c/d.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/" + project.getName() + "/?/c/*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("a/b/c/d")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("a/b/c/d.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("a/c/d")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("a/c/d.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/" + project.getName() + "/?/c/*.doc"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("a/c/d")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("a/c/c.doc")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("a/c/c.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("a/c/d.doc")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("a/c/d.txt")).isIgnored());
    }

    public void testBug279111() throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.shareProject(project);
        this.buildResources((IContainer)project, new String[]{"folder/", "folder/aaaa/", "folder/aaaa/aaaa.txt", "folder/aaaa/bbbb/", "folder/aaaa/bbbb/bbbb.txt", "folder/aaaa1/", "folder/aaaa1/aaaa1.txt", "folder/aaaa1/bbbb1/", "folder/aaaa1/bbbb1/bbbb1.txt"}, false);
        Team.setAllIgnores((String[])new String[]{"/*/aaaa/*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/*/aaaa*/*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/*/aaaa?/*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
    }

    public void testBug279111_comment11() throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.shareProject(project);
        this.buildResources((IContainer)project, new String[]{"folder/", "folder/aaaa/", "folder/aaaa/aaaa.txt", "folder/aaaa/bbbb/", "folder/aaaa/bbbb/bbbb.txt", "folder/aaaa1/", "folder/aaaa1/aaaa1.txt", "folder/aaaa1/bbbb1/", "folder/aaaa1/bbbb1/bbbb1.txt"}, false);
        Team.setAllIgnores((String[])new String[]{"*/aaaa", "*/aaaa/*"}, (boolean[])new boolean[]{true, true});
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"*/aaaa*", "*/aaaa*/*"}, (boolean[])new boolean[]{true, true});
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/*/aaaa"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertFalse((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
        Team.setAllIgnores((String[])new String[]{"/*/aaaa*"}, (boolean[])new boolean[]{true});
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa/bbbb")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa/bbbb/bbbb.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/aaaa.txt")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFolder("folder/aaaa1/bbbb1")).isIgnored());
        EclipseSynchronizerTest.assertTrue((boolean)this.getCVSResource((IResource)project.getFile("folder/aaaa1/bbbb1/bbbb1.txt")).isIgnored());
    }

    public void testMembers() throws CoreException, CVSException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1 = this.getUniqueTestProject(String.valueOf(this.getName()) + "1");
        IProject project2 = root.getProject(String.valueOf(this.getName()) + "2" + System.currentTimeMillis());
        IResource[] members = sync.members((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        this.assertBijection(members, ResourcesPlugin.getWorkspace().getRoot().getProjects(), null);
        members = sync.members((IContainer)project2);
        EclipseSynchronizerTest.assertEquals((String)"Non-existant project should have no members", (int)0, (int)members.length);
        IFolder folder = project1.getFolder("folder1");
        this.assertDoesNotExistInFileSystem((IResource)folder);
        members = sync.members((IContainer)folder);
        EclipseSynchronizerTest.assertEquals((String)"Non-existant folder should have no members", (int)0, (int)members.length);
        IFolder childFolder = folder.getFolder("folder2");
        this.assertDoesNotExistInFileSystem((IResource)childFolder);
        members = sync.members((IContainer)childFolder);
        EclipseSynchronizerTest.assertEquals((String)"Non-existant folder should have no members", (int)0, (int)members.length);
        this.buildResources((IContainer)project1, new String[]{"hassync.txt", "deleted_nosync.txt", "deleted.txt", "hassync/", "deleted/", "deleted_nosync/"}, true);
        IResource[] ignores = new IResource[]{project1.getFolder("CVS")};
        HashSet<IResource> expectedMembers = new HashSet<IResource>(Arrays.asList(project1.members()));
        members = sync.members((IContainer)project1);
        this.assertBijection(expectedMembers.toArray(), members, ignores);
        IFile resource = project1.getFile("hassync.txt");
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        resource = project1.getFolder("hassync");
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        resource = project1.getFile("deleted.txt");
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        resource = project1.getFolder("deleted");
        sync.setResourceSync((IResource)resource, this.dummyResourceSync((IResource)resource));
        members = sync.members((IContainer)project1);
        this.assertBijection(expectedMembers.toArray(), members, ignores);
        resource = project1.getFile("deleted.txt");
        resource.delete(false, null);
        expectedMembers.remove(resource);
        resource = project1.getFolder("deleted");
        resource.delete(false, null);
        expectedMembers.remove(resource);
        resource = project1.getFile("deleted_nosync.txt");
        resource.delete(false, null);
        expectedMembers.remove(resource);
        resource = project1.getFolder("deleted_nosync");
        resource.delete(false, null);
        expectedMembers.remove(resource);
        members = sync.members((IContainer)project1);
        this.assertBijection(expectedMembers.toArray(), members, ignores);
        resource = project1.getFile("hassync.txt");
        sync.deleteResourceSync((IResource)resource);
        resource = project1.getFolder("hassync");
        sync.deleteResourceSync((IResource)resource);
        resource = project1.getFile("deleted.txt");
        sync.deleteResourceSync((IResource)resource);
        expectedMembers.remove(resource);
        resource = project1.getFolder("deleted");
        sync.deleteResourceSync((IResource)resource);
        expectedMembers.remove(resource);
        members = sync.members((IContainer)project1);
        this.assertBijection(expectedMembers.toArray(), members, ignores);
    }

    private FolderSyncInfo dummyFolderSync(IContainer container) {
        return new FolderSyncInfo("repo", ":pserver:user@host:/root", CVSTag.DEFAULT, false);
    }

    private ResourceSyncInfo dummyResourceSync(IResource resource) {
        if (resource.getType() == 1) {
            MutableResourceSyncInfo info = new MutableResourceSyncInfo(resource.getName(), "1.1");
            info.setTag(CVSTag.DEFAULT);
            return info;
        }
        return new ResourceSyncInfo(resource.getName());
    }

    private <T> void assertBijection(T[] a, T[] b, T[] ignores) {
        LinkedList<T> listA = new LinkedList<T>(Arrays.asList(a));
        LinkedList<T> listB = new LinkedList<T>(Arrays.asList(b));
        if (ignores != null) {
            T[] TArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                T ignore = TArray[n2];
                listA.remove(ignore);
                listB.remove(ignore);
                ++n2;
            }
        }
        EclipseSynchronizerTest.assertEquals((String)"Should have same number of elements", (int)listA.size(), (int)listB.size());
        for (Object t : listB) {
            EclipseSynchronizerTest.assertTrue((String)"Should contain the same elements", (boolean)listA.contains(t));
            listA.remove(t);
        }
    }

    @Override
    protected IProject createProject(String[] resourcePaths) throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.buildResources((IContainer)project, resourcePaths, true);
        project.accept(resource -> {
            if (resource.getType() != 4) {
                sync.setResourceSync(resource, this.dummyResourceSync(resource));
            }
            if (resource.getType() != 1) {
                sync.setFolderSync((IContainer)resource, this.dummyFolderSync((IContainer)resource));
            }
            return true;
        });
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
        return project;
    }

    protected void assertHasSyncInfo(IProject project, String[] resourcePaths) throws CVSException {
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IResource resource = this.findResource(project, path);
            this.assertHasSyncInfo(resource);
            ++n2;
        }
    }

    private IResource findResource(IProject project, String path) {
        Object resource = project.findMember(path);
        if (resource == null) {
            resource = path.charAt(path.length() - 1) == '/' ? project.getFolder(path) : project.getFile(path);
        }
        return resource;
    }

    protected void assertHasSyncInfo(IResource resource) throws CVSException {
        if (resource.getType() == 8) {
            return;
        }
        if (resource.getType() != 1) {
            EclipseSynchronizerTest.assertNotNull((String)("Folder should have folder sync info but does not: " + resource.getProjectRelativePath()), (Object)sync.getFolderSync((IContainer)resource));
        }
        if (resource.getType() != 4) {
            EclipseSynchronizerTest.assertNotNull((String)("Resource should have sync bytes but does not: " + resource.getProjectRelativePath()), (Object)sync.getSyncBytes(resource));
            this.assertHasSyncInfo((IResource)resource.getParent());
        }
    }

    private void assertHasNoSyncInfo(IProject project, String[] resourcePaths) throws CoreException {
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IResource resource = this.findResource(project, path);
            this.assertHasNoSyncInfo(resource);
            ++n2;
        }
    }

    protected void assertHasNoSyncInfo(IResource resource) throws CoreException {
        if (resource.getType() == 8) {
            return;
        }
        if (resource.getType() != 1) {
            IResource[] members;
            EclipseSynchronizerTest.assertNull((String)("Folder should not have folder sync but does: " + resource.getProjectRelativePath()), (Object)sync.getFolderSync((IContainer)resource));
            IResource[] iResourceArray = members = ((IContainer)resource).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.assertHasNoSyncInfo(child);
                ++n2;
            }
        }
        if (resource.getType() != 4) {
            EclipseSynchronizerTest.assertNull((String)("Resource should not have sync bytes but does: " + resource.getProjectRelativePath()), (Object)sync.getSyncBytes(resource));
        }
    }

    public void testDeleteFile() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/folder2/file1", "folder1/folder2/file2"});
        IFile file = project.getFile("folder1/folder2/file1");
        file.delete(false, false, null);
        this.assertHasSyncInfo(project, new String[]{"folder1/folder2/file1"});
    }

    public void testDeleteFolder() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/folder2/file1", "folder1/folder2/file2"});
        IFolder folder = project.getFolder("folder1/folder2/");
        folder.delete(false, false, null);
        this.assertHasSyncInfo(project, new String[]{"folder1/folder2/file1", "folder1/folder2/file2"});
    }

    public void testMoveFile() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/folder2/file1", "folder1/folder2/file2"});
        IFile file = project.getFile("folder1/folder2/file1");
        project.getFolder("folder1/folder3/").create(false, true, null);
        file.move(project.getFolder("folder1/folder3/file1").getFullPath(), false, null);
        this.assertHasSyncInfo(project, new String[]{"folder1/folder2/file1"});
        this.assertHasNoSyncInfo(project, new String[]{"folder1/folder3"});
    }

    public void testMoveFolder() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/folder2/file1"});
        IFolder folder = project.getFolder("folder1/folder2/");
        folder.move(project.getFolder("folder1/folder3").getFullPath(), false, null);
        this.assertHasSyncInfo(project, new String[]{"folder1/folder2/file1"});
        this.assertHasNoSyncInfo(project, new String[]{"folder1/folder3/"});
    }

    public void testFileRecreation() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/file1"});
        IFile file = project.getFile("folder1/file1");
        file.delete(false, false, null);
        this.assertHasSyncInfo((IResource)file);
        file.create(this.getRandomContents(), false, null);
        this.assertHasSyncInfo((IResource)file);
        sync.deleteResourceSync((IResource)file);
        this.assertHasNoSyncInfo((IResource)file);
    }

    public void testFileMoveAndDelete() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/file1", "folder1/file2"});
        sync.run((ISchedulingRule)project, monitor -> {
            try {
                IFile file1 = project.getFile("folder1/file1");
                IFile file2 = project.getFile("folder1/file2");
                file1.delete(false, false, null);
                this.assertHasSyncInfo((IResource)file1);
                this.assertHasSyncInfo((IResource)file2);
                sync.deleteResourceSync((IResource)file1);
                this.assertHasNoSyncInfo((IResource)file1);
                this.assertHasSyncInfo((IResource)file2);
                file2.move((IPath)new Path("file3"), false, false, null);
                this.assertHasNoSyncInfo((IResource)file1);
                this.assertHasSyncInfo((IResource)file2);
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }, null);
    }

    public void testMoveFolderOverFolder() throws CoreException {
        IProject project = this.createProject(new String[]{"folder1/file1", "folder2/file1"});
        String revision = "1.9";
        IFile file11 = project.getFile("folder1/file1");
        ResourceSyncInfo info = sync.getResourceSync((IResource)file11);
        MutableResourceSyncInfo muttable = info.cloneMutable();
        muttable.setRevision(revision);
        sync.setResourceSync((IResource)file11, (ResourceSyncInfo)muttable);
        project.getFolder("folder2").delete(false, false, null);
        project.getFolder("folder1").move((IPath)new Path("folder2"), false, false, null);
        this.assertHasSyncInfo((IResource)file11);
        IFile file21 = project.getFile("folder2/file1");
        this.assertHasSyncInfo((IResource)file21);
        EclipseSynchronizerTest.assertTrue((boolean)sync.getResourceSync((IResource)file11).getRevision().equals(revision));
        EclipseSynchronizerTest.assertTrue((!sync.getResourceSync((IResource)file21).getRevision().equals(revision) ? 1 : 0) != 0);
    }
}

