/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.mappings.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.tests.ccvs.core.mappings.model.ModelFile;
import org.eclipse.team.tests.ccvs.core.mappings.model.ModelProject;

public abstract class ModelObject
extends PlatformObject {
    private final IResource resource;

    public static ModelObject create(IResource resource) {
        switch (resource.getType()) {
            case 4: {
                return new ModelProject((IProject)resource);
            }
            case 1: {
                if (!ModelFile.isModFile(resource)) break;
                return new ModelFile((IFile)resource);
            }
        }
        return null;
    }

    protected ModelObject(IResource resource) {
        this.resource = resource;
    }

    public abstract ModelObject[] getChildren() throws CoreException;

    public IResource getResource() {
        return this.resource;
    }

    public String getName() {
        return this.getResource().getName();
    }

    public String getPath() {
        return this.getResource().getFullPath().makeRelative().toString();
    }

    public ModelObject getParent() {
        return ModelObject.create((IResource)this.getResource().getParent());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelObject) {
            ModelObject mr = (ModelObject)((Object)obj);
            return this.getResource().equals((Object)mr.getResource());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public void delete() throws CoreException {
        this.getResource().delete(false, null);
    }

    public ModelProject getProject() {
        return (ModelProject)ModelObject.create((IResource)this.getResource().getProject());
    }
}

