/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class CVSProviderTest
extends EclipseTest {
    public CVSProviderTest() {
    }

    public CVSProviderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return CVSProviderTest.suite(CVSProviderTest.class);
    }

    public void testAdd() {
    }

    public void testDeleteHandling() throws TeamException, CoreException {
        IProject project = this.createProject("testDeleteHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        project.getFile("deleted.txt").delete(false, false, null);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("deleted.txt"));
        CVSProviderTest.assertTrue((String)"File is not outgoing deletion", (boolean)file.getSyncInfo().isDeleted());
        project.getFolder("folder1").delete(false, false, null);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("folder1"));
        CVSProviderTest.assertTrue((String)"Deleted folder not in proper state", (!folder.exists() && folder.isManaged() ? 1 : 0) != 0);
    }

    public void testCheckin() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testCheckin", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IResource[] newResources = this.buildResources((IContainer)project, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.addResources(newResources);
        this.deleteResources(new IResource[]{project.getFile("deleted.txt")});
        this.assertIsModified("testDeepCheckin: ", newResources);
        this.assertIsModified("testDeepCheckin: ", new IResource[]{project.getFile("deleted.txt"), project.getFile("changed.txt")});
        this.commitResources(new IResource[]{project}, 2);
        this.assertLocalStateEqualsRemote(project);
    }

    public void testMoveHandling() throws TeamException, CoreException {
        IProject project = this.createProject("testMoveHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        project.getFile("deleted.txt").move((IPath)new Path("moved.txt"), false, false, null);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("deleted.txt"));
        CVSProviderTest.assertTrue((String)"Source is not outgoing deletion", (boolean)file.getSyncInfo().isDeleted());
        file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("moved.txt"));
        CVSProviderTest.assertTrue((String)"Destination not in proper state", (!file.isManaged() ? 1 : 0) != 0);
        project.getFolder("folder1").move((IPath)new Path("moved"), false, false, null);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("folder1"));
        CVSProviderTest.assertTrue((String)"Deleted folder not in proper state", (!folder.exists() && folder.isManaged() ? 1 : 0) != 0);
        folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("moved"));
        CVSProviderTest.assertTrue((String)"Moved folder should not be managed", (!folder.isManaged() ? 1 : 0) != 0);
        CVSProviderTest.assertTrue((String)"Moved folder should not be a CVS folder", (!folder.isCVSFolder() ? 1 : 0) != 0);
    }

    public void testUpdate() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testUpdate", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.deleteResources(new IResource[]{copy.getFile("deleted.txt")});
        this.commitResources(new IResource[]{copy}, 2);
        this.updateProject(project, null, false);
        this.assertEquals(project, copy);
    }

    public void testUpdate123280() throws CoreException {
        IProject project = this.createProject(new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
        this.commitProject(copy);
        project.getFile("deleted.txt").delete(false, null);
        this.updateProject(project, null, false);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("deleted.txt"));
        CVSProviderTest.assertTrue((!file.exists() && file.isManaged() ? 1 : 0) != 0);
    }

    public void testVersionTag() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testVersionTag", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.changeResources((IContainer)copy, new String[]{"changed.txt"}, false);
        this.deleteResources((IContainer)copy, new String[]{"deleted.txt"}, false);
        this.commitResources((IContainer)copy, true);
        CVSTag v1Tag = new CVSTag("v1", 2);
        this.tagProject(project, v1Tag, false);
        IProject v1 = this.checkoutCopy(project, v1Tag);
        this.assertEquals(project, v1);
        this.updateProject(project, null, false);
        this.assertEquals(project, copy, false, true);
        this.updateProject(copy, v1Tag, false);
        this.assertEquals(copy, v1, false, true);
        this.updateProject(copy, CVSTag.DEFAULT, false);
        this.assertEquals(project, copy, false, true);
    }

    public void testMakeBranch() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testMakeBranch", new String[]{"file1.txt", "file2.txt", "file3.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.addResources((IContainer)project, new String[]{"folder1/c.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"folder1/b.txt"}, false);
        this.changeResources((IContainer)project, new String[]{"file2.txt"}, false);
        CVSTag version = new CVSTag("v1", 1);
        CVSTag branch = new CVSTag("branch1", 1);
        this.makeBranch(new IResource[]{project}, version, branch, true);
        IProject branchCopy = this.checkoutCopy(project, branch);
        IProject versionCopy = this.checkoutCopy(project, version);
        this.assertEquals(branchCopy, versionCopy, true, false);
        this.commitProject(project);
        this.updateProject(branchCopy, null, false);
        this.assertEquals(branchCopy, project, false, true);
    }

    public void testDuplicatedBranch() throws TeamException, CoreException {
        IProject project = this.createProject("testDuplicatedBranch", new String[]{"file1.txt", "file2.txt", "file3.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag version = new CVSTag("v1", 1);
        CVSTag branch = new CVSTag("branch1", 1);
        this.makeBranch(new IResource[]{project}, version, branch, false);
        try {
            this.makeBranch(new IResource[]{project}, version, branch, false);
            CVSProviderTest.fail();
        }
        catch (CVSException cVSException) {}
    }

    public void testPruning() throws TeamException, CoreException, IOException {
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(false);
        IProject project = this.createProject("testPruning", new String[]{"file.txt", "folder1/", "folder2/folder3/"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertEquals(project, copy);
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(true);
        this.updateProject(copy, null, false);
        this.assertDoesNotExistInFileSystem(new IResource[]{copy.getFolder("folder1"), copy.getFolder("folder2"), copy.getFolder("folder2/folder3")});
        IProject copy2 = this.checkoutCopy(project, "-copy2");
        this.assertEquals(copy, copy2);
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(true);
    }

    public void testGet() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testGet", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.deleteResources((IContainer)copy, new String[]{"deleted.txt"}, false);
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.replace(new IResource[]{copy}, null, true);
        this.assertEquals(project, copy);
    }

    public void testReadOnly() {
    }

    public void testCleanLineDelimiters() throws TeamException, CoreException, IOException {
        IProject project = this.getUniqueTestProject("testCleanLineDelimiters");
        IFile file = project.getFile("testfile");
        NullProgressMonitor monitor = new NullProgressMonitor();
        CVSProviderTest.setFileContents(file, "");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "");
        CVSProviderTest.setFileContents(file, "a");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "a");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "a");
        CVSProviderTest.setFileContents(file, "\r");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\r");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\r");
        CVSProviderTest.setFileContents(file, "\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\r\n");
        CVSProviderTest.setFileContents(file, "\r\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\r\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "\n");
        CVSProviderTest.setFileContents(file, "The \r\n quick brown \n fox \r\r\r\n jumped \n\n over \r\n the \n lazy dog.\r\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)false, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "The \n quick brown \n fox \r\r\n jumped \n\n over \n the \n lazy dog.\n");
        CVSProviderTest.setFileContents(file, "The \r\n quick brown \n fox \r\r\r\n jumped \n\n over \r\n the \n lazy dog.\r\n");
        CVSTeamProvider.cleanLineDelimiters((IFile)file, (boolean)true, (IProgressMonitor)monitor);
        CVSProviderTest.assertEqualsFileContents(file, "The \r\n quick brown \r\n fox \r\r\r\n jumped \r\n\r\n over \r\n the \r\n lazy dog.\r\n");
    }

    public void testKeywordSubstitution() throws TeamException, CoreException {
        this.testKeywordSubstitution(Command.KSUBST_BINARY);
        this.testKeywordSubstitution(Command.KSUBST_TEXT);
        this.testKeywordSubstitution(Command.KSUBST_TEXT_EXPAND);
    }

    private void testKeywordSubstitution(Command.KSubstOption ksubst) throws TeamException, CoreException {
        Team.setAllTypes((String[])new String[]{"xbin", "xtxt"}, (int[])new int[]{2, 1});
        IProject project = this.createProject("testKeywordSubstitution", new String[]{"dummy"});
        this.addResources((IContainer)project, new String[]{"binary.xbin", "text.xtxt", "folder1/", "folder1/a.xtxt"}, true);
        this.addResources((IContainer)project, new String[]{"added.xbin", "added.xtxt"}, false);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "binary.xbin", Command.KSUBST_BINARY);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "added.xbin", Command.KSUBST_BINARY);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "text.xtxt", CVSProviderPlugin.DEFAULT_TEXT_KSUBST_OPTION);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "folder1/a.xtxt", CVSProviderPlugin.DEFAULT_TEXT_KSUBST_OPTION);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "added.xtxt", CVSProviderPlugin.DEFAULT_TEXT_KSUBST_OPTION);
        HashMap<IFile, Command.KSubstOption> map = new HashMap<IFile, Command.KSubstOption>();
        map.put(project.getFile("binary.xbin"), ksubst);
        map.put(project.getFile("added.xbin"), ksubst);
        map.put(project.getFile("text.xtxt"), ksubst);
        map.put(project.getFile("folder1/a.xtxt"), ksubst);
        map.put(project.getFile("added.xtxt"), ksubst);
        this.waitMsec(1500);
        IStatus status = this.getProvider((IResource)project).setKeywordSubstitution(map, null, null);
        CVSProviderTest.assertTrue((String)("Status should be ok, was: " + status.toString()), (boolean)status.isOK());
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "binary.xbin", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "text.xtxt", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "folder1/a.xtxt", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "added.xtxt", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "added.xbin", ksubst);
        IProject copy = this.checkoutCopy(project, "-copy");
        CVSProviderTest.assertHasKSubstOption((IContainer)copy, "binary.xbin", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)copy, "text.xtxt", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)copy, "folder1/a.xtxt", ksubst);
        this.assertDoesNotExistInWorkspace((IResource)copy.getFile("added.xtxt"));
        this.assertDoesNotExistInWorkspace((IResource)copy.getFile("added.xbin"));
        this.commitResources((IContainer)project, new String[]{"added.xbin", "added.xtxt"});
        IProject copy2 = this.checkoutCopy(project, "-copy2");
        CVSProviderTest.assertHasKSubstOption((IContainer)copy2, "added.xtxt", ksubst);
        CVSProviderTest.assertHasKSubstOption((IContainer)copy2, "added.xbin", ksubst);
        IFileTypeInfo[] infos = Team.getDefaultTypes();
        String[] extensions = new String[infos.length];
        int[] types = new int[infos.length];
        int i = 0;
        while (i < infos.length) {
            IFileTypeInfo info = infos[i];
            extensions[i] = info.getExtension();
            types[i] = info.getType();
            ++i;
        }
        Team.setAllTypes((String[])extensions, (int[])types);
    }

    public void testKeywordSubsBinToText() throws TeamException, CoreException, IOException {
        Command.KSubstOption ksubst = Command.KSUBST_TEXT;
        IProject project = this.createProject("testKeywordSubsBinToText", new String[]{"dummy"});
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "dummy", Command.KSUBST_BINARY);
        HashMap<IFile, Command.KSubstOption> map = new HashMap<IFile, Command.KSubstOption>();
        map.put(project.getFile("dummy"), ksubst);
        this.waitMsec(1500);
        IStatus status = this.getProvider((IResource)project).setKeywordSubstitution(map, null, null);
        CVSProviderTest.assertTrue((String)("Status should be ok, was: " + status.toString()), (boolean)status.isOK());
        CVSProviderTest.assertHasKSubstOption((IContainer)project, "dummy", ksubst);
        IProject copy = this.checkoutCopy(project, "-copy");
        CVSProviderTest.assertHasKSubstOption((IContainer)copy, "dummy", ksubst);
        this.assertEquals(project, copy);
    }

    public static void setFileContents(IFile file, String string) throws CoreException {
        ByteArrayInputStream is = new ByteArrayInputStream(string.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)is, false, true, null);
        } else {
            file.create((InputStream)is, false, null);
        }
    }

    public static void assertEqualsFileContents(IFile file, String string) throws CoreException, IOException {
        String other = CVSProviderTest.getFileContents(file);
        CVSProviderTest.assertEquals((String)string, (String)other);
    }

    public static void assertHasKSubstOption(IContainer container, String filename, Command.KSubstOption ksubst) throws TeamException {
        IFile file = container.getFile((IPath)new Path(filename));
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        ResourceSyncInfo info = cvsFile.getSyncInfo();
        CVSProviderTest.assertEquals((Object)ksubst, (Object)info.getKeywordMode());
    }

    public void testUnmap() throws CoreException, TeamException {
        IProject project = this.createProject("testUnmap", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/", "folder1/folder2/deep.txt", "folder2/b.txt"});
        project.getFile("deleted.txt").delete(false, false, null);
        CVSProviderTest.assertTrue((boolean)project.getFile("deleted.txt").isPhantom());
        project.getFolder("folder2").delete(false, false, null);
        CVSProviderTest.assertTrue((boolean)project.getFolder("folder2").isPhantom());
        RepositoryProvider.unmap((IProject)project);
        CVSProviderTest.assertFalse((boolean)project.getFile("deleted.txt").isPhantom());
        CVSProviderTest.assertFalse((boolean)project.getFolder("folder2").isPhantom());
        project = this.createProject("testUnmap2", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/", "folder1/folder2/deep.txt", "folder2/b.txt"});
        project.getFolder("folder1/folder2").delete(false, false, null);
        CVSProviderTest.assertTrue((boolean)project.getFolder("folder1/folder2").isPhantom());
        RepositoryProvider.unmap((IProject)project);
        CVSProviderTest.assertFalse((boolean)project.getFolder("folder1/folder2").isPhantom());
    }

    public void testForBinaryLinefeedCorruption() throws CoreException, TeamException, IOException {
        String EOL = "\n";
        IProject project = this.createProject("testForBinaryLinefeedCorruption", new String[]{"binaryFile"});
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("binaryFile"));
        CVSProviderTest.assertTrue((boolean)ResourceSyncInfo.isBinary((byte[])cvsFile.getSyncBytes()));
        this.setContentsAndEnsureModified(project.getFile("binaryFile"), "line 1" + EOL + "line 2");
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertEquals(project, copy);
    }

    public void test33984CannotCommitAfterConflictsMergedLocally() throws CoreException, TeamException, IOException {
        String EOL = System.getProperty("line.separator");
        IProject project = this.createProject("test33984", new String[]{"a.txt", "b.txt"});
        this.setContentsAndEnsureModified(project.getFile("a.txt"), "line 1");
        this.setContentsAndEnsureModified(project.getFile("b.txt"), "line 1" + EOL + "line 2" + EOL + "line3");
        HashMap<IFile, Command.KSubstOption> kMode = new HashMap<IFile, Command.KSubstOption>();
        kMode.put(project.getFile("a.txt"), Command.KSUBST_TEXT);
        kMode.put(project.getFile("b.txt"), Command.KSUBST_TEXT);
        this.getProvider((IResource)project).setKeywordSubstitution(kMode, "", null);
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertEquals(project, copy);
        this.setContentsAndEnsureModified(copy.getFile("b.txt"), "line 1a" + EOL + "line 2" + EOL + "line3");
        this.commitProject(copy);
        this.setContentsAndEnsureModified(project.getFile("b.txt"), "line 1" + EOL + "line 2" + EOL + "line3a");
        this.updateProject(project, CVSTag.DEFAULT, false);
        this.commitProject(project);
        this.setContentsAndEnsureModified(copy.getFile("a.txt"), "line 1dfgdfne3");
        this.commitProject(copy);
        this.setContentsAndEnsureModified(project.getFile("a.txt"), "some other text");
        this.updateProject(project, CVSTag.DEFAULT, false);
        try {
            this.commitProject(project);
            CVSProviderTest.fail((String)"should not be allowed to commit a resource with merged conflicts");
        }
        catch (TeamException teamException) {}
    }

    public void testTagExistsFailure() throws TeamException, CoreException, IOException {
        IProject project = this.createProject(new String[]{"a.txt", "b.txt"});
        CVSTag tag = new CVSTag("v1", 2);
        this.tagProject(project, tag, false);
        this.setContentsAndEnsureModified(project.getFile("a.txt"));
        this.commitProject(project);
        try {
            this.tagProject(project, tag, false);
            CVSProviderTest.fail((String)"The tag should have failed since the tag already exists.");
        }
        catch (TeamException e) {
            CVSProviderTest.assertTrue((String)"This exception should be an error", (e.getStatus().getSeverity() == 4 ? 1 : 0) != 0);
        }
        this.tagProject(project, tag, true);
        IProject copy = this.checkoutCopy(project, tag);
        this.assertEquals(project, copy);
    }

    public void testUpdateWithOverwrite() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"a.txt", "b.txt"});
        this.buildResources((IContainer)project, new String[]{"new.txt"}, false);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"new.txt"}, true);
        IStatus status = this.executeCommand(project, Command.UPDATE, Command.NO_LOCAL_OPTIONS);
        this.assertStatusContainsCode(status, -27);
        status = this.executeCommand(project, Command.REPLACE, Command.NO_LOCAL_OPTIONS);
        CVSProviderTest.assertTrue((boolean)status.isOK());
    }

    private IStatus executeCommand(IProject project, Update update, Command.LocalOption[] options) throws CVSException {
        session.open(DEFAULT_MONITOR);
        try (Session session = new Session((ICVSRepositoryLocation)this.getRepository(), CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));){
            IStatus iStatus = update.execute(session, Command.NO_GLOBAL_OPTIONS, options, new String[]{"."}, null, DEFAULT_MONITOR);
            return iStatus;
        }
    }

    private void setOnlyLookAtTimestamps(boolean b) {
        CVSUIPlugin.getPlugin().getPreferenceStore().setValue("pref_consider_contents", !b);
    }

    public void testUpdateWithNoChange() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"a.txt"});
        this.setContentsAndEnsureModified(project.getFile("a.txt"), "contents");
        this.commitProject(project);
        this.setOnlyLookAtTimestamps(true);
        this.setContentsAndEnsureModified(project.getFile("a.txt"), "contents");
        this.updateProject(project, null, false);
        Date modDate = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("a.txt")).getSyncInfo().getTimeStamp();
        CVSProviderTest.assertEquals((String)"Timestamp was not properly reset", (Object)modDate, (Object)CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("a.txt")).getTimeStamp());
        this.setOnlyLookAtTimestamps(false);
    }

    public void testBinaryAddition() throws CoreException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            IProject copy = this.checkoutCopy(project, "-copy");
            this.create((IResource)copy.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(copy.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{copy.getFile("binaryFile")});
            this.commitProject(copy);
            this.updateProject(project, null, false);
            this.assertContentsEqual(copy.getFile("binaryFile"), project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testDeletedPhantom139250() throws CoreException {
        IProject project = this.createProject(new String[]{"a.txt"});
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("phantom"));
        ICVSFolder projectFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        FolderSyncInfo projectInfo = projectFolder.getFolderSyncInfo();
        String repo = Util.appendPath((String)projectInfo.getRepository(), (String)"phantom");
        FolderSyncInfo info = new FolderSyncInfo(repo, projectInfo.getRoot(), (CVSTag)projectInfo.getTag(), false);
        folder.setFolderSyncInfo(info);
        this.updateProject(project, null, false);
    }

    public void testUpdateOfDeletedFile140007() throws CoreException {
        IProject project = this.createProject(new String[]{"a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.deleteResources((IContainer)copy, new String[]{"a.txt"}, true);
        this.updateResources((IContainer)project, new String[]{"a.txt"}, false);
    }

    public void testUpdateOfRemotelyRemovedFile() throws CoreException, IOException {
        IProject project = this.createProject(new String[]{"a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"b.txt"}, false);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)copy.getFile("b.txt"));
        byte[] syncBytes = file.getSyncBytes();
        syncBytes = ResourceSyncInfo.setRevision((byte[])syncBytes, (String)"1.1");
        file.setSyncBytes(syncBytes, 0);
        file.checkedIn(null, true);
        this.updateProject(copy, null, false);
        this.assertEquals(project, copy);
    }

    public void testMergeWithTrailingLineFeeds() throws CoreException, IOException {
        IProject project = this.createProject("testFileConflict", new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "line1" + eol + "line2" + eol + "line3" + eol);
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.appendText((IResource)copy.getFile("file1.txt"), "line0" + eol, true);
        this.commitProject(copy);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "line1" + eol + "line2" + eol + "line2.5" + eol + "line3" + eol);
        this.updateProject(project, null, false);
        CVSProviderTest.assertTrue((String)"File contents are not correct after merge", (boolean)this.compareContent(new ByteArrayInputStream(("line0" + eol + "line1" + eol + "line2" + eol + "line2.5" + eol + "line3" + eol).getBytes()), project.getFile("file1.txt").getContents()));
    }

    public void testRevertToBaseHeadTag() throws CoreException, IOException {
        IProject project = this.createProject("testRevertToBase", new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "line1" + eol + "line2" + eol + "line3" + eol);
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.appendText((IResource)project.getFile("file1.txt"), "line0" + eol, true);
        this.updateProject(project, CVSTag.BASE, true);
        CVSProviderTest.assertTrue((String)"File has changed after revert to base", (boolean)this.compareContent(new ByteArrayInputStream(("line1" + eol + "line2" + eol + "line3" + eol).getBytes()), project.getFile("file1.txt").getContents()));
        this.assertEquals(this.getRepositoryProvider(copy), this.getRepositoryProvider(project), false, true);
    }

    private CVSTeamProvider getRepositoryProvider(IProject project) {
        return (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
    }

    public void testRevertToBaseNonHeadTag() throws CoreException, IOException {
        IProject project = this.createProject("testRevertToBaseNonHead", new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "line1" + eol + "line2" + eol);
        this.commitProject(project);
        this.tagProject(project, new CVSTag("testtag", 1), true);
        this.appendText((IResource)project.getFile("file1.txt"), "line3" + eol, true);
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.appendText((IResource)copy.getFile("file1.txt"), "line0" + eol, true);
        this.updateProject(copy, CVSTag.BASE, true);
        CVSProviderTest.assertTrue((String)"File has changed after revert to base", (boolean)this.compareContent(new ByteArrayInputStream(("line3" + eol + "line1" + eol + "line2" + eol).getBytes()), copy.getFile("file1.txt").getContents()));
        this.assertEquals(this.getRepositoryProvider(project), this.getRepositoryProvider(copy), false, true);
    }

    public void testSwitchTagForModifiedFile() throws CoreException, IOException {
        IProject project = this.createProject("testSwitchTagForModifiedFile", new String[]{"file"});
        this.commitProject(project);
        CVSTag tag = new CVSTag("A", 1);
        this.tagProject(project, tag, true);
        this.appendText((IResource)project.getFile("file"), "changed in head" + eol, false);
        this.updateProject(project, tag, false);
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("file"));
        CVSProviderTest.assertEquals((Object)tag, (Object)cvsFile.getSyncInfo().getTag());
    }
}

