/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class LinkResourcesTest
extends EclipseTest {
    public LinkResourcesTest() {
    }

    public LinkResourcesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LinkResourcesTest.class);
        return new CVSTestSetup((Test)suite);
    }

    public void testMapSuccess() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testLinkSuccess");
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"}, true);
        IFolder folder = project.getFolder("link");
        folder.createLink(Platform.getLocation().append("temp"), 16, null);
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        cvsFolder.setFolderSyncInfo(new FolderSyncInfo("repo/root", ":pserver:name@host:/root", null, false));
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
    }

    public void testLinkSuccess() throws CoreException, TeamException {
        IProject project = this.createProject("testLinkFailure", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IFolder folder = project.getFolder("link");
        folder.createLink(Platform.getLocation().append("temp"), 16, null);
        this.assertIsIgnored((IResource)folder, true);
        folder = project.getFolder("folder1/folder2/");
        folder.createLink(Platform.getLocation().append("temp"), 16, null);
        this.assertIsIgnored((IResource)folder, true);
    }

    public void testLinkCVSFolder() throws CoreException, TeamException, IOException {
        IProject source = this.createProject("testLinkSource", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject sourceCopy = this.checkoutCopy(source, "copy");
        EclipseSynchronizer.getInstance().flush((IContainer)source, true, DEFAULT_MONITOR);
        IProject target = this.createProject("testLinkTarget", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IFolder folder = target.getFolder("link");
        folder.createLink(source.getLocation(), 0, null);
        this.assertEquals(sourceCopy, source);
    }
}

