/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class ModuleTest
extends EclipseTest {
    public static final String RESOURCE_PATH = "resources/CommandTest/";
    private static boolean isSetUp = false;
    private static RemoteModule[] remoteModules;

    public ModuleTest() {
        super(null);
    }

    public ModuleTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModuleTest.class);
        return new CVSTestSetup((Test)suite);
    }

    @Override
    public void setUp() throws TeamException, CoreException, IOException {
        if (isSetUp) {
            return;
        }
        Bundle b = Platform.getBundle((String)"org.eclipse.team.tests.cvs.core");
        URL url = b.getEntry("resources/CommandTest/CVSROOT/modules");
        this.waitMsec(1000);
        IProject cvsroot = this.checkoutProject(null, "CVSROOT", null);
        try (InputStream in = url.openStream();){
            cvsroot.getFile("modules").setContents(in, false, false, DEFAULT_MONITOR);
        }
        this.commitProject(cvsroot);
        this.uploadProject("common");
        remoteModules = RemoteModule.getRemoteModules((ICVSRepositoryLocation)this.getRepository(), null, (IProgressMonitor)DEFAULT_MONITOR);
        isSetUp = true;
    }

    protected void uploadProject(String projectName) throws TeamException, IOException, CoreException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.team.tests.cvs.core");
        URL url = bundle.getEntry(RESOURCE_PATH + projectName);
        url = FileLocator.resolve((URL)url);
        Assert.assertTrue((boolean)url.getProtocol().equals("file"));
        Path path = new Path(url.getPath());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        projectDescription.setLocation((IPath)path);
        project.create(projectDescription, null);
        project.open(null);
        s.open(DEFAULT_MONITOR, true);
        try (Session s = new Session((ICVSRepositoryLocation)this.getRepository(), CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));){
            Command.IMPORT.execute(s, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Command.makeArgumentOption((Command.LocalOption)Command.MESSAGE_OPTION, (String)"")}, new String[]{projectName, "start", "vendor"}, null, DEFAULT_MONITOR);
        }
        project.delete(false, false, null);
    }

    protected IProject checkoutProject(String projectName, CVSTag tag) throws TeamException, CoreException {
        IProject project = super.checkoutProject(ModuleTest.getWorkspace().getRoot().getProject(projectName), null, tag);
        ICVSFolder parent = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
        ICVSResource vcmmeta = CVSWorkspaceRoot.getCVSResourceFor((IResource)project.getFile(".vcm_meta"));
        if (!vcmmeta.isManaged() && !parent.getFolderSyncInfo().getIsStatic()) {
            this.addResources(new IResource[]{project.getFile(".vcm_meta")});
            this.waitMsec(1000);
            this.commitProject(project);
        }
        return project;
    }

    public void testSelfReferencingModule() throws TeamException, CoreException, IOException {
        this.uploadProject("project1");
        IProject project1 = this.checkoutProject("project1", null);
        ICVSRemoteResource tree = this.getRemoteTree((IResource)project1, CVSTag.DEFAULT, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)project1), (ICVSResource)tree, false, false);
        RemoteModule module = this.getRemoteModule("project1");
        this.assertEquals((IPath)Path.EMPTY, (RemoteFolder)tree, (RemoteFolder)module, false);
    }

    public void testFlattenedStructure() throws TeamException, CoreException, IOException {
        IProject docs = this.checkoutProject("docs", null);
        ICVSRemoteResource tree = this.getRemoteTree((IResource)docs, CVSTag.DEFAULT, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)docs), (ICVSResource)tree, false, false);
        RemoteModule module = this.getRemoteModule("docs");
        this.assertEquals((IPath)Path.EMPTY, (RemoteFolder)tree, (RemoteFolder)module, false);
        IProject macros = this.checkoutProject("macros", null);
        tree = this.getRemoteTree((IResource)macros, CVSTag.DEFAULT, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)macros), (ICVSResource)tree, false, false);
        module = this.getRemoteModule("macros");
        this.assertEquals((IPath)Path.EMPTY, (RemoteFolder)tree, (RemoteFolder)module, false);
    }

    public void testIncludeAndExcludeDocs() throws TeamException, CoreException, IOException {
        this.uploadProject("project2");
        IProject project2 = this.checkoutProject("project2", null);
        ICVSRemoteResource tree = this.getRemoteTree((IResource)project2, CVSTag.DEFAULT, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)project2), (ICVSResource)tree, false, false);
        RemoteModule module = this.getRemoteModule("project2");
        this.assertEquals((IPath)Path.EMPTY, (RemoteFolder)tree, (RemoteFolder)module, false);
        project2 = this.checkoutProject("project2-only", null);
        tree = this.getRemoteTree((IResource)project2, CVSTag.DEFAULT, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)project2), (ICVSResource)tree, false, false);
        module = this.getRemoteModule("project2-only");
        this.assertEquals((IPath)Path.EMPTY, (RemoteFolder)tree, (RemoteFolder)module, false);
    }

    public void testSimpleAlias() throws TeamException, CoreException, IOException {
        this.uploadProject("project8");
    }

    public RemoteModule getRemoteModule(String moduleName) {
        int i = 0;
        while (i < remoteModules.length) {
            RemoteModule module = remoteModules[i];
            if (module.getName().equals(moduleName)) {
                return module;
            }
            ++i;
        }
        return null;
    }
}

