/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutToRemoteFolderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.ui.ReflectionUtils;

public class RemoteResourceTest
extends EclipseTest {
    public RemoteResourceTest() {
    }

    public RemoteResourceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return RemoteResourceTest.suite(RemoteResourceTest.class);
    }

    protected void assertRemoteMatchesLocal(String message, RemoteFolder remote, IContainer container) throws CVSException, IOException, CoreException {
        this.assertEquals((IPath)Path.EMPTY, (ICVSResource)remote, (ICVSResource)CVSWorkspaceRoot.getCVSFolderFor((IContainer)container), false, false);
    }

    protected void getMembers(ICVSRemoteFolder folder, boolean deep) throws TeamException {
        ICVSRemoteResource[] children = folder.members(DEFAULT_MONITOR);
        if (deep) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isContainer()) {
                    this.getMembers((ICVSRemoteFolder)children[i], deep);
                }
                ++i;
            }
        }
    }

    public void testSimpleChanges() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testRemoteTreeBuilder", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        IResource[] newResources = this.buildResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.addResources(newResources);
        this.deleteResources(new IResource[]{copy.getFile("deleted.txt")});
        this.commitResources(new IResource[]{copy}, 2);
        RemoteFolderTree tree = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)this.getRepository(), (IContainer)project, (CVSTag)CVSTag.DEFAULT, (IProgressMonitor)DEFAULT_MONITOR);
        this.assertRemoteMatchesLocal("testSimpleChanges", (RemoteFolder)tree, (IContainer)copy);
    }

    public void testNoRemoteChanges() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testNoRemoteChanges", new String[]{"file1.txt", "file2.txt", "folder1/a.txt", "folder2/folder3/b.txt"});
        RemoteFolderTree tree = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)this.getRepository(), (IContainer)project, (CVSTag)CVSTag.DEFAULT, (IProgressMonitor)DEFAULT_MONITOR);
        this.assertRemoteMatchesLocal("testNoRemoteChanges", (RemoteFolder)tree, (IContainer)project);
    }

    public void testGetBase() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testGetBase", new String[]{"file1.txt", "file2.txt", "folder1/a.txt", "folder2/folder3/b.txt"});
        RemoteFolder tree = RemoteFolderTreeBuilder.buildBaseTree((CVSRepositoryLocation)this.getRepository(), (ICVSFolder)CVSWorkspaceRoot.getCVSFolderFor((IContainer)project), (CVSTag)CVSTag.DEFAULT, (IProgressMonitor)DEFAULT_MONITOR);
        this.assertRemoteMatchesLocal("testGetBase", tree, (IContainer)project);
    }

    public void testFolderAddition() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testFolderAddition", new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"folder2/folder3/b.txt"}, false);
        this.commitResources(new IResource[]{copy}, 2);
        RemoteFolderTree tree = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)this.getRepository(), (IContainer)project, (CVSTag)CVSTag.DEFAULT, (IProgressMonitor)DEFAULT_MONITOR);
        this.assertRemoteMatchesLocal("testFolderAddition", (RemoteFolder)tree, (IContainer)copy);
    }

    public void testNonRootBuild() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testNonRootBuild", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt", "folder2/folder3/", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("folder2/folder3/c.txt"));
        this.addResources((IContainer)copy, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources(new IResource[]{copy.getFile("folder2/folder3/b.txt")});
        this.commitResources(new IResource[]{copy}, 2);
        RemoteFolderTree tree = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)this.getRepository(), (IContainer)project.getFolder("folder2"), (CVSTag)CVSTag.DEFAULT, (IProgressMonitor)DEFAULT_MONITOR);
        this.assertRemoteMatchesLocal("testNonRootBuild", (RemoteFolder)tree, (IContainer)copy.getFolder("folder2"));
    }

    public void testGetRemoteResource() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testGetRemoteResource", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt", "folder2/folder3/", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        ICVSRemoteResource file = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("folder1/a.txt"));
        RemoteResourceTest.assertTrue((String)"File should exist remotely", (boolean)file.exists(DEFAULT_MONITOR));
        this.assertEquals((IPath)Path.EMPTY, (ICVSResource)file, (ICVSResource)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("folder1/a.txt")), false, false);
        ICVSRemoteResource folder = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFolder("folder2/folder3/"));
        this.getMembers((ICVSRemoteFolder)folder, true);
        RemoteResourceTest.assertTrue((String)"Folder should exist remotely", (boolean)folder.exists(DEFAULT_MONITOR));
    }

    public void testVersionTag() throws TeamException, CoreException, IOException {
        CVSTag v1Tag = new CVSTag("v1", 2);
        IProject project = this.createProject("testVersionTag", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/folder3/c.txt"});
        this.tagProject(project, v1Tag, false);
        IFile file = project.getFile("folder1/a.txt");
        file.setContents(this.getRandomContents(), false, false, null);
        this.addResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"folder1/b.txt"}, false);
        this.commitResources(new IResource[]{project}, 2);
        ICVSRemoteResource tree = this.getRemoteTree((IResource)project, v1Tag, DEFAULT_MONITOR);
        project = this.checkoutCopy(project, v1Tag);
        this.assertEquals((IPath)Path.EMPTY, (ICVSResource)tree, CVSWorkspaceRoot.getCVSResourceFor((IResource)project), false, false);
    }

    public void testEmptyFile() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testEmptyFile", new String[]{"file.txt"});
        IFile file = project.getFile("file.txt");
        this.setContentsAndEnsureModified(file, "");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        IResourceVariant remote = (IResourceVariant)CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
        InputStream in = remote.getStorage(DEFAULT_MONITOR).getContents();
        int count = 0;
        while (in.read() != -1) {
            ++count;
        }
        RemoteResourceTest.assertTrue((String)"Remote file should be empty", (count == 0 ? 1 : 0) != 0);
    }

    public void testFileRevisions() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testFileRevisions", new String[]{"file.txt"});
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hi there");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "bye there");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        ICVSRemoteFile remote = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file.txt"));
        ILogEntry[] entries = remote.getLogEntries(DEFAULT_MONITOR);
        int i = 0;
        while (i < entries.length) {
            String contents;
            int c;
            byte[] buffer;
            int count;
            InputStream in = entries[i].getRemoteFile().getContents(DEFAULT_MONITOR);
            if (entries[i].getRevision().equals("1.2")) {
                count = 0;
                buffer = new byte[1024];
                while ((c = in.read()) != -1) {
                    buffer[count] = (byte)c;
                    ++count;
                }
                contents = new String(buffer, 0, count);
                RemoteResourceTest.assertEquals((String)"the contents of revision 1.2 are not equal", (String)contents, (String)"hi there");
            } else if (entries[i].getRevision().equals("1.3")) {
                count = 0;
                buffer = new byte[1024];
                while ((c = in.read()) != -1) {
                    buffer[count] = (byte)c;
                    ++count;
                }
                contents = new String(buffer, 0, count);
                RemoteResourceTest.assertEquals((String)"the contents of revision 1.3 are not equal", (String)contents, (String)"bye there");
            }
            ++i;
        }
    }

    public void testFileRevisionsForBranches() throws TeamException, CoreException {
        IProject project = this.createProject("testFileRevisionsForBranches", new String[]{"file.txt"});
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello HEAD");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello again HEAD");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        this.makeBranch(new IResource[]{project}, root, branch, true);
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello branch1");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello again branch1");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        CVSTag root2 = new CVSTag("root_branch2", 2);
        CVSTag branch2 = new CVSTag("branch2", 1);
        this.makeBranch(new IResource[]{project}, root2, branch2, true);
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello branch2");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        this.updateProject(project, CVSTag.DEFAULT, false);
        this.setContentsAndEnsureModified(project.getFile("file.txt"), "hello HEAD for the last time");
        this.commitResources((IContainer)project, new String[]{"file.txt"});
        ICVSRemoteFile remote = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file.txt"));
        ILogEntry[] entries = remote.getLogEntries(DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((int)7, (int)entries.length);
        LogEntry logEntry = this.getLogEntryByRevision(entries, "1.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)CVSTag.DEFAULT, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.2");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)CVSTag.DEFAULT, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.3");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)2, (int)logEntry.getTags().length);
        CVSTag tag = this.getTagByName(logEntry.getTags(), "root_branch1");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)root, (CVSTag)tag));
        RemoteResourceTest.assertEquals(null, (String)tag.getBranchRevision());
        tag = this.getTagByName(logEntry.getTags(), "branch1");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch, (CVSTag)tag));
        RemoteResourceTest.assertEquals((String)"1.3.0.2", (String)tag.getBranchRevision());
        RemoteResourceTest.assertEquals((int)2, (int)logEntry.getBranches().length);
        tag = this.getTagByName(logEntry.getBranches(), "HEAD");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)CVSTag.DEFAULT, (CVSTag)tag));
        tag = this.getTagByName(logEntry.getBranches(), branch.getName());
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch, (CVSTag)tag));
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.3.2.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1.3.0.2", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.3.2.2");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)2, (int)logEntry.getTags().length);
        tag = this.getTagByName(logEntry.getTags(), "root_branch2");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)root2, (CVSTag)tag));
        RemoteResourceTest.assertEquals(null, (String)tag.getBranchRevision());
        tag = this.getTagByName(logEntry.getTags(), "branch2");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch2, (CVSTag)tag));
        RemoteResourceTest.assertEquals((String)"1.3.2.2.0.2", (String)tag.getBranchRevision());
        RemoteResourceTest.assertEquals((int)2, (int)logEntry.getBranches().length);
        tag = this.getTagByName(logEntry.getBranches(), branch.getName());
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch, (CVSTag)tag));
        RemoteResourceTest.assertEquals((String)"1.3.0.2", (String)tag.getBranchRevision());
        tag = this.getTagByName(logEntry.getBranches(), branch2.getName());
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch2, (CVSTag)tag));
        RemoteResourceTest.assertEquals((String)"1.3.2.2.0.2", (String)tag.getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.3.2.2.2.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)branch2, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1.3.2.2.0.2", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.4");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)CVSTag.DEFAULT, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
    }

    private LogEntry getLogEntryByRevision(ILogEntry[] entries, String revision) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getRevision().equals(revision) && entries[i] instanceof LogEntry) {
                return (LogEntry)entries[i];
            }
            ++i;
        }
        return null;
    }

    private CVSTag getTagByName(CVSTag[] tags, String name) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getName().equals(name)) {
                return tags[i];
            }
            ++i;
        }
        return null;
    }

    public void testTag() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testTag", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        ICVSRemoteFolder remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        CVSTag tag = new CVSTag("v1", 2);
        this.tagRemoteResource((ICVSRemoteResource)remote, tag, false);
        ICVSRemoteFolder v1 = (ICVSRemoteFolder)this.getRemoteTree((IResource)project, tag, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, (ICVSRemoteResource)remote, (ICVSRemoteResource)v1, false);
        CVSTag tag2 = new CVSTag("v2", 2);
        this.tagRemoteResource((ICVSRemoteResource)v1, tag2, false);
        ICVSRemoteFolder v2 = (ICVSRemoteFolder)this.getRemoteTree((IResource)project, tag2, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, (ICVSRemoteResource)remote, (ICVSRemoteResource)v2, false);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        this.tagRemoteResource((ICVSRemoteResource)remote, tag, true);
        v1 = (ICVSRemoteFolder)this.getRemoteTree((IResource)project, tag, DEFAULT_MONITOR);
        this.assertEquals((IPath)Path.EMPTY, (ICVSRemoteResource)remote, (ICVSRemoteResource)v1, false);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        this.tagProject(project, tag2, true);
        IProject copy = this.checkoutCopy(project, tag2);
        this.assertEquals(project, copy, false, false);
    }

    public void testUnknownBranch() throws TeamException, CoreException {
        IProject project = this.createProject("testUnknownBranch", new String[]{"file1.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        this.makeBranch(new IResource[]{project}, root, branch, true);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        ICVSRemoteFolder remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        TagInRepositoryOperation op = new TagInRepositoryOperation(null, new ICVSRemoteResource[]{remote});
        op.addLocalOption((Command.LocalOption)ReflectionUtils.construct(Command.LocalOption.class.getName(), Command.LocalOption.class.getClassLoader(), new Class[]{String.class}, new Object[]{"-d"}));
        this.runTag((ITagOperation)op, branch, true);
        ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file1.txt"));
        ILogEntry[] entries = remoteFile.getLogEntries(DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((int)2, (int)entries.length);
        LogEntry logEntry = this.getLogEntryByRevision(entries, "1.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getTags().length);
        CVSTag tag = this.getTagByName(logEntry.getTags(), "root_branch1");
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)root, (CVSTag)tag));
        RemoteResourceTest.assertEquals(null, (String)tag.getBranchRevision());
        tag = this.getTagByName(logEntry.getTags(), "branch1");
        RemoteResourceTest.assertNull((Object)tag);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)CVSTag.DEFAULT, (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
        logEntry = this.getLogEntryByRevision(entries, "1.1.2.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getTags().length);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertEquals((String)CVSTag.UNKNOWN_BRANCH, (String)logEntry.getBranches()[0].getName());
        RemoteResourceTest.assertEquals((String)"1.1.0.2", (String)logEntry.getBranches()[0].getBranchRevision());
        RemoteResourceTest.assertEquals((int)0, (int)logEntry.getBranchRevisions().length);
    }

    public void testVendorBranch() throws TeamException, CoreException {
        IProject project = this.getUniqueTestProject("testVendorBranch");
        this.buildResources((IContainer)project, new String[]{"file1.txt"}, true);
        this.importProject(project);
        IProject copy = RemoteResourceTest.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + "copy");
        RemoteResourceTest.checkout((ICVSRepositoryLocation)this.getRepository(), copy, project.getName(), null, DEFAULT_MONITOR);
        ICVSRemoteFile remote = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)copy.getFile("file1.txt"));
        ILogEntry[] entries = remote.getLogEntries(DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((int)2, (int)entries.length);
        LogEntry logEntry = this.getLogEntryByRevision(entries, "1.1.1.1");
        RemoteResourceTest.assertNotNull((Object)logEntry);
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getTags().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)new CVSTag("start", 2), (CVSTag)logEntry.getTags()[0]));
        RemoteResourceTest.assertEquals((int)1, (int)logEntry.getBranches().length);
        RemoteResourceTest.assertTrue((boolean)CVSTag.equalTags((CVSTag)new CVSTag(this.getRepository().getUsername(), 1), (CVSTag)logEntry.getBranches()[0]));
        RemoteResourceTest.assertEquals((String)"1.1.1", (String)logEntry.getBranches()[0].getBranchRevision());
    }

    public void testExists() throws TeamException, CoreException {
        IProject project = this.createProject("testExists", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt", "folder2/folder3/", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        ICVSRemoteResource resource1 = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file1.txt"));
        RemoteResourceTest.assertTrue((boolean)resource1.exists(DEFAULT_MONITOR));
        ICVSRemoteResource resource2 = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFolder("folder2/folder3/"));
        RemoteResourceTest.assertTrue((boolean)resource2.exists(DEFAULT_MONITOR));
        this.deleteResources((IContainer)project, new String[]{"file1.txt", "folder2/folder3/b.txt", "folder2/folder3/c.txt"}, true);
        RemoteResourceTest.assertTrue((!resource1.exists(DEFAULT_MONITOR) ? 1 : 0) != 0);
        RemoteResourceTest.assertTrue((boolean)resource2.exists(DEFAULT_MONITOR));
        if (CVSTestSetup.INITIALIZE_REPO) {
            CVSTestSetup.executeRemoteCommand((ICVSRepositoryLocation)this.getRepository(), "rm -rf " + ((ICVSFolder)resource2).getFolderSyncInfo().getRemoteLocation());
            RemoteResourceTest.assertTrue((!resource2.exists(DEFAULT_MONITOR) ? 1 : 0) != 0);
        }
    }

    public void testCheckoutIntoRemoteFolder() throws CoreException, IOException, CVSException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        ICVSRemoteFolder remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        remote = this.checkoutRemote(remote);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)project), (ICVSResource)remote, false, true);
        CVSTag tag = new CVSTag("v1", 2);
        this.tagProject(project, tag, false);
        IProject copy = this.checkoutCopy(project, tag);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        ((RemoteFolder)remote).setTag(tag);
        remote = this.checkoutRemote(remote);
        this.assertEquals((IPath)Path.EMPTY, CVSWorkspaceRoot.getCVSResourceFor((IResource)copy), (ICVSResource)remote, false, true);
    }

    public void testBug244425() throws CVSException, CoreException, IOException {
        IProject projectHead = this.createProject("test", new String[]{"a/", "a/file1.txt", "a/file2.txt"});
        this.appendText((IResource)projectHead.getFile("a/file1.txt"), "dummy", true);
        this.appendText((IResource)projectHead.getFile("a/file2.txt"), "dummy", true);
        this.commitNewProject(projectHead);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject projectBranch = this.checkoutCopy(projectHead, "branch");
        this.tagProject(projectHead, root, false);
        this.tagProject(projectHead, branch, false);
        this.updateProject(projectBranch, branch, false);
        this.replace(new IResource[]{projectHead.getFile("a/file2.txt")}, branch, true);
        this.appendText((IResource)projectBranch.getFile("a/file2.txt"), "dummy2", true);
        this.commitProject(projectBranch);
        ICVSRemoteResource file1 = this.getRemoteTree((IResource)projectHead.getFile("a/file1.txt"), null, DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals(null, (Object)file1.getSyncInfo().getTag());
        RemoteResourceTest.assertEquals((String)"1.2", (String)file1.getSyncInfo().getRevision());
        ICVSRemoteResource file2 = this.getRemoteTree((IResource)projectHead.getFile("a/file2.txt"), null, DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((Object)branch, (Object)file2.getSyncInfo().getTag());
        RemoteResourceTest.assertEquals((String)"1.2.2.1", (String)file2.getSyncInfo().getRevision());
    }

    public void testBug244425_compare() throws CVSException, CoreException, IOException {
        IProject projectHead = this.createProject("test", new String[]{"a/", "a/file1.txt", "a/file2.txt"});
        this.appendText((IResource)projectHead.getFile("a/file1.txt"), "dummy", true);
        this.appendText((IResource)projectHead.getFile("a/file2.txt"), "dummy", true);
        CVSTag tag = new CVSTag("testtag", 2);
        this.tagProject(projectHead, tag, false);
        this.appendText((IResource)projectHead.getFile("a/file2.txt"), "dummy2", true);
        this.commitProject(projectHead);
        this.replace(new IResource[]{projectHead.getFile("a/file2.txt")}, tag, true);
        RemoteResourceTest.assertEquals((String)"1.1", (String)CVSWorkspaceRoot.getCVSFileFor((IFile)projectHead.getFile("a/file2.txt")).getSyncInfo().getRevision());
        ICVSRemoteResource remoteFile = this.getRemoteTree((IResource)projectHead.getFile("a/file2.txt"), new CVSTag(), DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((String)"1.2", (String)remoteFile.getSyncInfo().getRevision());
    }

    private ICVSRemoteFolder checkoutRemote(ICVSRemoteFolder remote) throws CVSException, InvocationTargetException, InterruptedException {
        return CheckoutToRemoteFolderOperation.checkoutRemoteFolder(null, (ICVSRemoteFolder)remote, (IProgressMonitor)DEFAULT_MONITOR);
    }

    public void testContentFetchForLocalDeletion() throws TeamException, IOException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        String contents = "the file contents";
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), contents);
        this.commitProject(project);
        project.getFile("file1.txt").delete(false, null);
        IResourceVariant remote = (IResourceVariant)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file1.txt"));
        String fetchedContents = this.asString(remote.getStorage(DEFAULT_MONITOR).getContents());
        RemoteResourceTest.assertEquals((String)"Contents do not match", (String)contents, (String)fetchedContents);
    }

    private String asString(InputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int b = stream.read();
        while (b != -1) {
            buffer.append((char)b);
            b = stream.read();
        }
        return buffer.toString();
    }

    public void testResourceVariant() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        IFile file = project.getFile("file1.txt");
        ICVSRemoteResource resource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
        IResourceVariant variant = (IResourceVariant)resource;
        IStorage storage = variant.getStorage(DEFAULT_MONITOR);
        RemoteResourceTest.assertEquals((Object)storage.getFullPath(), (Object)((CachedResourceVariant)resource).getDisplayPath());
    }

    public String getCachePath(ICVSRemoteResource resource) throws CVSException {
        ICVSRepositoryLocation location = resource.getRepository();
        Path path = new Path(location.getHost());
        path = path.append(location.getRootDirectory());
        path = path.append(resource.getParent().getRepositoryRelativePath());
        path = path.append(String.valueOf(resource.getName()) + ' ' + ((IResourceVariant)resource).getContentIdentifier());
        return path.toString();
    }
}

