/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class ResourceDeltaTest
extends EclipseTest {
    public ResourceDeltaTest() {
    }

    public ResourceDeltaTest(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(ResourceDeltaTest.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new ResourceDeltaTest(testName));
    }

    public void assertNotManaged(ICVSFile cvsFile) throws CVSException {
        ResourceDeltaTest.assertTrue((String)("File " + cvsFile.getName() + " should not be managed"), (!cvsFile.isManaged() ? 1 : 0) != 0);
    }

    public void assertNotManaged(ICVSFolder cvsFolder) throws CVSException {
        this.assertNotManaged(cvsFolder, false);
    }

    public void assertNotManaged(ICVSFolder cvsFolder, boolean rootManaged) throws CVSException {
        if (!rootManaged) {
            ResourceDeltaTest.assertTrue((String)("Folder " + cvsFolder.getName() + " should not be managed"), (!cvsFolder.isManaged() ? 1 : 0) != 0);
        }
        ResourceDeltaTest.assertTrue((String)("Folder " + cvsFolder.getName() + " should not be a cvs folder"), (!cvsFolder.isCVSFolder() ? 1 : 0) != 0);
        cvsFolder.acceptChildren(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                ResourceDeltaTest.this.assertNotManaged(file);
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                ResourceDeltaTest.this.assertNotManaged(folder, false);
            }
        });
    }

    public void assertAdditionMarkerFor(IResource resource, boolean exists) {
    }

    public void assertDeletionMarkerFor(IResource resource, boolean exists) {
    }

    public void testOrphanedSubtree() throws TeamException, CoreException {
        IProject project = this.createProject("testOrphanedSubtree", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        IFolder folder = project.getFolder((IPath)new Path("folder1"));
        folder.move((IPath)new Path("moved"), false, false, null);
        folder = project.getFolder((IPath)new Path("moved"));
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
        this.assertNotManaged(cvsFolder);
        this.assertAdditionMarkerFor((IResource)folder, true);
    }

    public void testOrphanedSubsubtree() throws TeamException, CoreException {
        IProject project = this.createProject("testOrphanedSubsubtree", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        IFolder folder = project.getFolder((IPath)new Path("folder1"));
        IFolder target = project.getFolder("sub");
        target.create(false, true, null);
        folder.move((IPath)new Path("sub/moved"), false, false, null);
        folder = project.getFolder((IPath)new Path("sub/moved"));
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
        this.assertNotManaged(cvsFolder);
        this.assertAdditionMarkerFor((IResource)target, true);
        this.assertAdditionMarkerFor((IResource)folder, false);
    }

    public void testDeletionHandling() throws TeamException, CoreException {
        IProject project = this.createProject("testDeletionHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        this.addResources((IContainer)project, new String[]{"added.txt"}, false);
        this.assertAdditionMarkerFor((IResource)project.getFile("added.txt"), false);
        this.deleteResources((IContainer)project, new String[]{"added.txt", "deleted.txt"}, false);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("added.txt"));
        this.assertNotManaged(file);
        this.assertDeletionMarkerFor((IResource)project.getFile("added.txt"), false);
        file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("deleted.txt"));
        ResourceDeltaTest.assertTrue((String)("File " + file.getName() + " should be managed"), (boolean)file.isManaged());
        ResourceSyncInfo info = file.getSyncInfo();
        ResourceDeltaTest.assertTrue((String)("File " + file.getName() + " should be marked as deleted"), (boolean)info.isDeleted());
        this.assertDeletionMarkerFor((IResource)project.getFile("deleted.txt"), true);
    }

    public void testFileAdditionHandling() throws TeamException, CoreException {
        IProject project = this.createProject("testFileAdditionHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        this.deleteResources((IContainer)project, new String[]{"deleted.txt"}, false);
        this.assertDeletionMarkerFor((IResource)project.getFile("deleted.txt"), true);
        this.addResources((IContainer)project, new String[]{"deleted.txt"}, false);
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("deleted.txt"));
        ResourceDeltaTest.assertTrue((String)("File " + file.getName() + " should be managed"), (boolean)file.isManaged());
        ResourceSyncInfo info = file.getSyncInfo();
        ResourceDeltaTest.assertTrue((String)("File " + file.getName() + " should not be marked as deleted"), (!info.isDeleted() ? 1 : 0) != 0);
        ResourceDeltaTest.assertTrue((String)("File " + file.getName() + " should not be marked as addition"), (!info.isAdded() ? 1 : 0) != 0);
        this.assertDeletionMarkerFor((IResource)project.getFile("deleted.txt"), false);
    }

    public void testFolderAdditionHandling() throws TeamException, CoreException {
        IProject project = this.createProject("testFolderAdditionHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        IFolder folder = project.getFolder("newfolder");
        folder.create(false, true, null);
        this.assertAdditionMarkerFor((IResource)folder, true);
        this.addResources(new IResource[]{folder});
        this.assertAdditionMarkerFor((IResource)folder, false);
    }

    private void setContents(File ioFile) throws IOException {
        this.waitMsec(1500);
        BufferedInputStream in = new BufferedInputStream(this.getRandomContents());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ioFile));){
            int next = ((InputStream)in).read();
            while (next != -1) {
                ((OutputStream)out).write(next);
                next = ((InputStream)in).read();
            }
        }
    }

    public void testOperationOnOutOfSync() throws CoreException, TeamException, IOException {
        block2: {
            IProject project = this.createProject("testFolderAdditionHandling", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
            IFile file = project.getFile("changed.txt");
            this.setContentsAndEnsureModified(file);
            File ioFile = file.getLocation().toFile();
            this.setContents(ioFile);
            try {
                this.updateProject(project, null, false);
            }
            catch (CVSException e) {
                if (this.containsCode((CoreException)e, 274)) break block2;
                throw e;
            }
        }
    }

    private boolean containsCode(CoreException e, int code) {
        return this.containsCode(e.getStatus(), code);
    }

    private boolean containsCode(IStatus status, int code) {
        Throwable t;
        if (status.getCode() == code) {
            return true;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (this.containsCode(child, code)) {
                    return true;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException) {
            CoreException e = (CoreException)t;
            return this.containsCode(e, code);
        }
        return false;
    }

    public void testAllCVSFolderRemoval() throws CoreException, TeamException {
        IProject project = this.createProject("testAllCVSFolderRemoval", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        EclipseSynchronizer.getInstance().ensureSyncInfoLoaded(new IResource[]{project}, 2);
        String[] cvsFolders = new String[]{"CVS", "folder1/CVS", "folder1/folder2/CVS"};
        this.deleteIOFiles(project, cvsFolders);
        this.assertNotManaged(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));
    }

    public void testSomeCVSFolderRemoval() throws CoreException, TeamException {
        IProject project = this.createProject("testAllCVSFolderRemoval", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        EclipseSynchronizer.getInstance().ensureSyncInfoLoaded(new IResource[]{project}, 2);
        String[] cvsFolders = new String[]{"folder1/CVS", "folder1/folder2/CVS"};
        this.deleteIOFiles(project, cvsFolders);
        this.assertNotManaged(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("folder1")), true);
    }

    public void deleteIOFiles(IProject project, String[] cvsFolders) throws CoreException {
        IPath rootPath = project.getLocation();
        int i = 0;
        while (i < cvsFolders.length) {
            String childPath = cvsFolders[i];
            IPath fullPath = rootPath.append(childPath);
            ResourceDeltaTest.deepDelete(fullPath.toFile());
            ++i;
        }
        project.refreshLocal(2, null);
    }

    private static void deepDelete(File resource) {
        if (resource.isDirectory()) {
            File[] fileList = resource.listFiles();
            int i = 0;
            while (i < fileList.length) {
                ResourceDeltaTest.deepDelete(fileList[i]);
                ++i;
            }
        }
        resource.delete();
    }

    public void testCVSFodlersMarkedTeamPrivate() throws CoreException, TeamException {
        IProject project = this.createProject("testTeamPrivatefolders", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        project.delete(false, true, null);
        project.create(null);
        project.open(null);
        project.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getName().equals("CVS")) {
                    ResourceDeltaTest.fail((String)("all folders should be marked as team private. This one was not:" + proxy.requestResource().getFullPath()));
                }
                return true;
            }
        }, 0);
    }

    public void testExternalDeletion() throws CoreException, TeamException {
        IProject project = this.createProject("testExternalDeletion", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        IFile file = project.getFile("folder1/a.txt");
        ResourceDeltaTest.deepDelete(file.getLocation().toFile());
        file.refreshLocal(0, DEFAULT_MONITOR);
        ResourceDeltaTest.assertTrue((!file.exists() ? 1 : 0) != 0);
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        ResourceDeltaTest.assertTrue((boolean)cvsFile.isManaged());
        byte[] syncBytes = cvsFile.getSyncBytes();
        ResourceDeltaTest.assertTrue((boolean)ResourceSyncInfo.isDeletion((byte[])syncBytes));
    }
}

